/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class SourceProvider {
    private ITypeRoot fTypeRoot;
    private IDocument fDocument;
    private MethodDeclaration fDeclaration;
    private SourceAnalyzer fAnalyzer;
    private boolean fMustEvalReturnedExpression;
    private boolean fReturnValueNeedsLocalVariable;
    private List<Expression> fReturnExpressions;
    private IDocument fSource;
    private static final int EXPRESSION_MODE = 1;
    private static final int STATEMENT_MODE = 2;
    private static final int RETURN_STATEMENT_MODE = 3;
    private int fMarkerMode;

    public SourceProvider(ITypeRoot typeRoot, MethodDeclaration declaration) {
        this.fTypeRoot = typeRoot;
        this.fDeclaration = declaration;
        List parameters = this.fDeclaration.parameters();
        for (SingleVariableDeclaration element : parameters) {
            ParameterData data = new ParameterData(element);
            element.setProperty(ParameterData.PROPERTY, (Object)data);
        }
        this.fAnalyzer = new SourceAnalyzer(this.fTypeRoot, this.fDeclaration);
        this.fReturnValueNeedsLocalVariable = true;
        this.fReturnExpressions = new ArrayList<Expression>();
    }

    public SourceProvider(ITypeRoot typeRoot, IDocument source, MethodDeclaration declaration) {
        this(typeRoot, declaration);
        this.fSource = source;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        return this.fAnalyzer.checkActivation();
    }

    public void initialize() throws JavaModelException {
        ASTNode last;
        this.fDocument = this.fSource == null ? new Document(this.fTypeRoot.getBuffer().getContents()) : this.fSource;
        this.fAnalyzer.initialize();
        if (this.hasReturnValue() && (last = this.getLastStatement()) != null) {
            ReturnAnalyzer analyzer = new ReturnAnalyzer();
            last.accept((ASTVisitor)analyzer);
        }
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fAnalyzer.isExecutionFlowInterrupted();
    }

    public boolean isVariableReferenced(IVariableBinding binding) {
        VariableReferenceFinder finder = new VariableReferenceFinder(binding);
        this.fDeclaration.accept((ASTVisitor)finder);
        return finder.getResult();
    }

    public boolean hasReturnValue() {
        IMethodBinding binding = this.fDeclaration.resolveBinding();
        return binding.getReturnType() != this.fDeclaration.getAST().resolveWellKnownType("void");
    }

    public boolean hasArrayAccess() {
        return this.fAnalyzer.hasArrayAccess();
    }

    public boolean hasSuperMethodInvocation() {
        return this.fAnalyzer.hasSuperMethodInvocation();
    }

    public boolean hasSuperFieldAccess() {
        return this.fAnalyzer.hasSuperFieldAccess();
    }

    public boolean mustEvaluateReturnedExpression() {
        return this.fMustEvalReturnedExpression;
    }

    public boolean returnValueNeedsLocalVariable() {
        return this.fReturnValueNeedsLocalVariable;
    }

    public int getNumberOfStatements() {
        return this.fDeclaration.getBody().statements().size();
    }

    public boolean isSimpleFunction() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() > 1) {
            return false;
        }
        if (statements.size() == 1) {
            return statements.get(0) instanceof ReturnStatement;
        }
        return true;
    }

    public boolean isLastStatementReturn() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() == 0) {
            return false;
        }
        return statements.get(statements.size() - 1) instanceof ReturnStatement;
    }

    public boolean isDangligIf() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() != 1) {
            return false;
        }
        ASTNode p = (ASTNode)statements.get(0);
        while (!(p instanceof IfStatement)) {
            ChildPropertyDescriptor childD;
            if (p instanceof WhileStatement) {
                childD = WhileStatement.BODY_PROPERTY;
            } else if (p instanceof ForStatement) {
                childD = ForStatement.BODY_PROPERTY;
            } else if (p instanceof EnhancedForStatement) {
                childD = EnhancedForStatement.BODY_PROPERTY;
            } else if (p instanceof DoStatement) {
                childD = DoStatement.BODY_PROPERTY;
            } else if (p instanceof LabeledStatement) {
                childD = LabeledStatement.BODY_PROPERTY;
            } else {
                return false;
            }
            Statement body = (Statement)p.getStructuralProperty((StructuralPropertyDescriptor)childD);
            if (body instanceof Block) {
                return false;
            }
            p = body;
        }
        return ((IfStatement)p).getElseStatement() == null;
    }

    public MethodDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public boolean isSynchronized() {
        List modifierList = this.fDeclaration.modifiers();
        for (IExtendedModifier modifier : modifierList) {
            Modifier m;
            if (!(modifier instanceof Modifier) || !(m = (Modifier)modifier).isSynchronized()) continue;
            return true;
        }
        return false;
    }

    public boolean isStatic() {
        List modifierList = this.fDeclaration.modifiers();
        for (IExtendedModifier modifier : modifierList) {
            Modifier m;
            if (!(modifier instanceof Modifier) || !(m = (Modifier)modifier).isStatic()) continue;
            return true;
        }
        return false;
    }

    public String getMethodName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getReturnType() {
        return this.fDeclaration.resolveBinding().getReturnType();
    }

    public List<Expression> getReturnExpressions() {
        return this.fReturnExpressions;
    }

    public boolean returnTypeMatchesReturnExpressions() {
        ITypeBinding returnType = this.getReturnType();
        for (Expression expression : this.fReturnExpressions) {
            if (Bindings.equals((IBinding)returnType, (IBinding)expression.resolveTypeBinding())) continue;
            return false;
        }
        return true;
    }

    public ParameterData getParameterData(int index) {
        SingleVariableDeclaration decl = (SingleVariableDeclaration)this.fDeclaration.parameters().get(index);
        return (ParameterData)decl.getProperty(ParameterData.PROPERTY);
    }

    public ITypeRoot getTypeRoot() {
        return this.fTypeRoot;
    }

    public boolean needsReturnedExpressionParenthesis(ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return NecessaryParenthesesChecker.needsParentheses(((ReturnStatement)last).getExpression(), parent, locationInParent);
        }
        return false;
    }

    public boolean returnsConditionalExpression() {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return ((ReturnStatement)last).getExpression() instanceof ConditionalExpression;
        }
        return false;
    }

    public int getReceiversToBeUpdated() {
        return this.fAnalyzer.getImplicitReceivers().size();
    }

    public boolean isVarargs() {
        return this.fDeclaration.isVarargs();
    }

    public int getVarargIndex() {
        return this.fDeclaration.parameters().size() - 1;
    }

    public TextEdit getDeleteEdit() {
        ASTRewrite rewriter = ASTRewrite.create((AST)this.fDeclaration.getAST());
        rewriter.remove((ASTNode)this.fDeclaration, null);
        Map options = this.fTypeRoot instanceof ICompilationUnit ? ((ICompilationUnit)this.fTypeRoot).getOptions(true) : this.fTypeRoot.getJavaProject().getOptions(true);
        return rewriter.rewriteAST(this.fDocument, options);
    }

    public String[] getCodeBlocks(CallContext context, ImportRewrite importRewrite) throws CoreException {
        int split;
        ASTNode last;
        ASTRewrite rewriter = ASTRewrite.create((AST)this.fDeclaration.getAST());
        this.replaceParameterWithExpression(rewriter, context, importRewrite);
        this.updateImplicitReceivers(rewriter, context);
        this.makeNamesUnique(rewriter, context);
        this.updateTypeReferences(rewriter, context);
        this.updateStaticReferences(rewriter, context);
        this.updateInnerStaticReferences(rewriter, context);
        this.updateTypeVariables(rewriter, context);
        this.updateMethodTypeVariable(rewriter, context);
        this.updateReturnStatements(rewriter, context);
        List<IRegion> ranges = null;
        ranges = this.hasReturnValue() ? (context.callMode == 41 || context.callMode == 101 ? this.getStatementRanges() : this.getExpressionRanges()) : ((last = this.getLastStatement()) != null && last.getNodeType() == 41 ? this.getReturnStatementRanges() : this.getStatementRanges());
        Map options = this.fTypeRoot instanceof ICompilationUnit ? ((ICompilationUnit)this.fTypeRoot).getOptions(true) : this.fTypeRoot.getJavaProject().getOptions(true);
        TextEdit dummy = rewriter.rewriteAST(this.fDocument, options);
        int size = ranges.size();
        RangeMarker[] markers = new RangeMarker[size];
        int i = 0;
        while (i < markers.length) {
            IRegion range = ranges.get(i);
            markers[i] = new RangeMarker(range.getOffset(), range.getLength());
            ++i;
        }
        if (size <= 1) {
            split = Integer.MAX_VALUE;
        } else {
            IRegion region = ranges.get(0);
            split = region.getOffset() + region.getLength();
        }
        TextEdit[] textEditArray = dummy.removeChildren();
        int n = textEditArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit edit = textEditArray[n2];
            int pos = edit.getOffset() >= split ? 1 : 0;
            markers[pos].addChild(edit);
            ++n2;
        }
        MultiTextEdit root = new MultiTextEdit(0, this.fDocument.getLength());
        root.addChildren((TextEdit[])markers);
        try {
            TextEditProcessor processor = new TextEditProcessor(this.fDocument, (TextEdit)root, 3);
            UndoEdit undo = processor.performEdits();
            String[] result = this.getBlocks(markers);
            processor = new TextEditProcessor(this.fDocument, (TextEdit)undo, 2);
            processor.performEdits();
            return result;
        }
        catch (BadLocationException | MalformedTreeException exception) {
            JavaManipulationPlugin.log(exception);
            return new String[0];
        }
    }

    private Expression createParenthesizedExpression(Expression newExpression, AST ast) {
        ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
        parenthesized.setExpression(newExpression);
        return parenthesized;
    }

    private void replaceParameterWithExpression(ASTRewrite rewriter, CallContext context, ImportRewrite importRewrite) throws CoreException {
        Expression[] arguments = context.arguments;
        try {
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(context.compilationUnit);
            int i = 0;
            while (i < arguments.length) {
                block12: {
                    Expression expression = arguments[i];
                    String expressionString = null;
                    if (expression instanceof SimpleName) {
                        expressionString = ((SimpleName)expression).getIdentifier();
                    } else {
                        try {
                            expressionString = buffer.getDocument().get(expression.getStartPosition(), expression.getLength());
                        }
                        catch (BadLocationException exception) {
                            JavaManipulationPlugin.log(exception);
                            break block12;
                        }
                    }
                    ParameterData parameter = this.getParameterData(i);
                    List<SimpleName> references = parameter.references();
                    Iterator<SimpleName> iterator = references.iterator();
                    while (iterator.hasNext()) {
                        SimpleName simpleName;
                        SimpleName element = simpleName = iterator.next();
                        Expression newExpression = (Expression)rewriter.createStringPlaceholder(expressionString, expression.getNodeType());
                        AST ast = rewriter.getAST();
                        ITypeBinding explicitCast = ASTNodes.getExplicitCast(expression, (Expression)element);
                        if (explicitCast != null) {
                            CastExpression cast = ast.newCastExpression();
                            if (NecessaryParenthesesChecker.needsParentheses(expression, (ASTNode)cast, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                                newExpression = this.createParenthesizedExpression(newExpression, ast);
                            }
                            cast.setExpression(newExpression);
                            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)expression, importRewrite);
                            cast.setType(importRewrite.addImport(explicitCast, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.CAST));
                            expression = newExpression = cast;
                        }
                        if (NecessaryParenthesesChecker.needsParentheses(expression, element.getParent(), element.getLocationInParent())) {
                            newExpression = this.createParenthesizedExpression(newExpression, ast);
                        }
                        rewriter.replace((ASTNode)element, (ASTNode)newExpression, null);
                    }
                }
                ++i;
            }
        }
        finally {
            RefactoringFileBuffers.release(context.compilationUnit);
        }
    }

    private void makeNamesUnique(ASTRewrite rewriter, CallContext context) {
        CodeScopeBuilder.Scope scope = context.scope;
        boolean addName = context.callMode != 90 && context.callMode != 91 && context.callMode != 89 && context.callMode != 92;
        Collection<SourceAnalyzer.NameData> usedCalleeNames = this.fAnalyzer.getUsedNames();
        for (SourceAnalyzer.NameData nd : usedCalleeNames) {
            CodeScopeBuilder.Scope curScope = scope;
            while (curScope != null && !curScope.isInUse(nd.getName())) {
                curScope = curScope.getParent();
            }
            if (curScope != null && curScope.isInUse(nd.getName())) {
                String newName = scope.createName(nd.getName(), addName);
                List<SimpleName> references = nd.references();
                for (SimpleName element : references) {
                    ASTNode newNode = rewriter.createStringPlaceholder(newName, 42);
                    rewriter.replace((ASTNode)element, newNode, null);
                }
                continue;
            }
            scope.createName(nd.getName(), true);
        }
    }

    private void updateImplicitReceivers(ASTRewrite rewriter, CallContext context) {
        if (context.receiver == null) {
            return;
        }
        List<Expression> implicitReceivers = this.fAnalyzer.getImplicitReceivers();
        Iterator<Expression> iterator = implicitReceivers.iterator();
        while (iterator.hasNext()) {
            Expression receiver;
            IVariableBinding vb;
            Expression expression;
            Expression node = expression = iterator.next();
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)node, context.importer);
            if (node instanceof MethodInvocation) {
                MethodInvocation inv = (MethodInvocation)node;
                rewriter.set((ASTNode)inv, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, (IMethodBinding)inv.getName().resolveBinding(), (ImportRewrite.ImportRewriteContext)importRewriteContext), null);
                continue;
            }
            if (node instanceof ClassInstanceCreation) {
                ClassInstanceCreation inst = (ClassInstanceCreation)node;
                rewriter.set((ASTNode)inst, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, inst.resolveConstructorBinding(), (ImportRewrite.ImportRewriteContext)importRewriteContext), null);
                continue;
            }
            if (node instanceof ThisExpression) {
                rewriter.replace((ASTNode)node, rewriter.createStringPlaceholder(context.receiver, 32), null);
                continue;
            }
            if (node instanceof FieldAccess) {
                FieldAccess access = (FieldAccess)node;
                rewriter.set((ASTNode)access, (StructuralPropertyDescriptor)FieldAccess.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, access.resolveFieldBinding(), (ImportRewrite.ImportRewriteContext)importRewriteContext), null);
                continue;
            }
            if (!(node instanceof SimpleName) || !(((SimpleName)node).resolveBinding() instanceof IVariableBinding) || !(vb = (IVariableBinding)((SimpleName)node).resolveBinding()).isField() || (receiver = this.createReceiver(rewriter, context, vb, (ImportRewrite.ImportRewriteContext)importRewriteContext)) == null || vb.isEnumConstant() && node.getLocationInParent() == SwitchCase.EXPRESSIONS2_PROPERTY) continue;
            FieldAccess access = node.getAST().newFieldAccess();
            ASTNode target = rewriter.createMoveTarget((ASTNode)node);
            access.setName((SimpleName)target);
            access.setExpression(receiver);
            rewriter.replace((ASTNode)node, (ASTNode)access, null);
        }
    }

    private void updateTypeReferences(ASTRewrite rewriter, CallContext context) {
        ImportRewrite importer = context.importer;
        for (SimpleName simpleName : this.fAnalyzer.getTypesToImport()) {
            SimpleName element = simpleName;
            ITypeBinding binding = ASTNodes.getTypeBinding((Name)element);
            if (binding == null || binding.isLocal()) continue;
            if (binding.isParameterizedType()) {
                binding = binding.getTypeDeclaration();
            }
            Object[] bindingNameComponents = Bindings.getNameComponents(binding);
            try {
                IType[] types;
                IType[] iTypeArray = types = context.compilationUnit.getAllTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    String typeName = type.getFullyQualifiedName();
                    Object[] typeNameComponents = typeName.split("\\.|\\$");
                    if (Arrays.equals(bindingNameComponents, typeNameComponents)) {
                        return;
                    }
                    ++n2;
                }
                String s = importer.addImport(binding);
                if (ASTNodes.asString((ASTNode)element).equals(s)) continue;
                rewriter.replace((ASTNode)element, rewriter.createStringPlaceholder(s, 42), null);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private void updateStaticReferences(ASTRewrite rewriter, CallContext context) {
        ImportRewrite importer = context.importer;
        for (SimpleName simpleName : this.fAnalyzer.getStaticsToImport()) {
            SimpleName element = simpleName;
            IBinding binding = element.resolveBinding();
            if (binding == null) continue;
            String s = importer.addStaticImport(binding);
            if (ASTNodes.asString((ASTNode)element).equals(s)) continue;
            rewriter.replace((ASTNode)element, rewriter.createStringPlaceholder(s, 42), null);
        }
    }

    private void updateInnerStaticReferences(ASTRewrite rewriter, CallContext context) {
        if (context.invocation instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)context.invocation;
            AbstractTypeDeclaration typeDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)invocation, AbstractTypeDeclaration.class);
            AbstractTypeDeclaration sourceTypeDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)this.fDeclaration, AbstractTypeDeclaration.class);
            if (typeDecl != null && !typeDecl.isPackageMemberTypeDeclaration() && typeDecl != sourceTypeDecl) {
                ITypeBinding typeDeclBinding = typeDecl.resolveBinding();
                ArrayList<IVariableBinding> targetStaticFields = new ArrayList<IVariableBinding>();
                ArrayList<IMethodBinding> targetStaticMethods = new ArrayList<IMethodBinding>();
                if (typeDeclBinding != null) {
                    ITypeBinding sourceTypeBinding;
                    ITypeBinding[] typeInterfaces;
                    IVariableBinding[] fields = typeDeclBinding.getDeclaredFields();
                    IMethodBinding[] methods = typeDeclBinding.getDeclaredMethods();
                    IVariableBinding[] iVariableBindingArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVariableBinding field = iVariableBindingArray[n2];
                        if (Modifier.isStatic((int)field.getModifiers())) {
                            targetStaticFields.add(field);
                        }
                        ++n2;
                    }
                    iVariableBindingArray = methods;
                    n = methods.length;
                    n2 = 0;
                    while (n2 < n) {
                        IVariableBinding method = iVariableBindingArray[n2];
                        if (Modifier.isStatic((int)method.getModifiers())) {
                            targetStaticMethods.add((IMethodBinding)method);
                        }
                        ++n2;
                    }
                    this.getAccessibleStaticFieldsAndMethods(typeDeclBinding.getSuperclass(), targetStaticFields, targetStaticMethods);
                    ITypeBinding[] iTypeBindingArray = typeInterfaces = typeDeclBinding.getInterfaces();
                    int n3 = typeInterfaces.length;
                    n = 0;
                    while (n < n3) {
                        ITypeBinding typeInterface = iTypeBindingArray[n];
                        this.getAccessibleStaticFieldsAndMethods(typeInterface, targetStaticFields, targetStaticMethods);
                        ++n;
                    }
                    if (!(targetStaticFields.isEmpty() && targetStaticMethods.isEmpty() || (sourceTypeBinding = sourceTypeDecl.resolveBinding()) == null)) {
                        String qualifiedName = sourceTypeBinding.getQualifiedName();
                        String packageName = sourceTypeBinding.getPackage().getName();
                        String qualifierNeeded = qualifiedName.substring(packageName.length() + 1);
                        UpdateStaticQualifierVisitor visitor = new UpdateStaticQualifierVisitor(rewriter, targetStaticFields, targetStaticMethods, qualifierNeeded);
                        this.fDeclaration.accept((ASTVisitor)visitor);
                    }
                }
            }
        }
    }

    private void getAccessibleStaticFieldsAndMethods(ITypeBinding typeBinding, List<IVariableBinding> fieldList, List<IMethodBinding> methodList) {
        ITypeBinding[] typeInterfaces;
        if (typeBinding == null) {
            return;
        }
        IVariableBinding[] fields = typeBinding.getDeclaredFields();
        IMethodBinding[] methods = typeBinding.getDeclaredMethods();
        IVariableBinding[] iVariableBindingArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding field = iVariableBindingArray[n2];
            int fieldModifiers = field.getModifiers();
            if (Modifier.isStatic((int)fieldModifiers) && !Modifier.isPrivate((int)fieldModifiers)) {
                fieldList.add(field);
            }
            ++n2;
        }
        iVariableBindingArray = methods;
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            IVariableBinding method = iVariableBindingArray[n2];
            int methodModifiers = method.getModifiers();
            if (Modifier.isStatic((int)methodModifiers) && !Modifier.isPrivate((int)methodModifiers)) {
                methodList.add((IMethodBinding)method);
            }
            ++n2;
        }
        this.getAccessibleStaticFieldsAndMethods(typeBinding.getSuperclass(), fieldList, methodList);
        ITypeBinding[] iTypeBindingArray = typeInterfaces = typeBinding.getInterfaces();
        int n3 = typeInterfaces.length;
        n = 0;
        while (n < n3) {
            ITypeBinding typeInterface = iTypeBindingArray[n];
            this.getAccessibleStaticFieldsAndMethods(typeInterface, fieldList, methodList);
            ++n;
        }
    }

    private Expression createReceiver(ASTRewrite rewriter, CallContext context, IMethodBinding method, ImportRewrite.ImportRewriteContext importRewriteContext) {
        String receiver = this.getReceiver(context, method.getModifiers(), importRewriteContext);
        if (receiver == null) {
            return null;
        }
        return (Expression)rewriter.createStringPlaceholder(receiver, 32);
    }

    private Expression createReceiver(ASTRewrite rewriter, CallContext context, IVariableBinding field, ImportRewrite.ImportRewriteContext importRewriteContext) {
        String receiver = this.getReceiver(context, field.getModifiers(), importRewriteContext);
        if (receiver == null) {
            return null;
        }
        return (Expression)rewriter.createStringPlaceholder(receiver, 42);
    }

    private String getReceiver(CallContext context, int modifiers, ImportRewrite.ImportRewriteContext importRewriteContext) {
        String receiver = context.receiver;
        ITypeBinding invocationType = ASTNodes.getEnclosingType(context.invocation);
        ITypeBinding sourceType = this.fDeclaration.resolveBinding().getDeclaringClass();
        if (invocationType != null && invocationType.getName().equals(receiver)) {
            return null;
        }
        if (!context.receiverIsStatic && Modifier.isStatic((int)modifiers)) {
            receiver = "this".equals(receiver) && invocationType != null && Bindings.equals((IBinding)invocationType, (IBinding)sourceType) ? null : context.importer.addImport(sourceType, importRewriteContext);
        }
        return receiver;
    }

    private void updateTypeVariables(ASTRewrite rewriter, CallContext context) {
        ITypeBinding type = context.getReceiverType();
        if (type == null) {
            return;
        }
        this.rewriteReferences(rewriter, type.getTypeArguments(), this.fAnalyzer.getTypeParameterReferences());
    }

    private void updateMethodTypeVariable(ASTRewrite rewriter, CallContext context) {
        IMethodBinding method = Invocations.resolveBinding(context.invocation);
        if (method == null) {
            return;
        }
        this.rewriteReferences(rewriter, method.getTypeArguments(), this.fAnalyzer.getMethodTypeParameterReferences());
    }

    private void updateReturnStatements(final ASTRewrite rewriter, CallContext context) {
        if (rewriter != null && context != null && context.callMode == 101) {
            Block nodeToVisit = this.fDeclaration.getBody();
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visit(ReturnStatement node) {
                    Expression exp = node.getExpression();
                    YieldStatement yStmt = rewriter.getAST().newYieldStatement();
                    yStmt.setExpression((Expression)rewriter.createMoveTarget((ASTNode)exp));
                    rewriter.replace((ASTNode)node, (ASTNode)yStmt, null);
                    return false;
                }
            };
            nodeToVisit.accept(visitor);
        }
    }

    private void rewriteReferences(ASTRewrite rewriter, ITypeBinding[] typeArguments, List<SourceAnalyzer.NameData> typeParameterReferences) {
        if (typeArguments.length == 0) {
            return;
        }
        Assert.isTrue((typeArguments.length == typeParameterReferences.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < typeArguments.length) {
            SourceAnalyzer.NameData refData = typeParameterReferences.get(i);
            List<SimpleName> references = refData.references();
            String newName = typeArguments[i].getName();
            for (SimpleName name : references) {
                rewriter.replace((ASTNode)name, rewriter.createStringPlaceholder(newName, 42), null);
            }
            ++i;
        }
    }

    private ASTNode getLastStatement() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.isEmpty()) {
            return null;
        }
        return (ASTNode)statements.get(statements.size() - 1);
    }

    private List<IRegion> getReturnStatementRanges() {
        this.fMarkerMode = 3;
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size <= 1) {
            return result;
        }
        result.add(this.createRange(statements, size - 2));
        return result;
    }

    private List<IRegion> getStatementRanges() {
        this.fMarkerMode = 2;
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size == 0) {
            return result;
        }
        result.add(this.createRange(statements, size - 1));
        return result;
    }

    private List<IRegion> getExpressionRanges() {
        this.fMarkerMode = 1;
        ArrayList<IRegion> result = new ArrayList<IRegion>(2);
        List statements = this.fDeclaration.getBody().statements();
        ReturnStatement rs = null;
        int size = statements.size();
        switch (size) {
            case 0: {
                return result;
            }
            case 1: {
                ASTNode node = (ASTNode)statements.get(0);
                if (node.getNodeType() == 41) {
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(this.createRange(node, node));
                break;
            }
            default: {
                ASTNode node = (ASTNode)statements.get(size - 1);
                if (node.getNodeType() == 41) {
                    result.add(this.createRange(statements, size - 2));
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(this.createRange(statements, size - 1));
            }
        }
        if (rs != null) {
            Expression exp = rs.getExpression();
            if (!(exp instanceof LambdaExpression) && this.hasNLS((Statement)rs)) {
                result.add(this.createRange((ASTNode)exp, (ASTNode)rs));
            } else {
                result.add(this.createRange((ASTNode)exp, (ASTNode)exp));
            }
        }
        return result;
    }

    private boolean hasNLS(Statement s) {
        ASTNode root = s.getRoot();
        if (root instanceof CompilationUnit) {
            CompilationUnit unit = (CompilationUnit)root;
            int start = unit.getExtendedStartPosition((ASTNode)s);
            int length = unit.getExtendedLength((ASTNode)s);
            IJavaElement element = unit.getJavaElement();
            if (element != null && element instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)element;
                try {
                    String statement = icu.getBuffer().getText(start, length);
                    if (statement.matches(".*?//\\s?\\$NON-NLS-\\d+\\$.*$")) {
                        return true;
                    }
                }
                catch (IndexOutOfBoundsException | JavaModelException throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private IRegion createRange(List<Statement> statements, int end) {
        ASTNode first = (ASTNode)statements.get(0);
        ASTNode last = (ASTNode)statements.get(end);
        return this.createRange(first, last);
    }

    private IRegion createRange(ASTNode first, ASTNode last) {
        ASTNode root = first.getRoot();
        if (root instanceof CompilationUnit) {
            CompilationUnit unit = (CompilationUnit)root;
            int start = unit.getExtendedStartPosition(first);
            int length = unit.getExtendedStartPosition(last) - start + unit.getExtendedLength(last);
            Region range = new Region(start, length);
            return range;
        }
        int start = first.getStartPosition();
        int length = last.getStartPosition() - start + last.getLength();
        Region range = new Region(start, length);
        return range;
    }

    private String[] getBlocks(RangeMarker[] markers) throws BadLocationException {
        String[] result = new String[markers.length];
        ICompilationUnit cu = this.fTypeRoot instanceof ICompilationUnit ? (ICompilationUnit)this.fTypeRoot : null;
        IJavaProject project = this.fTypeRoot.getJavaProject();
        int i = 0;
        while (i < markers.length) {
            RangeMarker marker = markers[i];
            String content = this.fDocument.get(marker.getOffset(), marker.getLength());
            String[] lines = Strings.convertIntoLines(content);
            if (cu != null) {
                Strings.trimIndentation(lines, cu, false);
            } else {
                Strings.trimIndentation(lines, project, false);
            }
            if (this.fMarkerMode == 2 && lines.length == 2 && this.isSingleControlStatementWithoutBlock()) {
                lines[1] = cu != null ? CodeFormatterUtil.createIndentString(1, cu) + lines[1] : CodeFormatterUtil.createIndentString(1, project) + lines[1];
            }
            result[i] = Strings.concatenate(lines, TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument));
            ++i;
        }
        return result;
    }

    private boolean isSingleControlStatementWithoutBlock() {
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size != 1) {
            return false;
        }
        Statement statement = (Statement)statements.get(size - 1);
        int nodeType = statement.getNodeType();
        switch (nodeType) {
            case 25: {
                IfStatement ifStatement = (IfStatement)statement;
                return !(ifStatement.getThenStatement() instanceof Block) && !(ifStatement.getElseStatement() instanceof Block);
            }
            case 24: {
                return !(((ForStatement)statement).getBody() instanceof Block);
            }
            case 61: {
                return !(((WhileStatement)statement).getBody() instanceof Block);
            }
        }
        return false;
    }

    public RefactoringStatus checkAccessCompatible(ASTNode targetNode) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fAnalyzer.onlyAccessesPublic()) {
            return result;
        }
        IMethodBinding declBinding = this.fDeclaration.resolveBinding();
        if (declBinding == null) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
            return result;
        }
        ASTNode targetRoot = targetNode.getRoot();
        if (targetRoot instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)targetRoot;
            ITypeRoot iTypeRoot = this.fTypeRoot;
            if (iTypeRoot instanceof ICompilationUnit) {
                MethodInvocation invocation;
                ITypeBinding targetTypeBinding;
                ICompilationUnit rootICU = (ICompilationUnit)iTypeRoot;
                AbstractTypeDeclaration typeNode = ASTNodes.getTopLevelTypeDeclaration(targetNode);
                AbstractTypeDeclaration declTypeNode = ASTNodes.getTopLevelTypeDeclaration((ASTNode)this.fDeclaration);
                if (typeNode != null && declTypeNode != null) {
                    ITypeBinding typeNodeBinding = typeNode.resolveBinding();
                    ITypeBinding declTypeNodeBinding = declTypeNode.resolveBinding();
                    if (typeNodeBinding != null && declTypeNodeBinding != null && typeNodeBinding.isEqualTo((IBinding)declTypeNodeBinding)) {
                        return result;
                    }
                }
                if (this.fAnalyzer.accessesPrivate()) {
                    result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_accesses_private, JavaStatusContext.create(this.fTypeRoot));
                    return result;
                }
                PackageDeclaration packageDecl = cu.getPackage();
                IPackageDeclaration[] rootPackageDecls = rootICU.getPackageDeclarations();
                if (packageDecl.getName().getFullyQualifiedName().equals(rootPackageDecls[0].getElementName())) {
                    return result;
                }
                if (this.fAnalyzer.accessesPackagePrivate()) {
                    result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_accesses_package_private, JavaStatusContext.create(this.fTypeRoot));
                    return result;
                }
                ITypeBinding typeBinding = declBinding.getDeclaringClass();
                if (typeBinding == null) {
                    result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
                    return result;
                }
                if (typeNode != null && (targetTypeBinding = typeNode.resolveBinding()) != null && (ASTNodes.findImplementedType(targetTypeBinding, typeBinding.getQualifiedName()) == null || targetNode instanceof MethodInvocation && (invocation = (MethodInvocation)targetNode).getExpression() != null && !(invocation.getExpression() instanceof ThisExpression))) {
                    result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_accesses_protected, JavaStatusContext.create(this.fTypeRoot));
                }
            }
        }
        return result;
    }

    private class ReturnAnalyzer
    extends ASTVisitor {
        private ReturnAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            Expression expression = node.getExpression();
            if (!ASTNodes.isLiteral(expression) && !(expression instanceof Name)) {
                SourceProvider.this.fMustEvalReturnedExpression = true;
            }
            if (Invocations.isInvocation((ASTNode)expression) || expression instanceof ClassInstanceCreation) {
                SourceProvider.this.fReturnValueNeedsLocalVariable = false;
            }
            SourceProvider.this.fReturnExpressions.add(expression);
            return false;
        }
    }

    private class UpdateStaticQualifierVisitor
    extends ASTVisitor {
        private final List<IVariableBinding> fTargetStaticFields;
        private final List<IMethodBinding> fTargetStaticMethods;
        private final ASTRewrite fRewriter;
        private final String fQualifierNeeded;

        public UpdateStaticQualifierVisitor(ASTRewrite rewriter, List<IVariableBinding> targetStaticFields, List<IMethodBinding> targetStaticMethods, String qualifierNeeded) {
            this.fTargetStaticFields = targetStaticFields;
            this.fTargetStaticMethods = targetStaticMethods;
            this.fRewriter = rewriter;
            this.fQualifierNeeded = qualifierNeeded;
        }

        public boolean visit(SimpleName name) {
            block4: {
                IVariableBinding varBinding;
                block3: {
                    IMethodBinding binding;
                    if (name.getLocationInParent() != MethodInvocation.NAME_PROPERTY) break block3;
                    MethodInvocation node = (MethodInvocation)name.getParent();
                    if (node.getExpression() != null || !Modifier.isStatic((int)(binding = node.resolveMethodBinding()).getModifiers())) break block4;
                    for (IMethodBinding staticMethodBinding : this.fTargetStaticMethods) {
                        if (!staticMethodBinding.getName().equals(binding.getName())) continue;
                        AST ast = this.fRewriter.getAST();
                        Name newName = ast.newName(this.fQualifierNeeded + "." + name.getFullyQualifiedName());
                        this.fRewriter.replace((ASTNode)name, (ASTNode)newName, null);
                    }
                    break block4;
                }
                IBinding binding = name.resolveBinding();
                if (binding instanceof IVariableBinding && (varBinding = (IVariableBinding)binding).isField()) {
                    for (IVariableBinding staticFieldBinding : this.fTargetStaticFields) {
                        if (!staticFieldBinding.getName().equals(varBinding.getName())) continue;
                        AST ast = this.fRewriter.getAST();
                        Name newName = ast.newName(this.fQualifierNeeded + "." + name.getFullyQualifiedName());
                        this.fRewriter.replace((ASTNode)name, (ASTNode)newName, null);
                    }
                }
            }
            return false;
        }
    }

    static class VariableReferenceFinder
    extends ASTVisitor {
        private boolean fResult;
        private IVariableBinding fBinding;

        public VariableReferenceFinder(IVariableBinding binding) {
            this.fBinding = binding;
        }

        public boolean getResult() {
            return this.fResult;
        }

        public boolean visit(SimpleName node) {
            if (!this.fResult) {
                this.fResult = Bindings.equals((IBinding)this.fBinding, node.resolveBinding());
            }
            return false;
        }
    }
}

