/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.commands.BuildPathCommand;
import org.eclipse.jdt.ls.core.internal.commands.DiagnosticsCommand;
import org.eclipse.jdt.ls.core.internal.commands.OrganizeImportsCommand;
import org.eclipse.jdt.ls.core.internal.commands.ProjectClasspathEntries;
import org.eclipse.jdt.ls.core.internal.commands.ProjectCommand;
import org.eclipse.jdt.ls.core.internal.commands.SourceAttachmentCommand;
import org.eclipse.jdt.ls.core.internal.commands.TypeHierarchyCommand;
import org.eclipse.jdt.ls.core.internal.commands.VmCommand;
import org.eclipse.jdt.ls.core.internal.framework.protobuf.ProtobufSupport;
import org.eclipse.jdt.ls.core.internal.handlers.BundleUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CreateModuleInfoHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.handlers.PasteEventHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ResolveSourceMappingHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SmartDetectionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SmartDetectionParams;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.managers.GradleProjectImporter;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.legacy.typeHierarchy.ResolveTypeHierarchyItemParams;
import org.eclipse.lsp4j.legacy.typeHierarchy.TypeHierarchyDirection;
import org.eclipse.lsp4j.legacy.typeHierarchy.TypeHierarchyItem;
import org.eclipse.lsp4j.legacy.typeHierarchy.TypeHierarchyParams;

public class JDTDelegateCommandHandler
implements IDelegateCommandHandler {
    @Override
    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        block108: {
            if (StringUtils.isBlank((CharSequence)commandId)) break block108;
            switch (commandId) {
                case "java.edit.organizeImports": {
                    OrganizeImportsCommand c = new OrganizeImportsCommand();
                    Object result = c.organizeImports(arguments);
                    boolean applyNow = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isWorkspaceApplyEditSupported();
                    if (applyNow) {
                        JavaLanguageServerPlugin.getInstance().getClientConnection().applyWorkspaceEdit((WorkspaceEdit)result);
                        return new Object();
                    }
                    return result;
                }
                case "java.edit.stringFormatting": {
                    FormatterHandler handler = new FormatterHandler(JavaLanguageServerPlugin.getPreferencesManager());
                    return handler.stringFormatting((String)arguments.get(0), JSONUtility.toModel(arguments.get(1), Map.class), Integer.parseInt((String)arguments.get(2)), monitor);
                }
                case "java.edit.handlePasteEvent": {
                    return PasteEventHandler.handlePasteEvent(JSONUtility.toLsp4jModel(arguments.get(0), PasteEventHandler.PasteEventParams.class), monitor);
                }
                case "java.project.resolveSourceAttachment": {
                    return SourceAttachmentCommand.resolveSourceAttachment(arguments, monitor);
                }
                case "java.project.updateSourceAttachment": {
                    return SourceAttachmentCommand.updateSourceAttachment(arguments, monitor);
                }
                case "java.project.addToSourcePath": {
                    String sourceFolder = (String)arguments.get(0);
                    return BuildPathCommand.addToSourcePath(sourceFolder);
                }
                case "java.project.removeFromSourcePath": {
                    String sourceFolder1 = (String)arguments.get(0);
                    return BuildPathCommand.removeFromSourcePath(sourceFolder1);
                }
                case "java.project.listSourcePaths": {
                    return BuildPathCommand.listSourcePaths();
                }
                case "java.project.getSettings": {
                    return ProjectCommand.getProjectSettings((String)arguments.get(0), (ArrayList)arguments.get(1));
                }
                case "java.project.getClasspaths": {
                    return ProjectCommand.getClasspaths((String)arguments.get(0), JSONUtility.toModel(arguments.get(1), ProjectCommand.ClasspathOptions.class));
                }
                case "java.project.updateClassPaths": {
                    String projectUri = (String)arguments.get(0);
                    ProjectClasspathEntries entries = JSONUtility.toModel(arguments.get(1), ProjectClasspathEntries.class);
                    ProjectCommand.updateClasspaths(projectUri, entries.getClasspathEntries(), monitor);
                    return null;
                }
                case "java.project.updateSettings": {
                    String projectUri = (String)arguments.get(0);
                    Map options = JSONUtility.toModel(arguments.get(1), Map.class);
                    ProjectCommand.updateProjectSettings(projectUri, options);
                    return null;
                }
                case "java.project.isTestFile": {
                    return ProjectCommand.isTestFile((String)arguments.get(0));
                }
                case "java.project.getAll": {
                    if (!arguments.isEmpty()) {
                        ProjectCommand.GetAllProjectOptions option = JSONUtility.toModel(arguments.get(0), ProjectCommand.GetAllProjectOptions.class);
                        if (option.includeNonJava) {
                            return ProjectCommand.getAllProjects();
                        }
                    }
                    return ProjectCommand.getAllJavaProjects();
                }
                case "java.project.refreshDiagnostics": {
                    if (arguments.size() < 4) {
                        return DiagnosticsCommand.refreshDiagnostics((String)arguments.get(0), (String)arguments.get(1), (Boolean)arguments.get(2));
                    }
                    return DiagnosticsCommand.refreshDiagnostics((String)arguments.get(0), (String)arguments.get(1), (Boolean)arguments.get(2), (Boolean)arguments.get(3));
                }
                case "java.project.import": {
                    ProjectCommand.importProject(monitor);
                    return null;
                }
                case "java.project.changeImportedProjects": {
                    ProjectCommand.changeImportedProjects((ArrayList)arguments.get(0), (ArrayList)arguments.get(1), (ArrayList)arguments.get(2), monitor);
                    return null;
                }
                case "java.project.resolveStackTraceLocation": {
                    ArrayList projectNames = null;
                    if (arguments.size() > 1) {
                        projectNames = (ArrayList)arguments.get(1);
                    }
                    return ResolveSourceMappingHandler.resolveStackTraceLocation((String)arguments.get(0), projectNames);
                }
                case "java.navigate.resolveTypeHierarchy": {
                    TypeHierarchyCommand resolveTypeHierarchyCommand = new TypeHierarchyCommand();
                    TypeHierarchyItem toResolve = JSONUtility.toModel(arguments.get(0), TypeHierarchyItem.class);
                    TypeHierarchyDirection resolveDirection = TypeHierarchyDirection.forValue(JSONUtility.toModel(arguments.get(1), Integer.class));
                    int resolveDepth = JSONUtility.toModel(arguments.get(2), Integer.class);
                    ResolveTypeHierarchyItemParams resolveParams = new ResolveTypeHierarchyItemParams();
                    resolveParams.setItem(toResolve);
                    resolveParams.setDirection(resolveDirection);
                    resolveParams.setResolve(resolveDepth);
                    TypeHierarchyItem resolvedItem = resolveTypeHierarchyCommand.resolveTypeHierarchy(resolveParams, monitor);
                    return resolvedItem;
                }
                case "java.navigate.openTypeHierarchy": {
                    TypeHierarchyCommand typeHierarchyCommand = new TypeHierarchyCommand();
                    TypeHierarchyParams params = new TypeHierarchyParams();
                    TextDocumentPositionParams textParams = JSONUtility.toModel(arguments.get(0), TextDocumentPositionParams.class);
                    TypeHierarchyDirection direction = TypeHierarchyDirection.forValue(JSONUtility.toModel(arguments.get(1), Integer.class));
                    int resolve = JSONUtility.toModel(arguments.get(2), Integer.class);
                    params.setResolve(resolve);
                    params.setDirection(direction);
                    params.setTextDocument(textParams.getTextDocument());
                    params.setPosition(textParams.getPosition());
                    TypeHierarchyItem typeHierarchyItem = typeHierarchyCommand.typeHierarchy(params, monitor);
                    return typeHierarchyItem;
                }
                case "java.project.upgradeGradle": {
                    String gradleVersion;
                    String projectUri = (String)arguments.get(0);
                    String string = gradleVersion = arguments.size() > 1 ? (String)arguments.get(1) : null;
                    if (gradleVersion == null) {
                        gradleVersion = GradleVersion.current().getVersion();
                    }
                    return GradleProjectImporter.upgradeGradleVersion(projectUri, gradleVersion, monitor);
                }
                case "java.project.resolveWorkspaceSymbol": {
                    SymbolInformation si = JSONUtility.toModel(arguments.get(0), SymbolInformation.class);
                    return ProjectCommand.resolveWorkspaceSymbol(si);
                }
                case "java.project.updateJdk": {
                    String projectUri = (String)arguments.get(0);
                    String jdkPath = (String)arguments.get(1);
                    return ProjectCommand.updateProjectJdk(projectUri, jdkPath, monitor);
                }
                case "java.protobuf.generateSources": {
                    ProtobufSupport.generateProtobufSources((ArrayList)arguments.get(0), monitor);
                    return null;
                }
                case "java.project.createModuleInfo": {
                    return CreateModuleInfoHandler.createModuleInfo((String)arguments.get(0), monitor);
                }
                case "java.reloadBundles": {
                    try {
                        BundleUtils.loadBundles((ArrayList)arguments.get(0));
                        return true;
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.log(e);
                        return false;
                    }
                }
                case "java.completion.onDidSelect": {
                    CompletionHandler completionHandler = new CompletionHandler(JavaLanguageServerPlugin.getPreferencesManager());
                    String requestId = (String)arguments.get(0);
                    String proposalId = (String)arguments.get(1);
                    completionHandler.onDidCompletionItemSelect(requestId, proposalId);
                    return new Object();
                }
                case "java.decompile": {
                    String uri = (String)arguments.get(0);
                    try {
                        ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
                        return contentProvider.getContent(new URI(uri), monitor);
                    }
                    catch (URISyntaxException e) {
                        return false;
                    }
                }
                case "java.edit.smartSemicolonDetection": {
                    if (!JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isSmartSemicolonDetection()) {
                        return null;
                    }
                    SmartDetectionParams smartDetectionParams = JSONUtility.toModel(arguments.get(0), SmartDetectionParams.class);
                    return new SmartDetectionHandler(smartDetectionParams).getLocation(monitor);
                }
                case "java.vm.getAllInstalls": {
                    return VmCommand.getAllVmInstalls();
                }
                case "java.project.resolveText": {
                    return PasteEventHandler.handleFilePasteEvent((String)arguments.get(0), (String)arguments.get(1), monitor);
                }
            }
        }
        throw new UnsupportedOperationException(String.format("Java language server doesn't support the command '%s'.", commandId));
    }
}

