/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.HashMap;
import java.util.function.Function;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.matching.ConstructorLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMConstructorLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMFieldLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMLocalVariableLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMMethodLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMPackageReferenceLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMSuperTypeReferenceLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMTypeDeclarationLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMTypeParameterLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMTypeReferenceLocator;
import org.eclipse.jdt.internal.core.search.matching.FieldLocator;
import org.eclipse.jdt.internal.core.search.matching.LocalVariableLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PackageReferenceLocator;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferenceLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeParameterLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeReferenceLocator;

class PatternLocatorVisitor
extends ASTVisitor {
    private final PatternLocator patternLocator;
    private final NodeSetWrapper nodeSet;
    private MatchLocator locator;
    private HashMap<PatternLocator, DOMPatternLocator> wrapperMap = new HashMap();

    public PatternLocatorVisitor(PatternLocator patternLocator, NodeSetWrapper nodeSet, MatchLocator locator) {
        super(true);
        this.patternLocator = patternLocator;
        this.nodeSet = nodeSet;
        this.locator = locator;
    }

    private DOMPatternLocator getWrapper(PatternLocator locator) {
        DOMPatternLocator l = this.wrapperMap.get(locator);
        if (l == null) {
            l = this.createWrapper(locator);
            this.wrapperMap.put(locator, l);
        }
        return l;
    }

    private DOMPatternLocator createWrapper(PatternLocator locator) {
        if (locator instanceof FieldLocator) {
            FieldLocator fl = (FieldLocator)locator;
            return new DOMFieldLocator(fl);
        }
        if (locator instanceof ConstructorLocator) {
            ConstructorLocator cl = (ConstructorLocator)locator;
            return new DOMConstructorLocator(cl);
        }
        if (locator instanceof LocalVariableLocator) {
            LocalVariableLocator lcl = (LocalVariableLocator)locator;
            return new DOMLocalVariableLocator(lcl);
        }
        if (locator instanceof MethodLocator) {
            MethodLocator ml = (MethodLocator)locator;
            return new DOMMethodLocator(ml);
        }
        if (locator instanceof PackageReferenceLocator) {
            PackageReferenceLocator prl = (PackageReferenceLocator)locator;
            return new DOMPackageReferenceLocator(prl);
        }
        if (locator instanceof SuperTypeReferenceLocator) {
            SuperTypeReferenceLocator strl = (SuperTypeReferenceLocator)locator;
            return new DOMSuperTypeReferenceLocator(strl);
        }
        if (locator instanceof TypeDeclarationLocator) {
            TypeDeclarationLocator tdl = (TypeDeclarationLocator)locator;
            return new DOMTypeDeclarationLocator(tdl);
        }
        if (locator instanceof TypeParameterLocator) {
            TypeParameterLocator tpl = (TypeParameterLocator)locator;
            return new DOMTypeParameterLocator(tpl);
        }
        if (locator instanceof TypeReferenceLocator) {
            TypeReferenceLocator trl = (TypeReferenceLocator)locator;
            return new DOMTypeReferenceLocator(trl);
        }
        return new DOMPatternLocator(null);
    }

    private <T extends ASTNode> boolean defaultVisitImplementation(T node, Function<T, Integer> levelFunc) {
        return this.defaultVisitImplementationWithFunc(node, levelFunc, DOMASTNodeUtils::getBinding);
    }

    private <T extends ASTNode> boolean defaultVisitImplementationWithFunc(T node, Function<T, Integer> levelFunc, Function<T, IBinding> bindingFunc) {
        int level = levelFunc.apply(node);
        if ((level & 0xF) == 2 && (this.nodeSet.getWrapped().mustResolve || this.patternLocator.isMustResolve())) {
            level = this.getWrapper(this.patternLocator).resolveLevel(node, bindingFunc.apply(node), this.locator);
        }
        this.nodeSet.addMatch(node, level);
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((AbstractTypeDeclaration)node, this.nodeSet, this.locator));
    }

    public boolean visit(TypeParameter node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match(node, this.nodeSet, this.locator));
    }

    public boolean visit(MethodDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match(node, this.nodeSet, this.locator));
    }

    public boolean visit(MethodInvocation node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match(node, this.nodeSet, this.locator));
    }

    public boolean visit(ExpressionMethodReference node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((Expression)node, this.nodeSet, this.locator));
    }

    public boolean visit(SuperMethodReference node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((Expression)node, this.nodeSet, this.locator));
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((Expression)node, this.nodeSet, this.locator));
    }

    private boolean visitAbstractTypeDeclaration(AbstractTypeDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match(node, this.nodeSet, this.locator));
    }

    public boolean visit(EnumDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(TypeDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(RecordDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((ASTNode)node, this.nodeSet, this.locator));
    }

    private boolean visitType(Type node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match(node, this.nodeSet, this.locator));
    }

    public boolean visit(SimpleType type) {
        this.visitType((Type)type);
        Name n = type.getName();
        if (n instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)n;
            Name qualifier = qn.getQualifier();
            if (qualifier instanceof SimpleName) {
                SimpleName sn1 = (SimpleName)qualifier;
                this.visit(sn1);
            } else if (qualifier instanceof QualifiedName) {
                QualifiedName qn1 = (QualifiedName)qualifier;
                this.visit(qn1);
            }
        }
        return false;
    }

    public boolean visit(QualifiedType type) {
        return this.visitType((Type)type);
    }

    public boolean visit(NameQualifiedType type) {
        return this.visitType((Type)type);
    }

    public boolean visit(ParameterizedType node) {
        return this.visitType((Type)node);
    }

    public boolean visit(IntersectionType node) {
        return this.visitType((Type)node);
    }

    public boolean visit(UnionType node) {
        return this.visitType((Type)node);
    }

    public boolean visit(ClassInstanceCreation node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((Expression)node, this.nodeSet, this.locator));
    }

    public boolean visit(CreationReference node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((Expression)node, this.nodeSet, this.locator));
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((ASTNode)node, this.nodeSet, this.locator));
    }

    public boolean visit(SimpleName node) {
        if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY || node.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY || node.getLocationInParent() == TypeDeclaration.NAME_PROPERTY || node.getLocationInParent() == EnumDeclaration.NAME_PROPERTY || node.getLocationInParent() == MethodDeclaration.NAME_PROPERTY) {
            return false;
        }
        int level = this.getWrapper(this.patternLocator).match((Name)node, this.nodeSet, this.locator);
        if ((level & 0xF) == 2 && (this.nodeSet.getWrapped().mustResolve || this.patternLocator.isMustResolve())) {
            IBinding b = node.resolveBinding();
            level = this.getWrapper(this.patternLocator).resolveLevel((ASTNode)node, b, this.locator);
        }
        this.nodeSet.addMatch((ASTNode)node, level);
        return level == 0;
    }

    public boolean visit(VariableDeclarationFragment node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((VariableDeclaration)node, this.nodeSet, this.locator));
    }

    public boolean visit(SingleVariableDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.getWrapper(this.patternLocator).match((VariableDeclaration)node, this.nodeSet, this.locator));
    }

    public boolean visit(EnumConstantDeclaration node) {
        int level = this.getWrapper(this.patternLocator).match((ASTNode)node, this.nodeSet, this.locator);
        if ((level & 0xF) == 2 && (this.nodeSet.getWrapped().mustResolve || this.patternLocator.isMustResolve())) {
            int l1 = this.getWrapper(this.patternLocator).resolveLevel((ASTNode)node, (IBinding)node.resolveVariable(), this.locator);
            int l2 = this.getWrapper(this.patternLocator).resolveLevel((ASTNode)node, (IBinding)node.resolveConstructorBinding(), this.locator);
            level = Math.max(l1, l2);
        }
        this.nodeSet.addMatch((ASTNode)node, level);
        return true;
    }

    public boolean visit(QualifiedName node) {
        if (node.getLocationInParent() == SimpleType.NAME_PROPERTY) {
            return false;
        }
        DOMPatternLocator wrapper = this.getWrapper(this.patternLocator);
        int level = wrapper.match((Name)node, this.nodeSet, this.locator);
        if ((level & 0xF) == 2 && (this.nodeSet.getWrapped().mustResolve || this.patternLocator.isMustResolve())) {
            level = wrapper.resolveLevel((ASTNode)node, node.resolveBinding(), this.locator);
        }
        this.nodeSet.addMatch((ASTNode)node, level);
        return (level & 0xF) == 0;
    }

    public boolean visit(ImportDeclaration node) {
        return true;
    }
}

