/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.DependencyModule;
import ch.epfl.scala.bsp4j.DependencyModulesItem;
import ch.epfl.scala.bsp4j.DependencyModulesParams;
import ch.epfl.scala.bsp4j.DependencyModulesResult;
import ch.epfl.scala.bsp4j.JavacOptionsItem;
import ch.epfl.scala.bsp4j.JavacOptionsParams;
import ch.epfl.scala.bsp4j.JavacOptionsResult;
import ch.epfl.scala.bsp4j.MavenDependencyModule;
import ch.epfl.scala.bsp4j.MavenDependencyModuleArtifact;
import ch.epfl.scala.bsp4j.OutputPathItem;
import ch.epfl.scala.bsp4j.OutputPathsItem;
import ch.epfl.scala.bsp4j.OutputPathsParams;
import ch.epfl.scala.bsp4j.OutputPathsResult;
import ch.epfl.scala.bsp4j.ResourcesItem;
import ch.epfl.scala.bsp4j.ResourcesParams;
import ch.epfl.scala.bsp4j.ResourcesResult;
import ch.epfl.scala.bsp4j.SourceItem;
import ch.epfl.scala.bsp4j.SourcesItem;
import ch.epfl.scala.bsp4j.SourcesParams;
import ch.epfl.scala.bsp4j.SourcesResult;
import ch.epfl.scala.bsp4j.extended.JvmBuildTargetEx;
import com.microsoft.gradle.bs.importer.BuildServerConnection;
import com.microsoft.gradle.bs.importer.EclipseVmUtil;
import com.microsoft.gradle.bs.importer.GradleBuildServerProjectImporter;
import com.microsoft.gradle.bs.importer.ImporterPlugin;
import com.microsoft.gradle.bs.importer.Utils;
import com.microsoft.gradle.bs.importer.jpms.JpmsArguments;
import com.microsoft.gradle.bs.importer.jpms.JpmsUtils;
import com.microsoft.gradle.bs.importer.model.GradleVersion;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;

public class GradleBuildServerBuildSupport
implements IBuildSupport {
    private static final String JAVA_HOME = "javaHome";
    private static final String GRADLE_VERSION = "gradleVersion";
    private static final String SOURCE_COMPATIBILITY = "sourceCompatibility";
    private static final String TARGET_COMPATIBILITY = "targetCompatibility";
    private static final Pattern GRADLE_FILE_EXT = Pattern.compile("^.*\\.gradle(\\.kts)?$");
    private static final String GRADLE_PROPERTIES = "gradle.properties";
    private static final String OUTPUT_KIND_SOURCE = "source";
    private static final String OUTPUT_KIND_RESOURCE = "resource";
    private static final String BUILD_TOOL_NAME = "GradleBuildServer";
    private static final IClasspathAttribute testAttribute = JavaCore.newClasspathAttribute((String)"test", (String)"true");
    private static final IClasspathAttribute optionalAttribute = JavaCore.newClasspathAttribute((String)"optional", (String)"true");
    private static final IClasspathAttribute modularAttribute = JavaCore.newClasspathAttribute((String)"module", (String)"true");
    private static final IClasspathAttribute buildServerAttribute = JavaCore.newClasspathAttribute((String)"gradle.buildServer", (String)"true");
    private static final IClasspathAttribute resourceAttribute = JavaCore.newClasspathAttribute((String)"resource", (String)"true");

    public boolean applies(IProject project) {
        return Utils.isGradleBuildServerProject(project);
    }

    public void onWillUpdate(Collection<IProject> projects, IProgressMonitor monitor) throws CoreException {
        HashSet<IPath> roots = new HashSet<IPath>();
        for (IProject project : projects) {
            IPath rootPath = ProjectUtils.findBelongedWorkspaceRoot((IPath)project.getLocation());
            if (rootPath == null) continue;
            roots.add(rootPath);
        }
        for (IPath rootPath : roots) {
            BuildServerConnection connection = ImporterPlugin.getBuildServerConnection(rootPath);
            if (connection == null) {
                JavaLanguageServerPlugin.logInfo((String)("Skip reloading " + rootPath + " because the connection is not available."));
                continue;
            }
            connection.workspaceReload().join();
        }
    }

    public void update(IProject project, boolean force, IProgressMonitor monitor) throws CoreException {
        boolean shouldUpdate;
        if (!this.applies(project)) {
            return;
        }
        boolean bl = shouldUpdate = GradleBuildServerProjectImporter.updateConfigurationDigest(project) || force;
        if (shouldUpdate) {
            IPath rootPath = ProjectUtils.findBelongedWorkspaceRoot((IPath)project.getLocation());
            if (rootPath == null) {
                JavaLanguageServerPlugin.logError((String)("Cannot find workspace root for project: " + project.getName()));
                return;
            }
            BuildServerConnection connection = ImporterPlugin.getBuildServerConnection(rootPath);
            if (connection == null) {
                JavaLanguageServerPlugin.logError((String)("Cannot find build server connection for root: " + rootPath));
                return;
            }
            Map<URI, List<BuildTarget>> buildTargetMap = Utils.getBuildTargetsMappedByProjectPath(connection);
            for (URI uri : buildTargetMap.keySet()) {
                IProject projectFromUri = ProjectUtils.getProjectFromUri((String)uri.toString());
                if (projectFromUri == null || !Utils.isGradleBuildServerProject(projectFromUri)) continue;
                this.updateClasspath(connection, projectFromUri, monitor);
                this.updateProjectDependencies(connection, projectFromUri, monitor);
            }
        }
    }

    public String buildToolName() {
        return BUILD_TOOL_NAME;
    }

    public void updateClasspath(BuildServerConnection connection, IProject project, IProgressMonitor monitor) throws CoreException {
        IPath rootPath = ProjectUtils.findBelongedWorkspaceRoot((IPath)project.getLocation());
        if (rootPath == null) {
            JavaLanguageServerPlugin.logError((String)("Cannot find workspace root for project: " + project.getName()));
            return;
        }
        Map<IPath, IClasspathEntry> classpathMap = new LinkedHashMap();
        List<BuildTarget> buildTargets = Utils.getBuildTargetsByProjectUri(connection, project.getLocationURI());
        this.moveTestTargetsToEnd(buildTargets);
        for (BuildTarget buildTarget : buildTargets) {
            boolean isTest = buildTarget.getTags().contains("test");
            OutputPathsResult outputResult = (OutputPathsResult)connection.buildTargetOutputPaths(new OutputPathsParams(Arrays.asList(buildTarget.getId()))).join();
            String sourceOutputUri = this.getOutputUriByKind(outputResult.getItems(), OUTPUT_KIND_SOURCE);
            IPath sourceOutputFullPath = this.getOutputFullPath(sourceOutputUri, project);
            if (sourceOutputFullPath == null) {
                JavaLanguageServerPlugin.logError((String)("Cannot find source output path for build target: " + buildTarget.getId()));
            } else {
                SourcesResult sourcesResult = (SourcesResult)connection.buildTargetSources(new SourcesParams(Arrays.asList(buildTarget.getId()))).join();
                List<IClasspathEntry> sourceEntries = this.getSourceEntries(rootPath, project, sourcesResult, sourceOutputFullPath, isTest, monitor);
                for (IClasspathEntry entry : sourceEntries) {
                    classpathMap.putIfAbsent(entry.getPath(), entry);
                }
            }
            String resourceOutputUri = this.getOutputUriByKind(outputResult.getItems(), OUTPUT_KIND_RESOURCE);
            IPath resourceOutputFullPath = this.getOutputFullPath(resourceOutputUri, project);
            if (resourceOutputFullPath == null) continue;
            ResourcesResult resourcesResult = (ResourcesResult)connection.buildTargetResources(new ResourcesParams(Arrays.asList(buildTarget.getId()))).join();
            List<IClasspathEntry> resourceEntries = this.getResourceEntries(project, resourcesResult, resourceOutputFullPath, isTest);
            for (IClasspathEntry entry : resourceEntries) {
                classpathMap.putIfAbsent(entry.getPath(), entry);
            }
        }
        if (classpathMap.isEmpty()) {
            return;
        }
        Utils.addNature(project, "org.eclipse.jdt.core.javanature", monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOption("org.eclipse.jdt.core.classpath.outputOverlappingAnotherSource", "ignore");
        classpathMap = this.getSourceCpeWithExclusions(new LinkedList<IClasspathEntry>(classpathMap.values())).stream().collect(Collectors.toMap(IClasspathEntry::getPath, Function.identity(), (e1, e2) -> e1, LinkedHashMap::new));
        javaProject.setRawClasspath(classpathMap.values().toArray(new IClasspathEntry[0]), monitor);
        boolean isModular = javaProject.getOwnModuleDescription() != null;
        this.setProjectJdk(classpathMap, buildTargets, javaProject, isModular);
        for (BuildTarget buildTarget : buildTargets) {
            boolean isTest = buildTarget.getTags().contains("test");
            DependencyModulesResult dependencyModuleResult = (DependencyModulesResult)connection.buildTargetDependencyModules(new DependencyModulesParams(Arrays.asList(buildTarget.getId()))).join();
            List<IClasspathEntry> dependencyEntries = this.getDependencyJars(dependencyModuleResult, isTest, isModular);
            for (IClasspathEntry entry : dependencyEntries) {
                classpathMap.putIfAbsent(entry.getPath(), entry);
            }
        }
        javaProject.setRawClasspath(classpathMap.values().toArray(new IClasspathEntry[0]), monitor);
        JavacOptionsResult javacOptions = (JavacOptionsResult)connection.buildTargetJavacOptions(new JavacOptionsParams(buildTargets.stream().map(BuildTarget::getId).collect(Collectors.toList()))).join();
        LinkedList<String> compilerArgs = new LinkedList<String>();
        for (JavacOptionsItem item : javacOptions.getItems()) {
            compilerArgs.addAll(item.getOptions());
        }
        JpmsArguments jpmsArgs = JpmsUtils.categorizeJpmsArguments(compilerArgs);
        if (jpmsArgs.isEmpty()) {
            return;
        }
        JpmsUtils.appendJpmsAttributesToEntries(javaProject, classpathMap, jpmsArgs);
        javaProject.setRawClasspath(classpathMap.values().toArray(new IClasspathEntry[0]), monitor);
    }

    public void updateProjectDependencies(BuildServerConnection connection, IProject project, IProgressMonitor monitor) throws CoreException {
        IPath rootPath = ProjectUtils.findBelongedWorkspaceRoot((IPath)project.getLocation());
        if (rootPath == null) {
            JavaLanguageServerPlugin.logError((String)("Cannot find workspace root for project: " + project.getName()));
            return;
        }
        List<BuildTarget> buildTargets = Utils.getBuildTargetsByProjectUri(connection, project.getLocationURI());
        LinkedHashSet<BuildTargetIdentifier> projectDependencies = new LinkedHashSet<BuildTargetIdentifier>();
        for (BuildTarget buildTarget : buildTargets) {
            projectDependencies.addAll(buildTarget.getDependencies());
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        LinkedList<IClasspathEntry> classpath = new LinkedList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        classpath.addAll(this.getProjectDependencyEntries(project, projectDependencies));
        javaProject.setRawClasspath((IClasspathEntry[])classpath.toArray(IClasspathEntry[]::new), javaProject.getOutputLocation(), monitor);
    }

    private List<IClasspathEntry> getProjectDependencyEntries(IProject project, Set<BuildTargetIdentifier> projectDependencies) {
        LinkedList<IClasspathEntry> entries = new LinkedList<IClasspathEntry>();
        for (BuildTargetIdentifier dependency : projectDependencies) {
            URI uri = Utils.getUriWithoutQuery(dependency.getUri());
            IProject dependencyProject = ProjectUtils.getProjectFromUri((String)uri.toString());
            if (dependencyProject == null || Objects.equals(project, dependencyProject)) continue;
            entries.add(JavaCore.newProjectEntry((IPath)dependencyProject.getFullPath(), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[]{buildServerAttribute}, (boolean)false));
        }
        return entries;
    }

    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        return this.isBuildFile(resource) || super.fileChanged(resource, changeType, monitor);
    }

    public boolean isBuildFile(IResource resource) {
        return resource != null && resource.getType() == 1 && this.isBuildLikeFileName(resource.getName()) && Utils.isGradleBuildServerProject(resource.getProject());
    }

    public boolean isBuildLikeFileName(String fileName) {
        return GRADLE_FILE_EXT.matcher(fileName).matches() || fileName.equals(GRADLE_PROPERTIES);
    }

    private List<IClasspathEntry> getSourceEntries(IPath rootPath, IProject project, SourcesResult sourcesResult, IPath outputFullPath, boolean isTest, IProgressMonitor monitor) throws CoreException {
        LinkedList<IClasspathEntry> sourceEntries = new LinkedList<IClasspathEntry>();
        for (SourcesItem sources : sourcesResult.getItems()) {
            for (SourceItem source : sources.getSources()) {
                IPath sourceFullPath;
                IPath sourcePath = ResourceUtils.filePathFromURI((String)source.getUri());
                IPath projectLocation = project.getLocation();
                if (projectLocation.isPrefixOf(sourcePath)) {
                    relativeSourcePath = sourcePath.makeRelativeTo(project.getLocation());
                    sourceFullPath = project.getFolder(relativeSourcePath).getFullPath();
                } else {
                    relativeSourcePath = sourcePath.makeRelativeTo(rootPath);
                    if (relativeSourcePath.isAbsolute()) {
                        JavaLanguageServerPlugin.logError((String)("The source path is not relative to the workspace root: " + relativeSourcePath));
                        continue;
                    }
                    IFolder linkFolder = project.getFolder(String.join((CharSequence)"_", relativeSourcePath.segments()));
                    if (!linkFolder.exists()) {
                        linkFolder.createLink(sourcePath, 272, monitor);
                    }
                    sourceFullPath = linkFolder.getFullPath();
                }
                if (sourceEntries.stream().anyMatch(entry -> entry.getPath().equals((Object)sourceFullPath))) continue;
                LinkedList<IClasspathAttribute> classpathAttributes = new LinkedList<IClasspathAttribute>();
                if (isTest) {
                    classpathAttributes.add(testAttribute);
                }
                if (!sourcePath.toFile().exists() || source.getGenerated().booleanValue() || this.isInBuildDir(sourceFullPath)) {
                    classpathAttributes.add(optionalAttribute);
                }
                classpathAttributes.add(buildServerAttribute);
                sourceEntries.add(JavaCore.newSourceEntry((IPath)sourceFullPath, null, null, (IPath)outputFullPath, (IClasspathAttribute[])classpathAttributes.toArray(new IClasspathAttribute[0])));
            }
        }
        return sourceEntries;
    }

    private List<IClasspathEntry> getResourceEntries(IProject project, ResourcesResult resourcesResult, IPath outputFullPath, boolean isTest) {
        LinkedList<IClasspathEntry> resourceEntries = new LinkedList<IClasspathEntry>();
        for (ResourcesItem resources : resourcesResult.getItems()) {
            for (String resourceUri : resources.getResources()) {
                IPath resourcePath = ResourceUtils.filePathFromURI((String)resourceUri);
                IPath relativeResourcePath = resourcePath.makeRelativeTo(project.getLocation());
                IPath resourceFullPath = project.getFolder(relativeResourcePath).getFullPath();
                LinkedList<IClasspathAttribute> classpathAttributes = new LinkedList<IClasspathAttribute>();
                if (isTest) {
                    classpathAttributes.add(testAttribute);
                }
                classpathAttributes.add(optionalAttribute);
                classpathAttributes.add(buildServerAttribute);
                classpathAttributes.add(resourceAttribute);
                resourceEntries.add(JavaCore.newSourceEntry((IPath)resourceFullPath, null, null, (IPath)outputFullPath, (IClasspathAttribute[])classpathAttributes.toArray(new IClasspathAttribute[0])));
            }
        }
        return resourceEntries;
    }

    private void moveTestTargetsToEnd(List<BuildTarget> buildTargets) {
        buildTargets.sort((bt1, bt2) -> Boolean.compare(bt1.getTags().contains("test"), bt2.getTags().contains("test")));
    }

    private IPath getOutputFullPath(String outputUri, IProject project) throws CoreException {
        if (StringUtils.isBlank((CharSequence)outputUri)) {
            return null;
        }
        IPath sourceOutputPath = ResourceUtils.filePathFromURI((String)Utils.getUriWithoutQuery(outputUri).toString());
        File outputDirectory = sourceOutputPath.toFile();
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        IPath relativeSourceOutputPath = sourceOutputPath.makeRelativeTo(project.getLocation());
        IFolder outputFolder = project.getFolder(relativeSourceOutputPath);
        outputFolder.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return outputFolder.getFullPath();
    }

    private String getOutputUriByKind(List<OutputPathsItem> items, String kind) {
        for (OutputPathsItem outputs : items) {
            for (OutputPathItem output : outputs.getOutputPaths()) {
                if (!Objects.equals(kind, Utils.getQueryValueByKey(output.getUri(), "kind"))) continue;
                return output.getUri();
            }
        }
        return "";
    }

    private boolean isInBuildDir(IPath sourceFullPath) {
        return Arrays.stream(sourceFullPath.segments()).anyMatch(segment -> segment.equals("build"));
    }

    private void setProjectJdk(Map<IPath, IClasspathEntry> classpathMap, List<BuildTarget> buildTargets, IJavaProject javaProject, boolean isModular) throws CoreException {
        String targetCompatibility;
        JvmBuildTargetEx jvmBuildTarget = this.getJvmTarget(buildTargets);
        String sourceCompatibility = jvmBuildTarget.getSourceCompatibility();
        if (StringUtils.isNotBlank((CharSequence)sourceCompatibility)) {
            javaProject.setOption("org.eclipse.jdt.core.compiler.source", sourceCompatibility);
        }
        if (StringUtils.isNotBlank((CharSequence)(targetCompatibility = jvmBuildTarget.getTargetCompatibility()))) {
            javaProject.setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetCompatibility);
            javaProject.setOption("org.eclipse.jdt.core.compiler.compliance", targetCompatibility);
        }
        String highestJavaVersion = this.getHighestCompatibleJavaVersion(jvmBuildTarget.getGradleVersion());
        try {
            IVMInstall vm = EclipseVmUtil.findOrRegisterStandardVM(targetCompatibility, sourceCompatibility, highestJavaVersion, new File(new URI(jvmBuildTarget.getJavaHome())));
            LinkedList<IClasspathAttribute> classpathAttributes = new LinkedList<IClasspathAttribute>();
            if (isModular) {
                classpathAttributes.add(modularAttribute);
            }
            classpathAttributes.add(buildServerAttribute);
            IClasspathEntry jdkEntry = JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((IVMInstall)vm), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])classpathAttributes.toArray(new IClasspathAttribute[0]), (boolean)false);
            classpathMap.putIfAbsent(jdkEntry.getPath(), jdkEntry);
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "com.microsoft.gradle.buildServer.importer", "Invalid Java home: " + jvmBuildTarget.getJavaHome(), (Throwable)e));
        }
    }

    private JvmBuildTargetEx getJvmTarget(List<BuildTarget> buildTargets) throws CoreException {
        JvmBuildTargetEx jvmTarget = new JvmBuildTargetEx("", "");
        for (BuildTarget buildTarget : buildTargets) {
            String targetCompatibility;
            String sourceCompatibility;
            String gradleVersion;
            if (!"jvm".equals(buildTarget.getDataKind())) continue;
            JvmBuildTargetEx rawJvmTarget = (JvmBuildTargetEx)((Object)JSONUtility.toModel((Object)buildTarget.getData(), JvmBuildTargetEx.class));
            if (StringUtils.isNotBlank((CharSequence)rawJvmTarget.getJavaHome()) && StringUtils.isBlank((CharSequence)jvmTarget.getJavaHome())) {
                jvmTarget.setJavaHome(rawJvmTarget.getJavaHome());
            }
            if (StringUtils.isNotBlank((CharSequence)(gradleVersion = rawJvmTarget.getGradleVersion())) && StringUtils.isBlank((CharSequence)jvmTarget.getGradleVersion())) {
                jvmTarget.setGradleVersion(gradleVersion);
            }
            if (StringUtils.isNotBlank((CharSequence)(sourceCompatibility = rawJvmTarget.getSourceCompatibility()))) {
                sourceCompatibility = this.getEclipseCompatibleVersion(sourceCompatibility);
                if (StringUtils.isBlank((CharSequence)jvmTarget.getSourceCompatibility()) || JavaCore.compareJavaVersions((String)sourceCompatibility, (String)jvmTarget.getSourceCompatibility()) > 0) {
                    jvmTarget.setSourceCompatibility(sourceCompatibility);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(targetCompatibility = rawJvmTarget.getTargetCompatibility()))) continue;
            targetCompatibility = this.getEclipseCompatibleVersion(targetCompatibility);
            if (!StringUtils.isBlank((CharSequence)jvmTarget.getTargetCompatibility()) && JavaCore.compareJavaVersions((String)targetCompatibility, (String)jvmTarget.getTargetCompatibility()) <= 0) continue;
            jvmTarget.setTargetCompatibility(targetCompatibility);
        }
        if (StringUtils.isBlank((CharSequence)jvmTarget.getJavaHome()) || StringUtils.isBlank((CharSequence)jvmTarget.getGradleVersion())) {
            throw new CoreException((IStatus)new Status(4, "com.microsoft.gradle.buildServer.importer", "Invalid JVM build target: " + jvmTarget.toString()));
        }
        return jvmTarget;
    }

    private String getEclipseCompatibleVersion(String javaVersion) {
        if ("1.9".equals(javaVersion)) {
            return "9";
        }
        if ("1.10".equals(javaVersion)) {
            return "10";
        }
        return javaVersion;
    }

    private List<IClasspathEntry> getDependencyJars(DependencyModulesResult dependencyModuleResult, boolean isTest, boolean isModular) {
        LinkedList<IClasspathEntry> dependencyEntries = new LinkedList<IClasspathEntry>();
        for (DependencyModulesItem item : dependencyModuleResult.getItems()) {
            for (DependencyModule module : item.getModules()) {
                MavenDependencyModule mavenDependencyModule;
                List artifacts;
                if (!"maven".equals(module.getDataKind()) || (artifacts = (mavenDependencyModule = (MavenDependencyModule)JSONUtility.toModel((Object)module.getData(), MavenDependencyModule.class)).getArtifacts()) == null) continue;
                File artifact = null;
                File sourceArtifact = null;
                for (MavenDependencyModuleArtifact artifactData : artifacts) {
                    String uri = artifactData.getUri();
                    if (uri == null) continue;
                    String classifier = artifactData.getClassifier();
                    try {
                        File jarFile = new File(new URI(uri));
                        if (classifier == null) {
                            artifact = jarFile;
                            continue;
                        }
                        if (!"sources".equals(classifier)) continue;
                        sourceArtifact = jarFile;
                    }
                    catch (URISyntaxException e) {
                        JavaLanguageServerPlugin.logException((Throwable)e);
                    }
                }
                if (artifact == null) continue;
                LinkedList<IClasspathAttribute> attributes = new LinkedList<IClasspathAttribute>();
                if (isTest) {
                    attributes.add(testAttribute);
                } else if (isModular) {
                    attributes.add(modularAttribute);
                }
                if (!artifact.exists()) {
                    attributes.add(optionalAttribute);
                }
                attributes.add(buildServerAttribute);
                dependencyEntries.add(JavaCore.newLibraryEntry((IPath)new Path(artifact.getAbsolutePath()), (IPath)(sourceArtifact == null ? null : new Path(sourceArtifact.getAbsolutePath())), null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])attributes.toArray(new IClasspathAttribute[0]), (boolean)false));
            }
        }
        return dependencyEntries;
    }

    private String getHighestCompatibleJavaVersion(String gradleVersion) {
        GradleVersion version = GradleVersion.version(gradleVersion);
        if (version.compareTo(GradleVersion.version("8.8")) >= 0) {
            return "22";
        }
        if (version.compareTo(GradleVersion.version("8.5")) >= 0) {
            return "21";
        }
        if (version.compareTo(GradleVersion.version("8.3")) >= 0) {
            return "20";
        }
        if (version.compareTo(GradleVersion.version("7.6")) >= 0) {
            return "19";
        }
        if (version.compareTo(GradleVersion.version("7.5")) >= 0) {
            return "18";
        }
        if (version.compareTo(GradleVersion.version("7.3")) >= 0) {
            return "17";
        }
        if (version.compareTo(GradleVersion.version("7.0")) >= 0) {
            return "16";
        }
        if (version.compareTo(GradleVersion.version("6.7")) >= 0) {
            return "15";
        }
        if (version.compareTo(GradleVersion.version("6.3")) >= 0) {
            return "14";
        }
        if (version.compareTo(GradleVersion.version("6.0")) >= 0) {
            return "13";
        }
        if (version.compareTo(GradleVersion.version("5.4")) >= 0) {
            return "12";
        }
        if (version.compareTo(GradleVersion.version("5.0")) >= 0) {
            return "11";
        }
        if (version.compareTo(GradleVersion.version("4.7")) >= 0) {
            return "10";
        }
        if (version.compareTo(GradleVersion.version("4.3")) >= 0) {
            return "9";
        }
        if (version.compareTo(GradleVersion.version("2.0")) >= 0) {
            return "1.8";
        }
        return "1.8";
    }

    private List<IClasspathEntry> getSourceCpeWithExclusions(List<IClasspathEntry> sourceEntries) {
        Collections.sort(sourceEntries, (path1, path2) -> path1.getPath().toString().compareTo(path2.getPath().toString()) * -1);
        LinkedList<IClasspathEntry> newSourceEntries = new LinkedList<IClasspathEntry>();
        for (IClasspathEntry currentEntry : sourceEntries) {
            ArrayList<IPath> exclusionPatterns = new ArrayList<IPath>();
            for (IClasspathEntry sourceEntry : newSourceEntries) {
                if (Objects.equals(currentEntry.getPath(), sourceEntry.getPath()) || !currentEntry.getPath().isPrefixOf(sourceEntry.getPath())) continue;
                exclusionPatterns.add(sourceEntry.getPath().makeRelativeTo(currentEntry.getPath()).addTrailingSeparator());
            }
            newSourceEntries.add(JavaCore.newSourceEntry((IPath)currentEntry.getPath(), (IPath[])currentEntry.getInclusionPatterns(), (IPath[])exclusionPatterns.toArray(new IPath[0]), (IPath)currentEntry.getOutputLocation(), (IClasspathAttribute[])currentEntry.getExtraAttributes()));
        }
        return newSourceEntries;
    }
}

