/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.model.ISystemPromptableObject;
import org.eclipse.rse.ui.view.ISystemViewRunnableObject;
import org.eclipse.swt.widgets.Shell;

public class SystemNewConnectionPromptObject
implements ISystemPromptableObject,
ISystemViewRunnableObject,
IAdaptable {
    private Object parent;
    private IRSESystemType[] systemTypes;
    private ISystemPromptableObject[] children;
    private SystemNewConnectionAction action = null;
    private boolean systemTypesSet = false;
    private String newConnText;
    private boolean isRootPrompt = false;
    protected static final Comparator SYSTEM_TYPE_SORTER = new RSESystemTypeSorter();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SystemNewConnectionPromptObject() {
        this.setSystemTypes(RSECorePlugin.getTheCoreRegistry().getSystemTypes());
        this.isRootPrompt = true;
    }

    public SystemNewConnectionPromptObject(SystemNewConnectionPromptObject parent, IRSESystemType systemType) {
        this.parent = parent;
        this.setSystemTypes(new IRSESystemType[]{systemType});
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.systemTypes = systemTypes;
        this.systemTypesSet = true;
    }

    public IRSESystemType[] getSystemTypes() {
        IRSESystemType[] types = this.systemTypes;
        if (types == null || !this.systemTypesSet) {
            types = new IRSESystemType[]{};
        }
        return types;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    public ISystemPromptableObject[] getChildren() {
        if (!this.hasChildren()) {
            return null;
        }
        if (this.children == null) {
            if (this.isRootPrompt) {
                this.systemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
            }
            if (this.systemTypes != null) {
                this.children = new ISystemPromptableObject[this.systemTypes.length];
                int idx = 0;
                while (idx < this.children.length) {
                    this.children[idx] = new SystemNewConnectionPromptObject(this, this.systemTypes[idx]);
                    ++idx;
                }
            }
        }
        return this.getChildrenFiltered(this.children);
    }

    private ISystemPromptableObject[] getChildrenFiltered(ISystemPromptableObject[] children) {
        if (children == null) {
            return null;
        }
        ArrayList<ISystemPromptableObject> filtered = new ArrayList<ISystemPromptableObject>();
        int i = 0;
        while (i < children.length) {
            ISystemPromptableObject promptObject = children[i];
            if (promptObject instanceof SystemNewConnectionPromptObject) {
                IRSESystemType[] systemTypes = ((SystemNewConnectionPromptObject)promptObject).getSystemTypes();
                boolean enabled = true;
                int j = 0;
                while (j < systemTypes.length && enabled) {
                    ViewerFilter filter;
                    IRSESystemType systemType = systemTypes[j];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.jface.viewers.ViewerFilter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((filter = (ViewerFilter)systemType.getAdapter((Class)clazz)) != null && !filter.select(null, null, (Object)systemType)) {
                        enabled = false;
                    }
                    if (enabled) {
                        RSESystemTypeAdapter adapter;
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((adapter = (RSESystemTypeAdapter)systemType.getAdapter((Class)clazz2)) != null && !adapter.isEnabled(systemType)) {
                            enabled = false;
                        }
                    }
                    ++j;
                }
                if (enabled) {
                    filtered.add(promptObject);
                }
            } else {
                filtered.add(promptObject);
            }
            ++i;
        }
        if (!filtered.isEmpty()) {
            Collections.sort(filtered, SYSTEM_TYPE_SORTER);
        }
        return filtered.toArray(new ISystemPromptableObject[filtered.size()]);
    }

    public boolean hasChildren() {
        return this.systemTypes != null && (this.systemTypes.length != 1 || this.isRootPrompt);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.hasChildren()) {
            return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newconnection_wizIcon");
        }
        IRSESystemType iRSESystemType = this.systemTypes[0];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RSESystemTypeAdapter adapter = (RSESystemTypeAdapter)iRSESystemType.getAdapter((Class)clazz);
        return adapter.getImageDescriptor(this.systemTypes[0]);
    }

    public String getText() {
        if (this.newConnText == null) {
            if (this.isRootPrompt || this.getSystemTypes().length == 0) {
                this.newConnText = this.hasChildren() ? SystemResources.RESID_NEWCONN_PROMPT_LABEL : String.valueOf(SystemResources.RESID_NEWCONN_PROMPT_LABEL) + " ...";
            } else if (this.getSystemTypes().length > 0) {
                this.newConnText = String.valueOf(this.systemTypes[0].getLabel()) + " ...";
            }
        }
        return this.newConnText;
    }

    public String getType() {
        if (this.hasChildren()) {
            return SystemResources.RESID_NEWCONN_EXPANDABLEPROMPT_VALUE;
        }
        return SystemResources.RESID_NEWCONN_PROMPT_VALUE;
    }

    public Object[] run(Shell shell) {
        if (this.action == null) {
            this.action = new SystemNewConnectionAction(shell, false, false, null);
        }
        if (this.systemTypes != null) {
            this.action.restrictSystemTypes(this.systemTypes);
        }
        try {
            this.action.run();
        }
        catch (Exception exc) {
            return new Object[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, null)};
        }
        IHost newConnection = (IHost)this.action.getValue();
        SystemMessageObject result = null;
        result = newConnection != null ? new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1108"), 4, null) : new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, null);
        return new Object[]{result};
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    private static class RSESystemTypeSorter
    implements Comparator {
        private RSESystemTypeSorter() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IRSESystemType && o2 instanceof IRSESystemType) {
                return ((IRSESystemType)o1).getLabel().compareTo(((IRSESystemType)o2).getLabel());
            }
            if (o1 instanceof ISystemPromptableObject && o2 instanceof ISystemPromptableObject) {
                return ((ISystemPromptableObject)o1).getText().compareTo(((ISystemPromptableObject)o2).getText());
            }
            return 0;
        }
    }
}

