/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.trace4cps.core.IAttributeAware;

public class AttributeAware
implements IAttributeAware {
    private final Map<String, String> attributes = new HashMap<String, String>();

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public String getAttributeValue(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, this.removeNewlines(value));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    public void setAttributes(Map<String, String> atts) {
        this.attributes.clear();
        if (atts != null) {
            for (Map.Entry<String, String> e : atts.entrySet()) {
                this.setAttribute(e.getKey(), e.getValue());
            }
        }
    }

    private String removeNewlines(String s) {
        return s.replace('\n', ' ');
    }

    public String toString() {
        return "AttributeAware[" + this.attributes.toString() + "]";
    }
}

