/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.ITSSeries;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.ui.view.ClaimDataItem;
import org.eclipse.trace4cps.ui.view.DependencyDataItem;
import org.eclipse.trace4cps.ui.view.EventDataItem;
import org.eclipse.trace4cps.ui.view.SignalDataItem;
import org.eclipse.trace4cps.ui.view.TimeSeriesDataItem;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class EclipseToolTipGenerator
implements XYToolTipGenerator {
    private final Supplier<TraceViewConfiguration> viewConfigSupplier;

    public EclipseToolTipGenerator(Supplier<TraceViewConfiguration> viewConfigSupplier) {
        this.viewConfigSupplier = viewConfigSupplier;
    }

    private Collection<String> getDescribingAttributes(TracePart part) {
        return this.viewConfigSupplier.get().getDescribingAttributes(part);
    }

    public String generateToolTip(XYDataset ds, int series, int item) {
        EventDataItem eDataItem = EventDataItem.getFrom(ds, series, item);
        if (eDataItem != null) {
            IEvent e = (IEvent)eDataItem.getBackReference().getSelectedTraceItem();
            return TraceHelper.getValues((IAttributeAware)e, this.getDescribingAttributes(TracePart.EVENT), (boolean)false);
        }
        DependencyDataItem dDataItem = DependencyDataItem.getFrom(ds, series, item);
        if (dDataItem != null) {
            IDependency d = (IDependency)dDataItem.getBackReference().getSelectedTraceItem();
            return TraceHelper.getValues((IAttributeAware)d, this.getDescribingAttributes(TracePart.DEPENDENCY), (boolean)false);
        }
        ClaimDataItem cDataItem = ClaimDataItem.getFrom(ds, series, item);
        if (cDataItem != null) {
            IClaim c = (IClaim)cDataItem.getBackReference().getSelectedTraceItem();
            return TraceHelper.getValues((IAttributeAware)c, this.getDescribingAttributes(TracePart.CLAIM), (boolean)false);
        }
        SignalDataItem sDataItem = SignalDataItem.getFrom(ds, series, item);
        if (sDataItem != null) {
            IPsopFragment f = (IPsopFragment)sDataItem.getBackReference().getSelectedTraceItem();
            return "Signal fragment: " + String.valueOf(f.dom()) + " : " + String.valueOf(f.getC()) + ", " + String.valueOf(f.getB()) + ", " + String.valueOf(f.getA()) + " (" + String.valueOf(f.getShape()) + ")";
        }
        TimeSeriesDataItem tsDataItem = TimeSeriesDataItem.getFrom(ds, series, item);
        if (tsDataItem != null) {
            ITSSeries ts = (ITSSeries)tsDataItem.getBackReference().getSelectedTraceItem();
            String name = ts.getAttributes().getOrDefault("name", "Value");
            return "<html><body>Time = " + tsDataItem.getX().toString() + "<br>" + name + " = " + tsDataItem.getY().toString() + "</body></html>";
        }
        return String.valueOf(ds) + " " + series + " " + item;
    }
}

