/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.trace4cps.core.IAttributeFilter;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.AnalysisUtil;
import org.eclipse.trace4cps.ui.dialog.BehaviorWizard;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class BehaviorRepresentativesAction
extends AbstractTraceViewAction {
    public BehaviorRepresentativesAction(TraceView view) {
        super(view);
        this.setText("Behavioral representatives");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1 && this.view.hasClaims(true);
    }

    @Override
    protected void doRun() throws TraceException {
        BehaviorWizard wizard = new BehaviorWizard(this.view);
        if (new WizardDialog(this.view.getEditorSite().getShell(), (IWizard)wizard).open() == 1) {
            return;
        }
        String idAtt = wizard.getIdAttribute();
        Set<String> uniqueness = wizard.getUniqueness();
        IAttributeFilter f = AnalysisUtil.computeBehavioralRepresentativeFilter(this.view.getTrace(), idAtt, uniqueness);
        this.viewCfg.addNonPersistentFilter(TracePart.CLAIM, f);
        this.view.update();
    }
}

