/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ToolChainManager
implements IToolChainManager {
    private Map<String, IConfigurationElement> providerElements;
    private Map<String, IToolChainProvider> providers;
    private Map<String, Map<String, IToolChain>> toolChains;
    private Map<String, String> toolChainTypeNames = new HashMap<String, String>();
    private List<IToolChain> orderedToolChains;
    private List<ISafeRunnable> listeners = new ArrayList<ISafeRunnable>();

    private synchronized void init() {
        block20: {
            if (this.providerElements != null) break block20;
            this.providerElements = new HashMap<String, IConfigurationElement>();
            this.providers = new HashMap<String, IToolChainProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint typesPoint = registry.getExtensionPoint("org.eclipse.cdt.core.toolChainProvider");
            IConfigurationElement[] iConfigurationElementArray = typesPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String id = element.getAttribute("id");
                this.providerElements.put(id, element);
                ++n2;
            }
            this.toolChains = new HashMap<String, Map<String, IToolChain>>();
            for (IConfigurationElement element : this.providerElements.values()) {
                switch (element.getName()) {
                    case "provider": {
                        SafeRunner.run(() -> {
                            IToolChainProvider provider = (IToolChainProvider)element.createExecutableExtension("class");
                            this.providers.put(element.getAttribute("id"), provider);
                            provider.init(this);
                        });
                        break;
                    }
                    case "type": {
                        this.toolChainTypeNames.put(element.getAttribute("id"), element.getAttribute("name"));
                    }
                }
            }
            this.orderedToolChains = new ArrayList<IToolChain>();
            Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").node(this.getClass().getSimpleName()).node("order");
            String nString = prefs.get("n", "");
            if (!nString.isEmpty()) {
                try {
                    int n3 = Integer.parseInt(nString);
                    int i = 0;
                    while (i < n3) {
                        String id;
                        String typeId = prefs.get(String.valueOf(Integer.toString(i)) + ".type", "");
                        IToolChain toolChain = this.getToolChain(typeId, id = prefs.get(String.valueOf(Integer.toString(i)) + ".id", ""));
                        if (toolChain != null) {
                            this.orderedToolChains.add(toolChain);
                        }
                        ++i;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CCorePlugin.log(numberFormatException);
                }
                catch (CoreException coreException) {
                    CCorePlugin.log(coreException.getStatus());
                }
            }
            for (Map map : this.toolChains.values()) {
                for (IToolChain toolChain : map.values()) {
                    if (this.orderedToolChains.contains(toolChain)) continue;
                    this.orderedToolChains.add(toolChain);
                }
            }
        }
    }

    @Override
    public String getToolChainTypeName(String typeId) {
        this.init();
        String name = this.toolChainTypeNames.get(typeId);
        return name != null ? name : typeId;
    }

    private void saveToolChainOrder() {
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").node(this.getClass().getSimpleName()).node("order");
        prefs.put("n", Integer.toString(this.orderedToolChains.size()));
        int i = 0;
        IToolChain[] iToolChainArray = this.orderedToolChains.toArray(new IToolChain[0]);
        int n = iToolChainArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain toolChain = iToolChainArray[n2];
            prefs.put(String.valueOf(Integer.toString(i)) + ".type", toolChain.getTypeId());
            prefs.put(String.valueOf(Integer.toString(i)) + ".id", toolChain.getId());
            ++i;
            ++n2;
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public void addToolChain(IToolChain toolChain) {
        Map<String, IToolChain> type = this.toolChains.get(toolChain.getTypeId());
        if (type == null) {
            type = new LinkedHashMap<String, IToolChain>();
            this.toolChains.put(toolChain.getTypeId(), type);
        }
        type.put(toolChain.getId(), toolChain);
        if (this.orderedToolChains != null) {
            this.orderedToolChains.add(toolChain);
            this.saveToolChainOrder();
        }
        this.fireChange();
    }

    @Override
    public void removeToolChain(IToolChain toolChain) {
        Map<String, IToolChain> type = this.toolChains.get(toolChain.getTypeId());
        if (type != null) {
            type.remove(toolChain.getId());
        }
        if (this.orderedToolChains.remove(toolChain)) {
            this.saveToolChainOrder();
        }
        this.fireChange();
    }

    @Override
    public IToolChainProvider getProvider(String providerId) throws CoreException {
        IConfigurationElement element;
        this.init();
        IToolChainProvider provider = this.providers.get(providerId);
        if (provider == null && (element = this.providerElements.get(providerId)) != null) {
            SafeRunner.run(() -> {
                IToolChainProvider provider2 = (IToolChainProvider)element.createExecutableExtension("class");
                this.providers.put(providerId, provider2);
                provider2.init(this);
            });
            return this.providers.get(providerId);
        }
        return provider;
    }

    @Override
    public IToolChain getToolChain(String typeId, String id) throws CoreException {
        this.init();
        Map<String, IToolChain> type = this.toolChains.get(typeId);
        return type != null ? type.get(id) : null;
    }

    @Override
    public Collection<IToolChain> getToolChainsMatching(Map<String, String> properties) {
        this.init();
        ArrayList<IToolChain> tcs = new ArrayList<IToolChain>();
        if (this.orderedToolChains != null) {
            IToolChain[] iToolChainArray = this.orderedToolChains.toArray(new IToolChain[0]);
            int n = iToolChainArray.length;
            int n2 = 0;
            while (n2 < n) {
                IToolChain toolChain = iToolChainArray[n2];
                if (toolChain.matches(properties)) {
                    tcs.add(toolChain);
                }
                ++n2;
            }
        }
        return tcs;
    }

    @Override
    public Collection<IToolChain> getAllToolChains() throws CoreException {
        this.init();
        return Collections.unmodifiableCollection(this.orderedToolChains);
    }

    @Override
    public void setToolChainOrder(List<IToolChain> orderedToolchains) throws CoreException {
        this.orderedToolChains = orderedToolchains;
        this.saveToolChainOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToolChainListener(ISafeRunnable listener) {
        List<ISafeRunnable> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeToolChainListener(ISafeRunnable listener) {
        List<ISafeRunnable> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ISafeRunnable> runners;
        List<ISafeRunnable> list = this.listeners;
        synchronized (list) {
            runners = new ArrayList<ISafeRunnable>(this.listeners);
        }
        for (ISafeRunnable runner : runners) {
            SafeRunner.run((ISafeRunnable)runner);
        }
    }
}

