/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfThreadSelectedSignal;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.FusedVMInformationProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.trace.VirtualMachineExperiment;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.Machine;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.Messages;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.Processor;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.SelectMachineDialog;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.VirtualResourceEntry;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.VirtualResourcePresentationProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractStateSystemTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class VirtualResourcesView
extends AbstractStateSystemTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.virtualresources";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.FusedVMView_stateTypeName};
    private final Action fHighlightMachine = new Action(Messages.FusedVMView_ButtonMachineSelected, 2){

        public void run() {
            VirtualResourcesView.this.refresh();
        }
    };
    private final Action fHighlightCPU = new Action(Messages.FusedVMView_ButtonCPUSelected, 2){

        public void run() {
            VirtualResourcesView.this.refresh();
        }
    };
    private final Action fHighlightProcess = new Action(Messages.FusedVMView_ButtonProcessSelected, 2){

        public void run() {
            VirtualResourcePresentationProvider presentationProvider = VirtualResourcesView.this.getFusedVMViewPresentationProvider();
            presentationProvider.resetTimeEventHighlight();
            VirtualResourcesView.this.refresh();
        }
    };
    private final Action fHighlightContainer = new Action(Messages.FusedVMView_ButtonContainerSelected, 2){

        public void run() {
            VirtualResourcesView.this.refresh();
        }
    };
    private Action fSelectMachineAction;
    private long beginSelectedTime;
    private long endSelectedTime;
    private final ITimeGraphTimeListener fTimeListenerFusedVMView = new ITimeGraphTimeListener(){

        public void timeSelected(TimeGraphTimeEvent event) {
            VirtualResourcesView.this.setBeginSelectedTime(event.getBeginTime());
            VirtualResourcesView.this.setEndSelectedTime(event.getEndTime());
            long begin = VirtualResourcesView.this.getBeginSelectedTime();
            long end = VirtualResourcesView.this.getEndSelectedTime();
            if (begin == end) {
                VirtualResourcePresentationProvider presentationProvider = VirtualResourcesView.this.getFusedVMViewPresentationProvider();
                Object o = presentationProvider.getSelectedFusedVMViewEntry();
                if (o == null) {
                    return;
                }
                if (!(o instanceof VirtualResourceEntry)) {
                    return;
                }
                VirtualResourceEntry entry = (VirtualResourceEntry)o;
                int cpuQuark = entry.getQuark();
                ITmfTrace trace = VirtualResourcesView.this.getTrace();
                if (trace == null) {
                    return;
                }
                ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
                if (ssq == null) {
                    return;
                }
                String machineName = null;
                try {
                    int machineNameQuark = ssq.getQuarkRelative(cpuQuark, new String[]{"Machine_name"});
                    ITmfStateInterval interval = ssq.querySingleState(begin, machineNameQuark);
                    ITmfStateValue value = interval.getStateValue();
                    machineName = value.unboxStr();
                    presentationProvider.setSelectedMachine(machineName);
                    int threadQuark = ssq.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                    interval = ssq.querySingleState(begin, threadQuark);
                    value = interval.getStateValue();
                    int threadID = value.unboxInt();
                    presentationProvider.setSelectedThread(new HostThread(machineName, Integer.valueOf(threadID)));
                    int conditionQuark = ssq.getQuarkRelative(cpuQuark, new String[]{"Condition"});
                    interval = ssq.querySingleState(begin, conditionQuark);
                    value = interval.getStateValue();
                    int condition = value.unboxInt();
                    List list = ssq.getQuarks(cpuQuark, new String[]{"Virtual_cpu"});
                    if (condition == 0 && !list.isEmpty()) {
                        int machineVCpuQuark = (Integer)list.get(0);
                        interval = ssq.querySingleState(begin, machineVCpuQuark);
                        value = interval.getStateValue();
                        int vcpu = value.unboxInt();
                        presentationProvider.setSelectedCpu(vcpu);
                    } else {
                        presentationProvider.setSelectedCpu(Integer.parseInt(ssq.getAttributeName(cpuQuark)));
                    }
                    if (threadID == 0) {
                        ++threadID;
                    }
                    int nsInumQuark = FusedVMInformationProvider.getNodeNsInum((ITmfStateSystem)ssq, (long)begin, (String)machineName, (int)threadID);
                    interval = ssq.querySingleState(begin, nsInumQuark);
                    String container = Long.toString(interval.getStateValue().unboxLong());
                    presentationProvider.setSelectedContainer(container);
                }
                catch (AttributeNotFoundException e) {
                    Activator.getDefault().logError("Error in FusedVirtualMachineView, timestamp: " + FusedVMInformationProvider.formatTime((long)event.getBeginTime()), e);
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {}
                VirtualResourcesView.this.updateButtonsSelection();
                VirtualResourcesView.this.updateToolTipTexts();
            } else {
                VirtualResourcesView.this.printInformations();
            }
        }
    };
    private final ITimeGraphSelectionListener fSelListenerFusedVMView = new ITimeGraphSelectionListener(){

        public void selectionChanged(TimeGraphSelectionEvent event) {
            ITimeGraphEntry entry = event.getSelection();
            if (entry instanceof VirtualResourceEntry) {
                VirtualResourcePresentationProvider presentationProvider = VirtualResourcesView.this.getFusedVMViewPresentationProvider();
                presentationProvider.setSelectedFusedVMViewEntry(entry);
            }
        }
    };
    private final MouseWheelListener fWheelListener = new MouseWheelListener(){

        public void mouseScrolled(MouseEvent e) {
            if ((e.stateMask & 0x20000) != 0) {
                VirtualResourcePresentationProvider presentationProvider = VirtualResourcesView.this.getFusedVMViewPresentationProvider();
                presentationProvider.modifySelectedThreadAlpha(e.count);
                presentationProvider.resetTimeEventHighlight();
                VirtualResourcesView.this.refresh();
            }
        }
    };
    private final Map<ITmfTrace, Machine> fPhysicalMachines = new HashMap<ITmfTrace, Machine>();
    private Map<String, Machine> fMachines;
    private static final Comparator<ITimeGraphEntry> ENTRY_COMPARATOR = new Comparator<ITimeGraphEntry>(){

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            if (!(o1 instanceof VirtualResourceEntry) || !(o2 instanceof VirtualResourceEntry)) {
                return 0;
            }
            return ((VirtualResourceEntry)o1).compareTo(o2);
        }
    };

    public VirtualResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new VirtualResourcePresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new FusedVMFilterLabelProvider());
        this.setEntryComparator(new FusedVMViewEntryComparator());
    }

    protected String getNextText() {
        return Messages.FusedVMView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.FusedVMView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.FusedVMView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.FusedVMView_previousResourceActionToolTipText;
    }

    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, final IProgressMonitor monitor) {
        long startTime;
        if (monitor.isCanceled()) {
            return;
        }
        if (!(parentTrace instanceof VirtualMachineExperiment)) {
            return;
        }
        final ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)parentTrace, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
        if (ssq == null) {
            return;
        }
        ssq.waitUntilBuilt();
        VirtualResourcePresentationProvider presentationProvider = this.getFusedVMViewPresentationProvider();
        presentationProvider.setSelectedElements(Collections.emptySet());
        this.fMachines = new HashMap<String, Machine>();
        Machine physicalMachine = this.createHierarchy(ssq);
        if (physicalMachine == null) {
            return;
        }
        this.fPhysicalMachines.put(trace, physicalMachine);
        VirtualResourceEntry traceEntry = null;
        long start = startTime = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), startTime));
        if (monitor.isCanceled()) {
            return;
        }
        long end = ssq.getCurrentEndTime();
        long endTime = end + 1L;
        this.setEndTime(Math.max(this.getEndTime(), endTime));
        List machinesQuarks = ssq.getQuarks(new String[]{"Hosts", "*"});
        String hostName = null;
        Iterator iterator = machinesQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            try {
                if (ssq.querySingleState(trace.getStartTime().getValue(), quark).getStateValue().unboxInt() != 1) continue;
                hostName = ssq.getAttributeName(quark);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                return;
            }
        }
        traceEntry = new VirtualResourceEntry(trace, hostName, startTime, endTime, VirtualResourceEntry.Type.VM, 0);
        traceEntry.sortChildren(ENTRY_COMPARATOR);
        List<@NonNull VirtualResourceEntry> entryList = Collections.singletonList(traceEntry);
        this.addToEntryList(parentTrace, ssq, entryList);
        this.createPhysicalCpuEntries(trace, ssq, traceEntry, startTime, endTime);
        this.createMachineAndContainerEntries(trace, ssq, physicalMachine, traceEntry, startTime, endTime);
        if (parentTrace.equals(this.getTrace())) {
            this.refresh();
        }
        final List traceEntryChildren = traceEntry.getChildren();
        long resolution = Math.max(1L, (endTime - ssq.getStartTime()) / (long)this.getDisplayWidth());
        long qStart = start;
        long qEnd = end;
        this.queryFullStates(ssq, qStart, qEnd, resolution, monitor, new AbstractStateSystemTimeGraphView.IQueryHandler(){

            public void handle(List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState) {
                for (ITimeGraphEntry child : traceEntryChildren) {
                    if (this.populateEventsRecursively(fullStates, prevFullState, child).isOK()) continue;
                    return;
                }
            }

            private IStatus populateEventsRecursively(@NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, ITimeGraphEntry entry) {
                TimeGraphEntry timeGraphEntry;
                List<ITimeEvent> eventList;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (entry instanceof TimeGraphEntry && (eventList = VirtualResourcesView.this.getEventList(timeGraphEntry = (TimeGraphEntry)entry, ssq, fullStates, prevFullState, monitor)) != null) {
                    for (ITimeEvent event : eventList) {
                        timeGraphEntry.addEvent(event);
                    }
                }
                for (ITimeGraphEntry child : entry.getChildren()) {
                    IStatus status = this.populateEventsRecursively(fullStates, prevFullState, child);
                    if (status.isOK()) continue;
                    return status;
                }
                return Status.OK_STATUS;
            }
        });
        start = end;
    }

    private void createPhysicalCpuEntries(@NonNull ITmfTrace trace, ITmfStateSystem ssq, TimeGraphEntry traceEntry, long startTime, long endTime) {
        List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
        int cpusQuark = ssq.optQuarkAbsolute(new String[]{"CPUs"});
        VirtualResourceEntry physicalCpusEntry = new VirtualResourceEntry(cpusQuark, trace, Messages.FusedVMView_PhysicalCpusEntry, startTime, endTime, VirtualResourceEntry.Type.NULL, cpusQuark);
        traceEntry.addChild((TimeGraphEntry)physicalCpusEntry);
        for (Integer cpuQuark : cpuQuarks) {
            String cpuName = ssq.getAttributeName(cpuQuark.intValue());
            int cpu = Integer.parseInt(cpuName);
            VirtualResourceEntry cpuEntry = new VirtualResourceEntry(cpuQuark, trace, startTime, endTime, VirtualResourceEntry.Type.CPU, cpu);
            physicalCpusEntry.addChild(cpuEntry);
            List irqQuarks = ssq.getQuarks(new String[]{"CPUs", cpuName, "IRQs", "*"});
            VirtualResourcesView.createCpuInterruptEntryWithQuark(trace, ssq, startTime, endTime, cpuEntry, irqQuarks, VirtualResourceEntry.Type.IRQ);
            List softIrqQuarks = ssq.getQuarks(new String[]{"CPUs", cpuName, "Soft_IRQs", "*"});
            VirtualResourcesView.createCpuInterruptEntryWithQuark(trace, ssq, startTime, endTime, cpuEntry, softIrqQuarks, VirtualResourceEntry.Type.SOFT_IRQ);
            Display.getDefault().asyncExec(() -> this.getTimeGraphViewer().setExpandedState((ITimeGraphEntry)cpuEntry, false));
        }
    }

    private void createMachineAndContainerEntries(@NonNull ITmfTrace trace, ITmfStateSystem ssq, Machine machine, TimeGraphEntry parentEntry, long startTime, long endTime) {
        Machine physicalMachine = this.fPhysicalMachines.get(trace);
        Collection<Machine> vms = machine.getVirtualMachines();
        Collection<Machine> containers = machine.getContainers();
        Collection<Processor> pcpus = machine.getPhysicalCpus();
        if (!vms.isEmpty()) {
            VirtualResourceEntry virtualMachinesEntry = new VirtualResourceEntry(0, trace, Messages.FusedVMView_VirtualMachinesEntry, startTime, endTime, VirtualResourceEntry.Type.NULL, 3 * vms.hashCode());
            parentEntry.addChild((TimeGraphEntry)virtualMachinesEntry);
            for (Machine vm : vms) {
                VirtualResourceEntry virtualMachineEntry = new VirtualResourceEntry(0, trace, vm.getMachineName(), startTime, endTime, VirtualResourceEntry.Type.VM, vm.hashCode());
                virtualMachinesEntry.addChild(virtualMachineEntry);
                this.createMachineAndContainerEntries(trace, ssq, vm, virtualMachineEntry, startTime, endTime);
            }
        }
        if (!containers.isEmpty()) {
            VirtualResourceEntry containersEntry = new VirtualResourceEntry(0, trace, Messages.FusedVMView_ContainersEntry, startTime, endTime, VirtualResourceEntry.Type.NULL, 3 * containers.hashCode());
            parentEntry.addChild((TimeGraphEntry)containersEntry);
            for (Machine container : containers) {
                VirtualResourceEntry containerEntry = new VirtualResourceEntry(0, trace, container.getMachineName(), startTime, endTime, VirtualResourceEntry.Type.CONTAINER, container.hashCode());
                containersEntry.addChild(containerEntry);
                this.createMachineAndContainerEntries(trace, ssq, container, containerEntry, startTime, endTime);
            }
        }
        if (!pcpus.isEmpty() && machine != physicalMachine) {
            VirtualResourceEntry pCpusEntry = new VirtualResourceEntry(0, trace, Messages.FusedVMView_PhysicalCpusEntry, startTime, endTime, VirtualResourceEntry.Type.NULL, 3 * pcpus.hashCode());
            parentEntry.addChild((TimeGraphEntry)pCpusEntry);
            for (Processor p : pcpus) {
                List list = ssq.getQuarks(new String[]{"CPUs", String.valueOf(p.getNumber())});
                if (list.isEmpty()) {
                    return;
                }
                int pCpuQuark = (Integer)list.get(0);
                VirtualResourceEntry.Type type = VirtualResourceEntry.Type.NULL;
                VirtualResourceEntry.Type typeMachine = ((VirtualResourceEntry)parentEntry).getType();
                if (typeMachine == VirtualResourceEntry.Type.VM) {
                    type = VirtualResourceEntry.Type.PCPU_VM;
                } else if (typeMachine == VirtualResourceEntry.Type.CONTAINER) {
                    type = VirtualResourceEntry.Type.PCPU_CONTAINER;
                }
                VirtualResourceEntry pCpuEntry = new VirtualResourceEntry(pCpuQuark, trace, startTime, endTime, type, p.getNumber());
                pCpusEntry.addChild(pCpuEntry);
            }
        }
    }

    private static void createCpuInterruptEntryWithQuark(@NonNull ITmfTrace trace, ITmfStateSystem ssq, long startTime, long endTime, VirtualResourceEntry cpuEntry, List<Integer> childrenQuarks, VirtualResourceEntry.Type type) {
        for (Integer quark : childrenQuarks) {
            @NonNull String resourceName = ssq.getAttributeName(quark.intValue());
            int resourceId = Integer.parseInt(resourceName);
            VirtualResourceEntry interruptEntry = new VirtualResourceEntry(quark, trace, startTime, endTime, type, resourceId);
            cpuEntry.addChild(interruptEntry);
        }
    }

    protected @Nullable List<ITimeEvent> getEventList(@NonNull TimeGraphEntry entry, ITmfStateSystem ssq, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        VirtualResourceEntry fusedVMViewEntry = (VirtualResourceEntry)entry;
        int quark = fusedVMViewEntry.getQuark();
        if (fusedVMViewEntry.getType().equals((Object)VirtualResourceEntry.Type.CPU)) {
            return this.getCpuEventsList(entry, ssq, fullStates, prevFullState, monitor, quark, VirtualResourceEntry.Type.CPU);
        }
        if ((fusedVMViewEntry.getType().equals((Object)VirtualResourceEntry.Type.IRQ) || fusedVMViewEntry.getType().equals((Object)VirtualResourceEntry.Type.SOFT_IRQ)) && quark >= 0) {
            return VirtualResourcesView.getIrqEventsList(entry, fullStates, prevFullState, monitor, quark);
        }
        if (fusedVMViewEntry.getType().equals((Object)VirtualResourceEntry.Type.PCPU_VM)) {
            return this.getCpuEventsList(entry, ssq, fullStates, prevFullState, monitor, quark, VirtualResourceEntry.Type.PCPU_VM);
        }
        if (fusedVMViewEntry.getType().equals((Object)VirtualResourceEntry.Type.PCPU_CONTAINER)) {
            return this.getCpuEventsList(entry, ssq, fullStates, prevFullState, monitor, quark, VirtualResourceEntry.Type.PCPU_CONTAINER);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private List<ITimeEvent> getCpuEventsList(TimeGraphEntry entry, ITmfStateSystem ssq, List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState, IProgressMonitor monitor, int quark, VirtualResourceEntry.Type type) {
        machineName = null;
        try {
            statusQuark = ssq.getQuarkRelative(quark, new String[]{"Status"});
            machineQuark = ssq.getQuarkRelative(quark, new String[]{"Machine_name"});
            currentThreadQuark = ssq.getQuarkRelative(quark, new String[]{"Current_thread"});
        }
        catch (AttributeNotFoundException v0) {
            return null;
        }
        eventList = new ArrayList<ITimeEvent>(fullStates.size());
        lastStatusInterval = prevFullState == null || statusQuark >= prevFullState.size() ? null : prevFullState.get(statusQuark);
        lastMachineInterval = prevFullState == null || machineQuark >= prevFullState.size() ? null : prevFullState.get(machineQuark);
        lastCurrentThreadInterval = prevFullState == null || currentThreadQuark >= prevFullState.size() ? null : prevFullState.get(currentThreadQuark);
        lastStatusStartTime = lastStatusInterval == null ? -1L : lastStatusInterval.getStartTime();
        lastStatusEndTime = lastStatusInterval == null ? 0x7FFFFFFFFFFFFFFFL : lastStatusInterval.getEndTime() + 1L;
        lastMachineStartTime = lastMachineInterval == null ? -1L : lastMachineInterval.getStartTime();
        lastMachineEndTime = lastMachineInterval == null ? 0x7FFFFFFFFFFFFFFFL : lastMachineInterval.getEndTime() + 1L;
        lastCurrentThreadStartTime = lastCurrentThreadInterval == null ? -1L : lastCurrentThreadInterval.getStartTime();
        lastCurrentThreadEndTime = lastCurrentThreadInterval == null ? 0x7FFFFFFFFFFFFFFFL : lastCurrentThreadInterval.getEndTime() + 1L;
        lastStartTime = Math.max(lastStatusStartTime, Math.max(lastMachineStartTime, lastCurrentThreadStartTime));
        lastEndTime = Math.min(lastStatusEndTime, Math.min(lastMachineEndTime, lastCurrentThreadEndTime));
        for (List<ITmfStateInterval> fullState : fullStates) {
            block11: {
                block12: {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (statusQuark >= fullState.size()) continue;
                    statusInterval = fullState.get(statusQuark);
                    machineInterval = fullState.get(machineQuark);
                    currentThreadInterval = fullState.get(currentThreadQuark);
                    if (type.equals((Object)VirtualResourceEntry.Type.CPU)) break block11;
                    if (!type.equals((Object)VirtualResourceEntry.Type.PCPU_VM)) break block12;
                    machineName = entry.getParent().getParent().getName();
                    if (!this.isInsideVM(machineInterval.getStateValue().unboxStr(), machineName)) {
                        continue;
                    }
                    break block11;
                }
                if (!type.equals((Object)VirtualResourceEntry.Type.PCPU_CONTAINER)) break block11;
                machineEntry = (VirtualResourceEntry)entry.getParent();
                if (machineEntry != null) ** GOTO lbl40
                continue;
lbl-1000:
                // 1 sources

                {
                    machineEntry = (VirtualResourceEntry)machineEntry.getParent();
lbl40:
                    // 2 sources

                    ** while (machineEntry.getType() != VirtualResourceEntry.Type.VM)
                }
lbl41:
                // 1 sources

                machineName = machineEntry.getName();
                if (machineName == null || !machineInterval.getStateValue().unboxStr().equals(machineName) || (containerID = entry.getParent().getParent().getName()) == null) continue;
                containerQuark = FusedVMInformationProvider.getContainerQuark((ITmfStateSystem)ssq, (String)machineName, (String)containerID);
                if (containerQuark == -2) {
                    Activator.getDefault().logWarning("Container quark not found for " + containerID + " in machine " + machineName + ". This shouldn't happen.");
                    break;
                }
                threadID = currentThreadInterval.getStateValue().unboxInt();
                threadsQuarks = ssq.getQuarks(containerQuark, new String[]{"Threads", "*"});
                foundThread = false;
                for (Integer threadQuark : threadsQuarks) {
                    if (Integer.parseInt(ssq.getAttributeName(threadQuark.intValue())) != threadID) continue;
                    foundThread = true;
                    break;
                }
                if (!foundThread) continue;
            }
            status = statusInterval.getStateValue().unboxInt();
            time = Math.max(statusInterval.getStartTime(), Math.max(machineInterval.getStartTime(), currentThreadInterval.getStartTime()));
            duration = Math.min(statusInterval.getEndTime(), Math.min(machineInterval.getEndTime(), currentThreadInterval.getEndTime())) - time + 1L;
            if (time == lastStartTime) continue;
            if (!statusInterval.getStateValue().isNull()) {
                if (lastEndTime != time && lastEndTime != -1L) {
                    eventList.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                }
                eventList.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
            } else {
                eventList.add((ITimeEvent)new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
            }
            lastStartTime = time;
            lastEndTime = time + duration;
        }
        return eventList;
    }

    private boolean isInsideVM(String machine1, String machine2) {
        Machine m2 = this.fMachines.get(machine2);
        if (m2 == null) {
            return false;
        }
        String machine2Host = m2.getHostId();
        if (machine1.equals(machine2Host)) {
            return true;
        }
        for (Machine child : m2.getVirtualMachines()) {
            if (!this.isInsideVM(machine1, child.getHostId())) continue;
            return true;
        }
        return false;
    }

    private static List<ITimeEvent> getIrqEventsList(TimeGraphEntry entry, List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState, IProgressMonitor monitor, int quark) {
        ArrayList<ITimeEvent> eventList = new ArrayList<ITimeEvent>(fullStates.size());
        ITmfStateInterval lastInterval = prevFullState == null || quark >= prevFullState.size() ? null : prevFullState.get(quark);
        long lastStartTime = lastInterval == null ? -1L : lastInterval.getStartTime();
        long lastEndTime = lastInterval == null ? -1L : lastInterval.getEndTime() + 1L;
        boolean lastIsNull = lastInterval == null ? false : lastInterval.getStateValue().isNull();
        for (List<ITmfStateInterval> fullState : fullStates) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (quark >= fullState.size()) continue;
            ITmfStateInterval irqInterval = fullState.get(quark);
            long time = irqInterval.getStartTime();
            long duration = irqInterval.getEndTime() - time + 1L;
            if (time == lastStartTime) continue;
            if (!irqInterval.getStateValue().isNull()) {
                int cpu = irqInterval.getStateValue().unboxInt();
                eventList.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)entry, time, duration, cpu));
                lastIsNull = false;
            } else {
                if (lastEndTime != time && lastIsNull) {
                    eventList.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime, -1));
                }
                eventList.add((ITimeEvent)new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                lastIsNull = true;
            }
            lastStartTime = time;
            lastEndTime = time + duration;
        }
        return eventList;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        Action selectMachineAction = this.getSelectMachineAction();
        selectMachineAction.setText(Messages.FusedVMView_selectMachineText);
        selectMachineAction.setToolTipText(Messages.FusedVMView_selectMachineText);
        manager.add((IAction)selectMachineAction);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTimeGraphViewer().addTimeListener(this.fTimeListenerFusedVMView);
        this.getTimeGraphViewer().addSelectionListener(this.fSelListenerFusedVMView);
        this.getTimeGraphViewer().getTimeGraphControl().addMouseWheelListener(this.fWheelListener);
    }

    public long getBeginSelectedTime() {
        return this.beginSelectedTime;
    }

    public void setBeginSelectedTime(long begin) {
        this.beginSelectedTime = begin;
    }

    public long getEndSelectedTime() {
        return this.endSelectedTime;
    }

    public void setEndSelectedTime(long end) {
        this.endSelectedTime = end;
    }

    public VirtualResourcePresentationProvider getFusedVMViewPresentationProvider() {
        ITimeGraphPresentationProvider pp = this.getPresentationProvider();
        if (!(pp instanceof VirtualResourcePresentationProvider)) {
            return null;
        }
        return (VirtualResourcePresentationProvider)pp;
    }

    private void printInformations() {
        long begin = this.getBeginSelectedTime();
        long end = this.getEndSelectedTime();
        Activator.getDefault().logInfo("Begin time: " + FormatTimeUtils.formatTime((long)begin, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
        Activator.getDefault().logInfo("End time: " + FormatTimeUtils.formatTime((long)end, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
    }

    private void updateToolTipTexts() {
        VirtualResourcePresentationProvider presentationProvider = this.getFusedVMViewPresentationProvider();
        this.fHighlightMachine.setToolTipText(presentationProvider.getSelectedMachine());
        this.fHighlightCPU.setToolTipText(Integer.toString(presentationProvider.getSelectedCpu()));
        this.fHighlightProcess.setToolTipText(Messages.FusedVMView_ButtonProcessSelected);
        this.fHighlightContainer.setToolTipText(presentationProvider.getSelectedContainer());
    }

    private void updateButtonsSelection() {
    }

    public Action getSelectMachineAction() {
        if (this.fSelectMachineAction == null) {
            this.fSelectMachineAction = new Action(){

                public void run() {
                    VirtualResourcePresentationProvider presentationProvider = (VirtualResourcePresentationProvider)VirtualResourcesView.this.getPresentationProvider();
                    Control dataViewer = VirtualResourcesView.this.getTimeGraphViewer().getControl();
                    if (dataViewer == null || dataViewer.isDisposed()) {
                        return;
                    }
                    ITmfTrace trace = VirtualResourcesView.this.getTrace();
                    if (trace == null) {
                        return;
                    }
                    Machine physicalMachine = VirtualResourcesView.this.fPhysicalMachines.get(trace);
                    if (physicalMachine == null) {
                        return;
                    }
                    SelectMachineDialog dialog = new SelectMachineDialog(dataViewer.getShell());
                    dialog.setInput(Collections.singleton(physicalMachine));
                    dialog.setInitialSelections(presentationProvider.getSelectedElements().toArray());
                    dialog.open();
                    Object[] result = dialog.getResult();
                    if (result != null) {
                        presentationProvider.setSelectedElements(Arrays.asList(result));
                        presentationProvider.resetTimeEventHighlight();
                        VirtualResourcesView.this.redraw();
                    }
                }
            };
            this.fSelectMachineAction.setText(Messages.FusedVMView_SelectMachineActionNameText);
            this.fSelectMachineAction.setToolTipText(Messages.FusedVMView_SelectMachineActionToolTipText);
        }
        return this.fSelectMachineAction;
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return Collections.singleton(trace);
    }

    private Machine createHierarchy(@NonNull ITmfStateSystem ssq) {
        Machine host = null;
        LinkedList<Machine> guests = new LinkedList<Machine>();
        for (String machineHost : FusedVMInformationProvider.getMachinesTraced((ITmfStateSystem)ssq)) {
            int typeMachine = FusedVMInformationProvider.getTypeMachine((ITmfStateSystem)ssq, (String)machineHost);
            if (typeMachine < 0) continue;
            String machineName = FusedVMInformationProvider.getMachineName((ITmfStateSystem)ssq, (String)machineHost);
            Machine machine = null;
            if ((typeMachine & 2) == 2) {
                machine = new Machine(machineName, machineHost, typeMachine, FusedVMInformationProvider.getPhysicalCpusUsedByMachine((ITmfStateSystem)ssq, (String)machineHost));
                this.fMachines.put(machine.getMachineName(), machine);
                guests.add(machine);
            } else if (typeMachine == 1) {
                machine = new Machine(machineName, machineHost, typeMachine);
                for (String cpus : FusedVMInformationProvider.getCpusUsedByMachine((ITmfStateSystem)ssq, (String)machineHost)) {
                    machine.addPCpu(cpus);
                }
                this.fMachines.put(machine.getMachineName(), machine);
                host = machine;
            }
            if (machine != null) continue;
        }
        if (host == null) {
            return null;
        }
        VirtualResourcesView.createContainersHierarchyForMachine(ssq, host);
        VirtualResourcesView.createMachineHierarchy(ssq, host, guests);
        for (Machine guest : guests) {
            VirtualResourcesView.createContainersHierarchyForMachine(ssq, guest);
        }
        return host;
    }

    private static void createMachineHierarchy(@NonNull ITmfStateSystem ssq, Machine host, List<Machine> guests) {
        for (Machine m : guests) {
            String parentHostId = FusedVMInformationProvider.getParentMachineHostId((ITmfStateSystem)ssq, (String)m.getHostId());
            if (parentHostId.equals(host.getHostId())) {
                m.setHost(host);
                host.addVirtualMachine(m);
            }
            for (Machine m2 : guests) {
                parentHostId = FusedVMInformationProvider.getParentMachineHostId((ITmfStateSystem)ssq, (String)m2.getHostId());
                if (!parentHostId.equals(m.getHostId())) continue;
                m2.setHost(m);
                m.addVirtualMachine(m2);
            }
        }
    }

    private static void createContainersHierarchyForMachine(@NonNull ITmfStateSystem ssq, Machine m) {
        String machineName = m.getHostId();
        Collection containersQuarks = FusedVMInformationProvider.getMachineContainersQuarks((ITmfStateSystem)ssq, (String)machineName);
        for (Integer quark : containersQuarks) {
            long parentContainer = FusedVMInformationProvider.getParentContainer((ITmfStateSystem)ssq, (int)quark);
            if (parentContainer != 0xEFFFFFFCL) continue;
            String containerName = ssq.getAttributeName(quark.intValue());
            List pCpus = FusedVMInformationProvider.getPCpusUsedByContainer((ITmfStateSystem)ssq, (int)quark);
            Machine container = m.createContainer(containerName, m.getHostId(), pCpus);
            VirtualResourcesView.createContainersHierarchyForContainer(ssq, container, containersQuarks);
        }
    }

    private static void createContainersHierarchyForContainer(@NonNull ITmfStateSystem ssq, Machine container, Collection<Integer> containersQuarks) {
        Long containerName = Long.parseLong(container.getMachineName());
        for (int quark : containersQuarks) {
            if (!FusedVMInformationProvider.getParentContainer((ITmfStateSystem)ssq, (int)quark).equals(containerName)) continue;
            String childName = ssq.getAttributeName(quark);
            List pCpus = FusedVMInformationProvider.getPCpusUsedByContainer((ITmfStateSystem)ssq, (int)quark);
            Machine child = container.createContainer(childName, container.getHostId(), pCpus);
            VirtualResourcesView.createContainersHierarchyForContainer(ssq, child, containersQuarks);
        }
    }

    @TmfSignalHandler
    public void threadSelected(TmfThreadSelectedSignal signal) {
        int threadId = signal.getThreadId();
        VirtualResourcePresentationProvider presentationProvider = this.getFusedVMViewPresentationProvider();
        presentationProvider.setSelectedThread(new HostThread(Objects.requireNonNull(signal.getHostId()), Integer.valueOf(threadId)));
        this.updateButtonsSelection();
        this.updateToolTipTexts();
    }

    private static class FusedVMFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private FusedVMFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            VirtualResourceEntry entry = (VirtualResourceEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }
    }

    private static class FusedVMViewEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private FusedVMViewEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            VirtualResourceEntry entry1 = (VirtualResourceEntry)o1;
            VirtualResourceEntry entry2 = (VirtualResourceEntry)o2;
            VirtualResourceEntry.Type typeE1 = entry1.getType();
            VirtualResourceEntry.Type typeE2 = entry2.getType();
            if (!(typeE1 != VirtualResourceEntry.Type.VM && typeE1 != VirtualResourceEntry.Type.CONTAINER || typeE2 != VirtualResourceEntry.Type.VM && typeE2 != VirtualResourceEntry.Type.CONTAINER)) {
                return entry1.getName().compareTo(entry2.getName());
            }
            if (typeE1 == VirtualResourceEntry.Type.NULL && typeE2 == VirtualResourceEntry.Type.NULL) {
                if (entry1.getName() == Messages.FusedVMView_PhysicalCpusEntry) {
                    return -1;
                }
                if (entry2.getName() == Messages.FusedVMView_PhysicalCpusEntry) {
                    return 1;
                }
                if (entry1.getName() == Messages.FusedVMView_ContainersEntry) {
                    return 1;
                }
                if (entry2.getName() == Messages.FusedVMView_ContainersEntry) {
                    return -1;
                }
            }
            return entry1.compareTo((ITimeGraphEntry)entry2);
        }
    }
}

