/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.search.FieldDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.FieldReferenceMatch;
import org.eclipse.wst.jsdt.core.search.LocalVariableDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.MethodReferenceMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.TypeDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.TypeReferenceMatch;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ASTMatchingVisitor
extends ASTVisitor {
    private SearchPattern pattern;
    private SearchParticipant participant;
    private ITypeRoot rootJSUnit;
    private int searchKind;
    private boolean isCaseSensitive;
    private boolean isCamelCase;
    private List<SearchMatch> matches;
    private Stack<char[]> contextNames;
    private int stackDepth;
    private Set<String> fieldNames;
    private Map<String, char[]> superTypeNames;
    private String ROOT_ELEMENT_NAME = "(top level)";
    private String ANONYMOUS_FUNCTION_NAME = "___anonymous";

    public ASTMatchingVisitor(SearchPattern pattern, SearchParticipant participant, ITypeRoot rootElement) {
        this.pattern = pattern;
        this.participant = participant;
        this.searchKind = pattern.kind;
        this.rootJSUnit = rootElement;
        this.matches = new ArrayList<SearchMatch>();
        if (pattern instanceof JavaSearchPattern) {
            this.isCaseSensitive = ((JavaSearchPattern)pattern).isCaseSensitive;
            this.isCamelCase = ((JavaSearchPattern)pattern).isCamelCase;
        } else {
            this.isCaseSensitive = false;
            this.isCamelCase = false;
        }
    }

    public List<SearchMatch> getMatches() {
        return this.matches;
    }

    public void clearMatches() {
        this.matches = new ArrayList<SearchMatch>();
    }

    @Override
    public boolean visit(JavaScriptUnit node) {
        this.contextNames = new Stack();
        this.stackDepth = 0;
        this.fieldNames = new HashSet<String>();
        this.superTypeNames = new HashMap<String, char[]>();
        return true;
    }

    @Override
    public void endVisit(JavaScriptUnit node) {
        this.contextNames = null;
        this.fieldNames = null;
        this.superTypeNames = null;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        ++this.stackDepth;
        char[] nodeName = node.getName().getIdentifier().toCharArray();
        char[] contextSuper = this.contextNames.isEmpty() ? new char[]{} : this.contextNames.peek();
        this.contextNames.push(nodeName);
        if (this.searchKind != 64) {
            return true;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        if (!fieldPattern.findDeclarations) {
            return true;
        }
        char[] patternName = fieldPattern.name;
        char[] patternSuper = fieldPattern.getDeclaringSimpleName();
        if (this.matchesName(patternName, nodeName) && (patternSuper == null || CharOperation.equals(patternSuper, contextSuper))) {
            IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
            LocalVariableDeclarationMatch match = new LocalVariableDeclarationMatch(enclosingElement, 0, node.getName().getStartPosition(), node.getName().getLength(), this.participant, this.rootJSUnit.getResource());
            this.matches.add(match);
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(VariableDeclarationFragment node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(ObjectLiteralField node) {
        char[] nodeSuperName;
        ++this.stackDepth;
        char[] nodeName = null;
        Expression name = node.getFieldName();
        if (name != null) {
            switch (name.getNodeType()) {
                case 42: {
                    nodeName = ((SimpleName)name).getIdentifier().toCharArray();
                    break;
                }
                case 45: {
                    nodeName = ((StringLiteral)name).getEscapedValue().toCharArray();
                }
            }
        } else {
            return true;
        }
        char[] cArray = nodeSuperName = this.contextNames.isEmpty() ? new char[]{} : this.contextNames.peek();
        if (nodeName != null) {
            this.contextNames.push(nodeName);
        }
        if (this.searchKind != 64) {
            return true;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        if (!fieldPattern.findDeclarations) {
            return true;
        }
        if (fieldPattern.getDeclaringSimpleName() != null && !this.contextNames.isEmpty() && !CharOperation.equals(nodeSuperName, fieldPattern.getDeclaringSimpleName(), false)) {
            return true;
        }
        char[] patternName = fieldPattern.name;
        if (this.matchesName(patternName, nodeName)) {
            IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
            FieldDeclarationMatch match = new FieldDeclarationMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), this.participant, this.rootJSUnit.getResource());
            this.matches.add(match);
        }
        this.isFieldDeclaration(nodeSuperName, nodeName);
        if (node.getInitializer() != null) {
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(ObjectLiteralField node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(FunctionDeclaration node) {
        char[] nodeName;
        Expression name = node.getMethodName();
        if (name != null) {
            ++this.stackDepth;
            if (name.getNodeType() == 45) {
                Util.verbose("Encountered FunctionDeclaration node with StringLiteral getMethodName(); this should not happen");
                return true;
            }
            nodeName = ((SimpleName)name).getIdentifier().toCharArray();
        } else {
            if (this.contextNames.isEmpty()) {
                return true;
            }
            nodeName = this.contextNames.pop();
        }
        char[] contextName = !this.contextNames.isEmpty() ? this.contextNames.peek() : new char[]{};
        this.contextNames.push(nodeName);
        switch (this.searchKind) {
            case 128: {
                MethodPattern methodPattern = (MethodPattern)this.pattern;
                if (!methodPattern.findDeclarations) {
                    return true;
                }
                if (methodPattern.getDeclaringSimpleName() != null && !CharOperation.equals(contextName, methodPattern.getDeclaringSimpleName(), false)) {
                    return true;
                }
                char[] patternName = methodPattern.selector;
                if (!this.matchesName(patternName, nodeName)) break;
                IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
                MethodDeclarationMatch match = new MethodDeclarationMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), this.participant, this.rootJSUnit.getResource());
                this.matches.add(match);
                break;
            }
            case 32: {
                ConstructorPattern constrPattern = (ConstructorPattern)this.pattern;
                if (!node.isConstructor() || !constrPattern.findDeclarations) {
                    return true;
                }
                char[] patternName = constrPattern.getSearchPrefix();
                if (!this.matchesName(patternName, contextName)) break;
                IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
                MethodDeclarationMatch match = new MethodDeclarationMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), this.participant, this.rootJSUnit.getResource());
                this.matches.add(match);
            }
        }
        return true;
    }

    @Override
    public void endVisit(FunctionDeclaration node) {
        if (node.getMethodName() != null) {
            --this.stackDepth;
            if (this.stackDepth < this.contextNames.size()) {
                this.contextNames.pop();
            }
        }
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        String name;
        if ((this.searchKind & 0x80) == 0) {
            return true;
        }
        MethodPattern methodPattern = (MethodPattern)this.pattern;
        if (!methodPattern.findReferences) {
            return true;
        }
        String superName = null;
        if (node.getName() != null) {
            name = node.getName().getIdentifier();
        } else if (node.getExpression().getNodeType() == 22) {
            FieldAccess fieldAccess = (FieldAccess)node.getExpression();
            name = fieldAccess.getName().getIdentifier();
            if (fieldAccess.getExpression() != null && fieldAccess.getExpression().getNodeType() == 42) {
                superName = ((SimpleName)fieldAccess.getExpression()).getIdentifier();
            }
        } else {
            return true;
        }
        char[] nodeName = name.toCharArray();
        char[] nodeSuper = superName != null ? superName.toCharArray() : (this.contextNames.isEmpty() ? new char[]{} : this.contextNames.peek());
        char[] patternName = methodPattern.selector;
        char[] patternSuper = methodPattern.getDeclaringSimpleName();
        if (patternSuper != null && !CharOperation.equals(nodeSuper, patternSuper, false)) {
            return true;
        }
        if (this.matchesName(patternName, nodeName)) {
            IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
            MethodReferenceMatch match = new MethodReferenceMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), false, false, false, this.participant, this.rootJSUnit.getResource());
            this.matches.add(match);
        }
        return true;
    }

    @Override
    public boolean visit(FieldAccess node) {
        if (this.searchKind != 64) {
            return true;
        }
        FieldPattern fieldPattern = (FieldPattern)this.pattern;
        char[] nodeName = node.getName().getIdentifier().toCharArray();
        char[] rootName = new char[]{};
        Expression expression = node.getExpression();
        switch (expression.getNodeType()) {
            case 42: {
                rootName = ((SimpleName)expression).getIdentifier().toCharArray();
                break;
            }
            case 52: {
                rootName = this.contextNames.isEmpty() ? new char[]{} : this.contextNames.peek();
                break;
            }
            case 22: {
                rootName = ((FieldAccess)expression).getName().getIdentifier().toCharArray();
            }
        }
        if (fieldPattern.getDeclaringSimpleName() != null && !CharOperation.equals(rootName, fieldPattern.getDeclaringSimpleName(), false)) {
            return true;
        }
        char[] patternName = fieldPattern.name;
        IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
        if (this.matchesName(patternName, nodeName)) {
            boolean isDeclaration = this.isFieldDeclaration(rootName, nodeName);
            if (fieldPattern.findDeclarations && isDeclaration) {
                FieldDeclarationMatch match = new FieldDeclarationMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), this.participant, this.rootJSUnit.getResource());
                this.matches.add(match);
            } else if (fieldPattern.findReferences && !isDeclaration) {
                FieldReferenceMatch match = new FieldReferenceMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), true, true, false, this.participant, this.rootJSUnit.getResource());
                this.matches.add(match);
            }
        }
        if (patternName != null && this.matchesName(patternName, rootName)) {
            FieldReferenceMatch match = new FieldReferenceMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), true, true, false, this.participant, this.rootJSUnit.getResource());
            this.matches.add(match);
        }
        return node.getExpression() != null && node.getExpression().getNodeType() != 42;
    }

    @Override
    public boolean visit(Assignment node) {
        ++this.stackDepth;
        Expression lhs = node.getLeftHandSide();
        char[] elementName = null;
        switch (lhs.getNodeType()) {
            case 42: {
                elementName = ((SimpleName)lhs).getIdentifier().toCharArray();
                break;
            }
            case 22: {
                elementName = ((FieldAccess)lhs).getName().getIdentifier().toCharArray();
            }
        }
        lhs.accept(this);
        this.contextNames.push(elementName);
        node.getRightHandSide().accept(this);
        return false;
    }

    @Override
    public void endVisit(Assignment node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(SimpleName node) {
        int parentNodeType = node.getParent().getNodeType();
        switch (parentNodeType) {
            case 22: 
            case 59: {
                return false;
            }
        }
        if (this.searchKind == 64) {
            FieldPattern fieldPattern = (FieldPattern)this.pattern;
            if (!fieldPattern.findReferences) {
                return false;
            }
            char[] patternName = fieldPattern.name;
            char[] nodeName = node.getIdentifier().toCharArray();
            if (this.matchesName(patternName, nodeName)) {
                IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
                FieldReferenceMatch match = new FieldReferenceMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), true, true, false, this.participant, this.rootJSUnit.getResource());
                this.matches.add(match);
            }
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        ++this.stackDepth;
        SimpleName name = node.getName();
        if (name == null) {
            return true;
        }
        char[] nodeName = name.getIdentifier().toCharArray();
        this.contextNames.push(nodeName);
        Expression superClass = node.getSuperclassExpression();
        char[] nodeSuperName = null;
        if (superClass != null && superClass.getNodeType() == 42) {
            nodeSuperName = ((SimpleName)superClass).getIdentifier().toCharArray();
        }
        if (nodeSuperName != null) {
            this.superTypeNames.put(new String(nodeName), nodeSuperName);
        }
        char[] patternName = new char[]{};
        char[] superName = null;
        switch (this.searchKind) {
            case 8: {
                TypeDeclarationPattern typeDecl = (TypeDeclarationPattern)this.pattern;
                patternName = typeDecl.simpleName;
                superName = typeDecl.qualification;
                break;
            }
            case 256: {
                OrPattern orPattern = (OrPattern)this.pattern;
                TypeDeclarationPattern typeDeclPattern = (TypeDeclarationPattern)orPattern.findPatternKind(8);
                if (typeDeclPattern != null) {
                    patternName = typeDeclPattern.simpleName;
                    superName = typeDeclPattern.qualification;
                    break;
                }
                return true;
            }
            default: {
                return true;
            }
        }
        if (superName != null && !CharOperation.equals(superName, nodeSuperName, false)) {
            return true;
        }
        if (this.matchesName(patternName, nodeName)) {
            IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
            TypeDeclarationMatch match = new TypeDeclarationMatch(enclosingElement, 0, node.getName().getStartPosition(), node.getName().getLength(), this.participant, this.rootJSUnit.getResource());
            this.matches.add(match);
        }
        return true;
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        --this.stackDepth;
        if (this.stackDepth < this.contextNames.size()) {
            this.contextNames.pop();
        }
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        char[] nodeSuperName;
        char[] patternSuperName;
        char[] patternName;
        switch (this.searchKind) {
            case 4: {
                TypeReferencePattern typeRef = (TypeReferencePattern)this.pattern;
                patternName = typeRef.simpleName;
                patternSuperName = typeRef.qualification;
                break;
            }
            case 256: {
                OrPattern orPattern = (OrPattern)this.pattern;
                TypeReferencePattern typeRefPattern = (TypeReferencePattern)orPattern.findPatternKind(4);
                if (typeRefPattern != null) {
                    patternName = typeRefPattern.simpleName;
                    patternSuperName = typeRefPattern.qualification;
                    break;
                }
                return true;
            }
            case 32: {
                ConstructorPattern constrPattern = (ConstructorPattern)this.pattern;
                if (!constrPattern.findReferences) {
                    return true;
                }
                patternName = constrPattern.getSearchPrefix();
                patternSuperName = constrPattern.declaringQualification;
                break;
            }
            default: {
                return true;
            }
        }
        Expression name = node.getMember();
        if (name == null || name.getNodeType() != 42) {
            return true;
        }
        char[] nodeName = ((SimpleName)name).getIdentifier().toCharArray();
        if (patternSuperName != null && !CharOperation.equals(nodeSuperName = this.superTypeNames.get(new String(nodeName)), patternSuperName, false)) {
            return true;
        }
        if (this.matchesName(patternName, nodeName)) {
            IJavaScriptElement enclosingElement = this.getEnclosingElement(node);
            TypeReferenceMatch match = new TypeReferenceMatch(enclosingElement, 0, node.getStartPosition(), node.getLength(), false, this.participant, this.rootJSUnit.getResource());
            this.matches.add(match);
        }
        return true;
    }

    private boolean matchesName(char[] patternName, char[] nodeName) {
        if (this.isCamelCase && CharOperation.camelCaseMatch(patternName, nodeName)) {
            return true;
        }
        if (this.isCaseSensitive) {
            return CharOperation.match(patternName, nodeName, true);
        }
        return CharOperation.match(CharOperation.toLowerCase(patternName), nodeName, false);
    }

    private IJavaScriptElement getEnclosingElement(ASTNode node) {
        ASTNode parent = node;
        block8: while (true) {
            parent = parent.getParent();
            switch (parent.getNodeType()) {
                case 15: {
                    return this.rootJSUnit.getField(this.ROOT_ELEMENT_NAME);
                }
                case 31: {
                    Expression methodName = ((FunctionDeclaration)parent).getMethodName();
                    if (methodName != null) {
                        String name = methodName.toString();
                        return this.rootJSUnit.getFunction(name, null);
                    }
                    String name = this.ANONYMOUS_FUNCTION_NAME;
                    ASTNode pparent = parent;
                    int i = 0;
                    while (i < 3) {
                        if ((pparent = pparent.getParent()) == null) break;
                        if (pparent.getNodeType() == 59) {
                            name = ((VariableDeclarationFragment)pparent).getName().getIdentifier();
                            break;
                        }
                        if (pparent.getNodeType() == 7) {
                            Expression lhs = ((Assignment)pparent).getLeftHandSide();
                            if (lhs.getNodeType() == 42) {
                                name = ((SimpleName)lhs).getIdentifier();
                            } else if (lhs.getNodeType() == 22) {
                                name = ((FieldAccess)lhs).getName().getIdentifier();
                            }
                        }
                        ++i;
                    }
                    return this.rootJSUnit.getField(name);
                }
                case 59: {
                    String name = ((VariableDeclarationFragment)parent).getName().getIdentifier();
                    return this.rootJSUnit.getField(name);
                }
                case 86: {
                    String name = ((ObjectLiteralField)parent).getFieldName().toString();
                    return this.rootJSUnit.getField(name);
                }
                case 55: {
                    String name = ((TypeDeclaration)parent).getName().getIdentifier();
                    return this.rootJSUnit.getType(name);
                }
                case 26: {
                    continue block8;
                }
            }
        }
    }

    private boolean isFieldDeclaration(char[] objectName, char[] propName) {
        if (objectName == null) {
            objectName = new char[]{};
        }
        char[] fullNameArray = new char[propName.length + objectName.length + 1];
        System.arraycopy(objectName, 0, fullNameArray, 0, objectName.length);
        fullNameArray[objectName.length] = 46;
        System.arraycopy(propName, 0, fullNameArray, objectName.length + 1, propName.length);
        String fullName = new String(fullNameArray);
        if (this.fieldNames.contains(fullName)) {
            return false;
        }
        this.fieldNames.add(fullName);
        return true;
    }
}

