/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.AnnotationCategoriesResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.AnnotationResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.AnnotationsQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.ArrowsQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.DataProvider;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.LinesQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.MarkerSetsResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.OptionalQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.RequestedQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.StylesResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TableColumnHeadersResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TimeGraphArrowsResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TimeGraphStatesResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TimeGraphTooltipResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TimeGraphTreeResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TooltipQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.TreeQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.VirtualTableResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.XYResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.XYTreeResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.TableColumnHeader;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.TreeModelWrapper;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.VirtualTableModelWrapper;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.QueryParametersUtil;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlOutputElement;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.XmlDataProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.annotations.TraceAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.w3c.dom.Element;

@Path(value="/experiments/{expUUID}/outputs")
public class DataProviderService {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(DataProviderService.class);
    private final DataProviderManager manager = DataProviderManager.getInstance();

    @GET
    @Tag(name="Experiments")
    @Produces(value={"application/json"})
    @Operation(summary="Get the list of outputs for this experiment", responses={@ApiResponse(responseCode="200", description="Returns a list of output provider descriptors", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataProvider.class)))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getProviders(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
        }
        List list = DataProviderManager.getInstance().getAvailableProviders((ITmfTrace)experiment);
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH)));
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.XY)));
        list.sort(Comparator.comparing(IDataProviderDescriptor::getName));
        list.removeIf(dp -> dp.getId().endsWith("org.eclipse.tracecompass.internal.analysis.timing.core.event.matching"));
        return Response.ok((Object)list).build();
    }

    @GET
    @Path(value="/{outputId}")
    @Tag(name="Experiments")
    @Produces(value={"application/json"})
    @Operation(summary="Get the output descriptor for this experiment and output", responses={@ApiResponse(responseCode="200", description="Returns the output provider descriptor", content={@Content(schema=@Schema(implementation=DataProvider.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getProvider(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
        }
        List list = DataProviderManager.getInstance().getAvailableProviders((ITmfTrace)experiment);
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH)));
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.XY)));
        Optional<IDataProviderDescriptor> provider = list.stream().filter(p -> p.getId().equals(outputId)).findFirst();
        if (provider.isPresent()) {
            return Response.ok((Object)provider.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Path(value="/data/{outputId}/tree")
    @Tag(name="Data Tree")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the data tree", description="Unique entry point for output providers, to get the tree of visible entries", responses={@ApiResponse(responseCode="200", description="Returns a list of data tree entries. The returned model must be consistent, parentIds must refer to a parent which exists in the model.", content={@Content(schema=@Schema(implementation=XYTreeResponse.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getDataTree(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the data tree entries. The object 'requested_timerange' specifies the requested time range. When absent the tree for the full range is returned.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_timerange\": {\"start\": 111111111, \"end\": 222222222}}}")}, schema=@Schema(implementation=TreeQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        return this.getTree(expUUID, outputId, queryParameters);
    }

    @POST
    @Path(value="/XY/{outputId}/tree")
    @Tag(name="XY")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the XY tree", description="Unique entry point for output providers, to get the tree of visible entries", responses={@ApiResponse(responseCode="200", description="Returns a list of XY entries. The returned model must be consistent, parentIds must refer to a parent which exists in the model.", content={@Content(schema=@Schema(implementation=XYTreeResponse.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getXYTree(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the XY tree. The object 'requested_timerange' specifies the requested time range. When absent the tree for the full range is returned.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_timerange\": {\"start\": 111111111, \"end\": 222222222}}}")}, schema=@Schema(implementation=TreeQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        return this.getTree(expUUID, outputId, queryParameters);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/XY/{outputId}/xy")
    @Tag(name="XY")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the XY model", description="Unique endpoint for all xy models, ensures that the same template is followed for all endpoints.", responses={@ApiResponse(responseCode="200", description="Return the queried XYResponse", content={@Content(schema=@Schema(implementation=XYResponse.class))}), @ApiResponse(responseCode="400", description="Missing query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getXY(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the XY model. The object 'requested_timerange' is the requested time range and number of samples. The array 'requested_items' is the list of entryId or seriesId being requested.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_timerange\": {\"start\": 111111111, \"end\": 222222222, \"nbTimes\": 1920},\"requested_items\": [1, 2]}}")}, schema=@Schema(implementation=RequestedQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getXY", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeXYDataProvider provider = (ITmfTreeXYDataProvider)this.manager.getOrCreateDataProvider((ITmfTrace)experiment, outputId, ITmfTreeXYDataProvider.class);
            if (provider == null) {
                provider = (ITmfTreeXYDataProvider)DataProviderService.getXmlProvider((ITmfTrace)experiment, outputId, EnumSet.of(XmlUtils.OutputType.XY));
            }
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateRequestedQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            @NonNull TmfModelResponse response = provider.fetchXY(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @GET
    @Hidden
    @Path(value="/XY/{outputId}/tooltip")
    @Produces(value={"application/json"})
    public Response getXYTooltip(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, @QueryParam(value="xValue") long xValue, @QueryParam(value="yValue") long yValue, @QueryParam(value="entryId") long entryId) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"XY tooltip are not implemented yet").build();
    }

    @POST
    @Path(value="/timeGraph/{outputId}/tree")
    @Tag(name="TimeGraph")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the Time Graph tree", description="Unique entry point for output providers, to get the tree of visible entries", responses={@ApiResponse(responseCode="200", description="Returns a list of Time Graph entries. The returned model must be consistent, parentIds must refer to a parent which exists in the model.", content={@Content(schema=@Schema(implementation=TimeGraphTreeResponse.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getTimeGraphTree(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the timegraph tree. The object 'requested_timerange' specifies the requested time range. When absent the tree for the full range is returned.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_timerange\": {\"start\": 111111111, \"end\": 222222222}}}")}, schema=@Schema(implementation=TreeQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        return this.getTree(expUUID, outputId, queryParameters);
    }

    @POST
    @Path(value="/timeGraph/{outputId}/states")
    @Tag(name="TimeGraph")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the Time Graph states", description="Unique entry point for all TimeGraph states, ensures that the same template is followed for all views", responses={@ApiResponse(responseCode="200", description="Returns a list of time graph rows", content={@Content(schema=@Schema(implementation=TimeGraphStatesResponse.class))}), @ApiResponse(responseCode="400", description="Missing query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getStates(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the timegraph states. The object 'requested_timerange' is the requested time range and number of samples. The array 'requested_items' is the list of entryId being requested. The object 'filter_query_parameters' contains requests for search/filter queries. The object 'filter_expressions_map' is the list of query requests, where the key 1 is DIMMED and 4 is EXCLUDED, and the value is an array of the desired search query ('thread=1' or 'process=ls' or 'duration>10ms'). The 'strategy' flag is an optional parameter within 'filter_query_parameters', and if omitted then 'SAMPLED' search would be the default value. If 'strategy' is set to 'DEEP' then the full time range between the first and last requested timestamp should be searched for filter matches. For timegraphs, only one matching state per gap in requested timestamps needs to be returned in the response. If matches to the queries from the 'filter_expressions_map' are found there'll be a field 'tags' in 'states'. The TimeGraphState class has a bit-mask called tags. If a state is supposed to be dimmed the tag will be the corresponding bit set.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_timerange\": {\"start\": 111111111, \"end\": 222222222, \"nbTimes\": 1920},\"requested_items\": [1, 2],\"filter_query_parameters\": {\"strategy\": \"SAMPLED\", \"filter_expressions_map\": {\"1\":[\"openat\", \"duration>10ms\"]}}}}")}, schema=@Schema(implementation=RequestedQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getStates", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateRequestedQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            errorMessage = QueryParametersUtil.validateFilterQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            TmfModelResponse response = provider.fetchRowModel(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/timeGraph/{outputId}/arrows")
    @Tag(name="TimeGraph")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the Time Graph arrows", description="Unique entry point for all TimeGraph models, ensures that the same template is followed for all models", responses={@ApiResponse(responseCode="200", description="Returns a sampled list of TimeGraph arrows", content={@Content(schema=@Schema(implementation=TimeGraphArrowsResponse.class))}), @ApiResponse(responseCode="400", description="Missing query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getArrows(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the timegraph arrows. The object 'requested_timerange' is the requested time range and number of samples.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_timerange\": {\"start\": 111111111, \"end\": 222222222, \"nbTimes\": 1920}}}")}, schema=@Schema(implementation=ArrowsQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getArrows", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateArrowsQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            @NonNull @NonNull TmfModelResponse response = provider.fetchArrows(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @GET
    @Path(value="/markerSets")
    @Tag(name="Annotations")
    @Produces(value={"application/json"})
    @Operation(summary="API to get marker sets available for this experiment", responses={@ApiResponse(responseCode="200", description="List of marker sets", content={@Content(schema=@Schema(implementation=MarkerSetsResponse.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getMarkerSets(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getMarkerSets", new Object[0]).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            List markerSets = MarkerConfigXmlParser.getMarkerSets();
            return Response.ok((Object)new TmfModelResponse((Object)markerSets, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @GET
    @Path(value="/{outputId}/annotations")
    @Tag(name="Annotations")
    @Produces(value={"application/json"})
    @Operation(summary="API to get annotation categories associated to this experiment and output", responses={@ApiResponse(responseCode="200", description="Annotation categories", content={@Content(schema=@Schema(implementation=AnnotationCategoriesResponse.class))}), @ApiResponse(responseCode="400", description="Missing parameter outputId", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getAnnotationCategories(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @Parameter(description="The optional requested marker set's id") @QueryParam(value="markerSetId") String markerSetId) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing parameter outputId").build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getAnnotationCategories", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getOrCreateDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            boolean isComplete = true;
            AnnotationCategoriesModel model = null;
            TraceAnnotationProvider traceAnnotationProvider = ExperimentManagerService.getTraceAnnotationProvider(expUUID);
            if (traceAnnotationProvider != null) {
                @NonNull @NonNull @NonNull ImmutableMap params = markerSetId == null ? Collections.emptyMap() : ImmutableMap.of((Object)"requested_marker_set", (Object)markerSetId);
                @NonNull TmfModelResponse traceAnnotations = traceAnnotationProvider.fetchAnnotationCategories((Map)params, null);
                if (traceAnnotations.getStatus() == ITmfResponse.Status.CANCELLED || traceAnnotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationCategoriesModel(Collections.emptyList()), traceAnnotations.getStatus(), traceAnnotations.getStatusMessage())).build();
                }
                isComplete &= traceAnnotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = (AnnotationCategoriesModel)traceAnnotations.getModel();
            }
            if (provider instanceof IOutputAnnotationProvider) {
                @NonNull TmfModelResponse annotations = ((IOutputAnnotationProvider)provider).fetchAnnotationCategories(Collections.emptyMap(), null);
                if (annotations.getStatus() == ITmfResponse.Status.CANCELLED || annotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationCategoriesModel(Collections.emptyList()), annotations.getStatus(), annotations.getStatusMessage())).build();
                }
                isComplete &= annotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = AnnotationCategoriesModel.of((AnnotationCategoriesModel[])new AnnotationCategoriesModel[]{model, (AnnotationCategoriesModel)annotations.getModel()});
            }
            if (isComplete) {
                return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
            }
            return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/{outputId}/annotations")
    @Tag(name="Annotations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the annotations associated to this experiment and output", responses={@ApiResponse(responseCode="200", description="Annotation", content={@Content(schema=@Schema(implementation=AnnotationResponse.class))}), @ApiResponse(responseCode="400", description="Missing query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getAnnotations(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the annotations. The object 'requested_timerange' is the requested time range and number of samples. The array 'requested_items' is the list of entryId being requested. The string 'requested_marker_set' is the optional requested marker set's id. The array 'requested_marker_categories' is the list of requested annotation categories; if absent, all annotations are returned.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_timerange\": {\"start\": 111111111, \"end\": 222222222, \"nbTimes\": 1920},\"requested_items\": [1, 2],\"requested_marker_set\": \"markerSetId\",\"requested_marker_categories\": [\"category1\", \"category2\"]}}")}, schema=@Schema(implementation=AnnotationsQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getAnnotations", new Object[0]).setCategory(outputId).build();){
            Set selectedCategories;
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getOrCreateDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateAnnotationsQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            boolean isComplete = true;
            AnnotationModel model = null;
            TraceAnnotationProvider traceAnnotationProvider = ExperimentManagerService.getTraceAnnotationProvider(expUUID);
            if (traceAnnotationProvider != null) {
                @NonNull TmfModelResponse traceAnnotations = traceAnnotationProvider.fetchAnnotations(params, null);
                if (traceAnnotations.getStatus() == ITmfResponse.Status.CANCELLED || traceAnnotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationModel(Collections.emptyMap()), traceAnnotations.getStatus(), traceAnnotations.getStatusMessage())).build();
                }
                isComplete &= traceAnnotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = (AnnotationModel)traceAnnotations.getModel();
            }
            if (provider instanceof IOutputAnnotationProvider) {
                @NonNull TmfModelResponse annotations = ((IOutputAnnotationProvider)provider).fetchAnnotations(params, null);
                if (annotations.getStatus() == ITmfResponse.Status.CANCELLED || annotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationModel(Collections.emptyMap()), annotations.getStatus(), annotations.getStatusMessage())).build();
                }
                isComplete &= annotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = AnnotationModel.of((AnnotationModel[])new AnnotationModel[]{model, (AnnotationModel)annotations.getModel()});
            }
            if ((selectedCategories = DataProviderParameterUtils.extractSelectedCategories(params)) != null && model != null) {
                @NonNull LinkedHashMap<@NonNull K, @NonNull @NonNull V> allAnnotations = new LinkedHashMap(model.getAnnotations());
                allAnnotations.keySet().removeIf(cat -> !selectedCategories.contains(cat));
                model = new AnnotationModel(allAnnotations);
            }
            if (isComplete) {
                return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
            }
            return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/timeGraph/{outputId}/tooltip")
    @Tag(name="TimeGraph")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get a Time Graph tooltip", description="Endpoint to retrieve tooltips for time graph", responses={@ApiResponse(responseCode="200", description="Returns a list of tooltip keys to values", content={@Content(schema=@Schema(implementation=TimeGraphTooltipResponse.class))}), @ApiResponse(responseCode="400", description="Missing query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getTimeGraphTooltip(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the timegraph tooltip. The array 'requested_times' is an array with a single timestamp. The array 'requested_items' is an array with a single entryId being requested.  The object 'requested_element' is the element for which the tooltip is requested.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_times\": [111200000],\"requested_items\": [1],\"requested_element\": {\"elementType\": \"state\", \"time\": 111100000, \"duration\": 100000}}}")}, schema=@Schema(implementation=TooltipQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getTimeGraphTooltip", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateTooltipQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            @NonNull @NonNull @NonNull TmfModelResponse response = provider.fetchTooltip(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> getTimeGraphProvider(@NonNull ITmfTrace trace, String outputId) {
        @NonNull ITimeGraphDataProvider provider = (ITimeGraphDataProvider)this.manager.getOrCreateDataProvider(trace, outputId, ITimeGraphDataProvider.class);
        if (provider == null && outputId != null) {
            provider = (ITimeGraphDataProvider)DataProviderService.getXmlProvider(trace, outputId, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH));
        }
        return provider;
    }

    @POST
    @Path(value="/table/{outputId}/columns")
    @Tag(name="Virtual Tables")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get table columns", description="Unique entry point for output providers, to get the column entries", responses={@ApiResponse(responseCode="200", description="Returns a list of table headers", content={@Content(schema=@Schema(implementation=TableColumnHeadersResponse.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getColumns(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the table columns", content={@Content(examples={@ExampleObject(value="{\"parameters\":{}}")}, schema=@Schema(implementation=OptionalQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response response = this.getTree(expUUID, outputId, queryParameters);
        Object entity = response.getEntity();
        if (!(entity instanceof TmfModelResponse)) {
            return response;
        }
        Object model = ((TmfModelResponse)entity).getModel();
        if (!(model instanceof TreeModelWrapper)) {
            return response;
        }
        List<@NonNull ITmfTreeDataModel> entries = ((TreeModelWrapper)model).getEntries();
        ArrayList<TableColumnHeader> columns = new ArrayList<TableColumnHeader>();
        for (ITmfTreeDataModel dataModel : entries) {
            columns.add(new TableColumnHeader(dataModel));
        }
        return Response.ok((Object)new TmfModelResponse(columns, ((TmfModelResponse)entity).getStatus(), ((TmfModelResponse)entity).getStatusMessage())).build();
    }

    @POST
    @Path(value="/table/{outputId}/lines")
    @Tag(name="Virtual Tables")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get virtual table lines", responses={@ApiResponse(responseCode="200", description="Returns a table model with a 2D array of strings and metadata", content={@Content(schema=@Schema(implementation=VirtualTableResponse.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Error reading the experiment", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getLines(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the table lines. One of 'requested_table_index' or 'requested_times' should be present. If 'requested_table_index' is used it is the starting index of the lines to be returned. If 'requested_times' is used it should contain an array with a single timestamp. The returned lines starting at the given timestamp (or the nearest following) will be returned. The 'requested_table_count' is the number of lines that should be returned. When 'requested_table_column_ids' is absent all columns are returned. When present it is the array of requested columnIds. Use 'table_search_expressions' for search providing a map of <columnId, regular expression>. Returned lines that match the search expression will be tagged. Use 'table_search_direction' to specify search direction [NEXT, PREVIOUS]. If present, 'requested_table_count' events are returned starting from the first matching event. Matching and not matching events are returned. Matching events will be tagged. If no matches are found, an empty list will be returned.", content={@Content(examples={@ExampleObject(value="{\"parameters\":{\"requested_table_index\": 0,\"requested_table_count\": 100,\"requested_table_column_ids\": [0, 1, 2],\"table_search_expressions\": {\"1\": \"cpu.*\"},\"table_search_direction\": \"NEXT\"}}")}, schema=@Schema(implementation=LinesQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getLines", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITmfVirtualTableDataProvider provider = (ITmfVirtualTableDataProvider)this.manager.getOrCreateDataProvider((ITmfTrace)experiment, outputId, ITmfVirtualTableDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateLinesQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            TmfModelResponse response = provider.fetchLines(params, null);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response.getStatusMessage()).build();
            }
            return Response.ok((Object)new TmfModelResponse((Object)new VirtualTableModelWrapper((ITmfVirtualTableModel)response.getModel()), response.getStatus(), response.getStatusMessage())).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <P extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> P getXmlProvider(@NonNull ITmfTrace trace, @NonNull String id, EnumSet<XmlUtils.OutputType> types) {
        for (XmlUtils.OutputType viewType : types) {
            for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()) && id.equals(element.getId()))) {
                Element viewElement = TmfXmlUtils.getElementInFile((String)element2.getPath(), (String)viewType.getXmlElem(), (String)id);
                if (viewElement != null && viewType == XmlUtils.OutputType.XY) {
                    return (P)XmlDataProviderManager.getInstance().getXyProvider(trace, viewElement);
                }
                if (viewElement == null || viewType != XmlUtils.OutputType.TIME_GRAPH) continue;
                return (P)XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            }
        }
        return null;
    }

    private static @NonNull List<IDataProviderDescriptor> getXmlDataProviderDescriptors(@NonNull ITmfTrace trace, EnumSet<XmlUtils.OutputType> types) {
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        for (ITmfTrace tr : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace)) {
            Map modules = TmfAnalysisManager.getAnalysisModules(tr.getClass());
            for (XmlUtils.OutputType viewType : types) {
                block2: for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()))) {
                    DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
                    String label = String.valueOf(element2.getLabel());
                    String elemId = element2.getId();
                    if (elemId == null) continue;
                    builder.setId(elemId);
                    if (viewType == XmlUtils.OutputType.XY) {
                        builder.setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY);
                    } else if (viewType == XmlUtils.OutputType.TIME_GRAPH) {
                        builder.setProviderType(IDataProviderDescriptor.ProviderType.TIME_GRAPH);
                    }
                    for (String id : element2.getAnalyses()) {
                        if (!modules.containsKey(id)) continue;
                        String analysisName = Objects.requireNonNull((IAnalysisModuleHelper)modules.get(id)).getName();
                        builder.setName(analysisName + ": " + label);
                        builder.setDescription(label + " provided by Analysis module: " + analysisName);
                        descriptors.add(builder.build());
                        continue block2;
                    }
                }
            }
        }
        return descriptors;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response getTree(UUID expUUID, String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Map<String, Object> params = queryParameters.getParameters();
        String errorMessage = QueryParametersUtil.validateTreeQueryParameters(params);
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getTree", new Object[0]).setCategory(outputId).build();){
            TmfModelResponse tmfModelResponse;
            TmfModelResponse treeResponse;
            Object model;
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull Object provider = this.manager.getOrCreateDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                provider = DataProviderService.getXmlProvider((ITmfTrace)experiment, outputId, EnumSet.allOf(XmlUtils.OutputType.class));
            }
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            List timeRequested = DataProviderParameterUtils.extractTimeRequested(params);
            if (timeRequested == null || timeRequested.isEmpty()) {
                params = new HashMap<String, Object>(params);
                timeRequested = ImmutableList.of((Object)experiment.getStartTime().toNanos(), (Object)experiment.getEndTime().toNanos());
                params.put("requested_times", timeRequested);
            }
            if ((model = (treeResponse = provider.fetchTree(params, null)).getModel()) instanceof TmfTreeModel) {
                tmfModelResponse = new TmfModelResponse((Object)new TreeModelWrapper((TmfTreeModel<ITmfTreeDataModel>)((TmfTreeModel)model)), treeResponse.getStatus(), treeResponse.getStatusMessage());
                return Response.ok((Object)tmfModelResponse).build();
            }
            tmfModelResponse = treeResponse;
            return Response.ok((Object)tmfModelResponse).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/{outputId}/style")
    @Tag(name="Styles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="API to get the style map associated to this experiment and output", responses={@ApiResponse(responseCode="200", description="Style model that can be used jointly with OutputElementStyle to retrieve specific style values", content={@Content(schema=@Schema(implementation=StylesResponse.class))}), @ApiResponse(responseCode="400", description="Missing query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or output provider not found", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="405", description="Analysis cannot run", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getStyles(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="ID of the output provider to query") @PathParam(value="outputId") String outputId, @RequestBody(description="Query parameters to fetch the style map", content={@Content(examples={@ExampleObject(value="{\"parameters\":{}}")}, schema=@Schema(implementation=OptionalQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Map<String, Object> params = queryParameters.getParameters();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getStyles", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getOrCreateDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            if (provider instanceof IOutputStyleProvider) {
                @NonNull TmfModelResponse styleModelResponse = ((IOutputStyleProvider)provider).fetchStyle(params, null);
                return Response.ok((Object)styleModelResponse).build();
            }
            return Response.ok((Object)new TmfModelResponse((Object)new OutputStyleModel(Collections.emptyMap()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Response validateParameters(String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing parameter outputId").build();
        }
        if (queryParameters == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query parameters").build();
        }
        return null;
    }
}

