/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CCompositeTypeScope;

public class CASTCompositeTypeSpecifier
extends CASTBaseDeclSpecifier
implements ICASTCompositeTypeSpecifier {
    private int fKey;
    private IASTName fName;
    private IASTDeclaration[] fActiveDeclarations;
    private IASTDeclaration[] fAllDeclarations;
    private int fDeclarationsPos = -1;
    private IScope fScope;

    public CASTCompositeTypeSpecifier() {
    }

    public CASTCompositeTypeSpecifier(int key, IASTName name) {
        this.fKey = key;
        this.setName(name);
    }

    @Override
    public CASTCompositeTypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTCompositeTypeSpecifier copy(IASTNode.CopyStyle style) {
        CASTCompositeTypeSpecifier copy = new CASTCompositeTypeSpecifier();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CASTCompositeTypeSpecifier> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setKey(this.fKey);
        copy.setName(this.fName == null ? null : this.fName.copy(style));
        IASTDeclaration[] iASTDeclarationArray = this.getMembers();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration member = iASTDeclarationArray[n2];
            copy.addMemberDeclaration(member == null ? null : member.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public int getKey() {
        return this.fKey;
    }

    @Override
    public void setKey(int key) {
        this.assertNotFrozen();
        this.fKey = key;
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    @Override
    public IASTDeclaration[] getMembers() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fDeclarationsPos + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    @Override
    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = ArrayUtil.trimAt(IASTDeclaration.class, this.fAllDeclarations, this.fDeclarationsPos);
            return this.fAllDeclarations;
        }
        return this.getMembers();
    }

    @Override
    public void addMemberDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(MEMBER_DECLARATION);
            this.fAllDeclarations = ArrayUtil.appendAt(IASTDeclaration.class, this.fAllDeclarations, ++this.fDeclarationsPos, declaration);
            this.fActiveDeclarations = null;
        }
    }

    @Override
    public void addDeclaration(IASTDeclaration declaration) {
        this.addMemberDeclaration(declaration);
    }

    @Override
    public IScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CCompositeTypeScope(this);
        }
        return this.fScope;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.visitAlignmentSpecifiers(action)) {
            return false;
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        IASTDeclaration[] decls = this.getDeclarations(action.includeInactiveNodes);
        int i = 0;
        while (i < decls.length) {
            if (!decls[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.fName) {
            return 2;
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fDeclarationsPos) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
        super.replace(child, other);
    }
}

