/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public abstract class BufferingKnnVectorsWriter
extends KnnVectorsWriter {
    private final List<FieldWriter> fields = new ArrayList<FieldWriter>();

    protected BufferingKnnVectorsWriter() {
    }

    public KnnFieldVectorsWriter<float[]> addField(FieldInfo fieldInfo) throws IOException {
        FieldWriter newField = new FieldWriter(fieldInfo);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, final Sorter.DocMap sortMap) throws IOException {
        for (final FieldWriter fieldData : this.fields) {
            KnnVectorsReader knnVectorsReader = new KnnVectorsReader(){

                @Override
                public long ramBytesUsed() {
                    return 0L;
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void checkIntegrity() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public VectorValues getVectorValues(String field) throws IOException {
                    BufferedVectorValues vectorValues = new BufferedVectorValues(fieldData.docsWithField, fieldData.vectors, fieldData.fieldInfo.getVectorDimension());
                    return sortMap != null ? new VectorValues.SortingVectorValues(vectorValues, sortMap) : vectorValues;
                }

                @Override
                public TopDocs search(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) {
                    throw new UnsupportedOperationException();
                }
            };
            this.writeField(fieldData.fieldInfo, knnVectorsReader, maxDoc);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = 0L;
        for (FieldWriter field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    @Override
    public void mergeOneField(final FieldInfo fieldInfo, final MergeState mergeState) throws IOException {
        KnnVectorsReader knnVectorsReader = new KnnVectorsReader(){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public TopDocs search(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VectorValues getVectorValues(String field) throws IOException {
                return KnnVectorsWriter.MergedVectorValues.mergeVectorValues(fieldInfo, mergeState);
            }

            @Override
            public void checkIntegrity() {
            }
        };
        this.writeField(fieldInfo, knnVectorsReader, mergeState.segmentInfo.maxDoc());
    }

    protected abstract void writeField(FieldInfo var1, KnnVectorsReader var2, int var3) throws IOException;

    private static class BufferedVectorValues
    extends VectorValues
    implements RandomAccessVectorValues {
        final DocsWithFieldSet docsWithField;
        final List<float[]> vectors;
        final int dimension;
        final ByteBuffer buffer;
        final BytesRef binaryValue;
        final ByteBuffer raBuffer;
        final BytesRef raBinaryValue;
        DocIdSetIterator docsWithFieldIter;
        int ord = -1;

        BufferedVectorValues(DocsWithFieldSet docsWithField, List<float[]> vectors, int dimension) {
            this.docsWithField = docsWithField;
            this.vectors = vectors;
            this.dimension = dimension;
            this.buffer = ByteBuffer.allocate(dimension * 4).order(ByteOrder.LITTLE_ENDIAN);
            this.binaryValue = new BytesRef(this.buffer.array());
            this.raBuffer = ByteBuffer.allocate(dimension * 4).order(ByteOrder.LITTLE_ENDIAN);
            this.raBinaryValue = new BytesRef(this.raBuffer.array());
            this.docsWithFieldIter = docsWithField.iterator();
        }

        @Override
        public RandomAccessVectorValues copy() {
            return new BufferedVectorValues(this.docsWithField, this.vectors, this.dimension);
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public BytesRef binaryValue() {
            this.buffer.asFloatBuffer().put(this.vectorValue());
            return this.binaryValue;
        }

        @Override
        public BytesRef binaryValue(int targetOrd) {
            this.raBuffer.asFloatBuffer().put(this.vectors.get(targetOrd));
            return this.raBinaryValue;
        }

        @Override
        public float[] vectorValue() {
            return this.vectors.get(this.ord);
        }

        @Override
        public float[] vectorValue(int targetOrd) {
            return this.vectors.get(targetOrd);
        }

        @Override
        public int docID() {
            return this.docsWithFieldIter.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithFieldIter.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                ++this.ord;
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithFieldIter.cost();
        }
    }

    private static class FieldWriter
    extends KnnFieldVectorsWriter<float[]> {
        private final FieldInfo fieldInfo;
        private final int dim;
        private final DocsWithFieldSet docsWithField;
        private final List<float[]> vectors;
        private int lastDocID = -1;

        public FieldWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.dim = fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<float[]>();
        }

        @Override
        public void addValue(int docID, Object value) {
            float[] vectorValue;
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            assert (docID > this.lastDocID);
            switch (this.fieldInfo.getVectorEncoding()) {
                case BYTE: {
                    vectorValue = this.bytesToFloats((BytesRef)value);
                    break;
                }
                default: {
                    vectorValue = (float[])value;
                }
            }
            this.docsWithField.add(docID);
            this.vectors.add(this.copyValue(vectorValue));
            this.lastDocID = docID;
        }

        private float[] bytesToFloats(BytesRef b) {
            float[] floats = new float[this.dim];
            for (int i = 0; i < this.dim; ++i) {
                floats[i] = b.bytes[i + b.offset];
            }
            return floats;
        }

        @Override
        public float[] copyValue(float[] vectorValue) {
            return ArrayUtil.copyOfSubArray(vectorValue, 0, this.dim);
        }

        @Override
        public long ramBytesUsed() {
            if (this.vectors.size() == 0) {
                return 0L;
            }
            return this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.vectors.size() * (long)this.dim * 4L;
        }
    }
}

