/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfTraceFolder
extends TmfProjectModelElement
implements IActionFilter,
IPropertySource2 {
    private static final String INFO_CATEGORY = "Info";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String LOCATION = "location";
    private static final String IS_LINKED = "isLinked";
    private static final String IS_LINKED_PROPERTY = Messages.TmfTraceElement_IsLinked;
    private static final ReadOnlyTextPropertyDescriptor NAME_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("name", "name");
    private static final ReadOnlyTextPropertyDescriptor PATH_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("path", "path");
    private static final ReadOnlyTextPropertyDescriptor LOCATION_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("location", "location");
    private static final ReadOnlyTextPropertyDescriptor IS_LINKED_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(IS_LINKED_PROPERTY, IS_LINKED_PROPERTY);
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{NAME_DESCRIPTOR, PATH_DESCRIPTOR, LOCATION_DESCRIPTOR, IS_LINKED_DESCRIPTOR};

    static {
        NAME_DESCRIPTOR.setCategory(INFO_CATEGORY);
        PATH_DESCRIPTOR.setCategory(INFO_CATEGORY);
        LOCATION_DESCRIPTOR.setCategory(INFO_CATEGORY);
        IS_LINKED_DESCRIPTOR.setCategory(INFO_CATEGORY);
    }

    public TmfTraceFolder(String name, IFolder resource, TmfProjectElement parent) {
        super(name, (IResource)resource, parent);
    }

    public TmfTraceFolder(String name, IFolder resource, TmfTraceFolder parent) {
        super(name, (IResource)resource, parent);
    }

    public IFolder getResource() {
        return (IFolder)super.getResource();
    }

    @Override
    protected synchronized void refreshChildren() {
        IFolder folder = this.getResource();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element : this.getChildren()) {
            childrenMap.put(element.getResource().getName(), element);
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String name = resource.getName();
                boolean isFolder = resource instanceof IFolder && TmfTraceType.getTraceTypeId((IResource)resource) == null;
                ITmfProjectModelElement element = (ITmfProjectModelElement)childrenMap.get(name);
                if (isFolder && !(element instanceof TmfTraceFolder) && !(element instanceof TmfTraceElement)) {
                    element = TmfTraceType.isDirectoryTrace((String)resource.getLocationURI().getPath()) ? new TmfTraceElement(name, resource, this) : new TmfTraceFolder(name, (IFolder)resource, this);
                    this.addChild(element);
                } else if (!isFolder && !(element instanceof TmfTraceElement)) {
                    element = new TmfTraceElement(name, resource, this);
                    this.addChild(element);
                } else {
                    childrenMap.remove(name);
                }
                if (element != null) {
                    ((TmfProjectModelElement)element).refreshChildren();
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
    }

    @Override
    public Image getIcon() {
        return TmfProjectModelIcons.FOLDER_ICON;
    }

    @Override
    public String getLabelText() {
        int nbTraces = this.getTraces().size();
        if (nbTraces > 0) {
            return String.valueOf(this.getName()) + " [" + nbTraces + ']';
        }
        return this.getName();
    }

    public List<@NonNull TmfTraceElement> getTraces() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<@NonNull TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        for (ITmfProjectModelElement child : children) {
            if (child instanceof TmfTraceElement) {
                traces.add((TmfTraceElement)child);
                continue;
            }
            if (!(child instanceof TmfTraceFolder)) continue;
            traces.addAll(((TmfTraceFolder)child).getTraces());
        }
        return traces;
    }

    public @NonNull List<TmfTraceElement> getTraceElements(@NonNull List<IResource> resources) {
        return resources.stream().flatMap(resource -> this.getTraces().stream().filter(traceElement -> traceElement.getResource().equals(resource))).distinct().collect(Collectors.toList());
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(IS_LINKED)) {
            boolean isLinked = this.getResource().isLinked();
            return Boolean.toString(isLinked).equals(value);
        }
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(DESCRIPTORS, DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (NAME.equals(id)) {
            return this.getName();
        }
        if (PATH.equals(id)) {
            return this.getPath().toString();
        }
        if (LOCATION.equals(id)) {
            return this.getLocation().toString();
        }
        if (IS_LINKED_PROPERTY.equals(id)) {
            return Boolean.toString(this.getResource().isLinked());
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

