/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.service;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TracePythonLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.DomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.EventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.FieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.LoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ProbeEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.UstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.XmlMiValidationErrorHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceConstants;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LttngVersion;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandInput;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandResult;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LTTngControlServiceMI
extends LTTngControlService {
    public static final String MI_SCHEMA_VALIDATION_KEY = "org.eclipse.tracecompass.lttng2.control.ui/mi/schema-validation";
    private final DocumentBuilder fDocumentBuilder;

    public LTTngControlServiceMI(@NonNull ICommandShell shell, @Nullable LttngVersion version) throws ExecutionException {
        super(shell);
        this.setVersion(version);
        DocumentBuilderFactory docBuilderFactory = XmlUtils.newSafeDocumentBuilderFactory();
        docBuilderFactory.setExpandEntityReferences(false);
        docBuilderFactory.setValidating(false);
        if (LTTngControlServiceMI.isSchemaValidationEnabled() && version != null && version.compareTo(new LttngVersion(2, 11, 0, null, null, null, null, null, null)) < 0) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                URL xsdUrl = LTTngControlService.class.getResource("mi_lttng.xsd");
                if (version.compareTo(new LttngVersion(2, 8, 0, null, null, null, null, null, null)) >= 0) {
                    xsdUrl = LTTngControlService.class.getResource("mi-lttng-3.0.xsd");
                    docBuilderFactory.setNamespaceAware(true);
                }
                docBuilderFactory.setSchema(schemaFactory.newSchema(xsdUrl));
            }
            catch (SAXException e) {
                throw new ExecutionException(Messages.TraceControl_InvalidSchemaError, (Throwable)e);
            }
        }
        try {
            this.fDocumentBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ExecutionException(Messages.TraceControl_XmlDocumentBuilderError, (Throwable)e);
        }
        this.fDocumentBuilder.setErrorHandler(new XmlMiValidationErrorHandler());
    }

    private static boolean isSchemaValidationEnabled() {
        String schemaValidationKey = Platform.getDebugOption((String)MI_SCHEMA_VALIDATION_KEY);
        String systemProperty = System.getProperty(MI_SCHEMA_VALIDATION_KEY);
        return schemaValidationKey != null && Boolean.parseBoolean(schemaValidationKey) || systemProperty != null && Boolean.parseBoolean(systemProperty);
    }

    private static Document getDocumentFromStrings(List<String> xmlStrings, DocumentBuilder documentBuilder) throws ExecutionException {
        Document document;
        StringBuilder concatenedString = new StringBuilder();
        for (String string : xmlStrings) {
            concatenedString.append(string);
        }
        InputSource stream = new InputSource(new StringReader(concatenedString.toString()));
        try {
            document = documentBuilder.parse(stream);
        }
        catch (IOException | SAXException e) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_XmlParsingError) + ':' + e.toString(), (Throwable)e);
        }
        return document;
    }

    public static LttngVersion parseVersion(ICommandResult commandResult) throws ExecutionException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory docBuilderFactory = XmlUtils.newSafeDocumentBuilderFactory();
        try {
            documentBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ExecutionException(Messages.TraceControl_XmlDocumentBuilderError, (Throwable)e);
        }
        Document doc = LTTngControlServiceMI.getDocumentFromStrings(commandResult.getOutput(), documentBuilder);
        NodeList element = doc.getElementsByTagName("version");
        if (element.getLength() != 1) {
            throw new ExecutionException(Messages.TraceControl_UnsupportedVersionError);
        }
        int major = 0;
        int minor = 0;
        int patchLevel = 0;
        String license = "";
        String commit = "";
        String name = "";
        String description = "";
        String url = "";
        String fullVersion = "";
        NodeList child = element.item(0).getChildNodes();
        int i = 0;
        while (i < child.getLength()) {
            Node node = child.item(i);
            switch (node.getNodeName()) {
                case "major": {
                    major = Integer.parseInt(node.getTextContent());
                    break;
                }
                case "minor": {
                    minor = Integer.parseInt(node.getTextContent());
                    break;
                }
                case "patchLevel": {
                    patchLevel = Integer.parseInt(node.getTextContent());
                    break;
                }
                case "commit": {
                    commit = node.getTextContent();
                    break;
                }
                case "description": {
                    description = node.getTextContent();
                    break;
                }
                case "license": {
                    license = node.getTextContent();
                    break;
                }
                case "name": {
                    name = node.getTextContent();
                    break;
                }
                case "string": {
                    fullVersion = node.getTextContent();
                    break;
                }
                case "url": {
                    url = node.getTextContent();
                    break;
                }
            }
            ++i;
        }
        return new LttngVersion(major, minor, patchLevel, license, commit, name, description, url, fullVersion);
    }

    @Override
    public List<String> getSessionNames(IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list");
        ICommandResult result = this.executeCommand(command, monitor);
        Document doc = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList elements = doc.getElementsByTagName("name");
        ArrayList<String> retArray = new ArrayList<String>();
        int i = 0;
        while (i < elements.getLength()) {
            Node node = elements.item(i);
            if (node.getParentNode().getNodeName().equalsIgnoreCase("session")) {
                retArray.add(node.getTextContent());
            }
            ++i;
        }
        return retArray;
    }

    @Override
    public ISessionInfo getSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list", sessionName);
        ICommandResult result = this.executeCommand(command, monitor);
        SessionInfo sessionInfo = new SessionInfo(sessionName);
        Document document = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList sessionsNode = document.getElementsByTagName("session");
        if (sessionsNode.getLength() != 1) {
            throw new ExecutionException(NLS.bind((String)Messages.TraceControl_MiInvalidNumberOfElementError, (Object)"session"));
        }
        Node rawSession = sessionsNode.item(0);
        this.parseSession((ISessionInfo)sessionInfo, rawSession);
        if (sessionInfo.isSnapshotSession()) {
            ISnapshotInfo snapshot = this.getSnapshotInfo(sessionName, monitor);
            sessionInfo.setSnapshotInfo(snapshot);
        }
        return sessionInfo;
    }

    private void parseSession(ISessionInfo sessionInfo, Node rawSession) throws ExecutionException {
        Matcher matcher;
        if (!rawSession.getNodeName().equalsIgnoreCase("session")) {
            throw new ExecutionException(Messages.TraceControl_MiInvalidElementError);
        }
        NodeList rawSessionInfos = rawSession.getChildNodes();
        int i = 0;
        while (i < rawSessionInfos.getLength()) {
            Node rawInfo = rawSessionInfos.item(i);
            switch (rawInfo.getNodeName()) {
                case "name": {
                    sessionInfo.setName(rawInfo.getTextContent());
                    break;
                }
                case "path": {
                    sessionInfo.setSessionPath(rawInfo.getTextContent());
                    break;
                }
                case "enabled": {
                    sessionInfo.setSessionState(rawInfo.getTextContent());
                    break;
                }
                case "snapshot_mode": {
                    if (!rawInfo.getTextContent().equals("1")) break;
                    SnapshotInfo snapshotInfo = new SnapshotInfo("");
                    sessionInfo.setSnapshotInfo((ISnapshotInfo)snapshotInfo);
                    break;
                }
                case "live_timer_interval": {
                    long liveDelay = Long.parseLong(rawInfo.getTextContent());
                    if (liveDelay <= 0L || liveDelay > LTTngControlServiceConstants.MAX_LIVE_TIMER_INTERVAL) break;
                    sessionInfo.setLive(true);
                    sessionInfo.setLiveUrl("net://127.0.0.1");
                    sessionInfo.setLivePort(Integer.valueOf(5344));
                    sessionInfo.setLiveDelay(liveDelay);
                    break;
                }
                case "domains": {
                    NodeList rawDomains = rawInfo.getChildNodes();
                    IDomainInfo domain = null;
                    int j = 0;
                    while (j < rawDomains.getLength()) {
                        if (rawDomains.item(j).getNodeName().equalsIgnoreCase("domain")) {
                            domain = this.parseDomain(rawDomains.item(j));
                            sessionInfo.addDomain(domain);
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        if (!sessionInfo.isSnapshotSession() && (matcher = LTTngControlServiceConstants.TRACE_NETWORK_PATTERN.matcher(sessionInfo.getSessionPath())).matches()) {
            sessionInfo.setStreamedTrace(true);
        }
    }

    protected IDomainInfo parseDomain(Node rawDomain) throws ExecutionException {
        DomainInfo domain = null;
        Node rawType = LTTngControlServiceMI.getFirstOf(rawDomain.getChildNodes(), "type");
        if (rawType == null) {
            throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
        }
        String rawTypeString = rawType.getTextContent().toLowerCase();
        TraceDomainType domainType = TraceDomainType.valueOfString((String)rawTypeString);
        switch (domainType) {
            case KERNEL: {
                domain = new DomainInfo(Messages.TraceControl_KernelProviderDisplayName);
                domain.setDomain(TraceDomainType.KERNEL);
                break;
            }
            case UST: {
                domain = new DomainInfo(Messages.TraceControl_UstGlobalDomainDisplayName);
                domain.setDomain(TraceDomainType.UST);
                break;
            }
            case JUL: {
                domain = new DomainInfo(Messages.TraceControl_JULDomainDisplayName);
                domain.setDomain(TraceDomainType.JUL);
                break;
            }
            case LOG4J: {
                domain = new DomainInfo(Messages.TraceControl_LOG4JDomainDisplayName);
                domain.setDomain(TraceDomainType.LOG4J);
                break;
            }
            case PYTHON: {
                domain = new DomainInfo(Messages.TraceControl_PythonDomainDisplayName);
                domain.setDomain(TraceDomainType.PYTHON);
                break;
            }
            case UNKNOWN: {
                domain = new DomainInfo(Messages.TraceControl_UnknownDomainDisplayName);
                domain.setDomain(TraceDomainType.UNKNOWN);
                break;
            }
            default: {
                throw new ExecutionException(Messages.TraceControl_MiInvalidElementError);
            }
        }
        NodeList rawInfos = rawDomain.getChildNodes();
        int i = 0;
        while (i < rawInfos.getLength()) {
            Node rawInfo = rawInfos.item(i);
            switch (rawInfo.getNodeName()) {
                case "buffer_type": {
                    BufferType bufferType = BufferType.valueOfString((String)rawInfo.getTextContent());
                    domain.setBufferType(bufferType);
                    break;
                }
                case "channels": {
                    ArrayList<IChannelInfo> channels = new ArrayList<IChannelInfo>();
                    LTTngControlServiceMI.parseChannels(rawInfo.getChildNodes(), channels);
                    if (channels.isEmpty()) break;
                    domain.setChannels(channels);
                    break;
                }
                case "events": {
                    ArrayList<ILoggerInfo> loggers = new ArrayList<ILoggerInfo>();
                    LTTngControlServiceMI.getLoggerInfo(rawInfo.getChildNodes(), loggers, domain.getDomain());
                    domain.setLoggers(loggers);
                    break;
                }
            }
            ++i;
        }
        return domain;
    }

    /*
     * Exception decompiling
     */
    private static void parseChannels(NodeList rawChannels, ArrayList<IChannelInfo> channels) throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[25] lbl155 : CaseStatement: default:\u000a, @NONE, blocks:[25] lbl155 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ISnapshotInfo getSnapshotInfo(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("snapshot", "list-output", "-s", sessionName);
        ICommandResult result = this.executeCommand(command, monitor);
        Document doc = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList rawSnapshotsOutputs = doc.getElementsByTagName("snapshot");
        SnapshotInfo snapshotInfo = new SnapshotInfo("");
        int i = 0;
        while (i < rawSnapshotsOutputs.getLength()) {
            NodeList rawSnapshotOutput = rawSnapshotsOutputs.item(i).getChildNodes();
            int j = 0;
            while (j < rawSnapshotOutput.getLength()) {
                Node rawInfo = rawSnapshotOutput.item(j);
                switch (rawInfo.getNodeName()) {
                    case "id": {
                        snapshotInfo.setId(Integer.parseInt(rawInfo.getTextContent()));
                        break;
                    }
                    case "name": {
                        snapshotInfo.setName(rawInfo.getTextContent());
                        break;
                    }
                    case "ctrl_url": {
                        snapshotInfo.setSnapshotPath(rawInfo.getTextContent());
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        Matcher matcher2 = LTTngControlServiceConstants.TRACE_NETWORK_PATTERN.matcher(snapshotInfo.getSnapshotPath());
        if (matcher2.matches()) {
            snapshotInfo.setStreamedSnapshot(true);
        }
        return snapshotInfo;
    }

    @Override
    public List<IBaseEventInfo> getKernelProvider(IProgressMonitor monitor) throws ExecutionException {
        ICommandInput tracepointCommand = this.createCommand("list", "-k");
        ICommandResult tracepointResult = this.executeCommand(tracepointCommand, monitor, false);
        ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
        if (this.isError(tracepointResult)) {
            if (this.ignoredPattern(tracepointResult.getErrorOutput(), LTTngControlServiceConstants.LIST_KERNEL_NO_KERNEL_PROVIDER_PATTERN)) {
                return events;
            }
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + tracepointCommand.toString());
        }
        Document tracepointDocument = LTTngControlServiceMI.getDocumentFromStrings(tracepointResult.getOutput(), this.fDocumentBuilder);
        NodeList rawTracepointEvents = tracepointDocument.getElementsByTagName("event");
        LTTngControlServiceMI.getBaseEventInfo(rawTracepointEvents, events);
        ICommandInput syscallCommand = this.createCommand("list", "-k", "--syscall");
        ICommandResult syscallResult = this.executeCommand(syscallCommand, monitor, false);
        ArrayList<IBaseEventInfo> syscallEvents = new ArrayList<IBaseEventInfo>();
        if (this.isError(syscallResult)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + syscallCommand.toString());
        }
        Document syscallDocument = LTTngControlServiceMI.getDocumentFromStrings(syscallResult.getOutput(), this.fDocumentBuilder);
        NodeList rawSyscallEvents = syscallDocument.getElementsByTagName("event");
        LTTngControlServiceMI.getBaseEventInfo(rawSyscallEvents, syscallEvents);
        events.addAll(syscallEvents);
        return events;
    }

    @Override
    public List<IUstProviderInfo> getUstProvider(IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list", "-u");
        command.add("-f");
        ICommandResult result = this.executeCommand(command, monitor, false);
        ArrayList<IUstProviderInfo> allProviders = new ArrayList<IUstProviderInfo>();
        if (this.isError(result)) {
            if (this.ignoredPattern(result.getErrorOutput(), LTTngControlServiceConstants.LIST_UST_NO_UST_PROVIDER_PATTERN)) {
                return allProviders;
            }
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + command.toString());
        }
        Document document = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList rawProviders = document.getElementsByTagName("pid");
        UstProviderInfo providerInfo = null;
        int i = 0;
        while (i < rawProviders.getLength()) {
            Node provider = rawProviders.item(i);
            Node name = LTTngControlServiceMI.getFirstOf(provider.getChildNodes(), "name");
            if (name == null) {
                throw new ExecutionException(Messages.TraceControl_MiInvalidProviderError);
            }
            providerInfo = new UstProviderInfo(name.getTextContent());
            NodeList infos = provider.getChildNodes();
            int j = 0;
            while (j < infos.getLength()) {
                Node info = infos.item(j);
                switch (info.getNodeName()) {
                    case "id": {
                        providerInfo.setPid(Integer.parseInt(info.getTextContent()));
                        break;
                    }
                    case "events": {
                        ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
                        NodeList rawEvents = info.getChildNodes();
                        LTTngControlServiceMI.getBaseEventInfo(rawEvents, events);
                        providerInfo.setEvents(events);
                        break;
                    }
                }
                ++j;
            }
            allProviders.add((IUstProviderInfo)providerInfo);
            ++i;
        }
        if (this.isVersionSupported("2.6")) {
            this.getUstProviderLoggers(allProviders, TraceDomainType.JUL, monitor);
            this.getUstProviderLoggers(allProviders, TraceDomainType.LOG4J, monitor);
            if (this.isVersionSupported("2.7")) {
                this.getUstProviderLoggers(allProviders, TraceDomainType.PYTHON, monitor);
            }
        }
        return allProviders;
    }

    @Override
    public ISessionInfo createSession(ISessionInfo sessionInfo, IProgressMonitor monitor) throws ExecutionException {
        if (sessionInfo.isStreamedTrace()) {
            return this.createStreamedSession(sessionInfo, monitor);
        }
        ICommandInput command = this.prepareSessionCreationCommand(sessionInfo);
        ICommandResult result = this.executeCommand(command, monitor);
        Document document = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList sessions = document.getElementsByTagName("session");
        if (sessions.getLength() != 1) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + NLS.bind((String)Messages.TraceControl_UnexpectedNumberOfElementError, (Object)"session") + " " + sessions.getLength());
        }
        SessionInfo outputSession = new SessionInfo("");
        this.parseSession((ISessionInfo)outputSession, sessions.item(0));
        if (outputSession.getName().equals("") || !"".equals(sessionInfo.getName()) && !outputSession.getName().equals(sessionInfo.getName())) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedNameError + ": " + outputSession.getName());
        }
        if (!sessionInfo.isSnapshotSession() && (outputSession.getSessionPath() == null || sessionInfo.getSessionPath() != null && !outputSession.getSessionPath().contains(sessionInfo.getSessionPath()))) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedPathError + ": " + outputSession.getName());
        }
        if (sessionInfo.isSnapshotSession()) {
            outputSession.setSnapshotInfo((ISnapshotInfo)new SnapshotInfo(""));
        }
        return outputSession;
    }

    private @NonNull ISessionInfo createStreamedSession(ISessionInfo sessionInfo, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.prepareStreamedSessionCreationCommand(sessionInfo);
        ICommandResult result = this.executeCommand(command, monitor);
        Document document = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList sessions = document.getElementsByTagName("session");
        if (sessions.getLength() != 1) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + NLS.bind((String)Messages.TraceControl_UnexpectedNumberOfElementError, (Object)"session") + " " + sessions.getLength());
        }
        SessionInfo outputSession = new SessionInfo("");
        this.parseSession((ISessionInfo)outputSession, sessions.item(0));
        if (outputSession.getName().equals("") || !"".equals(sessionInfo.getName()) && !outputSession.getName().equals(sessionInfo.getName())) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedNameError + ": " + outputSession.getName());
        }
        sessionInfo.setName(outputSession.getName());
        sessionInfo.setStreamedTrace(true);
        if (sessionInfo.getNetworkUrl() != null) {
            if (!sessionInfo.isSnapshotSession() && outputSession.getSessionPath() == null) {
                throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedPathError + ": " + outputSession.getName());
            }
            if (sessionInfo.isSnapshotSession()) {
                sessionInfo.setStreamedTrace(false);
            } else {
                sessionInfo.setSessionPath(outputSession.getSessionPath());
                Matcher matcher = LTTngControlServiceConstants.TRACE_FILE_PROTOCOL_PATTERN.matcher(outputSession.getSessionPath());
                if (matcher.matches()) {
                    sessionInfo.setStreamedTrace(false);
                }
            }
        }
        return sessionInfo;
    }

    @Override
    public void destroySession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("destroy", sessionName);
        ICommandResult result = this.executeCommand(command, monitor, false);
        List errorOutput = result.getErrorOutput();
        if (this.isError(result)) {
            if (this.ignoredPattern(errorOutput, LTTngControlServiceConstants.SESSION_NOT_FOUND_ERROR_PATTERN)) {
                return;
            }
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + result.toString());
        }
        Document doc = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList sessions = doc.getElementsByTagName("session");
        if (sessions.getLength() != 1) {
            throw new ExecutionException(NLS.bind((String)Messages.TraceControl_MiInvalidNumberOfElementError, (Object)"session"));
        }
        Node rawSessionName = LTTngControlServiceMI.getFirstOf(sessions.item(0).getChildNodes(), "name");
        if (rawSessionName == null) {
            throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
        }
        if (!rawSessionName.getTextContent().equals(sessionName)) {
            throw new ExecutionException(NLS.bind((String)Messages.TraceControl_UnexpectedValueError, (Object)rawSessionName.getTextContent(), (Object)sessionName));
        }
    }

    @Override
    protected ICommandInput createCommand(String ... strings) {
        ICommandInput command = this.getCommandShell().createCommand();
        command.add("lttng");
        List<@NonNull String> groupOption = this.getTracingGroupOption();
        if (!groupOption.isEmpty()) {
            command.addAll(groupOption);
        }
        command.add("--mi");
        command.add("xml");
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            command.add((String)NonNullUtils.checkNotNull((Object)string));
            ++n2;
        }
        return command;
    }

    private static void getBaseEventInfo(NodeList xmlBaseEvents, List<IBaseEventInfo> events) throws ExecutionException {
        BaseEventInfo eventInfo = null;
        int i = 0;
        while (i < xmlBaseEvents.getLength()) {
            block16: {
                NodeList rawInfos = xmlBaseEvents.item(i).getChildNodes();
                if (!xmlBaseEvents.item(i).getNodeName().equalsIgnoreCase("event")) break block16;
                Node rawName = LTTngControlServiceMI.getFirstOf(rawInfos, "name");
                if (rawName == null) {
                    throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
                }
                eventInfo = new BaseEventInfo(rawName.getTextContent());
                int j = 0;
                while (j < rawInfos.getLength()) {
                    Node infoNode = rawInfos.item(j);
                    switch (infoNode.getNodeName()) {
                        case "type": {
                            eventInfo.setEventType(infoNode.getTextContent());
                            break;
                        }
                        case "loglevel": {
                            eventInfo.setLogLevel(infoNode.getTextContent());
                            break;
                        }
                        case "event_fields": {
                            ArrayList<IFieldInfo> fields = new ArrayList<IFieldInfo>();
                            LTTngControlServiceMI.getFieldInfo(infoNode.getChildNodes(), fields);
                            eventInfo.setFields(fields);
                            break;
                        }
                    }
                    ++j;
                }
                events.add((IBaseEventInfo)eventInfo);
            }
            ++i;
        }
    }

    static void getEventInfo(NodeList xmlEvents, List<IEventInfo> events) throws ExecutionException {
        EventInfo eventInfo = null;
        int i = 0;
        while (i < xmlEvents.getLength()) {
            block52: {
                block54: {
                    boolean isProbeFunction;
                    NodeList rawInfos = xmlEvents.item(i).getChildNodes();
                    if (!xmlEvents.item(i).getNodeName().equalsIgnoreCase("event")) break block52;
                    Node rawName = LTTngControlServiceMI.getFirstOf(rawInfos, "name");
                    if (rawName == null) {
                        throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
                    }
                    eventInfo = new EventInfo(rawName.getTextContent());
                    int j = 0;
                    while (j < rawInfos.getLength()) {
                        Node infoNode = rawInfos.item(j);
                        switch (infoNode.getNodeName()) {
                            case "type": {
                                eventInfo.setEventType(infoNode.getTextContent());
                                break;
                            }
                            case "loglevel_type": {
                                eventInfo.setLogLevelType(LogLevelType.valueOfString((String)infoNode.getTextContent()));
                                break;
                            }
                            case "loglevel": {
                                eventInfo.setLogLevel(TraceLogLevel.valueOfString((String)infoNode.getTextContent()));
                                break;
                            }
                            case "enabled": {
                                eventInfo.setState(TraceEnablement.valueOfString((String)infoNode.getTextContent()));
                                break;
                            }
                            case "filter": {
                                if (!Boolean.TRUE.toString().equals(infoNode.getTextContent())) break;
                                eventInfo.setFilterExpression(Messages.TraceControl_DefaultEventFilterString);
                                break;
                            }
                            case "filter_expression": {
                                eventInfo.setFilterExpression(infoNode.getTextContent());
                                break;
                            }
                            case "exclusion": {
                                if (!Boolean.TRUE.toString().equals(infoNode.getTextContent())) break;
                                eventInfo.setExcludedEvents(Messages.TraceControl_DefaultEventExcludeString);
                                break;
                            }
                            case "exclusions": {
                                StringBuilder tmpString = new StringBuilder();
                                int k = 0;
                                while (k < infoNode.getChildNodes().getLength()) {
                                    if (k > 0) {
                                        tmpString.append(", ");
                                    }
                                    tmpString.append(infoNode.getChildNodes().item(k).getTextContent());
                                    ++k;
                                }
                                eventInfo.setExcludedEvents(tmpString.toString());
                                break;
                            }
                        }
                        ++j;
                    }
                    boolean bl = isProbeFunction = eventInfo.getEventType().equals((Object)TraceEventType.PROBE) || eventInfo.getEventType().equals((Object)TraceEventType.FUNCTION);
                    if (!isProbeFunction) break block54;
                    ProbeEventInfo probeEvent = new ProbeEventInfo((IEventInfo)eventInfo);
                    eventInfo = probeEvent;
                    Node rawDataNode = null;
                    switch (probeEvent.getEventType()) {
                        case PROBE: 
                        case FUNCTION: {
                            Node rawAttributes = LTTngControlServiceMI.getFirstOf(rawInfos, "attributes");
                            if (rawAttributes == null) {
                                throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
                            }
                            rawDataNode = LTTngControlServiceMI.getFirstOf(rawAttributes.getChildNodes(), "probe_attributes");
                            break;
                        }
                        default: {
                            throw new ExecutionException(Messages.TraceControl_MiInvalidElementError);
                        }
                    }
                    if (rawDataNode == null) {
                        throw new ExecutionException(Messages.TraceControl_MiInvalidElementError);
                    }
                    NodeList rawDatas = rawDataNode.getChildNodes();
                    int j2 = 0;
                    while (j2 < rawDatas.getLength()) {
                        Node rawData = rawDatas.item(j2);
                        switch (rawData.getNodeName()) {
                            case "symbol_name": {
                                probeEvent.setSymbol(rawData.getTextContent());
                                break;
                            }
                            case "address": {
                                probeEvent.setAddress(String.format("%#016x", new BigInteger(rawData.getTextContent())));
                                break;
                            }
                            case "offset": {
                                probeEvent.setOffset(String.format("%#016x", new BigInteger(rawData.getTextContent())));
                                break;
                            }
                        }
                        ++j2;
                    }
                }
                events.add((IEventInfo)eventInfo);
            }
            ++i;
        }
    }

    static void getLoggerInfo(NodeList xmlEvents, List<ILoggerInfo> loggers, TraceDomainType domain) throws ExecutionException {
        LoggerInfo loggerInfo = null;
        int i = 0;
        while (i < xmlEvents.getLength()) {
            block21: {
                NodeList rawInfos = xmlEvents.item(i).getChildNodes();
                if (!xmlEvents.item(i).getNodeName().equalsIgnoreCase("event")) break block21;
                Node rawName = LTTngControlServiceMI.getFirstOf(rawInfos, "name");
                if (rawName == null) {
                    throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
                }
                loggerInfo = new LoggerInfo(rawName.getTextContent());
                loggerInfo.setDomain(domain);
                int j = 0;
                while (j < rawInfos.getLength()) {
                    Node infoNode = rawInfos.item(j);
                    block5 : switch (infoNode.getNodeName()) {
                        case "loglevel_type": {
                            loggerInfo.setLogLevelType(LogLevelType.valueOfString((String)infoNode.getTextContent()));
                            break;
                        }
                        case "loglevel": {
                            switch (domain) {
                                case JUL: {
                                    loggerInfo.setLogLevel((ITraceLogLevel)TraceJulLogLevel.valueOfString((String)infoNode.getTextContent()));
                                    break block5;
                                }
                                case LOG4J: {
                                    loggerInfo.setLogLevel((ITraceLogLevel)TraceLog4jLogLevel.valueOfString((String)infoNode.getTextContent()));
                                    break block5;
                                }
                                case PYTHON: {
                                    loggerInfo.setLogLevel((ITraceLogLevel)TracePythonLogLevel.valueOfString((String)infoNode.getTextContent()));
                                    break block5;
                                }
                            }
                            break;
                        }
                        case "enabled": {
                            loggerInfo.setState(TraceEnablement.valueOfString((String)infoNode.getTextContent()));
                            break;
                        }
                    }
                    ++j;
                }
                loggers.add((ILoggerInfo)loggerInfo);
            }
            ++i;
        }
    }

    private static void getFieldInfo(NodeList fieldsList, List<IFieldInfo> fields) throws ExecutionException {
        FieldInfo fieldInfo = null;
        int i = 0;
        while (i < fieldsList.getLength()) {
            block10: {
                Node field = fieldsList.item(i);
                if (!field.getNodeName().equalsIgnoreCase("event_field")) break block10;
                Node name = LTTngControlServiceMI.getFirstOf(field.getChildNodes(), "name");
                if (name == null) {
                    throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
                }
                fieldInfo = new FieldInfo(name.getTextContent());
                NodeList infos = field.getChildNodes();
                int j = 0;
                while (j < infos.getLength()) {
                    Node info = infos.item(j);
                    switch (info.getNodeName()) {
                        case "type": {
                            fieldInfo.setFieldType(info.getTextContent());
                            break;
                        }
                    }
                    ++j;
                }
                fields.add((IFieldInfo)fieldInfo);
            }
            ++i;
        }
    }

    private static @Nullable Node getFirstOf(NodeList nodeList, String tagName) {
        Node node = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            if (Objects.equals(nodeList.item(i).getNodeName(), tagName)) {
                node = nodeList.item(i);
                break;
            }
            ++i;
        }
        return node;
    }

    private void getUstProviderLoggers(List<IUstProviderInfo> allProviders, TraceDomainType domain, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list");
        switch (domain) {
            case JUL: {
                command.add("-j");
                break;
            }
            case LOG4J: {
                command.add("-l");
                break;
            }
            case PYTHON: {
                command.add("-p");
                break;
            }
        }
        ICommandResult result = this.executeCommand(command, monitor, false);
        if (this.isError(result)) {
            if (this.ignoredPattern(result.getErrorOutput(), LTTngControlServiceConstants.LIST_UST_NO_UST_PROVIDER_PATTERN)) {
                return;
            }
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + command.toString());
        }
        Document document = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList rawProviders = document.getElementsByTagName("pid");
        int i = 0;
        while (i < rawProviders.getLength()) {
            Node provider = rawProviders.item(i);
            Node name = LTTngControlServiceMI.getFirstOf(provider.getChildNodes(), "name");
            if (name == null) {
                throw new ExecutionException(Messages.TraceControl_MiInvalidProviderError);
            }
            Node id = LTTngControlServiceMI.getFirstOf(provider.getChildNodes(), "id");
            if (id != null) {
                int k = 0;
                while (k < allProviders.size()) {
                    Node events;
                    if (allProviders.get(k).getPid() == Integer.parseInt(id.getTextContent()) && (events = LTTngControlServiceMI.getFirstOf(provider.getChildNodes(), "events")) != null) {
                        ArrayList<ILoggerInfo> loggers = new ArrayList<ILoggerInfo>();
                        NodeList rawEvents = events.getChildNodes();
                        LTTngControlServiceMI.getLoggerInfo(rawEvents, loggers, domain);
                        for (ILoggerInfo logger : loggers) {
                            logger.setDomain(domain);
                        }
                        allProviders.get(k).addLoggers(loggers);
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    @Override
    public @NonNull List<String> getContextList(IProgressMonitor monitor) throws ExecutionException {
        if (!this.isVersionSupported("2.8.0")) {
            return super.getContextList(monitor);
        }
        ICommandInput command = this.createCommand("add-context", "--list");
        ICommandResult result = this.executeCommand(command, monitor);
        if (!this.isVersionSupported("2.11.0")) {
            return result.getOutput();
        }
        if (this.isError(result)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + command.toString());
        }
        Document document = LTTngControlServiceMI.getDocumentFromStrings(result.getOutput(), this.fDocumentBuilder);
        NodeList rawContexts = document.getElementsByTagName("context");
        ArrayList<String> returnedContexts = new ArrayList<String>();
        int i = 0;
        while (i < rawContexts.getLength()) {
            Node contextNode = rawContexts.item(i);
            Node symbol = LTTngControlServiceMI.getFirstOf(contextNode.getChildNodes(), "symbol");
            if (symbol != null) {
                returnedContexts.add(symbol.getTextContent());
            }
            ++i;
        }
        return returnedContexts;
    }
}

