/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.parsers.custom.CustomExtraField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventContent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CustomEvent
extends TmfEvent {
    protected static final String NO_MESSAGE = "";
    private @NonNull ITmfTimestamp customEventTimestamp;
    private ITmfEventField customEventContent;
    private ITmfEventType customEventType;
    protected CustomTraceDefinition fDefinition;
    protected Map<Object, String> fData;

    public CustomEvent(CustomTraceDefinition definition) {
        super(null, -1L, null, null, null);
        this.fDefinition = definition;
        this.fData = new LinkedHashMap<Object, String>();
        this.customEventTimestamp = TmfTimestamp.ZERO;
    }

    public CustomEvent(CustomTraceDefinition definition, @NonNull TmfEvent other) {
        super(other);
        this.fDefinition = definition;
        this.fData = new LinkedHashMap<Object, String>();
        this.customEventTimestamp = other.getTimestamp();
        this.customEventContent = other.getContent();
        this.customEventType = other.getType();
    }

    public CustomEvent(CustomTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, TmfEventType type) {
        super(parentTrace, -1L, null, null, null);
        this.fDefinition = definition;
        this.fData = new LinkedHashMap<Object, String>();
        this.customEventTimestamp = timestamp == null ? TmfTimestamp.ZERO : timestamp;
        this.customEventContent = null;
        this.customEventType = type;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventTimestamp;
    }

    @Override
    public ITmfEventField getContent() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventContent;
    }

    @Override
    public ITmfEventType getType() {
        return this.customEventType;
    }

    @Override
    public String getName() {
        if (this.fData != null) {
            this.processData();
        }
        return super.getName();
    }

    protected void setTimestamp(@NonNull ITmfTimestamp timestamp) {
        this.customEventTimestamp = timestamp;
    }

    protected void setContent(ITmfEventField content) {
        this.customEventContent = content;
    }

    Object getContentValue() {
        return this.customEventContent.getValue();
    }

    protected void setType(ITmfEventType type) {
        this.customEventType = type;
    }

    private void processData() {
        String timestampString = this.fData.remove((Object)CustomTraceDefinition.Tag.TIMESTAMP);
        String timestampInputFormat = this.fData.remove((Object)Key.TIMESTAMP_INPUT_FORMAT);
        ITmfTimestamp timestamp = null;
        if (timestampInputFormat != null && timestampString != null) {
            TmfTimestampFormat timestampFormat = new TmfTimestampFormat(timestampInputFormat);
            try {
                long time = timestampFormat.parseValue(timestampString);
                timestamp = TmfTimestamp.fromNanos(this.getTrace().getTimestampTransform().transform(time));
                this.setTimestamp(timestamp);
            }
            catch (ParseException parseException) {
                this.setTimestamp(TmfTimestamp.ZERO);
            }
        } else {
            this.setTimestamp(TmfTimestamp.ZERO);
        }
        String eventName = this.fData.remove((Object)CustomTraceDefinition.Tag.EVENT_TYPE);
        ITmfEventType type = this.getType();
        if (eventName != null && type instanceof CustomEventType) {
            ((CustomEventType)type).setName(eventName);
        }
        LinkedHashMap<String, TmfEventField> fieldMap = new LinkedHashMap<String, TmfEventField>();
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            if (outputColumn.tag.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                if (timestamp == null || this.fDefinition.timeStampOutputFormat == null || this.fDefinition.timeStampOutputFormat.isEmpty()) continue;
                TmfTimestampFormat timestampFormat = new TmfTimestampFormat(this.fDefinition.timeStampOutputFormat);
                fieldMap.put(outputColumn.name, new TmfEventField(outputColumn.name, timestampFormat.format(timestamp.getValue()), null));
                continue;
            }
            if (!outputColumn.tag.equals((Object)CustomTraceDefinition.Tag.OTHER) && !outputColumn.tag.equals((Object)CustomTraceDefinition.Tag.MESSAGE)) continue;
            Object key = outputColumn.tag.equals((Object)CustomTraceDefinition.Tag.OTHER) ? outputColumn.name : outputColumn.tag;
            fieldMap.put(outputColumn.name, new TmfEventField(outputColumn.name, NonNullUtils.nullToEmptyString((Object)this.fData.remove(key)), null));
        }
        for (Map.Entry entry : this.fData.entrySet()) {
            String fieldName = NonNullUtils.nullToEmptyString((Object)entry.getKey().toString());
            if (fieldMap.containsKey(fieldName)) continue;
            fieldMap.put(fieldName, new CustomExtraField(fieldName, NonNullUtils.nullToEmptyString(entry.getValue()), null));
        }
        this.setContent(new CustomEventContent(this.customEventContent.getName(), this.customEventContent.getValue(), fieldMap.values().toArray(new ITmfEventField[fieldMap.size()])));
        this.fData = null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fDefinition == null ? 0 : this.fDefinition.hashCode());
        result = 31 * result + this.customEventTimestamp.hashCode();
        result = 31 * result + (this.customEventContent == null ? 0 : this.customEventContent.hashCode());
        result = 31 * result + (this.customEventType == null ? 0 : this.customEventType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CustomEvent)) {
            return false;
        }
        CustomEvent other = (CustomEvent)obj;
        if (!Objects.equals(this.fDefinition, other.fDefinition)) {
            return false;
        }
        if (!this.customEventTimestamp.equals(other.customEventTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.customEventContent, other.customEventContent)) {
            return false;
        }
        return Objects.equals(this.customEventType, other.customEventType);
    }

    protected static enum Key {
        TIMESTAMP_INPUT_FORMAT;

    }
}

