/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.text.StructuredAutoEditStrategy;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;

public class StructuredAutoEditStrategyXML
extends StructuredAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.supportsSmartInsert(document)) {
            return;
        }
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && command.text != null) {
                this.smartInsertCloseElement(command, document, model);
                this.smartInsertForComment(command, document, model);
                this.smartInsertForEndTag(command, document, model);
                this.smartRemoveEndTag(command, document, model);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private boolean isPreferenceEnabled(String key) {
        return key != null && XMLUIPlugin.getDefault().getPreferenceStore().getBoolean(key);
    }

    private boolean isCommentNode(IDOMNode node) {
        return node != null && node instanceof IDOMElement && ((IDOMElement)node).isCommentTag();
    }

    private boolean isDocumentNode(IDOMNode node) {
        return node != null && node.getNodeType() == 9;
    }

    private void smartRemoveEndTag(DocumentCommand command, IDocument document, IStructuredModel model) {
        try {
            IStructuredDocumentRegion region;
            IDOMNode node;
            if ("/".equals(command.text) && ">".equals(document.get(command.offset, 1)) && command.length == 0 && this.isPreferenceEnabled("removeEndTags") && (node = (IDOMNode)model.getIndexedRegion(command.offset)) != null && !node.hasChildNodes() && (region = node.getFirstStructuredDocumentRegion()).getFirstRegion().getType() == "XML_TAG_OPEN" && command.offset <= region.getEnd()) {
                ITextRegion prevTextRegion = region.getRegionAtCharacterOffset(command.offset - 1);
                boolean inUnclosedAttValueRegion = false;
                if (prevTextRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    String prevText = region.getText(prevTextRegion);
                    boolean bl = inUnclosedAttValueRegion = prevText.startsWith("'") && (prevText.length() == 1 || !prevText.endsWith("'")) || prevText.startsWith("\"") && (prevText.length() == 1 || !prevText.endsWith("\""));
                    if (!inUnclosedAttValueRegion) {
                        boolean bl2 = inUnclosedAttValueRegion = prevTextRegion == region.getRegionAtCharacterOffset(command.offset);
                    }
                }
                if (!inUnclosedAttValueRegion && (region = node.getEndStructuredDocumentRegion()) != null && region.isEnded()) {
                    document.replace(region.getStartOffset(), region.getLength(), "");
                }
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void smartInsertForComment(DocumentCommand command, IDocument document, IStructuredModel model) {
        try {
            if (command.text.equals("-") && document.getLength() >= 3 && document.get(command.offset - 3, 3).equals("<!-") && this.isPreferenceEnabled("completeComments")) {
                command.text = String.valueOf(command.text) + "  -->";
                command.shiftsCaret = false;
                command.caretOffset = command.offset + 2;
                command.doit = false;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void smartInsertCloseElement(DocumentCommand command, IDocument document, IStructuredModel model) {
        try {
            if (command.text.equals(">") && document.getLength() > 0 && document.getChar(command.offset - 1) != '/' && this.isPreferenceEnabled("completeElements")) {
                IDOMNode node = (IDOMNode)model.getIndexedRegion(command.offset - 1);
                boolean isClosedByParent = false;
                if (node != null && node.getNodeType() == 1 && (!node.isClosed() || (isClosedByParent = this.hasUnclosedAncestor(node)))) {
                    String text;
                    char first;
                    ITextRegion textRegion;
                    IStructuredDocumentRegion region = node.getEndStructuredDocumentRegion();
                    if (region != null && region.getRegions().size() > 0 && region.getRegions().get(0).getType() == "XML_END_TAG_OPEN" && !isClosedByParent) {
                        return;
                    }
                    region = node.getStartStructuredDocumentRegion();
                    if (region != null && (textRegion = region.getRegionAtCharacterOffset(command.offset - 1)) != null && "XML_TAG_ATTRIBUTE_VALUE".equals(textRegion.getType()) && ((first = (text = region.getText(textRegion)).charAt(0)) == '\'' || first == '\"')) {
                        if (text.length() < 2) {
                            return;
                        }
                        char last = text.charAt(text.length() - 1);
                        if (last == first) {
                            if (command.offset < region.getTextEndOffset(textRegion)) {
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                    command.text = String.valueOf(command.text) + "</" + this.getElementName(node, command.offset) + ">";
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + 1;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String getElementName(IDOMNode node, int offset) {
        String regionText;
        int nameStart;
        int length;
        String name = null;
        IStructuredDocumentRegion region = node.getFirstStructuredDocumentRegion();
        ITextRegion textRegion = region.getRegionAtCharacterOffset(offset);
        if (textRegion != null && textRegion.getType() == "XML_TAG_NAME" && (length = offset - (nameStart = region.getStartOffset(textRegion))) <= (regionText = region.getText(textRegion)).length()) {
            name = regionText.substring(0, length);
        }
        if (name == null) {
            name = node.getNodeName();
        }
        return name;
    }

    private void smartInsertForEndTag(DocumentCommand command, IDocument document, IStructuredModel model) {
        try {
            if (command.text.equals("/") && document.getLength() >= 1 && document.get(command.offset - 1, 1).equals("<") && this.isPreferenceEnabled("completeEndTags")) {
                IDOMNode parentNode = (IDOMNode)((IDOMNode)model.getIndexedRegion(command.offset - 1)).getParentNode();
                if (this.isCommentNode(parentNode)) {
                    while (parentNode != null && this.isCommentNode(parentNode)) {
                        parentNode = (IDOMNode)parentNode.getParentNode();
                    }
                }
                if (!this.isDocumentNode(parentNode)) {
                    StringBuffer toAdd;
                    IStructuredDocumentRegion endTagStructuredDocumentRegion = parentNode.getEndStructuredDocumentRegion();
                    IDOMNode ancestor = parentNode;
                    boolean smartInsertForEnd = false;
                    if (endTagStructuredDocumentRegion != null) {
                        while ((ancestor = (IDOMNode)ancestor.getParentNode()) != null) {
                            if (ancestor.getEndStructuredDocumentRegion() != null || !parentNode.getNodeName().equals(ancestor.getNodeName())) continue;
                            smartInsertForEnd = true;
                            break;
                        }
                    }
                    if ((endTagStructuredDocumentRegion == null || smartInsertForEnd) && (toAdd = new StringBuffer(parentNode.getNodeName())).length() > 0) {
                        toAdd.append(">");
                        String suffix = toAdd.toString();
                        if (document.getLength() < command.offset + suffix.length() || !suffix.equals(document.get(command.offset, suffix.length()))) {
                            command.text = String.valueOf(command.text) + suffix;
                        }
                    }
                }
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private boolean hasUnclosedAncestor(IDOMNode node) {
        IDOMNode parent = (IDOMNode)node.getParentNode();
        while (parent != null && parent.getNodeType() != 9 && parent.getNodeName().equals(node.getNodeName())) {
            if (!parent.isClosed()) {
                return true;
            }
            parent = (IDOMNode)parent.getParentNode();
        }
        return false;
    }
}

