/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui;

import java.security.cert.Certificate;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.equinox.internal.security.ui.wizard.CertificateViewer;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfirmationDialog
extends TitleAreaDialog {
    public static final int YES = 100;
    public static final int NO = 101;
    private Certificate cert;

    public ConfirmationDialog(Shell parentShell, Certificate cert) {
        super(parentShell);
        this.cert = cert;
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(SecurityUIMsg.CONFIRMATION_DIALOG_TITLE);
        this.setMessage(SecurityUIMsg.CONFIRMATION_DIALOG_MSG);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        CertificateViewer certViewer = new CertificateViewer(composite);
        certViewer.setCertificate(this.cert);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button yesBtn = this.createButton(parent, 100, SecurityUIMsg.CONFIRMATION_DIALGO_YES, true);
        yesBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setReturnCode(100);
            this.close();
        }));
        Button noBtn = this.createButton(parent, 101, SecurityUIMsg.CONFIRMATION_DIALGO_NO, false);
        noBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setReturnCode(101);
            this.close();
        }));
    }
}

