/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.analysis.timing.core.statistics.ITreeStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.ITreeStatisticsAnalysis;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.AbstractSegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.IDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsAspects;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentStoreTreeStatisticsDataProvider
extends AbstractSegmentStoreStatisticsDataProvider {
    public static final String ID = "org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreTreeStatisticsDataProvider";
    private final ITreeStatisticsAnalysis fProvider;
    private final @Nullable IAnalysisModule fModule;

    public SegmentStoreTreeStatisticsDataProvider(ITmfTrace trace, ITreeStatisticsAnalysis provider, String id) {
        super(trace, id);
        this.fProvider = provider;
        this.fModule = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
    }

    public SegmentStoreTreeStatisticsDataProvider(ITmfTrace trace, ITreeStatisticsAnalysis provider, String id, List<IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics>> userDefinedAspects) {
        super(trace, id, userDefinedAspects);
        this.fProvider = provider;
        this.fModule = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
    }

    public TmfModelResponse<TmfTreeModel<SegmentStoreStatisticsModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITreeStatistics<ISegment> statsRoot;
        IAnalysisModule module = this.fModule;
        if (module != null) {
            if (monitor != null) {
                module.waitForCompletion(monitor);
                if (monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
            } else {
                module.waitForCompletion();
            }
        }
        if ((statsRoot = this.fProvider.getStatsRoot()) == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ArrayList<SegmentStoreStatisticsModel> list = new ArrayList<SegmentStoreStatisticsModel>();
        String rootName = this.getRootEntryName();
        if (rootName == null) {
            rootName = this.getTrace().getName();
        }
        list.add(new SegmentStoreStatisticsModel(this.fTraceId, -1L, this.getCellLabels(NonNullUtils.nullToEmptyString((Object)rootName), statsRoot), statsRoot));
        this.addModelsRecursively(statsRoot, list, this.getUniqueId("Total_"), this.fTraceId, "Total_");
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        Boolean isFiltered = DataProviderParameterUtils.extractIsFiltered(fetchParameters);
        if (filter != null && isFiltered != null && isFiltered.booleanValue()) {
            IProgressMonitor nonNullMonitor;
            long end;
            long start = filter.getStart();
            ITreeStatistics<ISegment> statsRootForRange = this.fProvider.getStatsRootForRange(start, end = filter.getEnd(), nonNullMonitor = monitor != null ? monitor : new NullProgressMonitor());
            if (statsRootForRange == null) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            this.addModelsRecursively(statsRootForRange, list, this.getUniqueId("Selection_"), this.fTraceId, "Selection_");
        }
        TmfTreeModel.Builder treeModelBuilder = new TmfTreeModel.Builder();
        treeModelBuilder.setColumnDescriptors(this.getColumnDescriptors());
        treeModelBuilder.setEntries(Collections.unmodifiableList(list));
        return new TmfModelResponse((Object)treeModelBuilder.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private void addModelsRecursively(ITreeStatistics<ISegment> rootStats, List<SegmentStoreStatisticsModel> list, long currentId, long parentId, String prefix) {
        list.add(new SegmentStoreStatisticsModel(currentId, parentId, this.getCellLabels(rootStats.getName(), rootStats), rootStats));
        for (ITreeStatistics<ISegment> childStats : rootStats.getChildren()) {
            long uniqueIdForChild = this.getUniqueId(prefix + rootStats.getName() + childStats.getName());
            this.addModelsRecursively(childStats, list, uniqueIdForChild, currentId, prefix);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fModule != null) {
            this.fModule.dispose();
        }
    }
}

