/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class SearchResultUpdater
implements IResourceChangeListener,
IQueryListener {
    private AbstractTextSearchResult fResult;

    public SearchResultUpdater(AbstractTextSearchResult result) {
        this.fResult = result;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            this.handleDelta(delta);
        }
    }

    private void handleDelta(IResourceDelta d) {
        try {
            d.accept(delta -> {
                switch (delta.getKind()) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        IResource res = delta.getResource();
                        if (!(res instanceof IFile)) break;
                        Match[] matches = this.fResult.getMatches(res);
                        this.fResult.removeMatches(matches);
                        break;
                    }
                }
                return true;
            });
        }
        catch (CoreException e) {
            SearchPlugin.log(e);
        }
    }

    @Override
    public void queryAdded(ISearchQuery query) {
    }

    @Override
    public void queryRemoved(ISearchQuery query) {
        if (this.fResult.equals(query.getSearchResult())) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            NewSearchUI.removeQueryListener(this);
        }
    }

    @Override
    public void queryStarting(ISearchQuery query) {
    }

    @Override
    public void queryFinished(ISearchQuery query) {
    }
}

