/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;

public class RunnableWithProgressWrapper
implements IRunnableWithProgress {
    private IHeadlessRunnableWithProgress headlessRunnable = null;
    private IWorkspaceRunnable workspaceRunnable = null;
    private ValidationOperation validationOperation = null;

    public RunnableWithProgressWrapper(IHeadlessRunnableWithProgress aHeadlessRunnableWithProgress) {
        this.setHeadlessRunnable(aHeadlessRunnableWithProgress);
    }

    public RunnableWithProgressWrapper(IWorkspaceRunnable aHeadlessRunnableWithProgress) {
        this.setWorkspaceRunnable(aHeadlessRunnableWithProgress);
    }

    public RunnableWithProgressWrapper(ValidationOperation op) {
        this.setValidationOperation(op);
    }

    protected IHeadlessRunnableWithProgress getHeadlessRunnable() {
        return this.headlessRunnable;
    }

    protected IWorkspaceRunnable getWorkspaceRunnable() {
        return this.workspaceRunnable;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            if (this.getHeadlessRunnable() != null) {
                this.getHeadlessRunnable().run(monitor);
            } else {
                ValidationOperation runnable;
                Object object = runnable = this.getWorkspaceRunnable() == null ? this.validationOperation : this.getWorkspaceRunnable();
                if (runnable == null) {
                    return;
                }
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, monitor);
            }
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc);
        }
    }

    protected void setHeadlessRunnable(IHeadlessRunnableWithProgress newHeadlessRunnable) {
        this.headlessRunnable = newHeadlessRunnable;
    }

    protected void setWorkspaceRunnable(IWorkspaceRunnable newWorkspaceRunnable) {
        this.workspaceRunnable = newWorkspaceRunnable;
    }

    protected void setValidationOperation(ValidationOperation op) {
        this.validationOperation = op;
    }
}

