/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.internal.DetailedProgressViewer;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressViewUpdater;
import org.eclipse.e4.ui.progress.internal.ProgressViewerContentProvider;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ProgressView {
    DetailedProgressViewer viewer;
    @Inject
    ESelectionService selectionService;
    ISelectionChangedListener selectionListener;

    @PostConstruct
    public void createPartControl(Composite parent, ProgressManager progressManager, IProgressService progressService, FinishedJobs finishedJobs, ProgressViewUpdater viewUpdater) {
        this.viewer = new DetailedProgressViewer(parent, 2, progressService, finishedJobs);
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer, finishedJobs, viewUpdater, progressManager, true, true);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput((Object)progressManager);
        this.selectionListener = event -> {
            if (this.selectionService != null) {
                this.selectionService.setSelection((Object)event.getSelection());
            }
        };
        this.viewer.addSelectionChangedListener(this.selectionListener);
    }

    @Focus
    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }
}

