/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.internal.ui.text.DecoratingFileSearchLabelProvider;
import org.eclipse.search.internal.ui.text.EditorOpener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.text.quicksearch.internal.core.LineItem;
import org.eclipse.text.quicksearch.internal.core.QuickTextQuery;
import org.eclipse.text.quicksearch.internal.core.QuickTextSearchRequestor;
import org.eclipse.text.quicksearch.internal.core.QuickTextSearcher;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatchers;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchContext;
import org.eclipse.text.quicksearch.internal.ui.TableResizeHelper;
import org.eclipse.text.quicksearch.internal.util.DocumentFetcher;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class QuickSearchDialog
extends SelectionStatusDialog {
    private static final int OPEN_BUTTON_ID = 0;
    private static final int REFRESH_BUTTON_ID = 8;
    public static final StyledString.Styler HIGHLIGHT_STYLE = DecoratingFileSearchLabelProvider.HIGHLIGHT_STYLE;
    private UIJob refreshJob = UIJob.create((String)Messages.QuickSearchDialog_RefreshJob, m -> this.refreshWidgets());
    private UIJob progressJob = new UIJob(Messages.QuickSearchDialog_RefreshJob){
        int animate;
        {
            this.animate = 0;
        }

        protected String dots(int animate) {
            char[] chars = new char[animate];
            int i = 0;
            while (i < chars.length) {
                chars[i] = 46;
                ++i;
            }
            return new String(chars);
        }

        protected String currentFileInfo(IFile currentFile, int animate) {
            if (currentFile != null) {
                String path = currentFile.getFullPath().toString();
                if (path.length() <= 30) {
                    return path;
                }
                return "..." + path.substring(path.length() - 30);
            }
            return this.dots(animate);
        }

        public IStatus runInUIThread(IProgressMonitor mon) {
            if (!mon.isCanceled() && QuickSearchDialog.this.progressLabel != null && !QuickSearchDialog.this.progressLabel.isDisposed()) {
                if (QuickSearchDialog.this.searcher == null || !QuickSearchDialog.this.searcher.isActive()) {
                    if (QuickSearchDialog.this.searcher != null && QuickSearchDialog.this.searcher.searchTookMs != 0) {
                        QuickSearchDialog.this.progressLabel.setText(Messages.QuickSearchDialog_notFound);
                    } else {
                        QuickSearchDialog.this.progressLabel.setText(QuickSearchDialog.EMPTY_STRING);
                    }
                } else {
                    QuickSearchDialog.this.progressLabel.setText(NLS.bind((String)Messages.QuickSearchDialog_searching, (Object)this.currentFileInfo(QuickSearchDialog.this.searcher.getCurrentFile(), this.animate)));
                    this.animate = (this.animate + 1) % 4;
                }
                if (QuickSearchDialog.this.searcher != null) {
                    this.schedule(100L);
                }
            }
            return Status.OK_STATUS;
        }
    };
    public final StyledCellLabelProvider LINE_NUMBER_LABEL_PROVIDER = new StyledCellLabelProvider(){

        public void update(ViewerCell cell) {
            LineItem item = (LineItem)cell.getElement();
            if (item != null) {
                cell.setText(Integer.toString(item.getLineNumber()));
            } else {
                cell.setText("?");
            }
            cell.setImage(QuickSearchDialog.this.getBlankImage());
        }
    };
    private static final Color GREY = Display.getCurrent().getSystemColor(16);
    private final StyledCellLabelProvider LINE_TEXT_LABEL_PROVIDER = new StyledCellLabelProvider(){

        public void update(ViewerCell cell) {
            LineItem item = (LineItem)cell.getElement();
            if (item != null) {
                StyledString text = QuickSearchDialog.this.highlightMatches(item.getText());
                cell.setText(text.getString());
                cell.setStyleRanges(text.getStyleRanges());
            } else {
                cell.setText(QuickSearchDialog.EMPTY_STRING);
                cell.setStyleRanges(null);
            }
            cell.setImage(QuickSearchDialog.this.getBlankImage());
            super.update(cell);
        }
    };
    private Image blankImage;
    private final StyledCellLabelProvider LINE_FILE_LABEL_PROVIDER = new StyledCellLabelProvider(){

        public void update(ViewerCell cell) {
            LineItem item = (LineItem)cell.getElement();
            if (item != null) {
                IPath path = item.getFile().getFullPath();
                String name = path.lastSegment();
                String dir = path.removeLastSegments(1).toString();
                if (dir.startsWith("/")) {
                    dir = dir.substring(1);
                }
                cell.setText(name + " - " + dir);
                StyleRange[] styleRanges = new StyleRange[]{new StyleRange(name.length(), dir.length() + 3, GREY, null)};
                cell.setStyleRanges(styleRanges);
            } else {
                cell.setText(QuickSearchDialog.EMPTY_STRING);
                cell.setStyleRanges(null);
            }
            cell.setImage(QuickSearchDialog.this.getBlankImage());
            super.update(cell);
        }
    };
    private static final String DIALOG_SETTINGS = QuickSearchDialog.class.getName() + ".DIALOG_SETTINGS";
    private static final String DIALOG_BOUNDS_SETTINGS = "DialogBoundsSettings";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_COLUMNS = "COLUMN_WIDTHS";
    private static final String DIALOG_SASH_WEIGHTS = "SASH_WEIGHTS";
    private static final String DIALOG_LAST_QUERY = "LAST_QUERY";
    private static final String CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final boolean CASE_SENSITIVE_DEFAULT = true;
    private static final String KEEP_OPEN = "KEEP_OPEN";
    private static final boolean KEEP_OPEN_DEFAULT = false;
    private final Deque<String> filterHistory = new LinkedList<String>();
    private static final int FILTER_HISTORY_SIZE = 5;
    private static final String FILTER_HISTORY = "FILTER_HISTORY";
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private Text pattern;
    private TableViewer list;
    private MenuManager menuManager;
    private MenuManager contextMenuManager;
    private boolean multi;
    private ToolBar toolBar;
    private ToolItem toolItem;
    private Label progressLabel;
    private ContentProvider contentProvider;
    private String initialPatternText;
    private int selectionMode;
    private static final String EMPTY_STRING = "";
    private final int MAX_LINE_LEN;
    private final int MAX_RESULTS;
    private IHandlerActivation showViewHandler;
    private QuickTextSearcher searcher;
    private StyledText details;
    private DocumentFetcher documents;
    private ToggleCaseSensitiveAction toggleCaseSensitiveAction;
    private ToggleKeepOpenAction toggleKeepOpenAction;
    private QuickSearchContext context;
    private SashForm sashForm;
    private Label headerLabel;
    private IWorkbenchWindow window;
    private Combo searchIn;
    private Label listLabel;

    protected void openSelection() {
        try {
            LineItem item = (LineItem)this.getFirstResult();
            if (item != null) {
                QuickTextQuery q = this.getQuery();
                QuickTextQuery.TextRange range = q.findFirst(item.getText());
                EditorOpener opener = new EditorOpener();
                IWorkbenchPage page = this.window.getActivePage();
                if (page != null) {
                    opener.openAndSelect(page, item.getFile(), range.getOffset() + item.getOffset(), range.getLength(), true);
                }
            }
        }
        catch (PartInitException e) {
            QuickSearchActivator.log(e);
        }
    }

    private Image getBlankImage() {
        if (this.blankImage == null) {
            this.blankImage = new Image((Device)Display.getDefault(), 1, 1);
        }
        return this.blankImage;
    }

    public QuickSearchDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.window = window;
        this.setShellStyle(2160);
        this.setBlockOnOpen(false);
        this.setTitle(Messages.QuickSearchDialog_title);
        this.context = new QuickSearchContext(window);
        this.multi = false;
        this.contentProvider = new ContentProvider();
        this.selectionMode = 0;
        this.MAX_LINE_LEN = QuickSearchActivator.getDefault().getPreferences().getMaxLineLen();
        this.MAX_RESULTS = QuickSearchActivator.getDefault().getPreferences().getMaxResults();
        this.progressJob.setSystem(true);
    }

    public void create() {
        super.create();
        this.pattern.setFocus();
    }

    protected void restoreDialog(IDialogSettings settings) {
        try {
            String[] array;
            if (this.initialPatternText == null) {
                String lastSearch = settings.get(DIALOG_LAST_QUERY);
                if (lastSearch == null) {
                    lastSearch = EMPTY_STRING;
                }
                this.pattern.setText(lastSearch);
                this.pattern.selectAll();
            }
            if ((array = settings.getArray(FILTER_HISTORY)) != null) {
                this.filterHistory.addAll(List.of(array));
            }
            if (!this.filterHistory.isEmpty()) {
                String filter = this.filterHistory.getFirst();
                this.filterHistory.removeIf(String::isBlank);
                this.searchIn.setItems((String[])this.filterHistory.toArray(String[]::new));
                this.searchIn.setText(filter);
            }
            if (settings.getArray(DIALOG_COLUMNS) != null) {
                String[] columnWidths = settings.getArray(DIALOG_COLUMNS);
                Table table = this.list.getTable();
                int cols = table.getColumnCount();
                int i = 0;
                while (i < cols) {
                    TableColumn col = table.getColumn(i);
                    try {
                        if (col != null) {
                            col.setWidth(Integer.parseInt(columnWidths[i]));
                        }
                    }
                    catch (Throwable e) {
                        QuickSearchActivator.log(e);
                    }
                    ++i;
                }
            }
            if (settings.getArray(DIALOG_SASH_WEIGHTS) != null) {
                String[] _weights = settings.getArray(DIALOG_SASH_WEIGHTS);
                int[] weights = new int[_weights.length];
                int i = 0;
                while (i < weights.length) {
                    weights[i] = Integer.parseInt(_weights[i]);
                    ++i;
                }
                this.sashForm.setWeights(weights);
            }
        }
        catch (Throwable e) {
            QuickSearchActivator.log(e);
        }
    }

    private void inputNewSearchFilter(String searchIn) {
        this.filterHistory.remove(searchIn);
        this.filterHistory.addFirst(searchIn);
        if (this.filterHistory.size() > 5) {
            this.filterHistory.removeLast();
        }
    }

    public boolean close() {
        this.progressJob.cancel();
        this.progressJob = null;
        if (this.showViewHandler != null) {
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            service.deactivateHandler(this.showViewHandler);
            this.showViewHandler.getHandler().dispose();
            this.showViewHandler = null;
        }
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
        }
        this.storeDialog(this.getDialogSettings());
        if (this.searcher != null) {
            this.searcher.cancel();
        }
        return super.close();
    }

    protected void storeDialog(IDialogSettings settings) {
        Table table;
        String currentSearch = this.pattern.getText();
        settings.put(DIALOG_LAST_QUERY, currentSearch);
        this.inputNewSearchFilter(this.searchIn.getText());
        settings.put(FILTER_HISTORY, (String[])this.filterHistory.toArray(String[]::new));
        if (this.toggleCaseSensitiveAction != null) {
            settings.put(CASE_SENSITIVE, this.toggleCaseSensitiveAction.isChecked());
        }
        if (this.toggleKeepOpenAction != null) {
            settings.put(KEEP_OPEN, this.toggleKeepOpenAction.isChecked());
        }
        if ((table = this.list.getTable()).getColumnCount() > 0) {
            String[] columnWidths = new String[table.getColumnCount()];
            int i = 0;
            while (i < columnWidths.length) {
                columnWidths[i] = Integer.toString(table.getColumn(i).getWidth());
                ++i;
            }
            settings.put(DIALOG_COLUMNS, columnWidths);
        }
        if (this.sashForm.getWeights() != null) {
            int[] w = this.sashForm.getWeights();
            String[] ws = new String[w.length];
            int i = 0;
            while (i < ws.length) {
                ws[i] = Integer.toString(w[i]);
                ++i;
            }
            settings.put(DIALOG_SASH_WEIGHTS, ws);
        }
    }

    private Label createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        this.headerLabel = new Label(header, 0);
        this.headerLabel.addTraverseListener(e -> {
            if (e.detail == 128 && e.doit) {
                e.detail = 0;
                this.pattern.setFocus();
            }
        });
        GridData gd = new GridData(768);
        this.headerLabel.setLayoutData((Object)gd);
        this.createViewMenu(header);
        header.setLayoutData((Object)gd);
        this.refreshHeaderLabel();
        return this.headerLabel;
    }

    private void refreshHeaderLabel() {
        String msg = this.toggleCaseSensitiveAction.isChecked() ? Messages.QuickSearchDialog_caseSensitive_label : Messages.QuickSearchDialog_caseInsensitive_label;
        this.headerLabel.setText(msg);
    }

    private Label createLabels(Composite parent) {
        Composite labels = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labels.setLayout((Layout)layout);
        Label listLabel = new Label(labels, 0);
        listLabel.setText(EMPTY_STRING);
        listLabel.addTraverseListener(e -> {
            if (e.detail == 128 && e.doit) {
                e.detail = 0;
                this.list.getTable().setFocus();
            }
        });
        GridData gd = new GridData(768);
        listLabel.setLayoutData((Object)gd);
        this.progressLabel = new Label(labels, 131072);
        gd = new GridData(768);
        this.progressLabel.setLayoutData((Object)gd);
        this.createButton(labels, 8, Messages.QuickSearchDialog_Refresh, false);
        labels.setLayoutData((Object)gd);
        return listLabel;
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.toolBar.setLayoutData((Object)data);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                QuickSearchDialog.this.showViewMenu();
            }
        });
        this.toolItem.setImage(WorkbenchImages.getImage((String)"IMG_LCL_VIEW_MENU"));
        this.toolItem.setToolTipText(EMPTY_STRING);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickSearchDialog.this.showViewMenu();
            }
        });
        this.menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.menuManager);
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                QuickSearchDialog.this.showViewMenu();
                return null;
            }
        };
        this.showViewHandler = service.activateHandler("org.eclipse.ui.window.showViewMenu", (IHandler)handler, (Expression)new ActiveShellExpression(this.getShell()));
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        IDialogSettings settings = this.getDialogSettings();
        this.toggleCaseSensitiveAction = new ToggleCaseSensitiveAction(settings);
        menuManager.add((IAction)this.toggleCaseSensitiveAction);
        this.toggleKeepOpenAction = new ToggleKeepOpenAction(settings);
        menuManager.add((IAction)this.toggleKeepOpenAction);
    }

    private void showViewMenu() {
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
    }

    private void createPopupMenu() {
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(this::fillContextMenu);
        Table table = this.list.getTable();
        Menu menu = this.contextMenuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.addDisposeListener(e -> this.dispose());
        Composite content = this.createNestedComposite(dialogArea, 1, false);
        GridData gd = new GridData(1808);
        content.setLayoutData((Object)gd);
        final Label headerLabel = this.createHeader(content);
        Composite inputRow = this.createNestedComposite(content, 10, true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inputRow);
        this.pattern = new Text(inputRow, 2436);
        this.pattern.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LegacyActionTools.removeMnemonics((String)headerLabel.getText());
            }
        });
        GridDataFactory.fillDefaults().span(6, 1).grab(true, false).applyTo((Control)this.pattern);
        Composite searchInComposite = this.createNestedComposite(inputRow, 2, false);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)searchInComposite);
        Label searchInLabel = new Label(searchInComposite, 0);
        searchInLabel.setText(Messages.QuickSearchDialog_In);
        GridDataFactory.swtDefaults().indent(5, 0).applyTo((Control)searchInLabel);
        this.searchIn = new Combo(searchInComposite, 2308);
        this.searchIn.setToolTipText(Messages.QuickSearchDialog_InTooltip);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 0).applyTo((Control)this.searchIn);
        this.listLabel = this.createLabels(content);
        this.sashForm = new SashForm(content, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashForm);
        this.list = new TableViewer((Composite)this.sashForm, (this.multi ? 2 : 4) | 0x10000 | 0x800 | 0x200 | 0x10000000);
        this.list.getTable().setHeaderVisible(true);
        this.list.getTable().setLinesVisible(true);
        this.list.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = LegacyActionTools.removeMnemonics((String)QuickSearchDialog.this.listLabel.getText());
                }
            }
        });
        this.list.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerColumn col = new TableViewerColumn(this.list, 131072);
        col.setLabelProvider((CellLabelProvider)this.LINE_NUMBER_LABEL_PROVIDER);
        col.getColumn().setText(Messages.QuickSearchDialog_line);
        col.getColumn().setWidth(40);
        col = new TableViewerColumn(this.list, 16384);
        col.getColumn().setText(Messages.QuickSearchDialog_text);
        col.setLabelProvider((CellLabelProvider)this.LINE_TEXT_LABEL_PROVIDER);
        col.getColumn().setWidth(400);
        col = new TableViewerColumn(this.list, 16384);
        col.getColumn().setText(Messages.QuickSearchDialog_path);
        col.setLabelProvider((CellLabelProvider)this.LINE_FILE_LABEL_PROVIDER);
        col.getColumn().setWidth(150);
        new TableResizeHelper(this.list).enableResizing();
        this.list.setInput((Object)new Object[0]);
        this.list.setItemCount(this.contentProvider.getNumberOfElements());
        gd = new GridData(1808);
        QuickSearchDialog.applyDialogFont((Control)this.list.getTable());
        gd.heightHint = this.list.getTable().getItemHeight() * 15;
        this.list.getTable().setLayoutData((Object)gd);
        this.createPopupMenu();
        this.pattern.addModifyListener(e -> this.applyFilter(false));
        this.searchIn.addModifyListener(e -> this.applyPathMatcher());
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && QuickSearchDialog.this.list.getTable().getItemCount() > 0) {
                    QuickSearchDialog.this.list.getTable().setFocus();
                    QuickSearchDialog.this.list.getTable().select(0);
                    QuickSearchDialog.this.refreshDetails();
                }
            }
        });
        this.list.addSelectionChangedListener(event -> {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            this.handleSelected(selection);
        });
        this.list.addDoubleClickListener(event -> this.handleDoubleClick());
        this.list.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection selection;
                if (e.keyCode == 0x1000001 && (e.stateMask & 0x20000) == 0 && (e.stateMask & 0x40000) == 0 && (selection = (StructuredSelection)QuickSearchDialog.this.list.getSelection()).size() == 1) {
                    Object element = selection.getFirstElement();
                    if (element.equals(QuickSearchDialog.this.list.getElementAt(0))) {
                        QuickSearchDialog.this.pattern.setFocus();
                    }
                    QuickSearchDialog.this.list.getTable().notifyListeners(13, new Event());
                }
                if (e.keyCode == 0x1000002 && (e.stateMask & 0x20000) != 0 && (e.stateMask & 0x40000) != 0) {
                    QuickSearchDialog.this.list.getTable().notifyListeners(13, new Event());
                }
            }
        });
        this.createDetailsArea((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{5, 2});
        QuickSearchDialog.applyDialogFont((Control)content);
        this.restoreDialog(this.getDialogSettings());
        if (this.initialPatternText != null) {
            this.pattern.setText(this.initialPatternText);
        }
        switch (this.selectionMode) {
            case 1: {
                this.pattern.setSelection(0, 0);
                break;
            }
            case 2: {
                this.pattern.selectAll();
            }
        }
        this.applyFilter(false);
        return dialogArea;
    }

    private Composite createNestedComposite(Composite parent, int numRows, boolean equalRows) {
        Composite nested = new Composite(parent, 0);
        GridLayout layout = new GridLayout(numRows, equalRows);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.horizontalSpacing = 0;
        nested.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nested);
        return nested;
    }

    protected void dispose() {
        if (this.blankImage != null) {
            this.blankImage.dispose();
            this.blankImage = null;
        }
    }

    private void createDetailsArea(Composite parent) {
        this.details = new StyledText(parent, 2826);
        this.details.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.list.addSelectionChangedListener(event -> this.refreshDetails());
        this.details.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                QuickSearchDialog.this.refreshDetails();
            }
        });
    }

    private void refreshDetails() {
        if (this.details != null && this.list != null && !this.list.getTable().isDisposed()) {
            IStructuredSelection sel;
            if (this.documents == null) {
                this.documents = new DocumentFetcher();
            }
            if ((sel = (IStructuredSelection)this.list.getSelection()) == null || sel.isEmpty()) {
                this.details.setText(EMPTY_STRING);
            } else {
                LineItem item;
                IDocument document;
                int context = 100;
                int numLines = this.computeLines();
                if (numLines > 0 && (document = this.documents.getDocument((item = (LineItem)sel.getFirstElement()).getFile())) != null) {
                    try {
                        int line = item.getLineNumber() - 1;
                        int contextStartLine = Math.max(line - (numLines - 1) / 2 - 100, 0);
                        int start = document.getLineOffset(contextStartLine);
                        int end = document.getLength();
                        try {
                            IRegion lineInfo = document.getLineInformation(line + numLines / 2 + 100);
                            end = lineInfo.getOffset() + lineInfo.getLength();
                        }
                        catch (BadLocationException lineInfo) {
                            // empty catch block
                        }
                        StyledString styledString = this.highlightMatches(document.get(start, end - start));
                        this.details.setText(styledString.getString());
                        this.details.setStyleRanges(styledString.getStyleRanges());
                        this.details.setTopIndex(Math.max(line - contextStartLine - numLines / 2, 0));
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            this.details.setText(EMPTY_STRING);
        }
    }

    private int computeLines() {
        if (this.details != null && !this.details.isDisposed()) {
            int lineHeight = this.details.getLineHeight();
            int areaHeight = this.details.getClientArea().height;
            return (areaHeight + lineHeight - 1) / lineHeight;
        }
        return 0;
    }

    private StyledString highlightMatches(String visibleText) {
        StyledString styledText = new StyledString(visibleText);
        List<QuickTextQuery.TextRange> matches = this.getQuery().findAll(visibleText);
        for (QuickTextQuery.TextRange m : matches) {
            styledText.setStyle(m.getOffset(), m.getLength(), HIGHLIGHT_STYLE);
        }
        return styledText;
    }

    protected void handleSelected(StructuredSelection selection) {
        Status status = new Status(0, "org.eclipse.ui", 0, EMPTY_STRING, null);
        this.updateStatus((IStatus)status);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_BOUNDS_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_BOUNDS_SETTINGS);
            section.put(DIALOG_HEIGHT, 500);
            section.put(DIALOG_WIDTH, 600);
        }
        return section;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(IDEWorkbenchPlugin.class)).getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = dialogSettings.addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public void refreshWidgets() {
        if (this.list != null && !this.list.getTable().isDisposed()) {
            int itemCount = this.contentProvider.getNumberOfElements();
            this.list.setItemCount(itemCount);
            if (itemCount < this.MAX_RESULTS) {
                this.listLabel.setText(NLS.bind((String)Messages.QuickSearchDialog_listLabel, (Object)itemCount));
            } else {
                this.listLabel.setText(NLS.bind((String)Messages.QuickSearchDialog_listLabel_limit_reached, (Object)itemCount));
            }
            this.listLabel.pack();
            this.list.refresh(true, false);
            Button openButton = this.getButton(0);
            if (openButton != null && !openButton.isDisposed()) {
                openButton.setEnabled(itemCount > 0);
            }
            this.refreshDetails();
        }
    }

    public void scheduleRefresh() {
        this.refreshJob.schedule();
    }

    protected void computeResult() {
        Object first;
        List<Object> objectsToReturn = ((StructuredSelection)this.list.getSelection()).toList();
        if (objectsToReturn.isEmpty() && (first = this.list.getElementAt(0)) != null) {
            objectsToReturn = Arrays.asList(first);
        }
        this.setResult(objectsToReturn);
    }

    protected void handleDoubleClick() {
        this.okPressed();
    }

    protected void refreshButtonPressed() {
        this.applyFilter(true);
    }

    protected void okPressed() {
        this.computeResult();
        this.openSelection();
        if (!this.toggleKeepOpenAction.isChecked()) {
            this.setReturnCode(0);
            this.close();
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 8) {
            this.refreshButtonPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.QuickSearchDialog_Open, true);
        this.refreshWidgets();
    }

    public void setInitialPattern(String text) {
        this.setInitialPattern(text, 2);
    }

    public void setInitialPattern(String text, int selectionMode) {
        this.initialPatternText = text;
        this.selectionMode = selectionMode;
    }

    protected String getInitialPattern() {
        return this.initialPatternText;
    }

    protected StructuredSelection getSelectedItems() {
        StructuredSelection selection = (StructuredSelection)this.list.getSelection();
        List selectedItems = selection.toList();
        return new StructuredSelection(selectedItems);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected QuickTextQuery createFilter() {
        return new QuickTextQuery(this.pattern.getText(), !this.toggleCaseSensitiveAction.isChecked());
    }

    protected void applyFilter(boolean force) {
        QuickTextQuery newFilter = this.createFilter();
        this.getShell().setText(Messages.QuickSearchDialog_title + " - " + this.pattern.getText());
        if (this.searcher == null) {
            if (!newFilter.isTrivial()) {
                this.searcher = new QuickTextSearcher(newFilter, this.context.createPriorityFun(), this.MAX_LINE_LEN, new QuickTextSearchRequestor(){

                    @Override
                    public void add(LineItem match) {
                        QuickSearchDialog.this.contentProvider.add(match);
                        QuickSearchDialog.this.contentProvider.refresh();
                    }

                    @Override
                    public void clear() {
                        QuickSearchDialog.this.contentProvider.reset();
                        QuickSearchDialog.this.contentProvider.refresh();
                    }

                    @Override
                    public void revoke(LineItem match) {
                        QuickSearchDialog.this.contentProvider.remove(match);
                        QuickSearchDialog.this.contentProvider.refresh();
                    }

                    @Override
                    public void update(LineItem match) {
                        QuickSearchDialog.this.contentProvider.refresh();
                    }
                });
                this.searcher.setMaxResults(this.MAX_RESULTS);
                this.applyPathMatcher();
                this.refreshWidgets();
            }
        } else {
            this.searcher.setQuery(newFilter, force);
        }
        if (this.progressJob != null) {
            this.progressJob.schedule();
        }
    }

    private void applyPathMatcher() {
        if (this.searcher != null) {
            this.searcher.setPathMatcher(ResourceMatchers.commaSeparatedPaths(this.searchIn.getText()));
        }
    }

    public Control getPatternControl() {
        return this.pattern;
    }

    public QuickTextQuery getQuery() {
        return this.searcher.getQuery();
    }

    private class ContentProvider
    implements IStructuredContentProvider,
    ILazyContentProvider {
        private List items = Collections.synchronizedList(new ArrayList(2048));

        public void remove(LineItem match) {
            this.items.remove(match);
        }

        public void reset() {
            this.items.clear();
        }

        public void add(LineItem match) {
            this.items.add(match);
        }

        public void refresh() {
            QuickSearchDialog.this.scheduleRefresh();
        }

        public Object[] getElements(Object inputElement) {
            return this.items.toArray();
        }

        public int getNumberOfElements() {
            return this.items.size();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void updateElement(int index) {
            QuickSearchDialog.this.list.replace(this.items.size() > index ? this.items.get(index) : null, index);
        }
    }

    private class ToggleCaseSensitiveAction
    extends Action {
        public ToggleCaseSensitiveAction(IDialogSettings settings) {
            super(Messages.QuickSearchDialog_caseSensitive_toggle, 2);
            if (settings.get(QuickSearchDialog.CASE_SENSITIVE) == null) {
                this.setChecked(true);
            } else {
                this.setChecked(settings.getBoolean(QuickSearchDialog.CASE_SENSITIVE));
            }
        }

        public void run() {
            QuickSearchDialog.this.refreshHeaderLabel();
            QuickSearchDialog.this.applyFilter(false);
        }
    }

    private class ToggleKeepOpenAction
    extends Action {
        public ToggleKeepOpenAction(IDialogSettings settings) {
            super(Messages.QuickSearchDialog_keepOpen_toggle, 2);
            if (settings.get(QuickSearchDialog.KEEP_OPEN) == null) {
                this.setChecked(false);
            } else {
                this.setChecked(settings.getBoolean(QuickSearchDialog.KEEP_OPEN));
            }
        }

        public void run() {
        }
    }
}

