/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.uriresolver.internal;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;
import org.osgi.framework.Bundle;

public class URIResolverExtensionDescriptor {
    protected URIResolverExtension resolver;
    protected String fileType;
    protected String className;
    public List projectNatureIds;
    protected String resourceType;
    protected int stage = 2;
    protected String priority = "medium";
    protected String pluginId;
    protected boolean error;

    public URIResolverExtensionDescriptor(String className, String pluginId, List projectNatureIds, String resourceType, int stage, String priority) {
        this.className = className;
        this.pluginId = pluginId;
        this.projectNatureIds = projectNatureIds;
        this.resourceType = resourceType;
        this.stage = stage;
        this.priority = priority;
    }

    public URIResolverExtension getResolver() {
        if (this.resolver == null && this.className != null && !this.error) {
            try {
                Bundle bundle = Platform.getBundle((String)this.pluginId);
                Class theClass = bundle.loadClass(this.className);
                this.resolver = (URIResolverExtension)theClass.newInstance();
            }
            catch (Exception e) {
                this.error = true;
                e.printStackTrace();
            }
        }
        return this.resolver;
    }

    public boolean matches(String projectNatureId, String resourceType, int stage) {
        if (this.projectNatureIds.contains(projectNatureId)) {
            return this.matches(this.resourceType, resourceType) && this.stage == stage;
        }
        return false;
    }

    private boolean matches(String a, String b) {
        return a != null ? a.equals(b) : a == b;
    }
}

