/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class SecretKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int USAGE_NONE = 0;
    public static final int USAGE_CHECKSUM = 255;
    public static final int USAGE_SHA1 = 254;
    public static final int USAGE_AEAD = 253;
    private PublicKeyPacket pubKeyPacket;
    private byte[] secKeyData;
    private int s2kUsage;
    private int encAlgorithm;
    private int aeadAlgorithm;
    private S2K s2k;
    private byte[] iv;

    SecretKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(5, bCPGInputStream);
    }

    SecretKeyPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        this(5, bCPGInputStream, bl);
    }

    SecretKeyPacket(int n, BCPGInputStream bCPGInputStream) throws IOException {
        this(n, bCPGInputStream, false);
    }

    SecretKeyPacket(int n, BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(n, bl);
        int n2;
        this.pubKeyPacket = this instanceof SecretSubkeyPacket ? new PublicSubkeyPacket(bCPGInputStream, bl) : new PublicKeyPacket(bCPGInputStream, bl);
        int n3 = this.pubKeyPacket.getVersion();
        this.s2kUsage = bCPGInputStream.read();
        int n4 = -1;
        if (n3 == 5 || n3 == 6 && this.s2kUsage != 0) {
            n4 = bCPGInputStream.read();
        }
        this.encAlgorithm = this.s2kUsage == 255 || this.s2kUsage == 254 || this.s2kUsage == 253 ? bCPGInputStream.read() : this.s2kUsage;
        if (this.s2kUsage == 253) {
            this.aeadAlgorithm = bCPGInputStream.read();
        }
        if (n3 == 6 && (this.s2kUsage == 254 || this.s2kUsage == 253)) {
            n2 = bCPGInputStream.read();
            byte[] byArray = new byte[n2];
            bCPGInputStream.readFully(byArray);
            this.s2k = new S2K(new ByteArrayInputStream(byArray));
        } else if (this.s2kUsage == 255 || this.s2kUsage == 254 || this.s2kUsage == 253) {
            this.s2k = new S2K(bCPGInputStream);
        }
        if (this.s2kUsage == 253) {
            this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
            Streams.readFully((InputStream)bCPGInputStream, (byte[])this.iv);
        } else {
            int n5 = n2 = this.s2k != null && this.s2k.getType() == 101 && this.s2k.getProtectionMode() == 1 ? 1 : 0;
            if (n2 == 0 && this.s2kUsage != 0 && this.iv == null) {
                this.iv = this.encAlgorithm < 7 ? new byte[8] : new byte[16];
                bCPGInputStream.readFully(this.iv, 0, this.iv.length);
            }
        }
        if (n3 == 5) {
            long l = (long)bCPGInputStream.read() << 24 | (long)bCPGInputStream.read() << 16 | (long)bCPGInputStream.read() << 8 | (long)bCPGInputStream.read();
            if (this.s2kUsage == 255 || this.s2kUsage == 0) {
                l += 2L;
            }
            this.secKeyData = new byte[(int)l];
            bCPGInputStream.readFully(this.secKeyData);
        } else {
            this.secKeyData = bCPGInputStream.readAll();
        }
    }

    public SecretKeyPacket(PublicKeyPacket publicKeyPacket, int n, S2K s2K, byte[] byArray, byte[] byArray2) {
        this(5, publicKeyPacket, n, s2K, byArray, byArray2);
    }

    SecretKeyPacket(int n, PublicKeyPacket publicKeyPacket, int n2, S2K s2K, byte[] byArray, byte[] byArray2) {
        this(n, publicKeyPacket, n2, 0, n2 != 0 ? 255 : 0, s2K, byArray, byArray2);
    }

    public SecretKeyPacket(PublicKeyPacket publicKeyPacket, int n, int n2, S2K s2K, byte[] byArray, byte[] byArray2) {
        this(5, publicKeyPacket, n, 0, n2, s2K, byArray, byArray2);
    }

    public SecretKeyPacket(PublicKeyPacket publicKeyPacket, int n, int n2, int n3, S2K s2K, byte[] byArray, byte[] byArray2) {
        this(5, publicKeyPacket, n, n2, n3, s2K, byArray, byArray2);
    }

    SecretKeyPacket(int n, PublicKeyPacket publicKeyPacket, int n2, int n3, int n4, S2K s2K, byte[] byArray, byte[] byArray2) {
        super(n, publicKeyPacket.hasNewPacketFormat());
        this.pubKeyPacket = publicKeyPacket;
        this.encAlgorithm = n2;
        this.aeadAlgorithm = n3;
        this.s2kUsage = n4;
        this.s2k = s2K;
        this.iv = Arrays.clone((byte[])byArray);
        this.secKeyData = byArray2;
        if (s2K != null && s2K.getType() == 4 && n4 != 253) {
            throw new IllegalArgumentException("Argon2 is only used with AEAD (S2K usage octet 253)");
        }
        if (publicKeyPacket.getVersion() == 6 && n4 == 255) {
            throw new IllegalArgumentException("Version 6 keys MUST NOT use S2K usage USAGE_CHECKSUM");
        }
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getS2KUsage() {
        return this.s2kUsage;
    }

    public byte[] getIV() {
        return Arrays.clone((byte[])this.iv);
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.pubKeyPacket;
    }

    public byte[] getSecretKeyData() {
        return this.secKeyData;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream.write(this.pubKeyPacket.getEncodedContents());
        bCPGOutputStream.write(this.s2kUsage);
        byte[] byArray = this.encodeConditionalParameters();
        if (this.pubKeyPacket.getVersion() == 5 || this.pubKeyPacket.getVersion() == 6 && this.s2kUsage != 0) {
            bCPGOutputStream.write(byArray.length);
        }
        bCPGOutputStream.write(byArray);
        if (this.secKeyData != null && this.secKeyData.length > 0) {
            if (this.pubKeyPacket.getVersion() == 5) {
                int n = this.secKeyData.length;
                if (this.s2kUsage == 255 || this.s2kUsage == 0) {
                    n -= 2;
                }
                StreamUtil.write4OctetLength(bCPGOutputStream, n);
            }
            bCPGOutputStream.write(this.secKeyData);
        }
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] encodeConditionalParameters() throws IOException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl2 = bl = this.s2kUsage == 255 || this.s2kUsage == 254 || this.s2kUsage == 253;
        if (bl) {
            byteArrayOutputStream.write(this.encAlgorithm);
            if (this.s2kUsage == 253) {
                byteArrayOutputStream.write(this.aeadAlgorithm);
            }
            byte[] byArray = this.s2k.getEncoded();
            if (this.pubKeyPacket.getVersion() == 6) {
                byteArrayOutputStream.write(byArray.length);
            }
            byteArrayOutputStream.write(byArray);
        }
        if (this.iv != null) {
            byteArrayOutputStream.write(this.iv);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), this.getPacketTag(), this.getEncodedContents());
    }
}

