/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareContainer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ResizableDialog;
import org.eclipse.compare.internal.StructureCreatorDescriptor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@Deprecated
public class EditionSelectionDialog
extends ResizableDialog {
    private CompareConfiguration fCompareConfiguration;
    private final ArrayList<Object> fArrayList = new ArrayList();
    private boolean fTargetIsRight = false;
    private boolean fHideIdentical = true;
    private boolean fAddMode = false;
    private boolean fCompareMode = false;
    private boolean fStructureCompare = false;
    private boolean fMultiSelect = false;
    private HashMap<ITypedElement, List<Pair>> fMemberEditions;
    private HashMap<List<?>, ITypedElement> fMemberSelection;
    private List<?> fCurrentEditions;
    private Thread fThread;
    private Pair fTargetPair;
    private ITypedElement fSelectedItem;
    private String fTitleArg;
    private Image fTitleImage;
    private CompareViewerSwitchingPane fContentPane;
    private Button fCommitButton;
    private Table fMemberTable;
    private CompareViewerPane fMemberPane;
    private Tree fEditionTree;
    private CompareViewerPane fEditionPane;
    private Image fDateImage;
    private Image fTimeImage;
    private CompareViewerSwitchingPane fStructuredComparePane;
    private Label statusLabel;

    public EditionSelectionDialog(Shell parent, ResourceBundle bundle) {
        super(parent, bundle);
    }

    private CompareConfiguration getCompareConfiguration() {
        if (this.fCompareConfiguration == null) {
            this.fCompareConfiguration = new CompareConfiguration();
            this.fCompareConfiguration.setLeftEditable(false);
            this.fCompareConfiguration.setRightEditable(false);
            this.fCompareConfiguration.setContainer(new CompareContainer(){

                @Override
                public void setStatusMessage(String message) {
                    if (EditionSelectionDialog.this.statusLabel != null && !EditionSelectionDialog.this.statusLabel.isDisposed()) {
                        if (message == null) {
                            EditionSelectionDialog.this.statusLabel.setText("");
                        } else {
                            EditionSelectionDialog.this.statusLabel.setText(message);
                        }
                    }
                }
            });
        }
        return this.fCompareConfiguration;
    }

    @Override
    public void setHelpContextId(String contextId) {
        super.setHelpContextId(contextId);
    }

    public void setEditionTitleArgument(String titleArgument) {
        this.fTitleArg = titleArgument;
    }

    public void setEditionTitleImage(Image titleImage) {
        this.fTitleImage = titleImage;
    }

    public ITypedElement selectPreviousEdition(ITypedElement target, ITypedElement[] inputEditions, Object ppath) {
        Assert.isNotNull((Object)target);
        this.fTargetPair = new Pair(null, target);
        int count = inputEditions.length;
        IModificationDate[] editions = new IModificationDate[count];
        int i = 0;
        while (i < count) {
            editions[i] = (IModificationDate)((Object)inputEditions[i]);
            ++i;
        }
        if (count > 1) {
            EditionSelectionDialog.internalSort(editions);
        }
        IStructureCreator structureCreator = null;
        if (ppath != null) {
            String type = target.getType();
            StructureCreatorDescriptor scd = CompareUIPlugin.getDefault().getStructureCreator(type);
            if (scd != null) {
                structureCreator = scd.createStructureCreator();
            }
        }
        if (this.fAddMode) {
            return null;
        }
        if (structureCreator != null) {
            Pair pair = this.createPair(structureCreator, ppath, target);
            if (pair != null) {
                this.fTargetPair = pair;
            } else {
                ppath = null;
            }
        }
        int i2 = 0;
        while (i2 < count) {
            ITypedElement edition = (ITypedElement)((Object)editions[i2]);
            Pair pair = null;
            pair = structureCreator != null && ppath != null ? this.createPair(structureCreator, ppath, edition) : new Pair(null, edition);
            if (pair != null && pair.fHasError) {
                return null;
            }
            if (pair != null && !this.fTargetPair.equals(pair)) {
                return pair.fItem;
            }
            ++i2;
        }
        return null;
    }

    public ITypedElement selectEdition(ITypedElement target, ITypedElement[] inputEditions, Object ppath) {
        Assert.isNotNull((Object)target);
        this.fTargetPair = new Pair(null, target);
        final int count = inputEditions.length;
        final IModificationDate[] editions = new IModificationDate[count];
        int i = 0;
        while (i < count) {
            editions[i] = (IModificationDate)((Object)inputEditions[i]);
            ++i;
        }
        if (count > 1) {
            EditionSelectionDialog.internalSort(editions);
        }
        IStructureCreator structureCreator = null;
        if (ppath != null) {
            String type = target.getType();
            StructureCreatorDescriptor scd = CompareUIPlugin.getDefault().getStructureCreator(type);
            if (scd != null) {
                structureCreator = scd.createStructureCreator();
            }
        }
        if (!this.fAddMode) {
            if (structureCreator != null) {
                Pair pair = this.createPair(structureCreator, ppath, target);
                if (pair != null) {
                    this.fTargetPair = pair;
                } else {
                    ppath = null;
                }
            }
            String targetLabel = this.getTargetLabel(target, this.fTargetPair.getItem());
            if (this.fTargetIsRight) {
                this.getCompareConfiguration().setRightLabel(targetLabel);
            } else {
                this.getCompareConfiguration().setLeftLabel(targetLabel);
            }
            if (structureCreator != null && ppath != null) {
                final IStructureCreator sc = structureCreator;
                final Object path = ppath;
                this.fThread = new Thread(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < count) {
                            if (EditionSelectionDialog.this.fEditionTree == null || EditionSelectionDialog.this.fEditionTree.isDisposed()) break;
                            ITypedElement edition = (ITypedElement)((Object)editions[i]);
                            Pair pair = EditionSelectionDialog.this.createPair(sc, path, edition);
                            if (pair != null) {
                                EditionSelectionDialog.this.sendPair(pair);
                            }
                            ++i;
                        }
                        EditionSelectionDialog.this.sendPair(null);
                    }
                };
            } else {
                this.create();
                int i2 = 0;
                while (i2 < count) {
                    this.addMemberEdition(new Pair(null, (ITypedElement)((Object)editions[i2])));
                    ++i2;
                }
            }
        } else {
            Object[] children;
            final Object container = ppath;
            Assert.isNotNull((Object)container);
            if (structureCreator == null) {
                return null;
            }
            final HashSet current = new HashSet();
            IStructureComparator sco = structureCreator.locate(container, target);
            if (sco != null && (children = sco.getChildren()) != null) {
                Collections.addAll(current, children);
            }
            final IStructureCreator sc = structureCreator;
            this.fThread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < count) {
                        Object[] children;
                        if (EditionSelectionDialog.this.fEditionTree == null || EditionSelectionDialog.this.fEditionTree.isDisposed()) break;
                        ITypedElement edition = (ITypedElement)((Object)editions[i]);
                        IStructureComparator sco2 = sc.locate(container, edition);
                        if (sco2 != null && (children = sco2.getChildren()) != null) {
                            Object[] objectArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object c = objectArray[n2];
                                ITypedElement child = (ITypedElement)c;
                                if (!current.contains(child)) {
                                    EditionSelectionDialog.this.sendPair(new Pair(sc, edition, child));
                                }
                                ++n2;
                            }
                        }
                        ++i;
                    }
                    EditionSelectionDialog.this.sendPair(null);
                }
            };
        }
        this.open();
        if (this.getReturnCode() == 0) {
            return this.fSelectedItem;
        }
        return null;
    }

    private Pair createPair(IStructureCreator sc, Object path, ITypedElement input) {
        IStructureComparator scmp = sc.locate(path, input);
        if (scmp == null && sc.getStructure(input) == null) {
            Pair p = new Pair(sc, input);
            p.fHasError = true;
            return p;
        }
        if (scmp instanceof ITypedElement) {
            return new Pair(sc, input, (ITypedElement)((Object)scmp));
        }
        return null;
    }

    public void setHideIdenticalEntries(boolean hide) {
        this.fHideIdentical = hide;
    }

    public void setTargetIsRight(boolean isRight) {
        this.fTargetIsRight = isRight;
    }

    public void setAddMode(boolean addMode) {
        this.fAddMode = addMode;
        this.fMultiSelect = addMode;
    }

    public void setCompareMode(boolean compareMode) {
        this.fCompareMode = compareMode;
        this.fStructureCompare = this.fCompareMode && !this.fAddMode;
    }

    public ITypedElement getTarget() {
        return this.fTargetPair.getItem();
    }

    public ITypedElement[] getSelection() {
        ArrayList<ITypedElement> result = new ArrayList<ITypedElement>();
        if (this.fMemberSelection != null) {
            for (Object edition : this.fArrayList) {
                ITypedElement item = this.fMemberSelection.get(edition);
                if (item == null) continue;
                result.add(item);
            }
        } else if (this.fSelectedItem != null) {
            result.add(this.fSelectedItem);
        }
        return result.toArray(new ITypedElement[result.size()]);
    }

    protected String getTargetLabel(ITypedElement target, ITypedElement item) {
        String format = null;
        if (target instanceof ResourceNode) {
            format = Utilities.getString(this.fBundle, "workspaceTargetLabel", null);
        }
        if (format == null) {
            format = Utilities.getString(this.fBundle, "targetLabel");
        }
        if (format == null) {
            format = "x{0}";
        }
        return this.formatString(format, target.getName());
    }

    private String formatString(String string, String variable) {
        if (this.hasVariable(string) || this.hasDoubleQuotes(string)) {
            return MessageFormat.format(string, variable);
        }
        return string;
    }

    private boolean hasDoubleQuotes(String string) {
        return string.contains("''");
    }

    private boolean hasVariable(String string) {
        return string.contains("{0}");
    }

    protected String getEditionLabel(ITypedElement selectedEdition, ITypedElement item) {
        String format = null;
        if (selectedEdition instanceof ResourceNode) {
            format = Utilities.getString(this.fBundle, "workspaceEditionLabel", null);
        } else if (selectedEdition instanceof HistoryItem) {
            format = Utilities.getString(this.fBundle, "historyEditionLabel", null);
        }
        if (format == null) {
            format = Utilities.getString(this.fBundle, "editionLabel");
        }
        if (format == null) {
            format = "x{0}";
        }
        String date = "";
        if (selectedEdition instanceof IModificationDate) {
            long modDate = ((IModificationDate)((Object)selectedEdition)).getModificationDate();
            date = DateFormat.getDateTimeInstance().format(new Date(modDate));
        }
        return this.formatString(format, date);
    }

    protected String getShortEditionLabel(ITypedElement edition, ITypedElement item, Date date) {
        String format = null;
        if (edition instanceof ResourceNode) {
            format = Utilities.getString(this.fBundle, "workspaceTreeFormat", null);
        }
        if (format == null) {
            format = Utilities.getString(this.fBundle, "treeFormat", null);
        }
        if (format == null) {
            format = "x{0}";
        }
        String ds = DateFormat.getTimeInstance().format(date);
        return this.formatString(format, ds);
    }

    protected Image getEditionImage(ITypedElement selectedEdition, ITypedElement item) {
        if (selectedEdition instanceof ResourceNode) {
            return selectedEdition.getImage();
        }
        if (selectedEdition instanceof HistoryItem) {
            String iconName;
            ImageDescriptor id;
            if (this.fTimeImage == null && (id = CompareUIPlugin.getImageDescriptor(iconName = Utilities.getString(this.fBundle, "timeIcon", "obj16/resource_obj.svg"))) != null) {
                this.fTimeImage = id.createImage();
            }
            return this.fTimeImage;
        }
        return null;
    }

    protected synchronized Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        this.getShell().setText(Utilities.getString(this.fBundle, "title"));
        Splitter vsplitter = new Splitter(parent, 512);
        vsplitter.setLayoutData(new GridData(1808));
        vsplitter.addDisposeListener(e -> {
            if (this.fCompareConfiguration != null) {
                this.fCompareConfiguration.dispose();
                this.fCompareConfiguration = null;
            }
            if (this.fDateImage != null) {
                this.fDateImage.dispose();
                this.fDateImage = null;
            }
            if (this.fTimeImage != null) {
                this.fTimeImage.dispose();
                this.fTimeImage = null;
            }
        });
        if (this.fAddMode) {
            Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
            this.fMemberPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
            this.fMemberPane.setText(Utilities.getString(this.fBundle, "memberPaneTitle"));
            int flags = 768;
            if (this.fMultiSelect) {
                flags |= 0x20;
            }
            this.fMemberTable = new Table((Composite)this.fMemberPane, flags);
            this.fMemberTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 32 && e.item instanceof TableItem) {
                        TableItem ti = (TableItem)e.item;
                        Object data = ti.getData();
                        if (ti.getChecked()) {
                            EditionSelectionDialog.this.fArrayList.add(data);
                        } else {
                            EditionSelectionDialog.this.fArrayList.remove(data);
                        }
                        if (EditionSelectionDialog.this.fCommitButton != null) {
                            EditionSelectionDialog.this.fCommitButton.setEnabled(EditionSelectionDialog.this.fArrayList.size() > 0);
                        }
                        EditionSelectionDialog.this.fMemberTable.setSelection(new TableItem[]{ti});
                    }
                    EditionSelectionDialog.this.handleMemberSelect(e.item);
                }
            });
            this.fMemberPane.setContent((Control)this.fMemberTable);
            this.fMemberTable.setFocus();
            this.fEditionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
        } else {
            if (this.fStructureCompare) {
                Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
                this.fEditionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
                this.fStructuredComparePane = new CompareViewerSwitchingPane((Composite)hsplitter, 0x800800, true){

                    @Override
                    protected Viewer getViewer(Viewer oldViewer, Object input) {
                        if (input instanceof ICompareInput) {
                            return CompareUI.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this, EditionSelectionDialog.this.getCompareConfiguration());
                        }
                        return null;
                    }
                };
                this.fStructuredComparePane.addSelectionChangedListener(e -> this.feedInput2(e.getSelection()));
            } else {
                this.fEditionPane = new CompareViewerPane((Composite)vsplitter, 0x800800);
            }
            if (this.fTitleArg == null) {
                this.fTitleArg = this.fTargetPair.getItem().getName();
            }
            String titleFormat = Utilities.getString(this.fBundle, "treeTitleFormat");
            String title = MessageFormat.format(titleFormat, this.fTitleArg);
            this.fEditionPane.setText(title);
            if (this.fTitleImage != null) {
                this.fEditionPane.setImage(this.fTitleImage);
            }
        }
        this.fEditionTree = new Tree((Composite)this.fEditionPane, 768);
        this.fEditionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditionSelectionDialog.this.feedInput(e.item);
            }
        });
        this.fEditionPane.setContent((Control)this.fEditionTree);
        if (this.fThread != null) {
            this.fThread.start();
            this.fThread = null;
        }
        this.fContentPane = new CompareViewerSwitchingPane((Composite)vsplitter, 0x800800){

            @Override
            protected Viewer getViewer(Viewer oldViewer, Object input) {
                return CompareUI.findContentViewer(oldViewer, input, (Composite)this, EditionSelectionDialog.this.getCompareConfiguration());
            }
        };
        vsplitter.setWeights(new int[]{30, 70});
        this.statusLabel = new Label(parent, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        EditionSelectionDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String buttonLabel = Utilities.getString(this.fBundle, "buttonLabel", IDialogConstants.OK_LABEL);
        if (this.fCompareMode) {
            this.createButton(parent, 1, buttonLabel, false);
        } else {
            this.fCommitButton = this.createButton(parent, 0, buttonLabel, true);
            this.fCommitButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected void okPressed() {
        if (!this.fCompareMode) {
            super.okPressed();
        }
    }

    private void sendPair(Pair pair) {
        if (this.fEditionTree != null && !this.fEditionTree.isDisposed()) {
            Display display = this.fEditionTree.getDisplay();
            display.asyncExec(() -> this.addMemberEdition(pair));
        }
    }

    private static void internalSort(IModificationDate[] keys) {
        Arrays.sort(keys, (d1, d2) -> {
            long d = d2.getModificationDate() - d1.getModificationDate();
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        });
    }

    private void addMemberEdition(Pair pair) {
        ITypedElement item;
        List<Pair> editions;
        if (pair == null) {
            if (this.fMemberTable != null) {
                if (!this.fMemberTable.isDisposed() && this.fMemberTable.getItemCount() == 0) {
                    if (this.fMultiSelect) {
                        this.fMemberTable.dispose();
                        this.fMemberTable = new Table((Composite)this.fMemberPane, 0);
                        this.fMemberPane.setContent((Control)this.fMemberTable);
                    }
                    TableItem ti = new TableItem(this.fMemberTable, 0);
                    ti.setText(Utilities.getString(this.fBundle, "noAdditionalMembersMessage"));
                }
                return;
            }
            if (this.fEditionTree != null && !this.fEditionTree.isDisposed() && this.fEditionTree.getItemCount() == 0) {
                TreeItem ti = new TreeItem(this.fEditionTree, 0);
                ti.setText(Utilities.getString(this.fBundle, "notFoundInLocalHistoryMessage"));
            }
            return;
        }
        if (this.fMemberEditions == null) {
            this.fMemberEditions = new HashMap();
        }
        if (this.fMultiSelect && this.fMemberSelection == null) {
            this.fMemberSelection = new HashMap();
        }
        if ((editions = this.fMemberEditions.get(item = pair.getItem())) == null) {
            editions = new ArrayList<Pair>();
            this.fMemberEditions.put(item, editions);
            if (this.fMemberTable != null && !this.fMemberTable.isDisposed()) {
                ITypedElement te = item;
                String name = te.getName();
                TableItem[] items = this.fMemberTable.getItems();
                int where = items.length;
                int i = 0;
                while (i < where) {
                    String n = items[i].getText();
                    if (n.compareTo(name) > 0) {
                        where = i;
                        break;
                    }
                    ++i;
                }
                TableItem ti = new TableItem(this.fMemberTable, where, 0);
                ti.setImage(te.getImage());
                ti.setText(name);
                ti.setData(editions);
            }
        }
        if (this.fHideIdentical) {
            Pair last = this.fTargetPair;
            int size = editions.size();
            if (size > 0) {
                last = editions.get(size - 1);
            }
            if (last != null && last.equals(pair)) {
                return;
            }
        }
        editions.add(pair);
        if (!this.fAddMode || editions == this.fCurrentEditions) {
            this.addEdition(pair);
        }
    }

    private long dayNumber(long date) {
        int ONE_DAY_MS = 86400000;
        Calendar calendar = Calendar.getInstance();
        long localTimeOffset = calendar.get(15) + calendar.get(16);
        return (date + localTimeOffset) / (long)ONE_DAY_MS;
    }

    private void addEdition(Pair pair) {
        ITypedElement selected;
        Object selection;
        if (this.fEditionTree == null || this.fEditionTree.isDisposed()) {
            return;
        }
        TreeItem[] days = this.fEditionTree.getItems();
        TreeItem lastDay = null;
        if (days.length > 0) {
            lastDay = days[days.length - 1];
        }
        boolean first = lastDay == null;
        ITypedElement edition = pair.getEdition();
        ITypedElement item = pair.getItem();
        long ldate = ((IModificationDate)((Object)edition)).getModificationDate();
        long day = this.dayNumber(ldate);
        Date date = new Date(ldate);
        if (lastDay == null || day != this.dayNumber(((Date)lastDay.getData()).getTime())) {
            String iconName;
            ImageDescriptor id;
            lastDay = new TreeItem(this.fEditionTree, 0);
            if (this.fDateImage == null && (id = CompareUIPlugin.getImageDescriptor(iconName = Utilities.getString(this.fBundle, "dateIcon", "obj16/day_obj.svg"))) != null) {
                this.fDateImage = id.createImage();
            }
            lastDay.setImage(this.fDateImage);
            String df = DateFormat.getDateInstance().format(date);
            long today = this.dayNumber(System.currentTimeMillis());
            String formatKey = day == today ? "todayFormat" : (day == today - 1L ? "yesterdayFormat" : "dayFormat");
            String pattern = Utilities.getString(this.fBundle, formatKey);
            if (pattern != null) {
                df = MessageFormat.format(pattern, df);
            }
            lastDay.setText(df);
            lastDay.setData((Object)date);
        }
        TreeItem ti = new TreeItem(lastDay, 0);
        ti.setImage(this.getEditionImage(edition, item));
        String s = this.getShortEditionLabel(edition, item, date);
        if (pair.fHasError) {
            String pattern = Utilities.getString(this.fBundle, "parseErrorFormat");
            s = MessageFormat.format(pattern, s);
        }
        ti.setText(s);
        ti.setData((Object)pair);
        Object object = selection = first ? ti : null;
        if (this.fMemberSelection != null && (selected = this.fMemberSelection.get(this.fCurrentEditions)) != null) {
            selection = selected == pair.getItem() ? ti : null;
        }
        if (selection != null) {
            this.fEditionTree.setSelection(new TreeItem[]{selection});
            if (!this.fAddMode) {
                this.fEditionTree.setFocus();
            }
            this.feedInput((Widget)selection);
        }
        if (first) {
            lastDay.setExpanded(true);
        }
    }

    private void handleMemberSelect(Widget w) {
        List editions;
        Object data = w.getData();
        if (data instanceof List && (editions = (List)data) != this.fCurrentEditions) {
            this.fCurrentEditions = editions;
            this.fEditionTree.removeAll();
            String pattern = Utilities.getString(this.fBundle, "treeTitleFormat");
            String title = MessageFormat.format(pattern, ((Item)w).getText());
            this.fEditionPane.setText(title);
            for (Object item : editions) {
                if (!(item instanceof Pair)) continue;
                this.addEdition((Pair)item);
            }
        }
    }

    private void setInput(Object input) {
        this.fContentPane.setInput(input);
        if (this.fStructuredComparePane != null) {
            this.fStructuredComparePane.setInput(input);
        }
    }

    private void feedInput(Widget w) {
        Object input = w.getData();
        boolean isOK = false;
        if (input instanceof Pair) {
            Pair pair = (Pair)input;
            this.fSelectedItem = pair.getItem();
            isOK = !pair.fHasError;
            ITypedElement edition = pair.getEdition();
            String editionLabel = this.getEditionLabel(edition, this.fSelectedItem);
            Image editionImage = this.getEditionImage(edition, this.fSelectedItem);
            if (this.fAddMode) {
                if (this.fMemberSelection != null) {
                    this.fMemberSelection.put(this.fCurrentEditions, this.fSelectedItem);
                }
                this.setInput(this.fSelectedItem);
                this.fContentPane.setText(editionLabel);
                this.fContentPane.setImage(editionImage);
            } else {
                this.getCompareConfiguration();
                if (this.fTargetIsRight) {
                    this.fCompareConfiguration.setLeftLabel(editionLabel);
                    this.fCompareConfiguration.setLeftImage(editionImage);
                    this.setInput(new DiffNode(this.fSelectedItem, this.fTargetPair.getItem()));
                } else {
                    this.fCompareConfiguration.setRightLabel(editionLabel);
                    this.fCompareConfiguration.setRightImage(editionImage);
                    this.setInput(new DiffNode(this.fTargetPair.getItem(), this.fSelectedItem));
                }
            }
        } else {
            this.fSelectedItem = null;
            this.setInput(null);
        }
        if (this.fCommitButton != null) {
            if (this.fMultiSelect) {
                this.fCommitButton.setEnabled(isOK && this.fSelectedItem != null && this.fArrayList.size() > 0);
            } else {
                this.fCommitButton.setEnabled(isOK && this.fSelectedItem != null && this.fTargetPair.getItem() != this.fSelectedItem);
            }
        }
    }

    private void feedInput2(ISelection sel) {
        IStructuredSelection ss;
        if (sel instanceof IStructuredSelection && (ss = (IStructuredSelection)sel).size() == 1) {
            this.fContentPane.setInput(ss.getFirstElement());
        }
    }

    private static class Pair {
        private final ITypedElement fEdition;
        private final ITypedElement fItem;
        private String fContent;
        private final IStructureCreator fStructureCreator;
        private boolean fHasError = false;

        Pair(IStructureCreator structureCreator, ITypedElement edition, ITypedElement item) {
            this.fStructureCreator = structureCreator;
            this.fEdition = edition;
            this.fItem = item;
        }

        Pair(IStructureCreator structureCreator, ITypedElement edition) {
            this(structureCreator, edition, edition);
        }

        ITypedElement getEdition() {
            return this.fEdition;
        }

        ITypedElement getItem() {
            return this.fItem;
        }

        private String getContent() {
            if (this.fContent == null) {
                if (this.fStructureCreator != null) {
                    this.fContent = this.fStructureCreator.getContents(this.fItem, false);
                } else {
                    ITypedElement iTypedElement = this.fItem;
                    if (iTypedElement instanceof IStreamContentAccessor) {
                        IStreamContentAccessor sca = (IStreamContentAccessor)((Object)iTypedElement);
                        try {
                            this.fContent = Utilities.readString(sca);
                        }
                        catch (CoreException ex) {
                            CompareUIPlugin.log(ex);
                        }
                    }
                }
                if (this.fContent == null) {
                    this.fContent = "";
                }
            }
            return this.fContent;
        }

        public boolean equals(Object other) {
            if (other != null && other.getClass() == this.getClass() && this.getContent().equals(((Pair)other).getContent())) {
                return true;
            }
            return super.equals(other);
        }

        public int hashCode() {
            return this.getContent().hashCode();
        }
    }
}

