/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.nested;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.eclipse.jetty.ee8.nested.BufferedResponseHandler;
import org.eclipse.jetty.ee8.nested.HttpChannel;
import org.eclipse.jetty.ee8.nested.HttpOutput;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBufferedResponseHandler
extends BufferedResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FileBufferedResponseHandler.class);
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private int _bufferSize = 65536;
    private Path _tempDir = new File(System.getProperty("java.io.tmpdir")).toPath();

    public Path getTempDir() {
        return this._tempDir;
    }

    public void setTempDir(Path tempDir) {
        this._tempDir = Objects.requireNonNull(tempDir);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    @Override
    protected BufferedResponseHandler.BufferedInterceptor newBufferedInterceptor(HttpChannel httpChannel, HttpOutput.Interceptor interceptor) {
        return new FileBufferedInterceptor(httpChannel, interceptor);
    }

    class FileBufferedInterceptor
    implements BufferedResponseHandler.BufferedInterceptor {
        private final HttpOutput.Interceptor _next;
        private final HttpChannel _channel;
        private Boolean _aggregating;
        private Path _filePath;
        private OutputStream _fileOutputStream;

        public FileBufferedInterceptor(HttpChannel httpChannel, HttpOutput.Interceptor interceptor) {
            this._next = interceptor;
            this._channel = httpChannel;
        }

        @Override
        public HttpOutput.Interceptor getNextInterceptor() {
            return this._next;
        }

        @Override
        public void resetBuffer() {
            this.dispose();
            BufferedResponseHandler.BufferedInterceptor.super.resetBuffer();
        }

        protected void dispose() {
            IO.close((OutputStream)this._fileOutputStream);
            this._fileOutputStream = null;
            this._aggregating = null;
            if (this._filePath != null) {
                try {
                    Files.delete(this._filePath);
                }
                catch (Throwable t) {
                    if (LOG.isDebugEnabled()) {
                        LOG.atDebug().setCause(t).log("Could not immediately delete file (delaying to jvm exit) {}", (Object)this._filePath);
                    }
                    this._filePath.toFile().deleteOnExit();
                }
                this._filePath = null;
            }
        }

        @Override
        public void write(ByteBuffer content, boolean last, Callback callback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} write last={} {}", new Object[]{this, last, BufferUtil.toDetailString((ByteBuffer)content)});
            }
            if (this._aggregating == null) {
                this._aggregating = FileBufferedResponseHandler.this.shouldBuffer(this._channel, last);
            }
            if (!this._aggregating.booleanValue()) {
                this.getNextInterceptor().write(content, last, callback);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} aggregating", (Object)this);
            }
            try {
                if (BufferUtil.hasContent((ByteBuffer)content)) {
                    this.aggregate(content);
                }
            }
            catch (Throwable t) {
                this.dispose();
                callback.failed(t);
                return;
            }
            if (last) {
                this.commit(callback);
            } else {
                callback.succeeded();
            }
        }

        private void aggregate(ByteBuffer content) throws IOException {
            if (this._fileOutputStream == null) {
                this._filePath = Files.createTempFile(FileBufferedResponseHandler.this._tempDir, "BufferedResponse", "", new FileAttribute[0]);
                this._fileOutputStream = Files.newOutputStream(this._filePath, StandardOpenOption.WRITE);
            }
            BufferUtil.writeTo((ByteBuffer)content, (OutputStream)this._fileOutputStream);
        }

        private void commit(Callback callback) {
            if (this._fileOutputStream == null) {
                this.getNextInterceptor().write(BufferUtil.EMPTY_BUFFER, true, callback);
                return;
            }
            try {
                this._fileOutputStream.close();
                this._fileOutputStream = null;
            }
            catch (Throwable t) {
                this.dispose();
                callback.failed(t);
                return;
            }
            ByteBufferPool.Sized sizedPool = new ByteBufferPool.Sized(FileBufferedResponseHandler.this.getServer().getByteBufferPool(), true, FileBufferedResponseHandler.this.getBufferSize());
            Content.Source source = Content.Source.from((ByteBufferPool.Sized)sizedPool, (Path)this._filePath);
            Content.Sink sink = (last, bytebuffer, cb) -> this.getNextInterceptor().write(last, bytebuffer, cb);
            Callback disposer = Callback.from((Callback)callback, this::dispose);
            Content.copy((Content.Source)source, (Content.Sink)sink, (Callback)disposer);
        }
    }
}

