/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.authenticator;

import java.security.Principal;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterValve;
import org.apache.catalina.ha.authenticator.ClusterSingleSignOnListener;
import org.apache.catalina.ha.authenticator.SingleSignOnMessage;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.tomcat.util.ExceptionUtils;

public class ClusterSingleSignOn
extends SingleSignOn
implements ClusterValve {
    protected static final String info = "org.apache.catalina.ha.authenticator.ClusterSingleSignOn";
    protected int messageNumber = 0;
    private ClusterSingleSignOnListener clusterSSOListener = null;
    private CatalinaCluster cluster = null;

    public String getInfo() {
        return info;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    protected synchronized void startInternal() throws LifecycleException {
        this.clusterSSOListener = new ClusterSingleSignOnListener();
        this.clusterSSOListener.setClusterSSO(this);
        try {
            Container host;
            if (this.cluster == null && (host = this.getContainer()) instanceof Host && host.getCluster() instanceof CatalinaCluster) {
                this.setCluster((CatalinaCluster)host.getCluster());
            }
            if (this.cluster == null) {
                throw new LifecycleException("There is no Cluster for ClusterSingleSignOn");
            }
            this.getCluster().addClusterListener(this.clusterSSOListener);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            throw new LifecycleException("ClusterSingleSignOn exception during clusterLoad " + t);
        }
        super.startInternal();
    }

    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.getCluster() != null) {
            this.getCluster().removeClusterListener(this.clusterSSOListener);
        }
    }

    protected void associate(String ssoId, Session session) {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(1);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.associateLocal(ssoId, session);
    }

    protected void associateLocal(String ssoId, Session session) {
        super.associate(ssoId, session);
    }

    protected void deregister(String ssoId, Session session) {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(2);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.deregisterLocal(ssoId, session);
    }

    protected void deregisterLocal(String ssoId, Session session) {
        super.deregister(ssoId, session);
    }

    protected void deregister(String ssoId) {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(3);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.deregisterLocal(ssoId);
    }

    protected void deregisterLocal(String ssoId) {
        super.deregister(ssoId);
    }

    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(4);
            msg.setAuthType(authType);
            msg.setUsername(username);
            msg.setPassword(password);
            SerializablePrincipal sp = null;
            if (principal instanceof GenericPrincipal) {
                sp = SerializablePrincipal.createPrincipal((GenericPrincipal)principal);
                msg.setPrincipal(sp);
            }
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.registerLocal(ssoId, principal, authType, username, password);
    }

    protected void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.register(ssoId, principal, authType, username, password);
    }

    protected void update(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAction(5);
            msg.setAuthType(authType);
            msg.setUsername(username);
            msg.setPassword(password);
            SerializablePrincipal sp = null;
            if (principal instanceof GenericPrincipal) {
                sp = SerializablePrincipal.createPrincipal((GenericPrincipal)principal);
                msg.setPrincipal(sp);
            }
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.updateLocal(ssoId, principal, authType, username, password);
    }

    protected void updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.update(ssoId, principal, authType, username, password);
    }

    protected void removeSession(String ssoId, Session session) {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, session.getId());
            Manager mgr = session.getManager();
            if (mgr != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            msg.setAction(6);
            this.cluster.send(msg);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + msg.getAction()));
            }
        }
        this.removeSessionLocal(ssoId, session);
    }

    protected void removeSessionLocal(String ssoId, Session session) {
        super.removeSession(ssoId, session);
    }
}

