/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.gemini.web.internal.url.Path;
import org.eclipse.gemini.web.internal.url.WebBundleScannerCallback;
import org.eclipse.virgo.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebBundleScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebBundleScanner.class);
    private static final String LIB_DIR_SUFFIX = String.valueOf(File.separator) + "WEB-INF" + File.separator + "lib";
    private static final String CLASSES_DIR_SUFFIX = String.valueOf(File.separator) + "WEB-INF" + File.separator + "classes";
    private static final String FILE_SCHEME = "file";
    private static final String JAR_SUFFIX = ".jar";
    private static final String CLASS_SUFFIX = ".class";
    private static final String LIB_ENTRY_PREFIX = "WEB-INF/lib/";
    private static final String CLASSES_ENTRY_PREFIX = "WEB-INF/classes/";
    private static final String CLASS_PATH_ATTRIBUTE_NAME = "Class-Path";
    private static final String CLASS_PATH_SEPARATOR = " ";
    private final Object monitor = new Object();
    private final URL source;
    private final WebBundleScannerCallback callBack;
    private final boolean findClassesInNestedJars;
    private final Set<String> scannedJars = new HashSet<String>();

    WebBundleScanner(URL source, WebBundleScannerCallback callBack) {
        this(source, callBack, false);
    }

    WebBundleScanner(URL source, WebBundleScannerCallback callBack, boolean findClassesInNestedJars) {
        this.source = source;
        this.callBack = callBack;
        this.findClassesInNestedJars = findClassesInNestedJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scanWar() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.scannedJars.clear();
            if (this.isDirectory()) {
                this.scanWarDirectory();
            } else {
                this.scanWarFile();
            }
        }
    }

    private void scanWarDirectory() throws IOException {
        try {
            File classesDir;
            File bundleDir = this.sourceAsFile();
            File libDir = new File(bundleDir, LIB_DIR_SUFFIX);
            if (libDir.isDirectory()) {
                this.doScanLibDirectory(libDir);
            }
            if ((classesDir = new File(bundleDir, CLASSES_DIR_SUFFIX)).isDirectory()) {
                this.doScanClassesDirectory(classesDir);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unexpected URISyntaxException.", e);
        }
    }

    private void doScanLibDirectory(File libDir) throws IOException {
        File[] files = libDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String pathToJar;
                File file = fileArray[n2];
                if (file.isFile() && file.getName().endsWith(JAR_SUFFIX) && this.driveCallBackIfNewJarFound(pathToJar = LIB_ENTRY_PREFIX + file.getName())) {
                    this.doScanNestedJar(file);
                }
                ++n2;
            }
        }
    }

    private boolean driveCallBackIfNewJarFound(String pathToJar) {
        if (this.scannedJars.contains(pathToJar)) {
            return false;
        }
        this.scannedJars.add(pathToJar);
        this.callBack.jarFound(pathToJar);
        return true;
    }

    private void doScanNestedJar(File file) throws IOException {
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(new FileInputStream(file));
            this.doScanNestedJar(file.getAbsolutePath(), jis);
        }
        catch (Throwable throwable) {
            if (jis != null) {
                IOUtils.closeQuietly(jis);
            }
            throw throwable;
        }
        if (jis != null) {
            IOUtils.closeQuietly((Closeable)jis);
        }
    }

    private void doScanClassesDirectory(File classesDir) {
        File[] files = classesDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.doScanClassesDirectory(file);
                } else if (file.isFile() && file.getName().endsWith(CLASS_SUFFIX)) {
                    String path = WebBundleScanner.normalizePath(file.getPath());
                    this.callBack.classFound(path.substring(path.lastIndexOf(CLASSES_ENTRY_PREFIX) + CLASSES_ENTRY_PREFIX.length()));
                }
                ++n2;
            }
        }
    }

    private void scanWarFile() throws IOException {
        JarInputStream jis = new JarInputStream(this.source.openStream());
        try {
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.startsWith(LIB_ENTRY_PREFIX) && entryName.endsWith(JAR_SUFFIX)) {
                    if (!this.driveCallBackIfNewJarFound(entryName)) continue;
                    JarInputStream nestedJis = new JarInputStream(jis);
                    this.doScanNestedJar(entryName, nestedJis);
                    continue;
                }
                if (!entryName.startsWith(CLASSES_ENTRY_PREFIX) || !entryName.endsWith(CLASS_SUFFIX)) continue;
                this.callBack.classFound(entry.getName().substring(CLASSES_ENTRY_PREFIX.length()));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)jis);
        }
    }

    private void doScanNestedJar(String jarEntryName, JarInputStream jis) throws IOException {
        JarEntry entry;
        String classPath;
        Attributes mainAttributes;
        Manifest manifest = jis.getManifest();
        if (manifest != null && (mainAttributes = manifest.getMainAttributes()) != null && (classPath = mainAttributes.getValue(CLASS_PATH_ATTRIBUTE_NAME)) != null) {
            String[] classPathItems;
            Path jarPathx = WebBundleScanner.getNormalisedDirectoryPath(jarEntryName);
            String[] stringArray = classPathItems = classPath.split(CLASS_PATH_SEPARATOR);
            int n = classPathItems.length;
            int n2 = 0;
            while (n2 < n) {
                String classPathItem = stringArray[n2];
                try {
                    Path entryPath = jarPathx.applyRelativePath(new Path(classPathItem));
                    this.scanNestedJarInWar(entryPath.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n2;
            }
        }
        while ((entry = jis.getNextJarEntry()) != null) {
            String entryName = entry.getName();
            if (!entryName.endsWith(CLASS_SUFFIX)) continue;
            this.notifyClassFound(entryName);
        }
    }

    private static Path getNormalisedDirectoryPath(String jarEntryName) {
        String jarPath = WebBundleScanner.normalizePath(jarEntryName);
        int lastDirectoryIndex = jarPath.lastIndexOf("/");
        return lastDirectoryIndex == -1 ? new Path() : new Path(jarPath.substring(0, lastDirectoryIndex));
    }

    private void scanNestedJarInWar(String jarPath) throws IOException {
        if (this.isDirectory()) {
            this.scanNestedJarInWarDirectory(jarPath);
        } else {
            this.scanNestedJarInWarFile(jarPath);
        }
    }

    private void scanNestedJarInWarDirectory(String jarPath) throws IOException {
        try {
            String pathToJar;
            File bundleDir = this.sourceAsFile();
            File nestedJar = new File(bundleDir, "/" + jarPath);
            if (nestedJar.isFile() && this.driveCallBackIfNewJarFound(pathToJar = "/" + nestedJar.getName())) {
                this.doScanNestedJar(nestedJar);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unexpected URISyntaxException.", e);
        }
    }

    private void scanNestedJarInWarFile(String jarPath) throws IOException {
        JarInputStream jis = new JarInputStream(this.source.openStream());
        try {
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (!jarPath.endsWith(entryName) || !this.driveCallBackIfNewJarFound(entryName)) continue;
                JarInputStream nestedJis = new JarInputStream(jis);
                this.doScanNestedJar(entryName, nestedJis);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)jis);
        }
    }

    private void notifyClassFound(String entryName) {
        if (this.findClassesInNestedJars) {
            this.callBack.classFound(entryName);
        }
    }

    private boolean isDirectory() {
        if (FILE_SCHEME.equals(this.source.getProtocol())) {
            try {
                return this.sourceAsFile().isDirectory();
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Unable to determine if bundle '" + this.source + "'is a directory.", (Throwable)e);
            }
        }
        return false;
    }

    private File sourceAsFile() throws URISyntaxException {
        URI uri = this.source.toURI();
        if (uri.isOpaque()) {
            return new File(uri.getSchemeSpecificPart());
        }
        return new File(uri);
    }

    private static String normalizePath(String path) {
        return path.replace('\\', '/');
    }
}

