/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.config;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jk.config.GeneratorApache2;
import org.apache.jk.config.GeneratorJk1;
import org.apache.jk.config.GeneratorJk2;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebXml2Jk {
    String vhost = "";
    String cpath = "";
    String docBase;
    String file;
    String worker = "lb";
    Node webN;
    File jkDir;
    private static Log log = LogFactory.getLog(WebXml2Jk.class);

    public void setHost(String vhost) {
        this.vhost = vhost;
    }

    public void setContext(String contextPath) {
        this.cpath = contextPath;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public void setGroup(String route) {
        this.worker = route;
    }

    public Node getWebXmlNode() {
        return this.webN;
    }

    public File getJkDir() {
        return this.jkDir;
    }

    public Vector getWellcomeFiles() {
        Node n0 = WebXml2Jk.getChild(this.webN, "welcome-file-list");
        Vector<String> wF = new Vector<String>();
        if (n0 != null) {
            Node mapN = WebXml2Jk.getChild(this.webN, "welcome-file");
            while (mapN != null) {
                wF.addElement(WebXml2Jk.getContent(mapN));
                mapN = WebXml2Jk.getNext(mapN);
            }
        }
        return wF;
    }

    void generate(MappingGenerator gen) throws IOException {
        String url;
        gen.generateStart();
        log.info((Object)"Generating mappings for servlets ");
        Node mapN = WebXml2Jk.getChild(this.webN, "servlet-mapping");
        while (mapN != null) {
            String serv = WebXml2Jk.getChildContent(mapN, "servlet-name");
            url = WebXml2Jk.getChildContent(mapN, "url-pattern");
            gen.generateServletMapping(serv, url);
            mapN = WebXml2Jk.getNext(mapN);
        }
        log.info((Object)"Generating mappings for filters ");
        mapN = WebXml2Jk.getChild(this.webN, "filter-mapping");
        while (mapN != null) {
            String filter = WebXml2Jk.getChildContent(mapN, "filter-name");
            url = WebXml2Jk.getChildContent(mapN, "url-pattern");
            gen.generateFilterMapping(filter, url);
            mapN = WebXml2Jk.getNext(mapN);
        }
        mapN = WebXml2Jk.getChild(this.webN, "error-page");
        while (mapN != null) {
            String errorCode = WebXml2Jk.getChildContent(mapN, "error-code");
            String location = WebXml2Jk.getChildContent(mapN, "location");
            if (errorCode != null && !"".equals(errorCode)) {
                try {
                    int err = new Integer(errorCode);
                    gen.generateErrorPage(err, location);
                }
                catch (Exception ex) {
                    log.error((Object)("Format error " + location), (Throwable)ex);
                }
            }
            mapN = WebXml2Jk.getNext(mapN);
        }
        Node lcN = WebXml2Jk.getChild(this.webN, "login-config");
        if (lcN != null) {
            log.info((Object)"Generating mapping for login-config ");
            String authMeth = WebXml2Jk.getContent(WebXml2Jk.getChild(lcN, "auth-method"));
            if (authMeth == null) {
                authMeth = "BASIC";
            }
            Node n1 = WebXml2Jk.getChild(lcN, "form-login-config");
            String loginPage = WebXml2Jk.getChildContent(n1, "form-login-page");
            String errPage = WebXml2Jk.getChildContent(n1, "form-error-page");
            if (loginPage != null) {
                int lpos = loginPage.lastIndexOf("/");
                String jscurl = loginPage.substring(0, lpos + 1) + "j_security_check";
                gen.generateLoginConfig(jscurl, errPage, authMeth);
            }
        }
        log.info((Object)"Generating mappings for security constraints ");
        Node mapN2 = WebXml2Jk.getChild(this.webN, "security-constraint");
        while (mapN2 != null) {
            Vector<String> methods = new Vector<String>();
            Vector<String> urls = new Vector<String>();
            Vector<String> roles = new Vector<String>();
            boolean isSSL = false;
            Node wrcN = WebXml2Jk.getChild(mapN2, "web-resource-collection");
            Node uN = WebXml2Jk.getChild(wrcN, "http-method");
            while (uN != null) {
                methods.addElement(WebXml2Jk.getContent(uN));
                uN = WebXml2Jk.getNext(uN);
            }
            uN = WebXml2Jk.getChild(wrcN, "url-pattern");
            while (uN != null) {
                urls.addElement(WebXml2Jk.getContent(uN));
                uN = WebXml2Jk.getNext(uN);
            }
            Node acN = WebXml2Jk.getChild(mapN2, "auth-constraint");
            Node rN = WebXml2Jk.getChild(acN, "role-name");
            while (rN != null) {
                roles.addElement(WebXml2Jk.getContent(rN));
                rN = WebXml2Jk.getNext(rN);
            }
            Node ucN = WebXml2Jk.getChild(mapN2, "user-data-constraint");
            String transp = WebXml2Jk.getContent(WebXml2Jk.getChild(ucN, "transport-guarantee"));
            if (transp != null && ("INTEGRAL".equalsIgnoreCase(transp) || "CONFIDENTIAL".equalsIgnoreCase(transp))) {
                isSSL = true;
            }
            gen.generateConstraints(urls, methods, roles, isSSL);
            mapN2 = WebXml2Jk.getNext(mapN2);
        }
        gen.generateEnd();
    }

    public void execute() {
        try {
            if (this.docBase == null) {
                log.error((Object)"No docbase - please specify the base directory of you web application ( -docBase PATH )");
                return;
            }
            if (this.cpath == null) {
                log.error((Object)"No context - please specify the mount ( -context PATH )");
                return;
            }
            File docbF = new File(this.docBase);
            File wXmlF = new File(this.docBase, "WEB-INF/web.xml");
            Document wXmlN = WebXml2Jk.readXml(wXmlF);
            if (wXmlN == null) {
                return;
            }
            this.webN = wXmlN.getDocumentElement();
            if (this.webN == null) {
                log.error((Object)"Can't find web-app");
                return;
            }
            this.jkDir = new File(docbF, "WEB-INF/jk2");
            this.jkDir.mkdirs();
            MappingGenerator generator = new GeneratorJk2();
            generator.setWebXmlReader(this);
            this.generate(generator);
            generator = new GeneratorJk1();
            generator.setWebXmlReader(this);
            this.generate(generator);
            generator = new GeneratorApache2();
            generator.setWebXmlReader(this);
            this.generate(generator);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1 && ("-?".equals(args[0]) || "-h".equals(args[0]))) {
                System.out.println("Usage: ");
                System.out.println("  WebXml2Jk [OPTIONS]");
                System.out.println();
                System.out.println("  -docBase DIR        The location of the webapp. Required");
                System.out.println("  -group GROUP        Group, if you have multiple tomcats with diffrent content. ");
                System.out.println("                      The default is 'lb', and should be used in most cases");
                System.out.println("  -host HOSTNAME      Canonical hostname - for virtual hosts");
                System.out.println("  -context /CPATH     Context path where the app will be mounted");
                return;
            }
            WebXml2Jk w2jk = new WebXml2Jk();
            IntrospectionUtils.processArgs(w2jk, args, new String[0], null, new Hashtable());
            w2jk.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getContent(Node n) {
        if (n == null) {
            return null;
        }
        Node n1 = n.getFirstChild();
        String s1 = n1.getNodeValue();
        return s1.trim();
    }

    public static Node getChild(Node parent, String name) {
        if (parent == null) {
            return null;
        }
        Node first = parent.getFirstChild();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    public static String getChildContent(Node parent, String name) {
        Node first = parent.getFirstChild();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            return WebXml2Jk.getContent(node);
        }
        return null;
    }

    public static Node getNext(Node current) {
        Node first = current.getNextSibling();
        String name = current.getNodeName();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    public static Document readXml(File xmlF) throws SAXException, IOException, ParserConfigurationException {
        if (!xmlF.exists()) {
            log.error((Object)("No xml file " + xmlF));
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        Document doc = db.parse(xmlF);
        return doc;
    }

    public static class NullResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ResolveEntity: " + publicId + " " + systemId));
            }
            return new InputSource(new StringReader(""));
        }
    }

    public static interface MappingGenerator {
        public void setWebXmlReader(WebXml2Jk var1);

        public void generateStart() throws IOException;

        public void generateEnd() throws IOException;

        public void generateServletMapping(String var1, String var2) throws IOException;

        public void generateFilterMapping(String var1, String var2) throws IOException;

        public void generateLoginConfig(String var1, String var2, String var3) throws IOException;

        public void generateErrorPage(int var1, String var2) throws IOException;

        public void generateConstraints(Vector var1, Vector var2, Vector var3, boolean var4) throws IOException;
    }
}

