/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NameParserImpl;
import org.apache.naming.StringManager;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;

public abstract class BaseDirContext
implements DirContext {
    protected String docBase = null;
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected final NameParser nameParser = new NameParserImpl();
    protected boolean cached = true;
    protected int cacheTTL = 5000;
    protected int cacheMaxSize = 10240;
    protected int cacheObjectMaxSize = 512;
    protected Map<String, BaseDirContext> aliases = new HashMap<String, BaseDirContext>();

    public BaseDirContext() {
        this.env = new Hashtable();
    }

    public BaseDirContext(Hashtable env) {
        this.env = env;
    }

    public void addAlias(String path, BaseDirContext dirContext) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasPath", path));
        }
        this.aliases.put(path, dirContext);
    }

    public void removeAlias(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasPath", path));
        }
        this.aliases.remove(path);
    }

    public String getAliases() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, BaseDirContext>> iter = this.aliases.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            Map.Entry<String, BaseDirContext> entry = iter.next();
            result.append(entry.getKey());
            result.append('=');
            result.append(entry.getValue().getDocBase());
        }
        return result.toString();
    }

    public void setAliases(String theAliases) {
        String[] kvps;
        this.aliases.clear();
        if (theAliases == null || theAliases.length() == 0) {
            return;
        }
        for (String kvp : kvps = theAliases.split(",")) {
            String[] kv = kvp.split("=");
            if (kv.length != 2 || kv[0].length() == 0 || kv[1].length() == 0) {
                throw new IllegalArgumentException(this.sm.getString("resources.invalidAliasMapping", kvp));
            }
            BaseDirContext context = kv[1].endsWith(".war") && !new File(kv[1]).isDirectory() ? new WARDirContext() : new FileDirContext();
            ((BaseDirContext)context).setDocBase(kv[1]);
            this.addAlias(kv[0], context);
        }
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.docBase = docBase;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheObjectMaxSize() {
        return this.cacheObjectMaxSize;
    }

    public void setCacheObjectMaxSize(int cacheObjectMaxSize) {
        this.cacheObjectMaxSize = cacheObjectMaxSize;
    }

    public void allocate() {
    }

    public void release() {
    }

    public String getRealPath(String name) {
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.doGetRealPath(result.aliasName);
            }
        }
        return this.doGetRealPath(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public final Object lookup(String name) throws NamingException {
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.lookup(result.aliasName);
            }
        }
        return this.doLookup(name);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(name, obj, null);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(name, obj, null);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public abstract void unbind(String var1) throws NamingException;

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public abstract void rename(String var1, String var2) throws NamingException;

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public abstract NamingEnumeration list(String var1) throws NamingException;

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public abstract NamingEnumeration listBindings(String var1) throws NamingException;

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public abstract void destroySubcontext(String var1) throws NamingException;

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public abstract Object lookupLink(String var1) throws NamingException;

    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParserImpl();
    }

    public NameParser getNameParser(String name) throws NamingException {
        return new NameParserImpl();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)prefix.clone();
        return prefix.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env.clear();
    }

    public abstract String getNameInNamespace() throws NamingException;

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(name, null);
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public final Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.getAttributes(result.aliasName, attrIds);
            }
        }
        return this.doGetAttributes(name, attrIds);
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    public abstract void modifyAttributes(String var1, int var2, Attributes var3) throws NamingException;

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }

    public abstract void modifyAttributes(String var1, ModificationItem[] var2) throws NamingException;

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.bind(name.toString(), obj, attrs);
    }

    public abstract void bind(String var1, Object var2, Attributes var3) throws NamingException;

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(name.toString(), obj, attrs);
    }

    public abstract void rebind(String var1, Object var2, Attributes var3) throws NamingException;

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    public abstract DirContext createSubcontext(String var1, Attributes var2) throws NamingException;

    public DirContext getSchema(Name name) throws NamingException {
        return this.getSchema(name.toString());
    }

    public abstract DirContext getSchema(String var1) throws NamingException;

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    public abstract DirContext getSchemaClassDefinition(String var1) throws NamingException;

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(name.toString(), matchingAttributes, attributesToReturn);
    }

    public abstract NamingEnumeration search(String var1, Attributes var2, String[] var3) throws NamingException;

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name.toString(), matchingAttributes);
    }

    public abstract NamingEnumeration search(String var1, Attributes var2) throws NamingException;

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filter, cons);
    }

    public abstract NamingEnumeration search(String var1, String var2, SearchControls var3) throws NamingException;

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filterExpr, filterArgs, cons);
    }

    public abstract NamingEnumeration search(String var1, String var2, Object[] var3, SearchControls var4) throws NamingException;

    protected abstract Attributes doGetAttributes(String var1, String[] var2) throws NamingException;

    protected abstract Object doLookup(String var1) throws NamingException;

    protected abstract String doGetRealPath(String var1);

    private AliasResult findAlias(String name) {
        int slash;
        AliasResult result = new AliasResult();
        String searchName = name;
        result.dirContext = this.aliases.get(searchName);
        while (result.dirContext == null && (slash = searchName.lastIndexOf(47)) >= 0) {
            searchName = searchName.substring(0, slash);
            result.dirContext = this.aliases.get(searchName);
        }
        if (result.dirContext != null) {
            result.aliasName = name.substring(searchName.length());
        }
        return result;
    }

    private static class AliasResult {
        BaseDirContext dirContext;
        String aliasName;

        private AliasResult() {
        }
    }
}

