/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.shutdown;

import java.util.Arrays;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.extender.internal.dependencies.shutdown.BundleDependencyComparator;
import org.springframework.osgi.extender.internal.dependencies.shutdown.ServiceDependencySorter;

public class ComparatorServiceDependencySorter
implements ServiceDependencySorter {
    public Bundle[] computeServiceDependencyGraph(Bundle[] bundles) {
        TarganStronglyConnectedSorter parser = new TarganStronglyConnectedSorter(bundles);
        return parser.computeServiceDependencyGraph();
    }

    public static class TarganStronglyConnectedSorter {
        private BundleDependencyComparator comparator = new BundleDependencyComparator();
        private int id = 0;
        private int[] val;
        private int[] stack;
        private int p = 0;
        private Node[] adj;
        private int V;
        private Bundle[] bundles;
        private Bundle[] sourcebundles;
        private int index = 0;

        public TarganStronglyConnectedSorter(Bundle[] bundles) {
            this.V = bundles.length;
            this.bundles = new Bundle[this.V];
            this.sourcebundles = bundles;
            this.val = new int[this.V + 1];
            this.adj = new Node[this.V + 1];
            this.stack = new int[this.V + 1];
        }

        public Bundle[] computeServiceDependencyGraph() {
            int k;
            for (k = 1; k <= this.V; ++k) {
                this.val[k] = 0;
                this.adj[k] = null;
            }
            for (int y = 1; y <= this.V; ++y) {
                for (int x = 1; x <= this.V; ++x) {
                    if (!TarganStronglyConnectedSorter.references(this.sourcebundles[x - 1], this.sourcebundles[y - 1])) continue;
                    this.adj[y] = new Node(x, this.adj[y]);
                }
            }
            for (k = 1; k <= this.V; ++k) {
                if (this.val[k] != 0) continue;
                this.visit(k);
            }
            return this.bundles;
        }

        private int visit(int k) {
            this.val[k] = ++this.id;
            int min = this.id;
            this.stack[this.p++] = k;
            for (Node t = this.adj[k]; t != null; t = t.next()) {
                int m;
                int n = m = this.val[t.v()] == 0 ? this.visit(t.v()) : this.val[t.v()];
                if (m >= min) continue;
                min = m;
            }
            if (min == this.val[k]) {
                int subset = this.index;
                while (this.stack[this.p] != k) {
                    int visited = this.stack[--this.p];
                    this.bundles[this.index++] = this.sourcebundles[visited - 1];
                    this.val[visited] = this.V + 1;
                }
                if (this.index > subset) {
                    Arrays.sort(this.bundles, subset, this.index, this.comparator);
                }
            }
            return min;
        }

        protected static boolean references(Bundle a, Bundle b) {
            ServiceReference[] services = b.getRegisteredServices();
            if (services == null) {
                return false;
            }
            for (int i = 0; i < services.length; ++i) {
                Bundle[] referingBundles;
                if (!BundleDependencyComparator.isSpringManagedService(services[i]) || (referingBundles = services[i].getUsingBundles()) == null) continue;
                for (int j = 0; j < referingBundles.length; ++j) {
                    if (!a.equals(referingBundles[j])) continue;
                    return true;
                }
            }
            return false;
        }

        private static class Node {
            private int v;
            private Node next;

            public Node(int v, Node next) {
                this.v = v;
                this.next = next;
            }

            public int v() {
                return this.v;
            }

            public Node next() {
                return this.next;
            }
        }
    }
}

