/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.cacheing.cache.artifact;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.internal.cacheing.cache.artifact.Downloader;
import org.eclipse.virgo.repository.internal.cacheing.cache.artifact.SingleArtifactCache;
import org.eclipse.virgo.repository.internal.cacheing.cache.descriptorhash.ArtifactDescriptorHash;
import org.eclipse.virgo.repository.util.FileDigest;
import org.eclipse.virgo.util.io.PathReference;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandardSingleArtifactCache
implements SingleArtifactCache {
    private static final String ALGORITHM_HASH_SEPARATOR = ":";
    private static final String HASH_SUFFIX = ".hash";
    private static final Logger LOGGER;
    private final Object monitor = new Object();
    private final PathReference artifactCacheDirectory;
    private final URI repositoryArtifactURI;
    private final String fileName;
    private final PathReference artifactCacheFilePathReference;
    private final PathReference artifactHashFilePathReference;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.cacheing.cache.artifact.StandardSingleArtifactCache");
        LOGGER = LoggerFactory.getLogger(StandardSingleArtifactCache.class);
    }

    StandardSingleArtifactCache(String type, String name, Version version, URI repositoryArtifactURI, String fileName, File repositoryCacheDirectory) {
        this.artifactCacheDirectory = StandardSingleArtifactCache.obtainArtifactCacheDirectory(type, name, version, repositoryCacheDirectory);
        this.repositoryArtifactURI = repositoryArtifactURI;
        this.fileName = fileName;
        this.artifactCacheFilePathReference = this.artifactCacheDirectory.newChild(this.fileName).createFile();
        this.artifactHashFilePathReference = this.artifactCacheDirectory.newChild(String.valueOf(this.fileName) + HASH_SUFFIX).createFile();
    }

    private static PathReference obtainArtifactCacheDirectory(String type, String name, Version version, File repositoryCacheDirectory) {
        PathReference repositoryDirectory = new PathReference(repositoryCacheDirectory);
        PathReference artifactCacheDirectory = repositoryDirectory.newChild(type).newChild(name).newChild(version.toString());
        artifactCacheDirectory.createDirectory();
        return artifactCacheDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getCachedUri(ArtifactDescriptorHash artifactDescriptorHash) {
        Object object = this.monitor;
        synchronized (object) {
            String digestAlgorithm = artifactDescriptorHash.getDigestAlgorithm();
            String cachedHash = this.getHash(digestAlgorithm);
            if (cachedHash == null || !artifactDescriptorHash.matches(cachedHash)) {
                this.refresh(artifactDescriptorHash.getDigestAlgorithm());
                cachedHash = this.getHash(digestAlgorithm);
                if (cachedHash != null && artifactDescriptorHash.isPresent() && !artifactDescriptorHash.matches(cachedHash)) {
                    LOGGER.info("Newly cached artifact has a hash value different to that stored in the index");
                }
            }
            return this.getURI();
        }
    }

    private String getHash(String digestAlgorithm) {
        String string;
        BufferedReader bufferedHashFileReader = new BufferedReader(this.getHashFileReader());
        try {
            String digestAlgorithmAndHash = bufferedHashFileReader.readLine();
            string = this.extractHashForAlgorithm(digestAlgorithm, digestAlgorithmAndHash);
        }
        catch (Throwable throwable) {
            try {
                bufferedHashFileReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        bufferedHashFileReader.close();
        return string;
    }

    private String extractHashForAlgorithm(String digestAlgorithm, String digestAlgorithmAndHash) {
        String[] s;
        String hash = null;
        if (digestAlgorithmAndHash != null && (s = digestAlgorithmAndHash.split(ALGORITHM_HASH_SEPARATOR)).length == 2 && digestAlgorithm.equals(s[0])) {
            hash = s[1];
        }
        return hash;
    }

    private void refresh(String digestAlgorithm) {
        new Downloader(this.repositoryArtifactURI, this.artifactCacheFilePathReference).downloadArtifact();
        this.storeHash(digestAlgorithm);
    }

    private void storeHash(String digestAlgorithm) {
        try {
            String hash = FileDigest.getFileDigest(this.artifactCacheFilePathReference.toFile(), digestAlgorithm);
            Writer hashFileWriter = this.getHashFileWriter();
            try {
                hashFileWriter.write(String.valueOf(digestAlgorithm) + ALGORITHM_HASH_SEPARATOR + hash);
            }
            finally {
                hashFileWriter.close();
            }
        }
        catch (IOException iOException) {
            this.artifactHashFilePathReference.delete();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.artifactHashFilePathReference.delete();
        }
    }

    private Writer getHashFileWriter() throws IOException {
        return new FileWriter(this.artifactHashFilePathReference.toFile());
    }

    private Reader getHashFileReader() throws IOException {
        return new FileReader(this.artifactHashFilePathReference.toFile());
    }

    private URI getURI() {
        return this.artifactCacheFilePathReference.exists() ? this.artifactCacheFilePathReference.toURI() : null;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

