/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.FatalDeploymentException;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class SpringConfigServiceModelScanner {
    private static final String ATTRIBUTE_REF = "ref";
    private static final String ATTRIBUTE_INTERFACE = "interface";
    private static final String ELEMENT_VALUE = "value";
    private static final String ELEMENT_INTERFACES = "interfaces";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ELEMENT_SERVICE_PROPERTIES = "service-properties";
    private static final String SPRING_DM_NAMESPACE = "http://www.springframework.org/schema/osgi";
    private static final String SPRING_BEANS_NAMESPACE = "http://www.springframework.org/schema/beans";
    private static final String ELEMENT_SERVICE = "service";
    private static final String BEAN_NAME_PROPERTY = "org.springframework.osgi.bean.name";
    private final EventLogger eventLogger;
    private final ScopeServiceRepository repository;
    private final DocumentBuilder documentBuilder;
    private final String scopeName;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public SpringConfigServiceModelScanner(String scopeName, ScopeServiceRepository repository, EventLogger eventLogger) {
        try {
            this.scopeName = scopeName;
            this.repository = repository;
            this.eventLogger = eventLogger;
            this.documentBuilder = this.createDocumentBuilder();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void scanConfigFile(String bundleSymbolicName, Version bundleVersion, String configFileName, InputStream stream) throws DeploymentException {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Document doc = this.parseConfigFile(bundleSymbolicName, bundleVersion, configFileName, stream);
                this.doScopeServices(doc.getDocumentElement().getChildNodes());
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void doScopeServices(NodeList childNodes) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                int x = 0;
                while (x < childNodes.getLength()) {
                    Node node = childNodes.item(x);
                    if (this.isServiceElement(node)) {
                        this.parseServiceElement((Element)node);
                    }
                    this.doScopeServices(node.getChildNodes());
                    ++x;
                }
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void parseServiceElement(Element elem) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                String[] types = this.extractInterfaces(elem);
                Properties properties = this.extractServiceProperties(elem);
                this.repository.recordService(this.scopeName, types, properties);
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String[] extractInterfaces(Element e) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                HashSet<String> exportedInterfaces = new HashSet<String>();
                String iface = StringUtils.trimWhitespace((String)e.getAttribute(ATTRIBUTE_INTERFACE));
                if (StringUtils.hasText((String)iface)) {
                    exportedInterfaces.add(iface);
                } else {
                    NodeList children = e.getChildNodes();
                    int y = 0;
                    while (y < children.getLength()) {
                        Node child = children.item(y);
                        if (child instanceof Element && this.isInterfacesElement(child)) {
                            Element elem = (Element)child;
                            NodeList intChildren = elem.getChildNodes();
                            int i = 0;
                            while (i < intChildren.getLength()) {
                                Node intChild = intChildren.item(i);
                                if (this.isValueElement(intChild)) {
                                    exportedInterfaces.add(StringUtils.trimWhitespace((String)intChild.getTextContent()));
                                }
                                ++i;
                            }
                        }
                        ++y;
                    }
                }
                String[] stringArray = exportedInterfaces.toArray(new String[exportedInterfaces.size()]);
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return stringArray;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties extractServiceProperties(Element elem) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                NodeList servicePropertiesElems = elem.getElementsByTagNameNS(SPRING_DM_NAMESPACE, ELEMENT_SERVICE_PROPERTIES);
                Properties p = null;
                if (servicePropertiesElems.getLength() > 0) {
                    p = new Properties();
                    Node item = servicePropertiesElems.item(0);
                    this.readServiceProperties((Element)item, p);
                }
                Properties properties = p = this.addStandardServiceProperties(elem, p);
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return properties;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties addStandardServiceProperties(Element elem, Properties p) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                String beanName = StringUtils.trimWhitespace((String)elem.getAttribute(ATTRIBUTE_REF));
                if (StringUtils.hasText((String)beanName)) {
                    if (p == null) {
                        p = new Properties();
                    }
                    p.setProperty(BEAN_NAME_PROPERTY, beanName);
                }
                Properties properties = p;
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return properties;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void readServiceProperties(Element servicePropertiesElement, Properties serviceProperties) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                NodeList childNodes = servicePropertiesElement.getChildNodes();
                int y = 0;
                while (y < childNodes.getLength()) {
                    Node child = childNodes.item(y);
                    if (this.isEntryElement(child)) {
                        Element entry = (Element)child;
                        serviceProperties.setProperty(entry.getAttribute(ATTRIBUTE_KEY), entry.getAttribute("value"));
                    }
                    ++y;
                }
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Document parseConfigFile(String bundleSymbolicName, Version bundleVersion, String configFileName, InputStream stream) throws DeploymentException {
        try {
            try {
                Document document;
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                try {
                    document = this.documentBuilder.parse(new InputSource(stream));
                }
                catch (SAXException ex) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.CONFIG_FILE_ERROR, (Throwable)ex, new Object[]{configFileName, bundleSymbolicName, bundleVersion});
                    throw new DeploymentException("Error parsing configuration file '" + configFileName + "'.", ex);
                }
                catch (IOException ex) {
                    throw new FatalDeploymentException("Error accessing configuration file '" + configFileName + "'.", ex);
                }
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return document;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DocumentBuilder createDocumentBuilder() {
        try {
            try {
                DocumentBuilder documentBuilder;
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    documentBuilder = dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new FatalDeploymentException("Unable to create DocumentBuilder - JAXP parser configuration error.", e);
                }
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return documentBuilder;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isValueElement(Node node) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
                boolean bl = SPRING_BEANS_NAMESPACE.equals(node.getNamespaceURI()) && "value".equals(node.getLocalName()) && node.getNodeType() == 1;
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
                return bl;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isInterfacesElement(Node node) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
                boolean bl = SPRING_DM_NAMESPACE.equals(node.getNamespaceURI()) && ELEMENT_INTERFACES.equals(node.getLocalName()) && node.getNodeType() == 1;
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
                return bl;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isServiceElement(Node node) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
                boolean bl = SPRING_DM_NAMESPACE.equals(node.getNamespaceURI()) && ELEMENT_SERVICE.equals(node.getLocalName()) && node.getNodeType() == 1;
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
                return bl;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isEntryElement(Node node) {
        try {
            try {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
                boolean bl = SPRING_BEANS_NAMESPACE.equals(node.getNamespaceURI()) && ELEMENT_ENTRY.equals(node.getLocalName()) && node.getNodeType() == 1;
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
                return bl;
            }
            catch (Throwable throwable) {
                SpringConfigServiceModelScanner.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("SpringConfigServiceModelScanner.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "scanConfigFile", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "java.lang.String:org.osgi.framework.Version:java.lang.String:java.io.InputStream:", "bundleSymbolicName:bundleVersion:configFileName:stream:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 90);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doScopeServices", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.NodeList:", "childNodes:", "", "void"), 95);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isInterfacesElement", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Node:", "node:", "", "boolean"), 209);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isServiceElement", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Node:", "node:", "", "boolean"), 214);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isEntryElement", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Node:", "node:", "", "boolean"), 219);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "parseServiceElement", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Element:", "elem:", "", "void"), 105);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractInterfaces", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Element:", "e:", "", "[Ljava.lang.String;"), 117);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractServiceProperties", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Element:", "elem:", "", "java.util.Properties"), 143);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addStandardServiceProperties", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Element:java.util.Properties:", "elem:p:", "", "java.util.Properties"), 156);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readServiceProperties", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Element:java.util.Properties:", "servicePropertiesElement:serviceProperties:", "", "void"), 167);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "parseConfigFile", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "java.lang.String:org.osgi.framework.Version:java.lang.String:java.io.InputStream:", "bundleSymbolicName:bundleVersion:configFileName:stream:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.w3c.dom.Document"), 179);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createDocumentBuilder", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "", "", "", "javax.xml.parsers.DocumentBuilder"), 195);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isValueElement", "org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner", "org.w3c.dom.Node:", "node:", "", "boolean"), 204);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner");
    }
}

