/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Enumeration;
import org.apache.felix.log.LogEntryImpl;
import org.apache.felix.log.LogListenerThread;
import org.apache.felix.log.LogNode;
import org.apache.felix.log.LogNodeEnumeration;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

final class Log
implements BundleListener,
FrameworkListener,
ServiceListener {
    private LogNode m_head;
    private LogNode m_tail;
    private int m_size;
    private LogListenerThread listenerThread;
    private final int m_maxSize;
    private final boolean m_storeDebug;
    private static final String[] FRAMEWORK_EVENT_MESSAGES = new String[]{"FrameworkEvent STARTED", "FrameworkEvent ERROR", "FrameworkEvent PACKAGES REFRESHED", "FrameworkEvent STARTLEVEL CHANGED", "FrameworkEvent WARNING", "FrameworkEvent INFO"};
    private static final String[] BUNDLE_EVENT_MESSAGES = new String[]{"BundleEvent INSTALLED", "BundleEvent STARTED", "BundleEvent STOPPED", "BundleEvent UPDATED", "BundleEvent UNINSTALLED", "BundleEvent RESOLVED", "BundleEvent UNRESOLVED"};
    private static final String[] SERVICE_EVENT_MESSAGES = new String[]{"ServiceEvent REGISTERED", "ServiceEvent MODIFIED", "ServiceEvent UNREGISTERING"};

    Log(int maxSize, boolean storeDebug) {
        this.m_maxSize = maxSize;
        this.m_storeDebug = storeDebug;
    }

    void close() {
        if (this.listenerThread != null) {
            this.listenerThread.shutdown();
            this.listenerThread = null;
        }
        this.m_head = null;
        this.m_tail = null;
        this.m_size = 0;
    }

    synchronized void addEntry(LogEntry entry) {
        if (this.m_maxSize != 0) {
            if (this.m_storeDebug || entry.getLevel() != 4) {
                LogNode node = new LogNode(entry);
                node.setNextNode(this.m_head);
                if (this.m_head != null) {
                    this.m_head.setPreviousNode(node);
                }
                this.m_head = node;
                ++this.m_size;
                if (this.m_tail == null) {
                    this.m_tail = node;
                }
            }
            if (this.m_maxSize != -1 && this.m_size > this.m_maxSize) {
                LogNode last = this.m_tail.getPreviousNode();
                last.setNextNode(null);
                this.m_tail = last;
                --this.m_size;
            }
        }
        if (this.listenerThread != null) {
            this.listenerThread.addEntry(entry);
        }
    }

    synchronized void addListener(LogListener listener) {
        if (this.listenerThread == null) {
            this.listenerThread = new LogListenerThread();
            this.listenerThread.start();
        }
        this.listenerThread.addListener(listener);
    }

    synchronized void removeListener(LogListener listener) {
        if (this.listenerThread != null) {
            this.listenerThread.removeListener(listener);
            if (this.listenerThread.getListenerCount() == 0) {
                this.listenerThread.shutdown();
                this.listenerThread = null;
            }
        }
    }

    synchronized Enumeration getEntries() {
        return new LogNodeEnumeration(this.m_head, this.m_tail);
    }

    public void frameworkEvent(FrameworkEvent event) {
        int eventType = event.getType();
        String message = null;
        for (int i = 0; message == null && i < FRAMEWORK_EVENT_MESSAGES.length; ++i) {
            if (eventType >> i != 1) continue;
            message = FRAMEWORK_EVENT_MESSAGES[i];
        }
        LogEntryImpl entry = new LogEntryImpl(event.getBundle(), null, eventType == 2 ? 1 : 3, message, event.getThrowable());
        this.addEntry(entry);
    }

    public void bundleChanged(BundleEvent event) {
        int eventType = event.getType();
        String message = null;
        for (int i = 0; message == null && i < BUNDLE_EVENT_MESSAGES.length; ++i) {
            if (eventType >> i != 1) continue;
            message = BUNDLE_EVENT_MESSAGES[i];
        }
        if (message != null) {
            LogEntryImpl entry = new LogEntryImpl(event.getBundle(), null, 3, message, null);
            this.addEntry(entry);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        int eventType = event.getType();
        String message = null;
        for (int i = 0; message == null && i < SERVICE_EVENT_MESSAGES.length; ++i) {
            if (eventType >> i != 1) continue;
            message = SERVICE_EVENT_MESSAGES[i];
        }
        LogEntryImpl entry = new LogEntryImpl(event.getServiceReference().getBundle(), event.getServiceReference(), eventType == 2 ? 4 : 3, message, null);
        this.addEntry(entry);
    }
}

