/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.library;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.virgo.kernel.artifact.library.LibraryDefinition;
import org.eclipse.virgo.kernel.artifact.library.internal.ArtifactDescriptorLibraryDefinition;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.HashGenerator;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.repository.builder.AttributeBuilder;
import org.eclipse.virgo.util.common.CaseInsensitiveMap;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ImportedBundle;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParserFactory;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;
import org.eclipse.virgo.util.parser.manifest.RecoveringManifestParser;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryBridge
implements ArtifactBridge {
    public static final String LIBRARY_VERSION = "Library-Version";
    public static final String LIBRARY_SYMBOLICNAME = "Library-SymbolicName";
    public static final String IMPORT_BUNDLE = "Import-Bundle";
    public static final String LIBRARY_NAME = "Library-Name";
    public static final String LIBRARY_DESCRIPTION = "Library-Description";
    private static final String LIBRARY_DESCRIPTOR_SUFFIX = ".libd";
    private static final String DEFAULT_LIBRARY_VERSION = "0";
    public static final String RAW_HEADER_PREFIX = "RAW_HEADER:";
    public static final String SHARING_DIRECTIVE = "sharing";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String RESOLUTION_DIRECTIVE = "resolution";
    private static final String IMPORT_SCOPE_DIRECTIVE = "import-scope";
    private final HashGenerator hashGenerator;

    public LibraryBridge(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public ArtifactDescriptor generateArtifactDescriptor(File artifactFile) throws ArtifactGenerationException {
        ManifestContents manifestContents;
        if (!artifactFile.getName().endsWith(LIBRARY_DESCRIPTOR_SUFFIX)) {
            return null;
        }
        try {
            manifestContents = LibraryBridge.getManifestContents(artifactFile);
        }
        catch (IOException ie) {
            throw new ArtifactGenerationException("Unable to read library definition", "library", (Throwable)ie);
        }
        CaseInsensitiveMap contentsMap = new CaseInsensitiveMap();
        contentsMap.putAll(manifestContents.getMainAttributes());
        ArtifactDescriptorBuilder builder = new ArtifactDescriptorBuilder();
        builder.setUri(artifactFile.toURI());
        builder.setType("library");
        String name = LibraryBridge.createAttributeFromLibrarySymbolicName((CaseInsensitiveMap<String>)contentsMap, artifactFile, builder);
        builder.setName(name);
        Version version = LibraryBridge.createAttributeFromLibraryVersion((CaseInsensitiveMap<String>)contentsMap, builder);
        builder.setVersion(version);
        LibraryBridge.createAttributesFromImportBundle((CaseInsensitiveMap<String>)contentsMap, artifactFile, builder);
        LibraryBridge.createAttributeFromLibraryName((CaseInsensitiveMap<String>)contentsMap, builder);
        LibraryBridge.createAttributeFromLibraryDescription((CaseInsensitiveMap<String>)contentsMap, builder);
        LibraryBridge.createAttributesFromRawHeaders((CaseInsensitiveMap<String>)contentsMap, builder);
        this.hashGenerator.generateHash(builder, artifactFile);
        return builder.build();
    }

    private static ManifestContents getManifestContents(File file) throws IOException {
        RecoveringManifestParser manifestParser = new RecoveringManifestParser();
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            ManifestContents manifestContents = manifestParser.parse((Reader)reader);
            return manifestContents;
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    private static String createAttributeFromLibrarySymbolicName(CaseInsensitiveMap<String> manifestAttributes, File artifact, ArtifactDescriptorBuilder builder) throws ArtifactGenerationException {
        String symbolicNameString = LibraryBridge.getRequiredHeader(LIBRARY_SYMBOLICNAME, manifestAttributes, artifact);
        HeaderDeclaration symbolicNameDeclaration = HeaderParserFactory.newHeaderParser(null).parseLibrarySymbolicName(symbolicNameString);
        String symbolicName = (String)symbolicNameDeclaration.getNames().get(0);
        String sharingString = (String)symbolicNameDeclaration.getDirectives().get(SHARING_DIRECTIVE);
        LibraryDefinition.Sharing sharing = sharingString != null ? LibraryDefinition.Sharing.valueOf(sharingString.toUpperCase(Locale.ENGLISH)) : LibraryDefinition.Sharing.SHAREABLE;
        AttributeBuilder attBuilder = new AttributeBuilder();
        attBuilder.setName(LIBRARY_SYMBOLICNAME);
        attBuilder.setValue(symbolicName);
        attBuilder.putProperties(SHARING_DIRECTIVE, new String[]{sharing.toString().toLowerCase(Locale.ENGLISH)});
        builder.addAttribute(attBuilder.build());
        return symbolicName;
    }

    private static Version createAttributeFromLibraryVersion(CaseInsensitiveMap<String> manifestAttributes, ArtifactDescriptorBuilder builder) {
        String versionString = (String)manifestAttributes.get((Object)LIBRARY_VERSION);
        if (!StringUtils.hasText((String)versionString)) {
            versionString = DEFAULT_LIBRARY_VERSION;
        }
        Version version = new Version(versionString);
        builder.addAttribute(new AttributeBuilder().setName(LIBRARY_VERSION).setValue(version.toString()).build());
        return version;
    }

    private static void createAttributesFromImportBundle(CaseInsensitiveMap<String> manifestAttributes, File artifact, ArtifactDescriptorBuilder builder) throws ArtifactGenerationException {
        String importBundleString = LibraryBridge.getRequiredHeader(IMPORT_BUNDLE, manifestAttributes, artifact);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put(IMPORT_BUNDLE, importBundleString);
        BundleManifest manifest = BundleManifestFactory.createBundleManifest(headers);
        List importedBundles = manifest.getImportBundle().getImportedBundles();
        for (ImportedBundle importedBundle : importedBundles) {
            AttributeBuilder attBuilder = new AttributeBuilder();
            attBuilder.setName(IMPORT_BUNDLE);
            attBuilder.setValue(importedBundle.getBundleSymbolicName());
            attBuilder.putProperties(RESOLUTION_DIRECTIVE, new String[]{importedBundle.getResolution().toString().toLowerCase(Locale.ENGLISH)});
            attBuilder.putProperties(VERSION_ATTRIBUTE, new String[]{importedBundle.getVersion().toParseString()});
            if (importedBundle.isApplicationImportScope()) {
                attBuilder.putProperties(IMPORT_SCOPE_DIRECTIVE, new String[]{"application"});
            }
            attBuilder.putProperties(SHARING_DIRECTIVE, new String[]{importedBundle.getSharing().toString().toLowerCase(Locale.ENGLISH)});
            builder.addAttribute(attBuilder.build());
        }
    }

    private static void createAttributeFromLibraryName(CaseInsensitiveMap<String> manifestAttributes, ArtifactDescriptorBuilder builder) {
        String name = (String)manifestAttributes.get((Object)LIBRARY_NAME);
        if (name != null) {
            builder.addAttribute(new AttributeBuilder().setName(LIBRARY_NAME).setValue(name).build());
        }
    }

    private static void createAttributeFromLibraryDescription(CaseInsensitiveMap<String> manifestAttributes, ArtifactDescriptorBuilder builder) {
        String name = (String)manifestAttributes.get((Object)LIBRARY_DESCRIPTION);
        if (name != null) {
            builder.addAttribute(new AttributeBuilder().setName(LIBRARY_DESCRIPTION).setValue(name).build());
        }
    }

    private static void createAttributesFromRawHeaders(CaseInsensitiveMap<String> manifestAttributes, ArtifactDescriptorBuilder builder) {
        for (Map.Entry entry : manifestAttributes.entrySet()) {
            builder.addAttribute(new AttributeBuilder().setName(RAW_HEADER_PREFIX + (String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
    }

    private static String getRequiredHeader(String name, CaseInsensitiveMap<String> attrs, File artifactFile) throws ArtifactGenerationException {
        String value = (String)attrs.get((Object)name);
        if (value == null || value.trim().length() == 0) {
            throw new ArtifactGenerationException(String.format("Required attribute '%s' is missing from library descriptor '%s'.", name, artifactFile.getName()), "library");
        }
        return value;
    }

    public static List<ImportedBundle> parseImportBundle(String importBundleString) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put(IMPORT_BUNDLE, importBundleString);
        BundleManifest manifest = BundleManifestFactory.createBundleManifest(headers);
        return manifest.getImportBundle().getImportedBundles();
    }

    public static LibraryDefinition createLibraryDefinition(ArtifactDescriptor artefact) {
        return new ArtifactDescriptorLibraryDefinition(artefact);
    }
}

