/*******************************************************************************
 * Copyright (c) 2005, 2018 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.jsdt.web.core.internal;

import org.eclipse.osgi.util.NLS;
/**
*
* Provisional API: This class/interface is part of an interim API that is still under development and expected to
* change significantly before reaching stability. It is being made available at this early stage to solicit feedback
* from pioneering adopters on the understanding that any code that uses this API will almost certainly be broken
* (repeatedly) as the API evolves.
*/
public class JsCoreMessages extends NLS {
	private static final String BUNDLE_NAME = "org.eclipse.wst.jsdt.web.core.internal.JSPCorePluginResources"; //$NON-NLS-1$
	public static String JSP_Search;
	public static String JSPBatchValidator_0;
	public static String JSPDirectiveValidator_0;
	public static String JSPDirectiveValidator_1;
	public static String JSPDirectiveValidator_2;
	public static String JSPDirectiveValidator_3;
	public static String JSPDocumentLoader_1;
	public static String JSPEL_Syntax;
	public static String JSPEL_Token;
	public static String JSPFContentPropertiesManager_Problems_Updating;
	public static String JSPFContentPropertiesManager_Updating;
	public static String JSPIndexManager_0;
	public static String JSPIndexManager_2;
	public static String JavaScript_Indexer;
	/**
	 * @deprecated
	 */

	public static String MESSAGE_JSP_VALIDATING_MESSAGE_UI_;
	static {
		// initialize resource bundle
		NLS.initializeMessages(JsCoreMessages.BUNDLE_NAME, JsCoreMessages.class);
	}
	
	private JsCoreMessages() {}
}
