/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FacetType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadFacetRendererTestCase
extends BaseReadTestCase {
    public ReadFacetRendererTestCase(String name) {
        super(name);
    }

    public void testSingleFacet() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facet1 = this.getFacet1(edit.getFacesConfig());
            ReadFacetRendererTestCase.assertNotNull((Object)facet1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private FacetType getFacet1(FacesConfigType facesConfigType) {
        RenderKitType renderKit = (RenderKitType)FacesConfigModelUtil.findEObjectElementById((List)facesConfigType.getRenderKit(), "renderKit1");
        ReadFacetRendererTestCase.assertNotNull((Object)renderKit);
        RendererType renderer = (RendererType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getRenderer(), "renderKit1Renderer");
        ReadFacetRendererTestCase.assertNotNull((Object)renderer);
        return (FacetType)FacesConfigModelUtil.findEObjectElementById((List)renderer.getFacet(), "renderKit1Renderer1Facet1");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facetType = this.getFacet1(edit.getFacesConfig());
            ReadFacetRendererTestCase.assertNotNull((Object)facetType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)facetType.getDescription(), "renderKit1Renderer1Facet1Description");
            ReadFacetRendererTestCase.assertEquals((String)"RendererFacetDescription", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facetType = this.getFacet1(edit.getFacesConfig());
            ReadFacetRendererTestCase.assertNotNull((Object)facetType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)facetType.getDisplayName(), "renderKit1Renderer1Facet1DisplayName");
            ReadFacetRendererTestCase.assertEquals((String)"RendererFacetDisplayName", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facetType = this.getFacet1(edit.getFacesConfig());
            ReadFacetRendererTestCase.assertNotNull((Object)facetType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)facetType.getIcon(), "renderKit1Renderer1Facet1Icon");
            ReadFacetRendererTestCase.assertNotNull((Object)iconType);
            ReadFacetRendererTestCase.assertEquals((String)"facet-renderer-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadFacetRendererTestCase.assertEquals((String)"facet-renderer-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testFacetName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facet1 = this.getFacet1(edit.getFacesConfig());
            ReadFacetRendererTestCase.assertNotNull((Object)facet1);
            ReadFacetRendererTestCase.assertEquals((String)"rendererFacetName", (String)facet1.getFacetName().getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

