/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.jaxrslibraryconfiguration.internal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.jaxrslibraryconfiguration.internal.JAXRSLibraryReference;
import org.eclipse.jst.ws.jaxrs.core.jaxrslibraryconfiguration.internal.JAXRSLibraryReferenceFacadeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXRSLibraryConfigurationHelper {
    public static final String JAXRS_LIBRARY_CP_CONTAINER_ID = "org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibrarycontainer";

    public static Collection<JAXRSLibraryReference> getJAXRSLibraryReferences(IProject project) {
        HashSet<JAXRSLibraryReference> results = new HashSet<JAXRSLibraryReference>();
        IJavaProject jproj = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] entries = jproj.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                JAXRSLibraryReference ref = JAXRSLibraryReferenceFacadeFactory.create(entries[i]);
                if (ref != null) {
                    results.add(ref);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JAXRSCorePlugin.log((Exception)((Object)e), "Exception occurred calling getJAXRSLibraryReferences for " + project.getName());
        }
        return results;
    }

    public static boolean isJAXRSLibraryContainer(IClasspathEntry cpEntry) {
        if (cpEntry.getEntryKind() != 5) {
            return false;
        }
        IPath path = cpEntry.getPath();
        return path != null && path.segmentCount() == 2 && JAXRS_LIBRARY_CP_CONTAINER_ID.equals(path.segment(0));
    }
}

