/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.util;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.StringTokenizer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.toJava.Utils;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;

public class WSDLUtils {
    private static final String DOT = ".";
    static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance((Locale)Locale.ENGLISH);
    static final char keywordPrefix = '_';

    private WSDLUtils() {
    }

    public static String getServiceElementName(Definition definition) {
        Service service = (Service)definition.getServices().values().iterator().next();
        return service.getQName().getLocalPart();
    }

    public static String getPortTypeName(Definition definition) {
        Service service = (Service)definition.getServices().values().iterator().next();
        for (Port port : service.getPorts().values()) {
            int i = 0;
            while (i < port.getExtensibilityElements().size()) {
                if (port.getExtensibilityElements().get(i) instanceof SOAPAddress) {
                    Binding binding = port.getBinding();
                    return binding.getPortType().getQName().getLocalPart();
                }
                ++i;
            }
        }
        return "";
    }

    public static String getPortName(Definition definition) {
        Service service = (Service)definition.getServices().values().iterator().next();
        for (Port port : service.getPorts().values()) {
            int i = 0;
            while (i < port.getExtensibilityElements().size()) {
                if (port.getExtensibilityElements().get(i) instanceof SOAPAddress) {
                    return port.getName();
                }
                ++i;
            }
        }
        return "";
    }

    public static String makeNamespace(String clsName) {
        return WSDLUtils.makeNamespace(clsName, "http");
    }

    public static String makeNamespace(String clsName, String protocol) {
        if (clsName.lastIndexOf(46) == -1) {
            return String.valueOf(protocol) + "://" + "DefaultNamespace";
        }
        String packageName = clsName.substring(0, clsName.lastIndexOf(46));
        return WSDLUtils.makeNamespaceFromPackageName(packageName, protocol);
    }

    private static String makeNamespaceFromPackageName(String packageName, String protocol) {
        if (packageName == null || packageName.equals("")) {
            return String.valueOf(protocol) + "://" + "DefaultNamespace";
        }
        StringTokenizer st = new StringTokenizer(packageName, DOT);
        String[] words = new String[st.countTokens()];
        int i = 0;
        while (i < words.length) {
            words[i] = st.nextToken();
            ++i;
        }
        StringBuffer sb = new StringBuffer(80);
        int i2 = words.length - 1;
        while (i2 >= 0) {
            String word = words[i2];
            if (i2 != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
            --i2;
        }
        return String.valueOf(protocol) + "://" + sb.toString();
    }

    public static Definition getWSDLDefinition(String wsdlURL) {
        if (wsdlURL == null) {
            return null;
        }
        Definition definition = null;
        try {
            WSDLFactoryImpl wsdlFactory = new WSDLFactoryImpl();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            definition = wsdlReader.readWSDL(wsdlURL);
        }
        catch (Exception exception) {
            return null;
        }
        return definition;
    }

    public static String getPackageName(Definition definition) {
        if (definition != null) {
            String namespace = definition.getTargetNamespace();
            return WSDLUtils.namespaceURI2PackageName(namespace);
        }
        return "";
    }

    public static String getPackageNameForBindingImpl(Port port, Map ns2pkgMap) {
        Binding binding;
        QName bndQName;
        String namespace;
        Object pkg;
        if (port != null && ns2pkgMap != null && (pkg = ns2pkgMap.get(namespace = (bndQName = (binding = port.getBinding()).getQName()).getNamespaceURI())) != null) {
            return (String)pkg;
        }
        return WSDLUtils.getPackageNameForBindingImpl(port);
    }

    public static String getPackageNameForBindingImpl(Definition definition, Map ns2pkgMap) {
        if (definition != null && ns2pkgMap != null) {
            Service service = (Service)definition.getServices().values().iterator().next();
            Port port = (Port)service.getPorts().values().iterator().next();
            return WSDLUtils.getPackageNameForBindingImpl(port, ns2pkgMap);
        }
        return WSDLUtils.getPackageNameForBindingImpl(definition);
    }

    public static String getPackageNameForBindingImpl(Definition definition) {
        Port port = null;
        if (definition != null) {
            Service service = (Service)definition.getServices().values().iterator().next();
            port = (Port)service.getPorts().values().iterator().next();
        }
        return WSDLUtils.getPackageNameForBindingImpl(port);
    }

    public static String getPackageNameForBindingImpl(Port port) {
        if (port != null) {
            Binding binding = port.getBinding();
            QName bndQName = binding.getQName();
            String namespace = bndQName.getNamespaceURI();
            return WSDLUtils.namespaceURI2PackageName(namespace);
        }
        return "";
    }

    public static String getPortTypeNamespace(Definition definition) {
        String namespace = "";
        if (definition != null) {
            Service service = (Service)definition.getServices().values().iterator().next();
            for (Port port : service.getPorts().values()) {
                int i = 0;
                while (i < port.getExtensibilityElements().size()) {
                    if (port.getExtensibilityElements().get(i) instanceof SOAPAddress) {
                        PortType portType = port.getBinding().getPortType();
                        QName bndQName = portType.getQName();
                        namespace = bndQName.getNamespaceURI();
                    }
                    ++i;
                }
            }
        }
        return namespace;
    }

    public static String getPackageNameForPortType(Definition definition) {
        if (definition != null) {
            String namespace = WSDLUtils.getPortTypeNamespace(definition);
            return WSDLUtils.namespaceURI2PackageName(namespace);
        }
        return "";
    }

    public static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return String.valueOf('_') + keyword;
    }

    public static String getFullyQualifiedPortTypeName(Definition definition) {
        StringBuffer beanName = new StringBuffer();
        beanName.append(WSDLUtils.getPackageNameForPortType(definition));
        beanName.append(DOT);
        beanName.append(WSDLUtils.getPortTypeName(definition));
        return beanName.toString();
    }

    public static String getName(String uri) {
        int slash;
        int bslash = uri.lastIndexOf("\\");
        int i = bslash > (slash = uri.lastIndexOf("/")) ? bslash : slash;
        String fileName = uri.substring(i + 1).replace('?', '.');
        return fileName;
    }

    public static String getWSDLName(String uri) {
        String WSDLName = WSDLUtils.getName(uri).trim();
        if (WSDLName.equals("")) {
            WSDLName = "default.wsdl";
        } else if (!WSDLName.endsWith(".wsdl")) {
            if (WSDLName.toLowerCase().endsWith(".wsdl")) {
                int lastDot = WSDLName.lastIndexOf(DOT);
                WSDLName = String.valueOf(WSDLName.substring(0, lastDot)) + ".wsdl";
            } else {
                WSDLName = String.valueOf(WSDLName) + ".wsdl";
            }
        }
        return WSDLName;
    }

    public static String getPortTypeNameFromBeanName(String beanName) {
        return beanName.substring(beanName.lastIndexOf(46) + 1);
    }

    public static String getPackageName(Service service, Map ns2pkgMap) {
        if (service != null) {
            Object pkg;
            String namespace = service.getQName().getNamespaceURI();
            if (ns2pkgMap != null && (pkg = ns2pkgMap.get(namespace)) != null) {
                return (String)pkg;
            }
            return WSDLUtils.namespaceURI2PackageName(namespace);
        }
        return "";
    }

    public static String getPackageName(Port port, Map ns2pkgMap) {
        if (port != null) {
            return WSDLUtils.getPackageName(port.getBinding(), ns2pkgMap);
        }
        return "";
    }

    public static String getPackageName(Binding binding, Map ns2pkgMap) {
        if (binding != null) {
            Object pkg;
            String namespace = binding.getQName().getNamespaceURI();
            if (ns2pkgMap != null && (pkg = ns2pkgMap.get(namespace)) != null) {
                return (String)pkg;
            }
            return WSDLUtils.namespaceURI2PackageName(namespace);
        }
        return "";
    }

    public static String getPackageName(PortType portType, Map ns2pkgMap) {
        if (portType != null) {
            Object pkg;
            String namespace = portType.getQName().getNamespaceURI();
            if (ns2pkgMap != null && (pkg = ns2pkgMap.get(namespace)) != null) {
                return (String)pkg;
            }
            return WSDLUtils.namespaceURI2PackageName(namespace);
        }
        return "";
    }

    public static String namespaceURI2PackageName(String namespaceURI) {
        return Utils.makePackageName((String)namespaceURI);
    }

    public static String resolveDotInPortName(String name) {
        if (name.indexOf(DOT) < 0) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        boolean afterDot = false;
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == '.') {
                afterDot = true;
            } else if (afterDot) {
                sb.append(name.substring(i, i + 1).toUpperCase());
                afterDot = false;
            } else {
                sb.append(name.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

