/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class EditableDialogCellEditor
extends DialogCellEditor {
    private Text _text;

    public EditableDialogCellEditor() {
    }

    public EditableDialogCellEditor(Composite parent) {
        super(parent);
    }

    public EditableDialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createContents(Composite cell) {
        this._text = new Text(cell, 16384);
        this._text.setFont(cell.getFont());
        this._text.setBackground(cell.getBackground());
        this._text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                EditableDialogCellEditor.this.keyReleaseOccured(e);
                if (EditableDialogCellEditor.this.getControl() == null || EditableDialogCellEditor.this.getControl().isDisposed()) {
                    return;
                }
            }
        });
        this._text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean newValidState = EditableDialogCellEditor.this.isCorrect(EditableDialogCellEditor.this._text.getText());
                if (newValidState) {
                    EditableDialogCellEditor.this.markDirty();
                    EditableDialogCellEditor.this.doSetValue(EditableDialogCellEditor.this._text.getText());
                } else {
                    EditableDialogCellEditor.this.setErrorMessage(MessageFormat.format(EditableDialogCellEditor.this.getErrorMessage(), EditableDialogCellEditor.this._text.getText().toString()));
                }
            }
        });
        return this._text;
    }

    protected void doSetFocus() {
        this._text.setFocus();
        this._text.selectAll();
    }

    protected void updateContents(Object value) {
        if (this._text == null || this._text.isDisposed()) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this._text.setText(text);
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            boolean newValidState = this.isCorrect(this._text.getText());
            if (newValidState) {
                this.markDirty();
                this.doSetValue(this._text.getText());
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this._text.getText().toString()));
            }
            this.fireApplyEditorValue();
        }
        super.keyReleaseOccured(keyEvent);
    }
}

