/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist.href;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.contentassist.href.PathComparator;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.eclipse.wst.xsl.ui.provisional.contentassist.AbstractXSLContentAssistRequest;
import org.w3c.dom.Node;

public class HrefContentAssistRequest
extends AbstractXSLContentAssistRequest {
    private List<IPath> pathList = new ArrayList<IPath>();

    public HrefContentAssistRequest(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ArrayList<ICompletionProposal> getCompletionProposals() {
        this.pathList.clear();
        this.proposals.clear();
        try {
            String text = this.getText();
            int length = this.getCursorPosition() - this.getStartOffset();
            String precedingText = length > 0 && text.length() > length + 1 ? text.substring(1, length) : "";
            IFile editorFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getLocation()));
            editorFile.getProject().accept((IResourceVisitor)new XSLFileResourceVisitor(editorFile, precedingText));
            Collections.sort(this.pathList, new PathComparator());
            for (IPath path : this.pathList) {
                String pathString = path.toString();
                CustomCompletionProposal proposal = new CustomCompletionProposal(pathString, this.getStartOffset() + 1, text.length() - 2, pathString.length(), XSLPluginImageHelper.getInstance().getImage("icons/full/xslt_file.gif"), pathString, null, null, 0, true);
                this.proposals.add(proposal);
            }
        }
        catch (CoreException e) {
            XSLUIPlugin.log(e);
        }
        return this.proposals;
    }

    protected List<ICompletionProposal> sortProposals(List<ICompletionProposal> proposalsIn) {
        return proposalsIn;
    }

    private IPath getRelativePath(IFile relativeTo, IFile file) {
        IPath relPath;
        IPath filePath = file.getFullPath();
        IPath relativeToPath = relativeTo.getFullPath();
        if (filePath.segmentCount() > relativeToPath.segmentCount()) {
            relPath = filePath.removeFirstSegments(filePath.matchingFirstSegments(relativeToPath));
        } else if (filePath.segmentCount() < relativeToPath.segmentCount()) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < relativeToPath.segmentCount() - filePath.segmentCount()) {
                sb.append("../");
                ++i;
            }
            sb.append(file.getName());
            relPath = new Path(sb.toString());
        } else {
            relPath = new Path(file.getName());
        }
        return relPath;
    }

    private final class XSLFileResourceVisitor
    implements IResourceVisitor {
        private final String precedingText;
        private final IFile editorFile;

        private XSLFileResourceVisitor(IFile editorFile, String precedingText) {
            this.precedingText = precedingText;
            this.editorFile = editorFile;
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath path;
            IFile file;
            if (resource.getType() == 1 && XSLCore.isXSLFile((IFile)(file = (IFile)resource)) && !file.equals((Object)this.editorFile) && (path = HrefContentAssistRequest.this.getRelativePath(this.editorFile, file)).toString().startsWith(this.precedingText)) {
                HrefContentAssistRequest.this.pathList.add(path);
            }
            return true;
        }
    }
}

