/* The following code was generated by JFlex 1.4.2 on 22/03/13 04:21 PM */

/*******************************************************************************
 * Copyright (c) 2004, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.wst.css.core.internal.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.wst.css.core.internal.parser.regions.CSSTextRegionFactory;
import org.eclipse.wst.css.core.internal.parserz.CSSRegionContexts;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.2
 * on 22/03/13 04:21 PM from the specification file
 * <tt>CSSTokenizer.jflex</tt>
 */
public class CSSTokenizer implements CSSRegionContexts, ICSSTokenizer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_SELECTOR_ATTRIBUTE_NAME = 26;
  public static final int ST_IMPORT_DELIMITER = 10;
  public static final int ST_DECLARATION_PRE_VALUE = 38;
  public static final int ST_SELECTOR = 22;
  public static final int ST_CHARSET_DELIMITER = 4;
  public static final int ST_DECLARATION_VALUE = 40;
  public static final int ST_PAGE_PSEUDO_PAGE = 16;
  public static final int ST_IMPORT_URI = 6;
  public static final int ST_SELECTOR_ATTRIBUTE_END = 32;
  public static final int ST_SELECTOR_ATTRIBUTE_OPERATOR = 28;
  public static final int ST_DECLARATION = 34;
  public static final int ST_PAGE_DELIMITER = 18;
  public static final int ST_SELECTOR_ATTRIBUTE_VALUE = 30;
  public static final int ST_MEDIA_MEDIUM = 12;
  public static final int ST_CHARSET_NAME = 2;
  public static final int ST_IMPORT_MEDIUM = 8;
  public static final int ST_DECLARATION_SEPARATOR = 36;
  public static final int ST_FONT_FACE_DELIMITER = 20;
  public static final int ST_MEDIA_DELIMITER = 14;
  public static final int ST_SELECTOR_MODIFIER = 24;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9,  9,  9,  0,  0, 10, 10, 11, 11, 12, 12, 13, 13, 
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\17\1\0\1\4\1\20\22\0\1\6\1\31\1\11"+
    "\1\21\1\72\1\73\1\16\1\5\1\25\1\13\1\35\1\15\1\55"+
    "\1\10\1\14\1\34\12\1\1\62\1\50\1\30\1\71\1\32\1\27"+
    "\1\36\1\43\1\26\1\40\1\57\1\46\1\64\1\61\1\41\1\51"+
    "\2\66\1\24\1\52\1\65\1\54\1\53\1\66\1\23\1\44\1\47"+
    "\1\22\5\66\1\67\1\3\1\70\1\72\1\2\1\16\1\42\1\7"+
    "\1\37\1\56\1\45\1\63\1\61\1\41\1\51\2\66\1\24\1\52"+
    "\1\65\1\54\1\53\1\66\1\23\1\44\1\47\1\22\5\66\1\60"+
    "\1\72\1\33\1\72\1\0\uff80\2";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\23\0\1\1\1\2\1\1\1\3\4\1\1\4\1\1"+
    "\1\5\1\1\1\6\1\7\3\1\1\10\3\1\1\11"+
    "\2\1\1\12\1\13\2\1\1\14\1\15\1\16\2\1"+
    "\1\17\1\1\1\3\1\20\1\21\1\22\2\1\1\23"+
    "\1\1\1\24\1\25\4\1\1\26\3\1\1\27\1\30"+
    "\1\31\1\32\4\1\1\33\1\31\2\1\1\32\1\1"+
    "\2\34\1\3\1\0\1\2\1\0\1\35\1\0\1\36"+
    "\10\0\1\6\4\0\1\37\4\0\1\40\4\0\1\11"+
    "\1\0\1\13\1\0\1\16\1\0\1\41\1\0\1\22"+
    "\1\0\1\25\2\0\1\25\3\0\1\26\1\0\1\42"+
    "\2\0\1\43\1\0\1\32\1\44\1\32\2\0\1\45"+
    "\2\0\1\46\2\0\1\32\2\0\1\47\1\2\1\50"+
    "\1\35\1\36\10\0\1\6\1\0\1\37\2\0\1\37"+
    "\2\0\1\40\2\0\1\40\2\0\1\11\1\13\1\16"+
    "\1\22\1\25\1\0\1\25\2\0\1\25\1\0\1\26"+
    "\1\42\1\32\1\0\1\32\1\0\1\45\2\0\1\45"+
    "\1\0\1\46\1\51\1\32\1\0\1\2\1\35\1\36"+
    "\1\52\1\53\5\0\2\6\5\0\1\11\1\13\1\16"+
    "\1\22\1\25\2\0\1\26\1\42\2\32\2\0\1\46"+
    "\1\51\1\0\1\44\1\0\1\2\1\35\1\36\3\0"+
    "\1\54\1\0\1\6\10\0\1\55\1\11\1\13\1\16"+
    "\1\22\1\25\2\0\1\26\1\42\2\32\2\0\1\46"+
    "\2\51\5\0\1\56\1\0\1\2\1\35\1\36\2\0"+
    "\1\57\1\0\1\6\6\0\1\55\2\0\1\11\1\13"+
    "\1\16\1\22\1\25\2\0\1\26\1\42\2\32\2\0"+
    "\1\46\2\51\2\0\1\56\3\0\1\2\1\35\1\36"+
    "\1\0\1\60\1\0\1\6\13\0\1\11\1\13\1\16"+
    "\1\22\1\25\2\0\1\26\1\42\2\32\2\0\1\46"+
    "\2\51\10\0\1\35\1\36\1\61\1\0\1\6\6\0"+
    "\1\55\1\0\1\55\2\0\1\42\1\32\2\0\1\46"+
    "\2\51\2\0\1\56\1\0\1\56\5\0\1\32\1\51"+
    "\4\0\1\62\3\0\1\51\3\0\1\63\12\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[424];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\74\0\170\0\264\0\360\0\u012c\0\u0168\0\u01a4"+
    "\0\u01e0\0\u021c\0\u0258\0\u0294\0\u02d0\0\u030c\0\u0348\0\u0384"+
    "\0\u03c0\0\u03fc\0\u0438\0\u0474\0\u04b0\0\u04ec\0\u0528\0\u0564"+
    "\0\u05a0\0\u05dc\0\u0618\0\u0474\0\u0654\0\u0474\0\u0690\0\u06cc"+
    "\0\u0474\0\u0708\0\u0744\0\u0780\0\u0474\0\u07bc\0\u07f8\0\u0834"+
    "\0\u0870\0\u08ac\0\u08e8\0\u0474\0\u0924\0\u0960\0\u099c\0\u0474"+
    "\0\u0474\0\u09d8\0\u0a14\0\u0a50\0\u0474\0\u0a8c\0\u0ac8\0\u0474"+
    "\0\u0474\0\u0b04\0\u0b40\0\u0b7c\0\u0474\0\u0bb8\0\u0474\0\u0bf4"+
    "\0\u0c30\0\u0c6c\0\u0ca8\0\u0ce4\0\u0d20\0\u0d5c\0\u0d98\0\u0dd4"+
    "\0\u0474\0\u0474\0\u0e10\0\u0e4c\0\u0e88\0\u0ec4\0\u0f00\0\u0f3c"+
    "\0\u0474\0\u0f78\0\u0fb4\0\u0ff0\0\u102c\0\u1068\0\u0654\0\u0474"+
    "\0\u10a4\0\u04ec\0\u10e0\0\u111c\0\u05a0\0\u1158\0\u05dc\0\u1194"+
    "\0\u11d0\0\u120c\0\u1248\0\u1284\0\u12c0\0\u12fc\0\u1338\0\u1374"+
    "\0\u13b0\0\u13ec\0\u0708\0\u1428\0\u0474\0\u0780\0\u1464\0\u07bc"+
    "\0\u14a0\0\u0474\0\u07f8\0\u14dc\0\u1518\0\u08ac\0\u1554\0\u0960"+
    "\0\u1590\0\u0a14\0\u15cc\0\u1608\0\u0474\0\u0b40\0\u1644\0\u0c30"+
    "\0\u1680\0\u0c6c\0\u16bc\0\u0474\0\u0ce4\0\u16f8\0\u0d5c\0\u1734"+
    "\0\u1770\0\u17ac\0\u17e8\0\u1824\0\u0474\0\u0e88\0\u1860\0\u0474"+
    "\0\u189c\0\u0ec4\0\u18d8\0\u0474\0\u0f3c\0\u1914\0\u0ff0\0\u1950"+
    "\0\u198c\0\u19c8\0\u1068\0\u1a04\0\u0474\0\u1a40\0\u0474\0\u1a7c"+
    "\0\u1ab8\0\u1af4\0\u1b30\0\u1b6c\0\u1ba8\0\u1be4\0\u1c20\0\u1c5c"+
    "\0\u1c98\0\u1cd4\0\u1d10\0\u0708\0\u1d4c\0\u1d88\0\u0780\0\u1dc4"+
    "\0\u1e00\0\u07bc\0\u1e3c\0\u1e78\0\u07f8\0\u1eb4\0\u1ef0\0\u1f2c"+
    "\0\u1f68\0\u1fa4\0\u1fe0\0\u201c\0\u2058\0\u0c6c\0\u2094\0\u20d0"+
    "\0\u0ce4\0\u210c\0\u2148\0\u2184\0\u21c0\0\u21fc\0\u2238\0\u2274"+
    "\0\u0ec4\0\u22b0\0\u22ec\0\u0f3c\0\u2328\0\u2364\0\u23a0\0\u23dc"+
    "\0\u2418\0\u2454\0\u2490\0\u24cc\0\u0474\0\u0474\0\u2508\0\u2544"+
    "\0\u2580\0\u25bc\0\u25f8\0\u0474\0\u2634\0\u2670\0\u26ac\0\u26e8"+
    "\0\u2724\0\u2760\0\u279c\0\u27d8\0\u2814\0\u2850\0\u288c\0\u28c8"+
    "\0\u2904\0\u2940\0\u297c\0\u29b8\0\u29f4\0\u2a30\0\u2a6c\0\u2aa8"+
    "\0\u2ae4\0\u2b20\0\u2b5c\0\u2b98\0\u2bd4\0\u2c10\0\u2c4c\0\u2c88"+
    "\0\u2cc4\0\u2d00\0\u0474\0\u2d3c\0\u2d78\0\u2db4\0\u2df0\0\u2e2c"+
    "\0\u2e68\0\u2ea4\0\u2ee0\0\u2f1c\0\u2f58\0\u0474\0\u2f94\0\u2fd0"+
    "\0\u300c\0\u3048\0\u3084\0\u30c0\0\u30fc\0\u3138\0\u3174\0\u31b0"+
    "\0\u31ec\0\u3228\0\u3264\0\u32a0\0\u32dc\0\u3318\0\u3354\0\u3390"+
    "\0\u2b5c\0\u33cc\0\u3408\0\u0474\0\u3444\0\u3480\0\u34bc\0\u34f8"+
    "\0\u3534\0\u3570\0\u0474\0\u35ac\0\u35e8\0\u3624\0\u3660\0\u369c"+
    "\0\u36d8\0\u3714\0\u3750\0\u2ea4\0\u378c\0\u37c8\0\u3804\0\u3840"+
    "\0\u387c\0\u38b8\0\u38f4\0\u3930\0\u396c\0\u39a8\0\u39e4\0\u3a20"+
    "\0\u3a5c\0\u3a98\0\u3ad4\0\u3b10\0\u3b4c\0\u3b88\0\u3bc4\0\u3c00"+
    "\0\u3354\0\u3c3c\0\u3c78\0\u3cb4\0\u3cf0\0\u3d2c\0\u3d68\0\u3da4"+
    "\0\u0474\0\u3de0\0\u3e1c\0\u3e58\0\u3e94\0\u3ed0\0\u3f0c\0\u3f48"+
    "\0\u3f84\0\u3fc0\0\u3ffc\0\u4038\0\u4074\0\u40b0\0\u40ec\0\u4128"+
    "\0\u4164\0\u41a0\0\u41dc\0\u4218\0\u4254\0\u4290\0\u42cc\0\u4308"+
    "\0\u4344\0\u4380\0\u43bc\0\u43f8\0\u4434\0\u4470\0\u44ac\0\u44e8"+
    "\0\u4524\0\u4560\0\u459c\0\u45d8\0\u4614\0\u4650\0\u468c\0\u46c8"+
    "\0\u0474\0\u4704\0\u4740\0\u477c\0\u47b8\0\u47f4\0\u4830\0\u486c"+
    "\0\u48a8\0\u2f1c\0\u48e4\0\u2f58\0\u4920\0\u495c\0\u4998\0\u49d4"+
    "\0\u4a10\0\u4a4c\0\u4a88\0\u4ac4\0\u4b00\0\u4b3c\0\u4b78\0\u33cc"+
    "\0\u4bb4\0\u3408\0\u4bf0\0\u4c2c\0\u4c68\0\u4ca4\0\u4ce0\0\u4d1c"+
    "\0\u4d58\0\u4d94\0\u4dd0\0\u4e0c\0\u4e48\0\u0474\0\u4e84\0\u4ec0"+
    "\0\u4efc\0\u0474\0\u4f38\0\u4f74\0\u4fb0\0\u0474\0\u4fec\0\u5028"+
    "\0\u5064\0\u50a0\0\u50dc\0\u5118\0\u5154\0\u5190\0\u51cc\0\u5208";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[424];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\24\1\25\1\26\1\27\1\24\1\27\1\25\1\30"+
    "\1\24\1\27\1\24\1\31\2\24\2\27\1\32\3\25"+
    "\1\24\1\25\1\24\1\33\2\24\1\34\1\35\1\36"+
    "\1\37\11\25\1\24\4\25\1\24\2\25\1\24\1\25"+
    "\1\40\4\25\1\41\10\24\1\27\1\42\1\27\1\24"+
    "\1\43\1\44\1\27\4\24\2\27\7\24\1\33\2\24"+
    "\1\34\1\35\1\24\1\37\41\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\24\1\45\27\24"+
    "\1\27\1\46\1\27\1\24\1\43\1\47\1\27\4\24"+
    "\2\27\1\24\1\50\5\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\11\24\1\45\25\24\1\51\1\52\1\27"+
    "\1\24\1\27\1\51\1\53\1\24\1\27\4\24\2\27"+
    "\1\24\3\51\1\24\1\51\1\24\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\11\51\1\45\4\51\1\24\2\51"+
    "\1\24\1\51\1\24\4\51\11\24\1\27\1\24\1\27"+
    "\1\24\1\43\1\24\1\27\4\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\24\1\45\4\24"+
    "\1\54\20\24\1\55\1\56\1\27\1\24\1\27\1\55"+
    "\1\57\1\24\1\27\4\24\2\27\1\24\3\55\1\24"+
    "\1\55\1\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\11\55\1\24\4\55\1\24\2\55\1\60\1\55\1\24"+
    "\4\55\11\24\1\27\1\24\1\27\1\24\1\43\1\24"+
    "\1\27\4\24\2\27\7\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\16\24\1\61\2\24\1\60\15\24\1\62"+
    "\1\63\1\27\1\24\1\27\1\62\1\64\1\24\1\27"+
    "\4\24\2\27\1\24\3\62\1\24\1\62\1\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\62\1\24\4\62"+
    "\1\24\2\62\1\65\1\62\1\66\4\62\11\24\1\27"+
    "\1\24\1\27\1\24\1\43\1\24\1\27\4\24\2\27"+
    "\7\24\1\33\2\24\1\34\1\35\1\24\1\37\21\24"+
    "\1\65\17\24\1\67\1\24\1\67\1\24\1\43\1\24"+
    "\1\67\1\24\1\31\1\70\1\24\2\67\1\32\6\24"+
    "\1\33\1\24\1\70\1\34\1\35\1\36\1\37\16\24"+
    "\1\71\2\24\1\65\1\24\1\40\4\24\1\41\6\24"+
    "\1\72\1\73\1\27\1\24\1\27\1\72\1\74\1\24"+
    "\1\27\4\24\2\27\1\24\3\72\1\24\1\72\1\24"+
    "\1\33\2\24\1\34\1\35\1\24\1\37\11\72\1\24"+
    "\4\72\1\24\2\72\1\24\1\72\1\24\4\72\1\24"+
    "\1\75\7\24\1\27\1\24\1\27\1\24\1\43\1\24"+
    "\1\27\4\24\2\27\7\24\1\33\2\24\1\34\1\35"+
    "\1\76\1\37\31\24\1\75\1\77\1\76\3\24\1\100"+
    "\1\101\1\27\1\102\1\27\1\100\1\103\1\104\1\27"+
    "\4\24\2\27\1\24\3\100\1\24\1\100\1\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\100\1\24\4\100"+
    "\1\24\2\100\1\24\1\100\1\24\4\100\11\24\1\27"+
    "\1\24\1\27\1\24\1\43\1\24\1\27\4\24\2\27"+
    "\7\24\1\33\2\24\1\34\1\35\1\24\1\37\31\24"+
    "\1\75\5\24\1\105\1\106\1\27\1\24\1\27\1\105"+
    "\1\107\1\24\1\27\4\24\2\27\1\24\3\105\1\24"+
    "\1\105\1\24\1\33\2\24\1\34\1\35\1\110\1\37"+
    "\11\105\1\111\4\105\1\24\2\105\1\24\1\105\1\24"+
    "\4\105\11\24\1\27\1\24\1\27\1\24\1\43\1\24"+
    "\1\27\4\24\2\27\7\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\11\24\1\111\11\24\1\112\12\24\1\113"+
    "\1\114\1\115\1\27\1\116\1\27\1\114\1\117\1\120"+
    "\1\27\1\121\1\122\1\123\1\24\2\27\1\124\1\125"+
    "\2\114\1\24\1\114\1\24\1\33\1\126\1\24\1\34"+
    "\1\127\1\24\1\37\11\114\1\111\4\114\1\130\2\114"+
    "\1\24\1\114\1\24\4\114\6\24\1\113\1\114\1\115"+
    "\1\131\1\116\1\131\1\114\1\117\1\120\1\131\1\121"+
    "\1\122\1\123\1\24\2\131\1\124\1\125\2\114\1\24"+
    "\1\114\1\24\1\33\1\126\1\24\1\34\1\127\1\24"+
    "\1\37\11\114\1\111\4\114\1\130\2\114\1\24\1\114"+
    "\1\24\4\114\5\24\75\0\2\25\1\132\3\0\2\25"+
    "\11\0\3\25\1\0\1\25\10\0\11\25\1\0\4\25"+
    "\1\0\2\25\1\0\1\25\1\0\4\25\6\0\1\133"+
    "\2\25\1\0\2\25\1\133\2\25\1\0\4\25\2\0"+
    "\16\25\1\133\2\25\1\133\2\25\1\133\10\25\1\133"+
    "\4\25\1\133\10\25\4\0\1\27\1\0\1\27\3\0"+
    "\1\27\4\0\2\27\55\0\1\25\1\132\3\0\1\25"+
    "\1\134\11\0\3\25\1\0\1\25\10\0\11\25\1\0"+
    "\4\25\1\0\2\25\1\0\1\25\1\0\4\25\6\0"+
    "\2\135\1\136\3\0\2\135\11\0\3\135\1\0\1\135"+
    "\10\0\11\135\1\0\4\135\1\0\2\135\1\0\1\135"+
    "\1\0\4\135\6\0\2\137\1\140\3\0\2\137\11\0"+
    "\3\137\1\0\1\137\10\0\11\137\1\0\4\137\1\0"+
    "\2\137\1\0\1\137\1\0\4\137\36\0\1\141\77\0"+
    "\1\142\75\0\2\143\10\0\1\144\1\145\1\146\7\0"+
    "\2\147\11\0\1\150\1\151\3\0\1\150\1\152\11\0"+
    "\3\150\1\0\1\150\10\0\11\150\1\0\4\150\1\0"+
    "\2\150\1\0\1\150\1\0\4\150\6\0\2\153\1\154"+
    "\1\0\1\155\11\153\2\0\53\153\10\0\1\134\64\0"+
    "\2\156\1\157\1\0\4\156\1\155\5\156\2\0\53\156"+
    "\1\0\2\160\1\161\1\0\1\162\11\160\2\0\53\160"+
    "\1\0\2\163\1\164\1\0\4\163\1\162\5\163\2\0"+
    "\53\163\23\0\1\165\51\0\2\51\1\166\3\0\2\51"+
    "\11\0\3\51\1\0\1\51\10\0\11\51\1\0\4\51"+
    "\1\0\2\51\1\0\1\51\1\0\4\51\6\0\1\167"+
    "\2\51\1\0\2\51\1\167\2\51\1\0\4\51\2\0"+
    "\16\51\1\167\2\51\1\167\2\51\1\167\10\51\1\167"+
    "\4\51\1\167\10\51\2\0\1\51\1\166\3\0\1\51"+
    "\1\134\11\0\3\51\1\0\1\51\10\0\11\51\1\0"+
    "\4\51\1\0\2\51\1\0\1\51\1\0\4\51\6\0"+
    "\2\55\1\170\3\0\2\55\11\0\3\55\1\0\1\55"+
    "\10\0\11\55\1\0\4\55\1\0\2\55\1\0\1\55"+
    "\1\0\4\55\6\0\1\171\2\55\1\0\2\55\1\171"+
    "\2\55\1\0\4\55\2\0\16\55\1\171\2\55\1\171"+
    "\2\55\1\171\10\55\1\171\4\55\1\171\10\55\2\0"+
    "\1\55\1\170\3\0\1\55\1\134\11\0\3\55\1\0"+
    "\1\55\10\0\11\55\1\0\4\55\1\0\2\55\1\0"+
    "\1\55\1\0\4\55\6\0\2\62\1\172\3\0\2\62"+
    "\11\0\3\62\1\0\1\62\10\0\11\62\1\0\4\62"+
    "\1\0\2\62\1\0\1\62\1\0\4\62\6\0\1\173"+
    "\2\62\1\0\2\62\1\173\2\62\1\0\4\62\2\0"+
    "\16\62\1\173\2\62\1\173\2\62\1\173\10\62\1\173"+
    "\4\62\1\173\10\62\2\0\1\62\1\172\3\0\1\62"+
    "\1\134\11\0\3\62\1\0\1\62\10\0\11\62\1\0"+
    "\4\62\1\0\2\62\1\0\1\62\1\0\4\62\7\0"+
    "\1\62\1\172\3\0\1\62\1\174\11\0\3\62\1\0"+
    "\1\62\10\0\11\62\1\0\4\62\1\0\2\62\1\0"+
    "\1\62\1\0\4\62\5\0\4\175\1\67\1\175\1\67"+
    "\3\175\1\67\2\175\1\0\1\175\2\67\11\175\1\0"+
    "\1\175\1\0\20\175\1\0\2\175\1\0\13\175\1\0"+
    "\2\72\1\176\3\0\2\72\11\0\3\72\1\0\1\72"+
    "\10\0\11\72\1\0\4\72\1\0\2\72\1\0\1\72"+
    "\1\0\4\72\6\0\1\177\2\72\1\0\2\72\1\177"+
    "\2\72\1\0\4\72\2\0\16\72\1\177\2\72\1\177"+
    "\2\72\1\177\10\72\1\177\4\72\1\177\10\72\2\0"+
    "\1\72\1\176\3\0\1\72\1\134\11\0\3\72\1\0"+
    "\1\72\10\0\11\72\1\0\4\72\1\0\2\72\1\0"+
    "\1\72\1\0\4\72\76\0\1\77\3\0\2\100\1\200"+
    "\3\0\2\100\11\0\3\100\1\0\1\100\10\0\11\100"+
    "\1\0\4\100\1\0\2\100\1\0\1\100\1\0\4\100"+
    "\6\0\1\201\2\100\1\0\2\100\1\201\2\100\1\0"+
    "\4\100\2\0\16\100\1\201\2\100\1\201\2\100\1\201"+
    "\10\100\1\201\4\100\1\201\10\100\1\0\2\202\1\203"+
    "\1\0\1\204\11\202\2\0\53\202\2\0\1\100\1\200"+
    "\3\0\1\100\1\134\11\0\3\100\1\0\1\100\10\0"+
    "\11\100\1\0\4\100\1\0\2\100\1\0\1\100\1\0"+
    "\4\100\6\0\2\205\1\206\1\0\4\205\1\204\5\205"+
    "\2\0\53\205\1\0\2\105\1\207\3\0\2\105\11\0"+
    "\3\105\1\0\1\105\10\0\11\105\1\0\4\105\1\0"+
    "\2\105\1\0\1\105\1\0\4\105\6\0\1\210\2\105"+
    "\1\0\2\105\1\210\2\105\1\0\4\105\2\0\16\105"+
    "\1\210\2\105\1\210\2\105\1\210\10\105\1\210\4\105"+
    "\1\210\10\105\2\0\1\105\1\207\3\0\1\105\1\134"+
    "\11\0\3\105\1\0\1\105\10\0\11\105\1\0\4\105"+
    "\1\0\2\105\1\0\1\105\1\0\4\105\7\0\1\105"+
    "\1\207\3\0\1\105\1\211\11\0\3\105\1\0\1\105"+
    "\10\0\11\105\1\0\4\105\1\0\2\105\1\0\1\105"+
    "\1\0\4\105\6\0\1\113\1\212\1\213\3\0\1\212"+
    "\1\214\3\0\1\122\5\0\3\212\1\0\1\212\10\0"+
    "\11\212\1\0\4\212\1\0\2\212\1\0\1\212\1\0"+
    "\4\212\4\0\1\215\1\0\2\114\1\216\3\0\2\114"+
    "\3\0\1\217\5\0\3\114\1\220\1\114\10\0\11\114"+
    "\1\0\4\114\1\0\2\114\1\0\1\114\1\0\4\114"+
    "\6\0\1\221\2\114\1\0\2\114\1\221\2\114\1\0"+
    "\4\114\2\0\16\114\1\221\2\114\1\221\2\114\1\221"+
    "\10\114\1\221\4\114\1\221\10\114\1\0\2\222\1\223"+
    "\1\0\1\224\11\222\2\0\53\222\1\0\1\113\1\114"+
    "\1\216\3\0\1\114\1\134\3\0\1\122\5\0\3\114"+
    "\1\0\1\114\10\0\11\114\1\0\4\114\1\0\2\114"+
    "\1\0\1\114\1\0\4\114\6\0\2\225\1\226\1\0"+
    "\4\225\1\224\5\225\2\0\53\225\1\0\1\122\1\212"+
    "\1\213\3\0\1\212\1\214\11\0\3\212\1\0\1\212"+
    "\10\0\11\212\1\0\4\212\1\0\2\212\1\0\1\212"+
    "\1\0\4\212\4\0\1\215\1\0\1\113\12\0\1\122"+
    "\60\0\2\227\1\230\3\0\2\227\11\0\3\227\1\0"+
    "\1\227\10\0\11\227\1\0\4\227\1\0\2\227\1\0"+
    "\1\227\1\0\4\227\6\0\2\114\1\216\3\0\2\114"+
    "\3\0\1\217\1\231\4\0\1\114\1\232\1\114\1\220"+
    "\1\114\10\0\11\114\1\0\4\114\1\0\2\114\1\0"+
    "\1\114\1\0\4\114\11\0\1\233\1\0\1\233\3\0"+
    "\1\233\4\0\2\233\30\0\1\234\22\0\4\235\1\131"+
    "\1\235\1\131\3\235\1\131\4\235\2\131\12\235\1\0"+
    "\14\235\1\0\23\235\1\0\1\236\1\25\1\132\1\25"+
    "\1\0\1\25\1\236\1\25\1\0\1\25\4\0\2\25"+
    "\1\0\3\25\1\0\1\25\10\0\1\236\2\25\1\236"+
    "\2\25\1\236\2\25\1\0\4\25\1\0\1\236\1\25"+
    "\1\0\1\25\1\0\1\236\3\25\37\0\1\237\42\0"+
    "\1\240\2\135\1\0\2\135\1\240\2\135\1\0\4\135"+
    "\2\0\16\135\1\240\2\135\1\240\2\135\1\240\10\135"+
    "\1\240\4\135\1\240\10\135\1\0\1\241\2\137\1\0"+
    "\2\137\1\241\2\137\1\0\4\137\2\0\16\137\1\241"+
    "\2\137\1\241\2\137\1\241\10\137\1\241\4\137\1\241"+
    "\10\137\10\0\1\242\63\0\35\142\1\243\36\142\41\0"+
    "\1\244\104\0\1\245\66\0\2\246\67\0\2\247\104\0"+
    "\1\250\20\0\2\150\1\151\3\0\2\150\11\0\3\150"+
    "\1\251\1\150\10\0\11\150\1\0\4\150\1\0\2\150"+
    "\1\0\1\150\1\0\4\150\6\0\1\252\2\150\1\0"+
    "\2\150\1\252\2\150\1\0\4\150\2\0\16\150\1\252"+
    "\2\150\1\252\2\150\1\252\10\150\1\252\4\150\1\252"+
    "\10\150\2\0\1\150\1\151\3\0\1\150\12\0\3\150"+
    "\1\0\1\150\10\0\11\150\1\0\4\150\1\0\2\150"+
    "\1\0\1\150\1\0\4\150\6\0\1\253\1\153\1\154"+
    "\1\153\1\254\1\153\1\253\10\153\1\255\16\153\1\253"+
    "\2\153\1\253\2\153\1\253\10\153\1\253\4\153\1\253"+
    "\10\153\1\0\1\256\1\156\1\157\3\156\1\256\1\156"+
    "\1\257\6\156\1\260\16\156\1\256\2\156\1\256\2\156"+
    "\1\256\10\156\1\256\4\156\1\256\10\156\1\0\1\261"+
    "\1\160\1\161\1\160\1\262\1\160\1\261\10\160\1\263"+
    "\16\160\1\261\2\160\1\261\2\160\1\261\10\160\1\261"+
    "\4\160\1\261\10\160\1\0\1\264\1\163\1\164\3\163"+
    "\1\264\1\163\1\265\6\163\1\266\16\163\1\264\2\163"+
    "\1\264\2\163\1\264\10\163\1\264\4\163\1\264\10\163"+
    "\24\0\1\267\50\0\1\270\1\51\1\166\1\51\1\0"+
    "\1\51\1\270\1\51\1\0\1\51\4\0\2\51\1\0"+
    "\3\51\1\0\1\51\10\0\1\270\2\51\1\270\2\51"+
    "\1\270\2\51\1\0\4\51\1\0\1\270\1\51\1\0"+
    "\1\51\1\0\1\270\3\51\6\0\1\271\1\55\1\170"+
    "\1\55\1\0\1\55\1\271\1\55\1\0\1\55\4\0"+
    "\2\55\1\0\3\55\1\0\1\55\10\0\1\271\2\55"+
    "\1\271\2\55\1\271\2\55\1\0\4\55\1\0\1\271"+
    "\1\55\1\0\1\55\1\0\1\271\3\55\6\0\1\272"+
    "\1\62\1\172\1\62\1\0\1\62\1\272\1\62\1\0"+
    "\1\62\4\0\2\62\1\0\3\62\1\0\1\62\10\0"+
    "\1\272\2\62\1\272\2\62\1\272\2\62\1\0\4\62"+
    "\1\0\1\272\1\62\1\0\1\62\1\0\1\272\3\62"+
    "\7\0\1\62\1\172\3\0\1\62\12\0\3\62\1\0"+
    "\1\62\10\0\11\62\1\0\4\62\1\0\2\62\1\0"+
    "\1\62\1\0\4\62\6\0\1\273\1\72\1\176\1\72"+
    "\1\0\1\72\1\273\1\72\1\0\1\72\4\0\2\72"+
    "\1\0\3\72\1\0\1\72\10\0\1\273\2\72\1\273"+
    "\2\72\1\273\2\72\1\0\4\72\1\0\1\273\1\72"+
    "\1\0\1\72\1\0\1\273\3\72\6\0\1\274\1\100"+
    "\1\200\1\100\1\0\1\100\1\274\1\100\1\0\1\100"+
    "\4\0\2\100\1\0\3\100\1\0\1\100\10\0\1\274"+
    "\2\100\1\274\2\100\1\274\2\100\1\0\4\100\1\0"+
    "\1\274\1\100\1\0\1\100\1\0\1\274\3\100\6\0"+
    "\1\275\1\202\1\203\1\202\1\276\1\202\1\275\10\202"+
    "\1\277\16\202\1\275\2\202\1\275\2\202\1\275\10\202"+
    "\1\275\4\202\1\275\10\202\1\0\1\300\1\205\1\206"+
    "\3\205\1\300\1\205\1\301\6\205\1\302\16\205\1\300"+
    "\2\205\1\300\2\205\1\300\10\205\1\300\4\205\1\300"+
    "\10\205\1\0\1\303\1\105\1\207\1\105\1\0\1\105"+
    "\1\303\1\105\1\0\1\105\4\0\2\105\1\0\3\105"+
    "\1\0\1\105\10\0\1\303\2\105\1\303\2\105\1\303"+
    "\2\105\1\0\4\105\1\0\1\303\1\105\1\0\1\105"+
    "\1\0\1\303\3\105\7\0\1\105\1\207\3\0\1\105"+
    "\12\0\3\105\1\0\1\105\10\0\11\105\1\0\4\105"+
    "\1\0\2\105\1\0\1\105\1\0\4\105\6\0\2\212"+
    "\1\213\3\0\2\212\11\0\3\212\1\0\1\212\10\0"+
    "\11\212\1\0\4\212\1\0\2\212\1\0\1\212\1\0"+
    "\4\212\6\0\1\304\2\212\1\0\2\212\1\304\2\212"+
    "\1\0\4\212\2\0\16\212\1\304\2\212\1\304\2\212"+
    "\1\304\10\212\1\304\4\212\1\304\10\212\2\0\1\212"+
    "\1\213\3\0\1\212\12\0\3\212\1\0\1\212\10\0"+
    "\11\212\1\0\4\212\1\0\2\212\1\0\1\212\1\0"+
    "\4\212\6\0\2\305\1\306\3\0\2\305\11\0\3\305"+
    "\1\0\1\305\10\0\11\305\1\0\4\305\1\0\2\305"+
    "\1\0\1\305\1\0\4\305\6\0\1\307\1\114\1\216"+
    "\1\114\1\0\1\114\1\307\1\114\1\0\1\114\1\0"+
    "\1\217\2\0\2\114\1\0\3\114\1\220\1\114\10\0"+
    "\1\307\2\114\1\307\2\114\1\307\2\114\1\0\4\114"+
    "\1\0\1\307\1\114\1\0\1\114\1\0\1\307\3\114"+
    "\6\0\1\310\1\222\1\223\1\222\1\311\1\222\1\310"+
    "\10\222\1\312\16\222\1\310\2\222\1\310\2\222\1\310"+
    "\10\222\1\310\4\222\1\310\10\222\1\0\1\313\1\225"+
    "\1\226\3\225\1\313\1\225\1\314\6\225\1\315\16\225"+
    "\1\313\2\225\1\313\2\225\1\313\10\225\1\313\4\225"+
    "\1\313\10\225\1\0\1\316\2\227\1\0\2\227\1\316"+
    "\2\227\1\0\4\227\2\0\16\227\1\316\2\227\1\316"+
    "\2\227\1\316\10\227\1\316\4\227\1\316\10\227\1\0"+
    "\1\317\5\0\1\317\16\0\2\317\7\0\2\317\1\0"+
    "\2\317\1\0\2\317\7\0\2\317\3\0\2\317\10\0"+
    "\2\114\1\216\3\0\2\114\3\0\1\217\5\0\2\114"+
    "\1\320\1\220\1\114\10\0\11\114\1\0\4\114\1\0"+
    "\2\114\1\0\1\114\1\0\4\114\57\0\1\321\22\0"+
    "\1\322\1\25\1\132\1\25\1\0\1\25\1\322\1\25"+
    "\1\0\1\25\4\0\2\25\1\0\3\25\1\0\1\25"+
    "\10\0\1\322\2\25\1\322\2\25\1\322\2\25\1\0"+
    "\4\25\1\0\1\322\1\25\1\0\1\25\1\0\1\322"+
    "\3\25\6\0\1\323\1\135\1\136\1\135\1\0\1\135"+
    "\1\323\1\135\1\0\1\135\4\0\2\135\1\0\3\135"+
    "\1\0\1\135\10\0\1\323\2\135\1\323\2\135\1\323"+
    "\2\135\1\0\4\135\1\0\1\323\1\135\1\0\1\135"+
    "\1\0\1\323\3\135\6\0\1\324\1\137\1\140\1\137"+
    "\1\0\1\137\1\324\1\137\1\0\1\137\4\0\2\137"+
    "\1\0\3\137\1\0\1\137\10\0\1\324\2\137\1\324"+
    "\2\137\1\324\2\137\1\0\4\137\1\0\1\324\1\137"+
    "\1\0\1\137\1\0\1\324\3\137\15\0\1\325\63\0"+
    "\34\142\1\326\1\243\36\142\42\0\2\327\103\0\1\330"+
    "\76\0\2\331\75\0\1\332\77\0\1\333\7\0\1\251"+
    "\2\0\1\251\1\0\3\251\1\0\1\251\1\334\1\0"+
    "\1\251\1\0\2\251\1\0\3\251\1\0\1\251\10\0"+
    "\11\251\1\0\4\251\1\0\2\251\1\0\1\251\1\0"+
    "\4\251\6\0\1\335\1\150\1\151\1\150\1\0\1\150"+
    "\1\335\1\150\1\0\1\150\4\0\2\150\1\0\3\150"+
    "\1\251\1\150\10\0\1\335\2\150\1\335\2\150\1\335"+
    "\2\150\1\0\4\150\1\0\1\335\1\150\1\0\1\150"+
    "\1\0\1\335\3\150\6\0\1\336\1\153\1\154\1\153"+
    "\1\155\1\153\1\336\27\153\1\336\2\153\1\336\2\153"+
    "\1\336\10\153\1\336\4\153\1\336\10\153\1\0\2\153"+
    "\1\154\1\0\1\155\12\153\1\0\53\153\1\0\1\337"+
    "\1\156\1\157\3\156\1\337\1\156\1\155\25\156\1\337"+
    "\2\156\1\337\2\156\1\337\10\156\1\337\4\156\1\337"+
    "\10\156\1\0\2\156\1\157\1\0\4\156\1\155\6\156"+
    "\1\0\53\156\1\0\1\340\1\160\1\161\1\160\1\162"+
    "\1\160\1\340\27\160\1\340\2\160\1\340\2\160\1\340"+
    "\10\160\1\340\4\160\1\340\10\160\1\0\2\160\1\161"+
    "\1\0\1\162\12\160\1\0\53\160\1\0\1\341\1\163"+
    "\1\164\3\163\1\341\1\163\1\162\25\163\1\341\2\163"+
    "\1\341\2\163\1\341\10\163\1\341\4\163\1\341\10\163"+
    "\1\0\2\163\1\164\1\0\4\163\1\162\6\163\1\0"+
    "\53\163\25\0\1\342\47\0\1\343\1\51\1\166\1\51"+
    "\1\0\1\51\1\343\1\51\1\0\1\51\4\0\2\51"+
    "\1\0\3\51\1\0\1\51\10\0\1\343\2\51\1\343"+
    "\2\51\1\343\2\51\1\0\4\51\1\0\1\343\1\51"+
    "\1\0\1\51\1\0\1\343\3\51\6\0\1\344\1\55"+
    "\1\170\1\55\1\0\1\55\1\344\1\55\1\0\1\55"+
    "\4\0\2\55\1\0\3\55\1\0\1\55\10\0\1\344"+
    "\2\55\1\344\2\55\1\344\2\55\1\0\4\55\1\0"+
    "\1\344\1\55\1\0\1\55\1\0\1\344\3\55\6\0"+
    "\1\345\1\62\1\172\1\62\1\0\1\62\1\345\1\62"+
    "\1\0\1\62\4\0\2\62\1\0\3\62\1\0\1\62"+
    "\10\0\1\345\2\62\1\345\2\62\1\345\2\62\1\0"+
    "\4\62\1\0\1\345\1\62\1\0\1\62\1\0\1\345"+
    "\3\62\6\0\1\346\1\72\1\176\1\72\1\0\1\72"+
    "\1\346\1\72\1\0\1\72\4\0\2\72\1\0\3\72"+
    "\1\0\1\72\10\0\1\346\2\72\1\346\2\72\1\346"+
    "\2\72\1\0\4\72\1\0\1\346\1\72\1\0\1\72"+
    "\1\0\1\346\3\72\6\0\1\347\1\100\1\200\1\100"+
    "\1\0\1\100\1\347\1\100\1\0\1\100\4\0\2\100"+
    "\1\0\3\100\1\0\1\100\10\0\1\347\2\100\1\347"+
    "\2\100\1\347\2\100\1\0\4\100\1\0\1\347\1\100"+
    "\1\0\1\100\1\0\1\347\3\100\6\0\1\350\1\202"+
    "\1\203\1\202\1\204\1\202\1\350\27\202\1\350\2\202"+
    "\1\350\2\202\1\350\10\202\1\350\4\202\1\350\10\202"+
    "\1\0\2\202\1\203\1\0\1\204\12\202\1\0\53\202"+
    "\1\0\1\351\1\205\1\206\3\205\1\351\1\205\1\204"+
    "\25\205\1\351\2\205\1\351\2\205\1\351\10\205\1\351"+
    "\4\205\1\351\10\205\1\0\2\205\1\206\1\0\4\205"+
    "\1\204\6\205\1\0\53\205\1\0\1\352\1\105\1\207"+
    "\1\105\1\0\1\105\1\352\1\105\1\0\1\105\4\0"+
    "\2\105\1\0\3\105\1\0\1\105\10\0\1\352\2\105"+
    "\1\352\2\105\1\352\2\105\1\0\4\105\1\0\1\352"+
    "\1\105\1\0\1\105\1\0\1\352\3\105\6\0\1\353"+
    "\1\212\1\213\1\212\1\0\1\212\1\353\1\212\1\0"+
    "\1\212\4\0\2\212\1\0\3\212\1\0\1\212\10\0"+
    "\1\353\2\212\1\353\2\212\1\353\2\212\1\0\4\212"+
    "\1\0\1\353\1\212\1\0\1\212\1\0\1\353\3\212"+
    "\6\0\2\305\1\306\3\0\2\305\3\0\1\217\5\0"+
    "\3\305\1\0\1\305\10\0\11\305\1\0\4\305\1\0"+
    "\2\305\1\0\1\305\1\0\4\305\6\0\1\354\2\305"+
    "\1\0\2\305\1\354\2\305\1\0\4\305\2\0\16\305"+
    "\1\354\2\305\1\354\2\305\1\354\10\305\1\354\4\305"+
    "\1\354\10\305\1\0\1\355\1\114\1\216\1\114\1\0"+
    "\1\114\1\355\1\114\1\0\1\114\1\0\1\217\2\0"+
    "\2\114\1\0\3\114\1\220\1\114\10\0\1\355\2\114"+
    "\1\355\2\114\1\355\2\114\1\0\4\114\1\0\1\355"+
    "\1\114\1\0\1\114\1\0\1\355\3\114\6\0\1\356"+
    "\1\222\1\223\1\222\1\224\1\222\1\356\27\222\1\356"+
    "\2\222\1\356\2\222\1\356\10\222\1\356\4\222\1\356"+
    "\10\222\1\0\2\222\1\223\1\0\1\224\12\222\1\0"+
    "\53\222\1\0\1\357\1\225\1\226\3\225\1\357\1\225"+
    "\1\224\25\225\1\357\2\225\1\357\2\225\1\357\10\225"+
    "\1\357\4\225\1\357\10\225\1\0\2\225\1\226\1\0"+
    "\4\225\1\224\6\225\1\0\53\225\1\0\1\360\1\227"+
    "\1\230\1\227\1\0\1\227\1\360\1\227\1\0\1\227"+
    "\4\0\2\227\1\0\3\227\1\0\1\227\10\0\1\360"+
    "\2\227\1\360\2\227\1\360\2\227\1\0\4\227\1\0"+
    "\1\360\1\227\1\0\1\227\1\0\1\360\3\227\6\0"+
    "\1\361\5\0\1\361\1\362\15\0\2\361\7\0\2\361"+
    "\1\0\2\361\1\0\2\361\7\0\2\361\3\0\2\361"+
    "\10\0\2\114\1\216\3\0\2\114\3\0\1\217\5\0"+
    "\3\114\1\363\1\114\10\0\11\114\1\0\4\114\1\0"+
    "\2\114\1\0\1\114\1\0\4\114\60\0\1\364\21\0"+
    "\1\365\1\25\1\132\1\25\1\0\1\25\1\365\1\25"+
    "\1\0\1\25\4\0\2\25\1\0\3\25\1\0\1\25"+
    "\10\0\1\365\2\25\1\365\2\25\1\365\2\25\1\0"+
    "\4\25\1\0\1\365\1\25\1\0\1\25\1\0\1\365"+
    "\3\25\6\0\1\366\1\135\1\136\1\135\1\0\1\135"+
    "\1\366\1\135\1\0\1\135\4\0\2\135\1\0\3\135"+
    "\1\0\1\135\10\0\1\366\2\135\1\366\2\135\1\366"+
    "\2\135\1\0\4\135\1\0\1\366\1\135\1\0\1\135"+
    "\1\0\1\366\3\135\6\0\1\367\1\137\1\140\1\137"+
    "\1\0\1\137\1\367\1\137\1\0\1\137\4\0\2\137"+
    "\1\0\3\137\1\0\1\137\10\0\1\367\2\137\1\367"+
    "\2\137\1\367\2\137\1\0\4\137\1\0\1\367\1\137"+
    "\1\0\1\137\1\0\1\367\3\137\30\0\1\370\124\0"+
    "\1\371\70\0\1\372\67\0\2\373\74\0\1\374\25\0"+
    "\1\375\1\150\1\151\1\150\1\0\1\150\1\375\1\150"+
    "\1\0\1\150\4\0\2\150\1\0\3\150\1\251\1\150"+
    "\10\0\1\375\2\150\1\375\2\150\1\375\2\150\1\0"+
    "\4\150\1\0\1\375\1\150\1\0\1\150\1\0\1\375"+
    "\3\150\6\0\1\376\1\153\1\154\1\153\1\155\1\153"+
    "\1\376\27\153\1\376\2\153\1\376\2\153\1\376\10\153"+
    "\1\376\4\153\1\376\10\153\1\0\1\377\1\156\1\157"+
    "\3\156\1\377\1\156\1\155\25\156\1\377\2\156\1\377"+
    "\2\156\1\377\10\156\1\377\4\156\1\377\10\156\1\0"+
    "\1\u0100\1\160\1\161\1\160\1\162\1\160\1\u0100\27\160"+
    "\1\u0100\2\160\1\u0100\2\160\1\u0100\10\160\1\u0100\4\160"+
    "\1\u0100\10\160\1\0\1\u0101\1\163\1\164\3\163\1\u0101"+
    "\1\163\1\162\25\163\1\u0101\2\163\1\u0101\2\163\1\u0101"+
    "\10\163\1\u0101\4\163\1\u0101\10\163\1\0\2\u0102\1\u0103"+
    "\1\342\1\u0104\1\342\2\u0102\1\u0105\1\342\1\u0106\3\u0102"+
    "\2\342\4\u0102\1\0\46\u0102\1\0\1\u0107\1\51\1\166"+
    "\1\51\1\0\1\51\1\u0107\1\51\1\0\1\51\4\0"+
    "\2\51\1\0\3\51\1\0\1\51\10\0\1\u0107\2\51"+
    "\1\u0107\2\51\1\u0107\2\51\1\0\4\51\1\0\1\u0107"+
    "\1\51\1\0\1\51\1\0\1\u0107\3\51\6\0\1\u0108"+
    "\1\55\1\170\1\55\1\0\1\55\1\u0108\1\55\1\0"+
    "\1\55\4\0\2\55\1\0\3\55\1\0\1\55\10\0"+
    "\1\u0108\2\55\1\u0108\2\55\1\u0108\2\55\1\0\4\55"+
    "\1\0\1\u0108\1\55\1\0\1\55\1\0\1\u0108\3\55"+
    "\6\0\1\u0109\1\62\1\172\1\62\1\0\1\62\1\u0109"+
    "\1\62\1\0\1\62\4\0\2\62\1\0\3\62\1\0"+
    "\1\62\10\0\1\u0109\2\62\1\u0109\2\62\1\u0109\2\62"+
    "\1\0\4\62\1\0\1\u0109\1\62\1\0\1\62\1\0"+
    "\1\u0109\3\62\6\0\1\u010a\1\72\1\176\1\72\1\0"+
    "\1\72\1\u010a\1\72\1\0\1\72\4\0\2\72\1\0"+
    "\3\72\1\0\1\72\10\0\1\u010a\2\72\1\u010a\2\72"+
    "\1\u010a\2\72\1\0\4\72\1\0\1\u010a\1\72\1\0"+
    "\1\72\1\0\1\u010a\3\72\6\0\1\u010b\1\100\1\200"+
    "\1\100\1\0\1\100\1\u010b\1\100\1\0\1\100\4\0"+
    "\2\100\1\0\3\100\1\0\1\100\10\0\1\u010b\2\100"+
    "\1\u010b\2\100\1\u010b\2\100\1\0\4\100\1\0\1\u010b"+
    "\1\100\1\0\1\100\1\0\1\u010b\3\100\6\0\1\u010c"+
    "\1\202\1\203\1\202\1\204\1\202\1\u010c\27\202\1\u010c"+
    "\2\202\1\u010c\2\202\1\u010c\10\202\1\u010c\4\202\1\u010c"+
    "\10\202\1\0\1\u010d\1\205\1\206\3\205\1\u010d\1\205"+
    "\1\204\25\205\1\u010d\2\205\1\u010d\2\205\1\u010d\10\205"+
    "\1\u010d\4\205\1\u010d\10\205\1\0\1\u010e\1\105\1\207"+
    "\1\105\1\0\1\105\1\u010e\1\105\1\0\1\105\4\0"+
    "\2\105\1\0\3\105\1\0\1\105\10\0\1\u010e\2\105"+
    "\1\u010e\2\105\1\u010e\2\105\1\0\4\105\1\0\1\u010e"+
    "\1\105\1\0\1\105\1\0\1\u010e\3\105\6\0\1\u010f"+
    "\1\212\1\213\1\212\1\0\1\212\1\u010f\1\212\1\0"+
    "\1\212\4\0\2\212\1\0\3\212\1\0\1\212\10\0"+
    "\1\u010f\2\212\1\u010f\2\212\1\u010f\2\212\1\0\4\212"+
    "\1\0\1\u010f\1\212\1\0\1\212\1\0\1\u010f\3\212"+
    "\6\0\1\u0110\1\305\1\306\1\305\1\0\1\305\1\u0110"+
    "\1\305\1\0\1\305\1\0\1\217\2\0\2\305\1\0"+
    "\3\305\1\0\1\305\10\0\1\u0110\2\305\1\u0110\2\305"+
    "\1\u0110\2\305\1\0\4\305\1\0\1\u0110\1\305\1\0"+
    "\1\305\1\0\1\u0110\3\305\6\0\1\u0111\1\114\1\216"+
    "\1\114\1\0\1\114\1\u0111\1\114\1\0\1\114\1\0"+
    "\1\217\2\0\2\114\1\0\3\114\1\220\1\114\10\0"+
    "\1\u0111\2\114\1\u0111\2\114\1\u0111\2\114\1\0\4\114"+
    "\1\0\1\u0111\1\114\1\0\1\114\1\0\1\u0111\3\114"+
    "\6\0\1\u0112\1\222\1\223\1\222\1\224\1\222\1\u0112"+
    "\27\222\1\u0112\2\222\1\u0112\2\222\1\u0112\10\222\1\u0112"+
    "\4\222\1\u0112\10\222\1\0\1\u0113\1\225\1\226\3\225"+
    "\1\u0113\1\225\1\224\25\225\1\u0113\2\225\1\u0113\2\225"+
    "\1\u0113\10\225\1\u0113\4\225\1\u0113\10\225\1\0\1\u0114"+
    "\1\227\1\230\1\227\1\0\1\227\1\u0114\1\227\1\0"+
    "\1\227\4\0\2\227\1\0\3\227\1\0\1\227\10\0"+
    "\1\u0114\2\227\1\u0114\2\227\1\u0114\2\227\1\0\4\227"+
    "\1\0\1\u0114\1\227\1\0\1\227\1\0\1\u0114\3\227"+
    "\6\0\1\u0115\5\0\1\u0115\1\362\15\0\2\u0115\7\0"+
    "\2\u0115\1\0\2\u0115\1\0\2\u0115\7\0\2\u0115\3\0"+
    "\2\u0115\10\0\1\u0116\5\0\1\u0116\16\0\2\u0116\7\0"+
    "\2\u0116\1\0\2\u0116\1\0\2\u0116\7\0\2\u0116\3\0"+
    "\2\u0116\10\0\2\u0117\1\u0118\1\u0119\1\u011a\1\u0119\2\u0117"+
    "\1\u011b\1\u0119\1\u011c\3\u0117\2\u0119\4\u0117\1\0\46\u0117"+
    "\54\0\1\u011d\20\0\1\u011e\1\25\1\132\1\25\1\0"+
    "\1\25\1\u011e\1\25\1\0\1\25\4\0\2\25\1\0"+
    "\3\25\1\0\1\25\10\0\1\u011e\2\25\1\u011e\2\25"+
    "\1\u011e\2\25\1\0\4\25\1\0\1\u011e\1\25\1\0"+
    "\1\25\1\0\1\u011e\3\25\6\0\1\u011f\1\135\1\136"+
    "\1\135\1\0\1\135\1\u011f\1\135\1\0\1\135\4\0"+
    "\2\135\1\0\3\135\1\0\1\135\10\0\1\u011f\2\135"+
    "\1\u011f\2\135\1\u011f\2\135\1\0\4\135\1\0\1\u011f"+
    "\1\135\1\0\1\135\1\0\1\u011f\3\135\6\0\1\u0120"+
    "\1\137\1\140\1\137\1\0\1\137\1\u0120\1\137\1\0"+
    "\1\137\4\0\2\137\1\0\3\137\1\0\1\137\10\0"+
    "\1\u0120\2\137\1\u0120\2\137\1\u0120\2\137\1\0\4\137"+
    "\1\0\1\u0120\1\137\1\0\1\137\1\0\1\u0120\3\137"+
    "\51\0\1\u0121\52\0\1\u0122\112\0\2\u0123\40\0\1\u0124"+
    "\64\0\1\u0125\1\150\1\151\1\150\1\0\1\150\1\u0125"+
    "\1\150\1\0\1\150\4\0\2\150\1\0\3\150\1\251"+
    "\1\150\10\0\1\u0125\2\150\1\u0125\2\150\1\u0125\2\150"+
    "\1\0\4\150\1\0\1\u0125\1\150\1\0\1\150\1\0"+
    "\1\u0125\3\150\6\0\1\u0126\1\153\1\154\1\153\1\155"+
    "\1\153\1\u0126\27\153\1\u0126\2\153\1\u0126\2\153\1\u0126"+
    "\10\153\1\u0126\4\153\1\u0126\10\153\1\0\1\u0127\1\156"+
    "\1\157\3\156\1\u0127\1\156\1\155\25\156\1\u0127\2\156"+
    "\1\u0127\2\156\1\u0127\10\156\1\u0127\4\156\1\u0127\10\156"+
    "\1\0\1\u0128\1\160\1\161\1\160\1\162\1\160\1\u0128"+
    "\27\160\1\u0128\2\160\1\u0128\2\160\1\u0128\10\160\1\u0128"+
    "\4\160\1\u0128\10\160\1\0\1\u0129\1\163\1\164\3\163"+
    "\1\u0129\1\163\1\162\25\163\1\u0129\2\163\1\u0129\2\163"+
    "\1\u0129\10\163\1\u0129\4\163\1\u0129\10\163\1\0\2\u0102"+
    "\1\u0103\1\u012a\1\0\3\u0102\1\0\1\u012a\1\u0106\3\u0102"+
    "\2\u012a\4\u0102\1\0\46\u0102\1\0\1\u012b\1\u0102\1\u0103"+
    "\1\u012a\2\u0102\1\u012b\2\u0102\1\u012a\1\u012c\3\u0102\2\u012a"+
    "\16\u0102\1\u012b\2\u0102\1\u012b\2\u0102\1\u012b\10\u0102\1\u012b"+
    "\4\u0102\1\u012b\10\u0102\1\0\2\u0104\1\u012d\1\0\1\u012a"+
    "\11\u0104\2\0\53\u0104\1\0\2\u0105\1\u012e\1\0\4\u0105"+
    "\1\u012a\5\u0105\2\0\53\u0105\1\0\1\u012f\1\51\1\166"+
    "\1\51\1\0\1\51\1\u012f\1\51\1\0\1\51\4\0"+
    "\2\51\1\0\3\51\1\0\1\51\10\0\1\u012f\2\51"+
    "\1\u012f\2\51\1\u012f\2\51\1\0\4\51\1\0\1\u012f"+
    "\1\51\1\0\1\51\1\0\1\u012f\3\51\6\0\1\u0130"+
    "\1\55\1\170\1\55\1\0\1\55\1\u0130\1\55\1\0"+
    "\1\55\4\0\2\55\1\0\3\55\1\0\1\55\10\0"+
    "\1\u0130\2\55\1\u0130\2\55\1\u0130\2\55\1\0\4\55"+
    "\1\0\1\u0130\1\55\1\0\1\55\1\0\1\u0130\3\55"+
    "\6\0\1\u0131\1\62\1\172\1\62\1\0\1\62\1\u0131"+
    "\1\62\1\0\1\62\4\0\2\62\1\0\3\62\1\0"+
    "\1\62\10\0\1\u0131\2\62\1\u0131\2\62\1\u0131\2\62"+
    "\1\0\4\62\1\0\1\u0131\1\62\1\0\1\62\1\0"+
    "\1\u0131\3\62\6\0\1\u0132\1\72\1\176\1\72\1\0"+
    "\1\72\1\u0132\1\72\1\0\1\72\4\0\2\72\1\0"+
    "\3\72\1\0\1\72\10\0\1\u0132\2\72\1\u0132\2\72"+
    "\1\u0132\2\72\1\0\4\72\1\0\1\u0132\1\72\1\0"+
    "\1\72\1\0\1\u0132\3\72\6\0\1\u0133\1\100\1\200"+
    "\1\100\1\0\1\100\1\u0133\1\100\1\0\1\100\4\0"+
    "\2\100\1\0\3\100\1\0\1\100\10\0\1\u0133\2\100"+
    "\1\u0133\2\100\1\u0133\2\100\1\0\4\100\1\0\1\u0133"+
    "\1\100\1\0\1\100\1\0\1\u0133\3\100\6\0\1\u0134"+
    "\1\202\1\203\1\202\1\204\1\202\1\u0134\27\202\1\u0134"+
    "\2\202\1\u0134\2\202\1\u0134\10\202\1\u0134\4\202\1\u0134"+
    "\10\202\1\0\1\u0135\1\205\1\206\3\205\1\u0135\1\205"+
    "\1\204\25\205\1\u0135\2\205\1\u0135\2\205\1\u0135\10\205"+
    "\1\u0135\4\205\1\u0135\10\205\1\0\1\u0136\1\105\1\207"+
    "\1\105\1\0\1\105\1\u0136\1\105\1\0\1\105\4\0"+
    "\2\105\1\0\3\105\1\0\1\105\10\0\1\u0136\2\105"+
    "\1\u0136\2\105\1\u0136\2\105\1\0\4\105\1\0\1\u0136"+
    "\1\105\1\0\1\105\1\0\1\u0136\3\105\6\0\1\u0137"+
    "\1\212\1\213\1\212\1\0\1\212\1\u0137\1\212\1\0"+
    "\1\212\4\0\2\212\1\0\3\212\1\0\1\212\10\0"+
    "\1\u0137\2\212\1\u0137\2\212\1\u0137\2\212\1\0\4\212"+
    "\1\0\1\u0137\1\212\1\0\1\212\1\0\1\u0137\3\212"+
    "\6\0\1\u0138\1\305\1\306\1\305\1\0\1\305\1\u0138"+
    "\1\305\1\0\1\305\1\0\1\217\2\0\2\305\1\0"+
    "\3\305\1\0\1\305\10\0\1\u0138\2\305\1\u0138\2\305"+
    "\1\u0138\2\305\1\0\4\305\1\0\1\u0138\1\305\1\0"+
    "\1\305\1\0\1\u0138\3\305\6\0\1\u0139\1\114\1\216"+
    "\1\114\1\0\1\114\1\u0139\1\114\1\0\1\114\1\0"+
    "\1\217\2\0\2\114\1\0\3\114\1\220\1\114\10\0"+
    "\1\u0139\2\114\1\u0139\2\114\1\u0139\2\114\1\0\4\114"+
    "\1\0\1\u0139\1\114\1\0\1\114\1\0\1\u0139\3\114"+
    "\6\0\1\u013a\1\222\1\223\1\222\1\224\1\222\1\u013a"+
    "\27\222\1\u013a\2\222\1\u013a\2\222\1\u013a\10\222\1\u013a"+
    "\4\222\1\u013a\10\222\1\0\1\u013b\1\225\1\226\3\225"+
    "\1\u013b\1\225\1\224\25\225\1\u013b\2\225\1\u013b\2\225"+
    "\1\u013b\10\225\1\u013b\4\225\1\u013b\10\225\1\0\1\u013c"+
    "\1\227\1\230\1\227\1\0\1\227\1\u013c\1\227\1\0"+
    "\1\227\4\0\2\227\1\0\3\227\1\0\1\227\10\0"+
    "\1\u013c\2\227\1\u013c\2\227\1\u013c\2\227\1\0\4\227"+
    "\1\0\1\u013c\1\227\1\0\1\227\1\0\1\u013c\3\227"+
    "\6\0\1\u013d\5\0\1\u013d\1\362\15\0\2\u013d\7\0"+
    "\2\u013d\1\0\2\u013d\1\0\2\u013d\7\0\2\u013d\3\0"+
    "\2\u013d\10\0\1\u013e\5\0\1\u013e\16\0\2\u013e\7\0"+
    "\2\u013e\1\0\2\u013e\1\0\2\u013e\7\0\2\u013e\3\0"+
    "\2\u013e\10\0\2\u0117\1\u0118\1\u013f\1\0\3\u0117\1\0"+
    "\1\u013f\1\u011c\3\u0117\2\u013f\4\u0117\1\0\46\u0117\1\0"+
    "\1\u0140\1\u0117\1\u0118\1\u013f\2\u0117\1\u0140\2\u0117\1\u013f"+
    "\1\u0141\3\u0117\2\u013f\16\u0117\1\u0140\2\u0117\1\u0140\2\u0117"+
    "\1\u0140\10\u0117\1\u0140\4\u0117\1\u0140\10\u0117\1\0\2\u011a"+
    "\1\u0142\1\0\1\u013f\11\u011a\2\0\53\u011a\1\0\2\u011b"+
    "\1\u0143\1\0\4\u011b\1\u013f\5\u011b\2\0\53\u011b\23\0"+
    "\1\u0144\51\0\1\u0145\1\25\1\132\1\25\1\0\1\25"+
    "\1\u0145\1\25\1\0\1\25\4\0\2\25\1\0\3\25"+
    "\1\0\1\25\10\0\1\u0145\2\25\1\u0145\2\25\1\u0145"+
    "\2\25\1\0\4\25\1\0\1\u0145\1\25\1\0\1\25"+
    "\1\0\1\u0145\3\25\6\0\1\u0146\1\135\1\136\1\135"+
    "\1\0\1\135\1\u0146\1\135\1\0\1\135\4\0\2\135"+
    "\1\0\3\135\1\0\1\135\10\0\1\u0146\2\135\1\u0146"+
    "\2\135\1\u0146\2\135\1\0\4\135\1\0\1\u0146\1\135"+
    "\1\0\1\135\1\0\1\u0146\3\135\6\0\1\u0147\1\137"+
    "\1\140\1\137\1\0\1\137\1\u0147\1\137\1\0\1\137"+
    "\4\0\2\137\1\0\3\137\1\0\1\137\10\0\1\u0147"+
    "\2\137\1\u0147\2\137\1\u0147\2\137\1\0\4\137\1\0"+
    "\1\u0147\1\137\1\0\1\137\1\0\1\u0147\3\137\52\0"+
    "\2\u0148\74\0\1\u0149\107\0\2\u014a\10\0\1\u014b\1\150"+
    "\1\151\1\150\1\0\1\150\1\u014b\1\150\1\0\1\150"+
    "\4\0\2\150\1\0\3\150\1\251\1\150\10\0\1\u014b"+
    "\2\150\1\u014b\2\150\1\u014b\2\150\1\0\4\150\1\0"+
    "\1\u014b\1\150\1\0\1\150\1\0\1\u014b\3\150\6\0"+
    "\1\u014c\1\153\1\154\1\153\1\155\1\153\1\u014c\27\153"+
    "\1\u014c\2\153\1\u014c\2\153\1\u014c\10\153\1\u014c\4\153"+
    "\1\u014c\10\153\1\0\1\u014d\1\156\1\157\3\156\1\u014d"+
    "\1\156\1\155\25\156\1\u014d\2\156\1\u014d\2\156\1\u014d"+
    "\10\156\1\u014d\4\156\1\u014d\10\156\1\0\1\u014e\1\160"+
    "\1\161\1\160\1\162\1\160\1\u014e\27\160\1\u014e\2\160"+
    "\1\u014e\2\160\1\u014e\10\160\1\u014e\4\160\1\u014e\10\160"+
    "\1\0\1\u014f\1\163\1\164\3\163\1\u014f\1\163\1\162"+
    "\25\163\1\u014f\2\163\1\u014f\2\163\1\u014f\10\163\1\u014f"+
    "\4\163\1\u014f\10\163\4\0\1\u012a\1\0\1\u012a\3\0"+
    "\1\u012a\1\u0106\3\0\2\u012a\54\0\1\u0150\1\u0102\1\u0103"+
    "\1\u0102\1\0\1\u0102\1\u0150\1\u0102\1\0\1\u0102\1\u0106"+
    "\11\u0102\1\0\11\u0102\1\u0150\2\u0102\1\u0150\2\u0102\1\u0150"+
    "\10\u0102\1\u0150\4\u0102\1\u0150\10\u0102\1\0\1\u0151\1\u0104"+
    "\1\u012d\1\u0104\1\u0152\1\u0104\1\u0151\10\u0104\1\u0153\16\u0104"+
    "\1\u0151\2\u0104\1\u0151\2\u0104\1\u0151\10\u0104\1\u0151\4\u0104"+
    "\1\u0151\10\u0104\1\0\1\u0154\1\u0105\1\u012e\3\u0105\1\u0154"+
    "\1\u0105\1\u0155\6\u0105\1\u0156\16\u0105\1\u0154\2\u0105\1\u0154"+
    "\2\u0105\1\u0154\10\u0105\1\u0154\4\u0105\1\u0154\10\u0105\1\0"+
    "\1\u0157\1\51\1\166\1\51\1\0\1\51\1\u0157\1\51"+
    "\1\0\1\51\4\0\2\51\1\0\3\51\1\0\1\51"+
    "\10\0\1\u0157\2\51\1\u0157\2\51\1\u0157\2\51\1\0"+
    "\4\51\1\0\1\u0157\1\51\1\0\1\51\1\0\1\u0157"+
    "\3\51\6\0\1\u0158\1\55\1\170\1\55\1\0\1\55"+
    "\1\u0158\1\55\1\0\1\55\4\0\2\55\1\0\3\55"+
    "\1\0\1\55\10\0\1\u0158\2\55\1\u0158\2\55\1\u0158"+
    "\2\55\1\0\4\55\1\0\1\u0158\1\55\1\0\1\55"+
    "\1\0\1\u0158\3\55\6\0\1\u0159\1\62\1\172\1\62"+
    "\1\0\1\62\1\u0159\1\62\1\0\1\62\4\0\2\62"+
    "\1\0\3\62\1\0\1\62\10\0\1\u0159\2\62\1\u0159"+
    "\2\62\1\u0159\2\62\1\0\4\62\1\0\1\u0159\1\62"+
    "\1\0\1\62\1\0\1\u0159\3\62\6\0\1\u015a\1\72"+
    "\1\176\1\72\1\0\1\72\1\u015a\1\72\1\0\1\72"+
    "\4\0\2\72\1\0\3\72\1\0\1\72\10\0\1\u015a"+
    "\2\72\1\u015a\2\72\1\u015a\2\72\1\0\4\72\1\0"+
    "\1\u015a\1\72\1\0\1\72\1\0\1\u015a\3\72\6\0"+
    "\1\u015b\1\100\1\200\1\100\1\0\1\100\1\u015b\1\100"+
    "\1\0\1\100\4\0\2\100\1\0\3\100\1\0\1\100"+
    "\10\0\1\u015b\2\100\1\u015b\2\100\1\u015b\2\100\1\0"+
    "\4\100\1\0\1\u015b\1\100\1\0\1\100\1\0\1\u015b"+
    "\3\100\6\0\1\u015c\1\202\1\203\1\202\1\204\1\202"+
    "\1\u015c\27\202\1\u015c\2\202\1\u015c\2\202\1\u015c\10\202"+
    "\1\u015c\4\202\1\u015c\10\202\1\0\1\u015d\1\205\1\206"+
    "\3\205\1\u015d\1\205\1\204\25\205\1\u015d\2\205\1\u015d"+
    "\2\205\1\u015d\10\205\1\u015d\4\205\1\u015d\10\205\1\0"+
    "\1\u015e\1\105\1\207\1\105\1\0\1\105\1\u015e\1\105"+
    "\1\0\1\105\4\0\2\105\1\0\3\105\1\0\1\105"+
    "\10\0\1\u015e\2\105\1\u015e\2\105\1\u015e\2\105\1\0"+
    "\4\105\1\0\1\u015e\1\105\1\0\1\105\1\0\1\u015e"+
    "\3\105\6\0\1\u015f\1\212\1\213\1\212\1\0\1\212"+
    "\1\u015f\1\212\1\0\1\212\4\0\2\212\1\0\3\212"+
    "\1\0\1\212\10\0\1\u015f\2\212\1\u015f\2\212\1\u015f"+
    "\2\212\1\0\4\212\1\0\1\u015f\1\212\1\0\1\212"+
    "\1\0\1\u015f\3\212\6\0\1\u0160\1\305\1\306\1\305"+
    "\1\0\1\305\1\u0160\1\305\1\0\1\305\1\0\1\217"+
    "\2\0\2\305\1\0\3\305\1\0\1\305\10\0\1\u0160"+
    "\2\305\1\u0160\2\305\1\u0160\2\305\1\0\4\305\1\0"+
    "\1\u0160\1\305\1\0\1\305\1\0\1\u0160\3\305\6\0"+
    "\1\u0161\1\114\1\216\1\114\1\0\1\114\1\u0161\1\114"+
    "\1\0\1\114\1\0\1\217\2\0\2\114\1\0\3\114"+
    "\1\220\1\114\10\0\1\u0161\2\114\1\u0161\2\114\1\u0161"+
    "\2\114\1\0\4\114\1\0\1\u0161\1\114\1\0\1\114"+
    "\1\0\1\u0161\3\114\6\0\1\u0162\1\222\1\223\1\222"+
    "\1\224\1\222\1\u0162\27\222\1\u0162\2\222\1\u0162\2\222"+
    "\1\u0162\10\222\1\u0162\4\222\1\u0162\10\222\1\0\1\u0163"+
    "\1\225\1\226\3\225\1\u0163\1\225\1\224\25\225\1\u0163"+
    "\2\225\1\u0163\2\225\1\u0163\10\225\1\u0163\4\225\1\u0163"+
    "\10\225\1\0\1\u0164\1\227\1\230\1\227\1\0\1\227"+
    "\1\u0164\1\227\1\0\1\227\4\0\2\227\1\0\3\227"+
    "\1\0\1\227\10\0\1\u0164\2\227\1\u0164\2\227\1\u0164"+
    "\2\227\1\0\4\227\1\0\1\u0164\1\227\1\0\1\227"+
    "\1\0\1\u0164\3\227\6\0\1\u0165\5\0\1\u0165\1\362"+
    "\15\0\2\u0165\7\0\2\u0165\1\0\2\u0165\1\0\2\u0165"+
    "\7\0\2\u0165\3\0\2\u0165\10\0\1\u0166\5\0\1\u0166"+
    "\16\0\2\u0166\7\0\2\u0166\1\0\2\u0166\1\0\2\u0166"+
    "\7\0\2\u0166\3\0\2\u0166\13\0\1\u013f\1\0\1\u013f"+
    "\3\0\1\u013f\1\u011c\3\0\2\u013f\54\0\1\u0167\1\u0117"+
    "\1\u0118\1\u0117\1\0\1\u0117\1\u0167\1\u0117\1\0\1\u0117"+
    "\1\u011c\11\u0117\1\0\11\u0117\1\u0167\2\u0117\1\u0167\2\u0117"+
    "\1\u0167\10\u0117\1\u0167\4\u0117\1\u0167\10\u0117\1\0\1\u0168"+
    "\1\u011a\1\u0142\1\u011a\1\u0169\1\u011a\1\u0168\10\u011a\1\u016a"+
    "\16\u011a\1\u0168\2\u011a\1\u0168\2\u011a\1\u0168\10\u011a\1\u0168"+
    "\4\u011a\1\u0168\10\u011a\1\0\1\u016b\1\u011b\1\u0143\3\u011b"+
    "\1\u016b\1\u011b\1\u016c\6\u011b\1\u016d\16\u011b\1\u016b\2\u011b"+
    "\1\u016b\2\u011b\1\u016b\10\u011b\1\u016b\4\u011b\1\u016b\10\u011b"+
    "\47\0\1\u016e\25\0\2\25\1\132\1\25\1\0\3\25"+
    "\1\0\1\25\4\0\2\25\1\0\3\25\1\0\1\25"+
    "\10\0\11\25\1\0\4\25\1\0\2\25\1\0\1\25"+
    "\1\0\4\25\6\0\1\u016f\1\135\1\136\1\135\1\0"+
    "\1\135\1\u016f\1\135\1\0\1\135\4\0\2\135\1\0"+
    "\3\135\1\0\1\135\10\0\1\u016f\2\135\1\u016f\2\135"+
    "\1\u016f\2\135\1\0\4\135\1\0\1\u016f\1\135\1\0"+
    "\1\135\1\0\1\u016f\3\135\6\0\1\u0170\1\137\1\140"+
    "\1\137\1\0\1\137\1\u0170\1\137\1\0\1\137\4\0"+
    "\2\137\1\0\3\137\1\0\1\137\10\0\1\u0170\2\137"+
    "\1\u0170\2\137\1\u0170\2\137\1\0\4\137\1\0\1\u0170"+
    "\1\137\1\0\1\137\1\0\1\u0170\3\137\54\0\1\u0171"+
    "\66\0\2\u0172\31\0\1\u0173\1\150\1\151\1\150\1\0"+
    "\1\150\1\u0173\1\150\1\0\1\150\4\0\2\150\1\0"+
    "\3\150\1\251\1\150\10\0\1\u0173\2\150\1\u0173\2\150"+
    "\1\u0173\2\150\1\0\4\150\1\0\1\u0173\1\150\1\0"+
    "\1\150\1\0\1\u0173\3\150\6\0\1\u0174\1\153\1\154"+
    "\1\153\1\155\1\153\1\u0174\27\153\1\u0174\2\153\1\u0174"+
    "\2\153\1\u0174\10\153\1\u0174\4\153\1\u0174\10\153\1\0"+
    "\1\u0175\1\156\1\157\3\156\1\u0175\1\156\1\155\25\156"+
    "\1\u0175\2\156\1\u0175\2\156\1\u0175\10\156\1\u0175\4\156"+
    "\1\u0175\10\156\1\0\1\u0176\1\160\1\161\1\160\1\162"+
    "\1\160\1\u0176\27\160\1\u0176\2\160\1\u0176\2\160\1\u0176"+
    "\10\160\1\u0176\4\160\1\u0176\10\160\1\0\1\u0177\1\163"+
    "\1\164\3\163\1\u0177\1\163\1\162\25\163\1\u0177\2\163"+
    "\1\u0177\2\163\1\u0177\10\163\1\u0177\4\163\1\u0177\10\163"+
    "\1\0\1\u0178\1\u0102\1\u0103\1\u0102\1\0\1\u0102\1\u0178"+
    "\1\u0102\1\0\1\u0102\1\u0106\11\u0102\1\0\11\u0102\1\u0178"+
    "\2\u0102\1\u0178\2\u0102\1\u0178\10\u0102\1\u0178\4\u0102\1\u0178"+
    "\10\u0102\1\0\1\u0179\1\u0104\1\u012d\1\u0104\1\u012a\1\u0104"+
    "\1\u0179\27\u0104\1\u0179\2\u0104\1\u0179\2\u0104\1\u0179\10\u0104"+
    "\1\u0179\4\u0104\1\u0179\10\u0104\1\0\2\u0104\1\u012d\2\u012a"+
    "\1\u0152\3\u0104\1\u0152\1\u017a\3\u0104\2\u012a\53\u0104\1\0"+
    "\2\u0104\1\u012d\1\0\1\u012a\12\u0104\1\0\53\u0104\1\0"+
    "\1\u017b\1\u0105\1\u012e\3\u0105\1\u017b\1\u0105\1\u012a\25\u0105"+
    "\1\u017b\2\u0105\1\u017b\2\u0105\1\u017b\10\u0105\1\u017b\4\u0105"+
    "\1\u017b\10\u0105\1\0\2\u0105\1\u012e\1\u012a\1\u0105\1\u0155"+
    "\2\u0105\1\u012a\1\u0155\1\u017c\3\u0105\2\u012a\53\u0105\1\0"+
    "\2\u0105\1\u012e\1\0\4\u0105\1\u012a\6\u0105\1\0\53\u0105"+
    "\1\0\2\51\1\166\1\51\1\0\3\51\1\0\1\51"+
    "\4\0\2\51\1\0\3\51\1\0\1\51\10\0\11\51"+
    "\1\0\4\51\1\0\2\51\1\0\1\51\1\0\4\51"+
    "\6\0\2\55\1\170\1\55\1\0\3\55\1\0\1\55"+
    "\4\0\2\55\1\0\3\55\1\0\1\55\10\0\11\55"+
    "\1\0\4\55\1\0\2\55\1\0\1\55\1\0\4\55"+
    "\6\0\2\62\1\172\1\62\1\0\3\62\1\0\1\62"+
    "\4\0\2\62\1\0\3\62\1\0\1\62\10\0\11\62"+
    "\1\0\4\62\1\0\2\62\1\0\1\62\1\0\4\62"+
    "\6\0\2\72\1\176\1\72\1\0\3\72\1\0\1\72"+
    "\4\0\2\72\1\0\3\72\1\0\1\72\10\0\11\72"+
    "\1\0\4\72\1\0\2\72\1\0\1\72\1\0\4\72"+
    "\6\0\2\100\1\200\1\100\1\0\3\100\1\0\1\100"+
    "\4\0\2\100\1\0\3\100\1\0\1\100\10\0\11\100"+
    "\1\0\4\100\1\0\2\100\1\0\1\100\1\0\4\100"+
    "\6\0\1\u017d\1\202\1\203\1\202\1\204\1\202\1\u017d"+
    "\27\202\1\u017d\2\202\1\u017d\2\202\1\u017d\10\202\1\u017d"+
    "\4\202\1\u017d\10\202\1\0\1\u017e\1\205\1\206\3\205"+
    "\1\u017e\1\205\1\204\25\205\1\u017e\2\205\1\u017e\2\205"+
    "\1\u017e\10\205\1\u017e\4\205\1\u017e\10\205\1\0\2\105"+
    "\1\207\1\105\1\0\3\105\1\0\1\105\4\0\2\105"+
    "\1\0\3\105\1\0\1\105\10\0\11\105\1\0\4\105"+
    "\1\0\2\105\1\0\1\105\1\0\4\105\6\0\1\u017f"+
    "\1\212\1\213\1\212\1\0\1\212\1\u017f\1\212\1\0"+
    "\1\212\4\0\2\212\1\0\3\212\1\0\1\212\10\0"+
    "\1\u017f\2\212\1\u017f\2\212\1\u017f\2\212\1\0\4\212"+
    "\1\0\1\u017f\1\212\1\0\1\212\1\0\1\u017f\3\212"+
    "\6\0\1\u0180\1\305\1\306\1\305\1\0\1\305\1\u0180"+
    "\1\305\1\0\1\305\1\0\1\217\2\0\2\305\1\0"+
    "\3\305\1\0\1\305\10\0\1\u0180\2\305\1\u0180\2\305"+
    "\1\u0180\2\305\1\0\4\305\1\0\1\u0180\1\305\1\0"+
    "\1\305\1\0\1\u0180\3\305\6\0\2\114\1\216\1\114"+
    "\1\0\3\114\1\0\1\114\1\0\1\217\2\0\2\114"+
    "\1\0\3\114\1\220\1\114\10\0\11\114\1\0\4\114"+
    "\1\0\2\114\1\0\1\114\1\0\4\114\6\0\1\u0181"+
    "\1\222\1\223\1\222\1\224\1\222\1\u0181\27\222\1\u0181"+
    "\2\222\1\u0181\2\222\1\u0181\10\222\1\u0181\4\222\1\u0181"+
    "\10\222\1\0\1\u0182\1\225\1\226\3\225\1\u0182\1\225"+
    "\1\224\25\225\1\u0182\2\225\1\u0182\2\225\1\u0182\10\225"+
    "\1\u0182\4\225\1\u0182\10\225\1\0\1\u0183\1\227\1\230"+
    "\1\227\1\0\1\227\1\u0183\1\227\1\0\1\227\4\0"+
    "\2\227\1\0\3\227\1\0\1\227\10\0\1\u0183\2\227"+
    "\1\u0183\2\227\1\u0183\2\227\1\0\4\227\1\0\1\u0183"+
    "\1\227\1\0\1\227\1\0\1\u0183\3\227\6\0\1\u0184"+
    "\5\0\1\u0184\1\362\15\0\2\u0184\7\0\2\u0184\1\0"+
    "\2\u0184\1\0\2\u0184\7\0\2\u0184\3\0\2\u0184\10\0"+
    "\1\u0185\5\0\1\u0185\16\0\2\u0185\7\0\2\u0185\1\0"+
    "\2\u0185\1\0\2\u0185\7\0\2\u0185\3\0\2\u0185\10\0"+
    "\1\u0186\1\u0117\1\u0118\1\u0117\1\0\1\u0117\1\u0186\1\u0117"+
    "\1\0\1\u0117\1\u011c\11\u0117\1\0\11\u0117\1\u0186\2\u0117"+
    "\1\u0186\2\u0117\1\u0186\10\u0117\1\u0186\4\u0117\1\u0186\10\u0117"+
    "\1\0\1\u0187\1\u011a\1\u0142\1\u011a\1\u013f\1\u011a\1\u0187"+
    "\27\u011a\1\u0187\2\u011a\1\u0187\2\u011a\1\u0187\10\u011a\1\u0187"+
    "\4\u011a\1\u0187\10\u011a\1\0\2\u011a\1\u0142\2\u013f\1\u0169"+
    "\3\u011a\1\u0169\1\u0188\3\u011a\2\u013f\53\u011a\1\0\2\u011a"+
    "\1\u0142\1\0\1\u013f\12\u011a\1\0\53\u011a\1\0\1\u0189"+
    "\1\u011b\1\u0143\3\u011b\1\u0189\1\u011b\1\u013f\25\u011b\1\u0189"+
    "\2\u011b\1\u0189\2\u011b\1\u0189\10\u011b\1\u0189\4\u011b\1\u0189"+
    "\10\u011b\1\0\2\u011b\1\u0143\1\u013f\1\u011b\1\u016c\2\u011b"+
    "\1\u013f\1\u016c\1\u018a\3\u011b\2\u013f\53\u011b\1\0\2\u011b"+
    "\1\u0143\1\0\4\u011b\1\u013f\6\u011b\1\0\53\u011b\42\0"+
    "\2\u018b\31\0\2\135\1\136\1\135\1\0\3\135\1\0"+
    "\1\135\4\0\2\135\1\0\3\135\1\0\1\135\10\0"+
    "\11\135\1\0\4\135\1\0\2\135\1\0\1\135\1\0"+
    "\4\135\6\0\2\137\1\140\1\137\1\0\3\137\1\0"+
    "\1\137\4\0\2\137\1\0\3\137\1\0\1\137\10\0"+
    "\11\137\1\0\4\137\1\0\2\137\1\0\1\137\1\0"+
    "\4\137\44\0\2\u018c\34\0\2\150\1\151\1\150\1\0"+
    "\3\150\1\0\1\150\4\0\2\150\1\0\3\150\1\251"+
    "\1\150\10\0\11\150\1\0\4\150\1\0\2\150\1\0"+
    "\1\150\1\0\4\150\6\0\2\153\1\154\1\153\1\155"+
    "\66\153\1\0\2\156\1\157\5\156\1\155\62\156\1\0"+
    "\2\160\1\161\1\160\1\162\66\160\1\0\2\163\1\164"+
    "\5\163\1\162\62\163\1\0\1\u018d\1\u0102\1\u0103\1\u0102"+
    "\1\0\1\u0102\1\u018d\1\u0102\1\0\1\u0102\1\u0106\11\u0102"+
    "\1\0\11\u0102\1\u018d\2\u0102\1\u018d\2\u0102\1\u018d\10\u0102"+
    "\1\u018d\4\u0102\1\u018d\10\u0102\1\0\1\u018e\1\u0104\1\u012d"+
    "\1\u0104\1\u012a\1\u0104\1\u018e\27\u0104\1\u018e\2\u0104\1\u018e"+
    "\2\u0104\1\u018e\10\u0104\1\u018e\4\u0104\1\u018e\10\u0104\1\0"+
    "\1\u018f\1\u0105\1\u012e\3\u0105\1\u018f\1\u0105\1\u012a\25\u0105"+
    "\1\u018f\2\u0105\1\u018f\2\u0105\1\u018f\10\u0105\1\u018f\4\u0105"+
    "\1\u018f\10\u0105\1\0\2\202\1\203\1\202\1\204\66\202"+
    "\1\0\2\205\1\206\5\205\1\204\62\205\1\0\2\212"+
    "\1\213\1\212\1\0\3\212\1\0\1\212\4\0\2\212"+
    "\1\0\3\212\1\0\1\212\10\0\11\212\1\0\4\212"+
    "\1\0\2\212\1\0\1\212\1\0\4\212\6\0\1\u0190"+
    "\1\305\1\306\1\305\1\0\1\305\1\u0190\1\305\1\0"+
    "\1\305\1\0\1\217\2\0\2\305\1\0\3\305\1\0"+
    "\1\305\10\0\1\u0190\2\305\1\u0190\2\305\1\u0190\2\305"+
    "\1\0\4\305\1\0\1\u0190\1\305\1\0\1\305\1\0"+
    "\1\u0190\3\305\6\0\2\222\1\223\1\222\1\224\66\222"+
    "\1\0\2\225\1\226\5\225\1\224\62\225\1\0\2\227"+
    "\1\230\1\227\1\0\3\227\1\0\1\227\4\0\2\227"+
    "\1\0\3\227\1\0\1\227\10\0\11\227\1\0\4\227"+
    "\1\0\2\227\1\0\1\227\1\0\4\227\15\0\1\362"+
    "\64\0\1\u0191\5\0\1\u0191\16\0\2\u0191\7\0\2\u0191"+
    "\1\0\2\u0191\1\0\2\u0191\7\0\2\u0191\3\0\2\u0191"+
    "\10\0\1\u0192\1\u0117\1\u0118\1\u0117\1\0\1\u0117\1\u0192"+
    "\1\u0117\1\0\1\u0117\1\u011c\11\u0117\1\0\11\u0117\1\u0192"+
    "\2\u0117\1\u0192\2\u0117\1\u0192\10\u0117\1\u0192\4\u0117\1\u0192"+
    "\10\u0117\1\0\1\u0193\1\u011a\1\u0142\1\u011a\1\u013f\1\u011a"+
    "\1\u0193\27\u011a\1\u0193\2\u011a\1\u0193\2\u011a\1\u0193\10\u011a"+
    "\1\u0193\4\u011a\1\u0193\10\u011a\1\0\1\u0194\1\u011b\1\u0143"+
    "\3\u011b\1\u0194\1\u011b\1\u013f\25\u011b\1\u0194\2\u011b\1\u0194"+
    "\2\u011b\1\u0194\10\u011b\1\u0194\4\u011b\1\u0194\10\u011b\65\0"+
    "\1\u0195\53\0\2\u0196\26\0\1\u0197\1\u0102\1\u0103\1\u0102"+
    "\1\0\1\u0102\1\u0197\1\u0102\1\0\1\u0102\1\u0106\11\u0102"+
    "\1\0\11\u0102\1\u0197\2\u0102\1\u0197\2\u0102\1\u0197\10\u0102"+
    "\1\u0197\4\u0102\1\u0197\10\u0102\1\0\1\u0198\1\u0104\1\u012d"+
    "\1\u0104\1\u012a\1\u0104\1\u0198\27\u0104\1\u0198\2\u0104\1\u0198"+
    "\2\u0104\1\u0198\10\u0104\1\u0198\4\u0104\1\u0198\10\u0104\1\0"+
    "\1\u0199\1\u0105\1\u012e\3\u0105\1\u0199\1\u0105\1\u012a\25\u0105"+
    "\1\u0199\2\u0105\1\u0199\2\u0105\1\u0199\10\u0105\1\u0199\4\u0105"+
    "\1\u0199\10\u0105\1\0\2\305\1\306\1\305\1\0\3\305"+
    "\1\0\1\305\1\0\1\217\2\0\2\305\1\0\3\305"+
    "\1\0\1\305\10\0\11\305\1\0\4\305\1\0\2\305"+
    "\1\0\1\305\1\0\4\305\6\0\1\u019a\5\0\1\u019a"+
    "\16\0\2\u019a\7\0\2\u019a\1\0\2\u019a\1\0\2\u019a"+
    "\7\0\2\u019a\3\0\2\u019a\10\0\1\u019b\1\u0117\1\u0118"+
    "\1\u0117\1\0\1\u0117\1\u019b\1\u0117\1\0\1\u0117\1\u011c"+
    "\11\u0117\1\0\11\u0117\1\u019b\2\u0117\1\u019b\2\u0117\1\u019b"+
    "\10\u0117\1\u019b\4\u0117\1\u019b\10\u0117\1\0\1\u019c\1\u011a"+
    "\1\u0142\1\u011a\1\u013f\1\u011a\1\u019c\27\u011a\1\u019c\2\u011a"+
    "\1\u019c\2\u011a\1\u019c\10\u011a\1\u019c\4\u011a\1\u019c\10\u011a"+
    "\1\0\1\u019d\1\u011b\1\u0143\3\u011b\1\u019d\1\u011b\1\u013f"+
    "\25\u011b\1\u019d\2\u011b\1\u019d\2\u011b\1\u019d\10\u011b\1\u019d"+
    "\4\u011b\1\u019d\10\u011b\47\0\1\u019e\25\0\1\u019f\1\u0102"+
    "\1\u0103\1\u0102\1\0\1\u0102\1\u019f\1\u0102\1\0\1\u0102"+
    "\1\u0106\11\u0102\1\0\11\u0102\1\u019f\2\u0102\1\u019f\2\u0102"+
    "\1\u019f\10\u0102\1\u019f\4\u0102\1\u019f\10\u0102\1\0\1\u01a0"+
    "\1\u0104\1\u012d\1\u0104\1\u012a\1\u0104\1\u01a0\27\u0104\1\u01a0"+
    "\2\u0104\1\u01a0\2\u0104\1\u01a0\10\u0104\1\u01a0\4\u0104\1\u01a0"+
    "\10\u0104\1\0\1\u01a1\1\u0105\1\u012e\3\u0105\1\u01a1\1\u0105"+
    "\1\u012a\25\u0105\1\u01a1\2\u0105\1\u01a1\2\u0105\1\u01a1\10\u0105"+
    "\1\u01a1\4\u0105\1\u01a1\10\u0105\1\0\1\u01a2\1\u0117\1\u0118"+
    "\1\u0117\1\0\1\u0117\1\u01a2\1\u0117\1\0\1\u0117\1\u011c"+
    "\11\u0117\1\0\11\u0117\1\u01a2\2\u0117\1\u01a2\2\u0117\1\u01a2"+
    "\10\u0117\1\u01a2\4\u0117\1\u01a2\10\u0117\1\0\1\u01a3\1\u011a"+
    "\1\u0142\1\u011a\1\u013f\1\u011a\1\u01a3\27\u011a\1\u01a3\2\u011a"+
    "\1\u01a3\2\u011a\1\u01a3\10\u011a\1\u01a3\4\u011a\1\u01a3\10\u011a"+
    "\1\0\1\u01a4\1\u011b\1\u0143\3\u011b\1\u01a4\1\u011b\1\u013f"+
    "\25\u011b\1\u01a4\2\u011b\1\u01a4\2\u011b\1\u01a4\10\u011b\1\u01a4"+
    "\4\u011b\1\u01a4\10\u011b\1\0\2\u0102\1\u0103\1\u0102\1\0"+
    "\3\u0102\1\0\1\u0102\1\u0106\11\u0102\1\0\46\u0102\1\0"+
    "\1\u01a5\1\u0104\1\u012d\1\u0104\1\u012a\1\u0104\1\u01a5\27\u0104"+
    "\1\u01a5\2\u0104\1\u01a5\2\u0104\1\u01a5\10\u0104\1\u01a5\4\u0104"+
    "\1\u01a5\10\u0104\1\0\1\u01a6\1\u0105\1\u012e\3\u0105\1\u01a6"+
    "\1\u0105\1\u012a\25\u0105\1\u01a6\2\u0105\1\u01a6\2\u0105\1\u01a6"+
    "\10\u0105\1\u01a6\4\u0105\1\u01a6\10\u0105\1\0\2\u0117\1\u0118"+
    "\1\u0117\1\0\3\u0117\1\0\1\u0117\1\u011c\11\u0117\1\0"+
    "\46\u0117\1\0\1\u01a7\1\u011a\1\u0142\1\u011a\1\u013f\1\u011a"+
    "\1\u01a7\27\u011a\1\u01a7\2\u011a\1\u01a7\2\u011a\1\u01a7\10\u011a"+
    "\1\u01a7\4\u011a\1\u01a7\10\u011a\1\0\1\u01a8\1\u011b\1\u0143"+
    "\3\u011b\1\u01a8\1\u011b\1\u013f\25\u011b\1\u01a8\2\u011b\1\u01a8"+
    "\2\u011b\1\u01a8\10\u011b\1\u01a8\4\u011b\1\u01a8\10\u011b\1\0"+
    "\2\u0104\1\u012d\1\u0104\1\u012a\66\u0104\1\0\2\u0105\1\u012e"+
    "\5\u0105\1\u012a\62\u0105\1\0\2\u011a\1\u0142\1\u011a\1\u013f"+
    "\66\u011a\1\0\2\u011b\1\u0143\5\u011b\1\u013f\62\u011b";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21060];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\23\0\1\11\7\1\1\11\1\1\1\11\2\1\1\11"+
    "\3\1\1\11\6\1\1\11\3\1\2\11\3\1\1\11"+
    "\2\1\2\11\3\1\1\11\1\1\1\11\11\1\2\11"+
    "\6\1\1\11\6\1\1\11\1\1\1\0\1\1\1\0"+
    "\1\1\1\0\1\1\10\0\1\1\4\0\1\11\4\0"+
    "\1\11\4\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\1\11\1\0\1\1\1\0\1\1\2\0\1\11\3\0"+
    "\1\1\1\0\1\1\2\0\1\11\1\0\1\1\1\11"+
    "\1\1\2\0\1\11\2\0\1\1\2\0\1\1\2\0"+
    "\1\11\1\1\1\11\2\1\10\0\1\1\1\0\1\1"+
    "\2\0\1\1\2\0\1\1\2\0\1\1\2\0\5\1"+
    "\1\0\1\1\2\0\1\1\1\0\3\1\1\0\1\1"+
    "\1\0\1\1\2\0\1\1\1\0\3\1\1\0\3\1"+
    "\2\11\5\0\1\11\1\1\5\0\5\1\2\0\4\1"+
    "\2\0\2\1\1\0\1\1\1\0\3\1\3\0\1\11"+
    "\1\0\1\1\10\0\1\11\5\1\2\0\4\1\2\0"+
    "\3\1\5\0\1\11\1\0\3\1\2\0\1\11\1\0"+
    "\1\1\6\0\1\1\2\0\5\1\2\0\4\1\2\0"+
    "\3\1\2\0\1\1\3\0\3\1\1\0\1\11\1\0"+
    "\1\1\13\0\5\1\2\0\4\1\2\0\3\1\10\0"+
    "\2\1\1\11\1\0\1\1\6\0\1\1\1\0\1\1"+
    "\2\0\2\1\2\0\3\1\2\0\1\1\1\0\1\1"+
    "\5\0\2\1\4\0\1\11\3\0\1\11\3\0\1\11"+
    "\12\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[424];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	private final static String UNDEFINED = "undefined";
	private String fBufferedContext = null;
	private int fBufferedStart;
//	private int fBufferedTextLength;
	private int fBufferedLength;
//	private StringBuffer fBufferedText = null;
	private CSSTextRegionFactory fRegionFactory = CSSTextRegionFactory.getInstance();
	private int fInitialState = YYINITIAL;
	public final static int BUFFER_SIZE_NORMAL = 16384;
	public final static int BUFFER_SIZE_SMALL = 256;
	private int fInitialBufferSize = BUFFER_SIZE_NORMAL;

	public void setInitialState(int state) {
		fInitialState = state;
	}
	
	public void setInitialBufferSize(int size) {
		fInitialBufferSize = size;
	}

	/* user method */
  	public final ITextRegion getNextToken() throws IOException {
		String context;
		String nextTokenType;
		boolean spaceFollows;
//		StringBuffer text;
		int start;
		int textLength;
		int length;
		if (fBufferedContext != null) {
			context = fBufferedContext;
//			text = fBufferedText;
			start = fBufferedStart;
			textLength = length = fBufferedLength;

			fBufferedContext = null;
		} else {
			context = primGetNextToken();
//			text = new StringBuffer(yytext());
			start = yychar;
			textLength = length = yylength();
		}

		if (context != null) {
			if (context == UNDEFINED) {
				// undef -> concatenate undef's
				nextTokenType = primGetNextToken();
				while (nextTokenType == UNDEFINED) {
//					text.append(yytext());
					textLength += yylength();
					length = textLength;
					nextTokenType = primGetNextToken();
				}
				fBufferedContext = nextTokenType;
//				fBufferedText = new StringBuffer(yytext());
				fBufferedStart = yychar;
				fBufferedLength = yylength();
			} else {
				nextTokenType = null;
				spaceFollows = false;
				if (CSSRegionUtil.isDeclarationValueType(context)) { // declaration value can contain VALUE_S
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_DECLARATION_VALUE_S);
				} else if (canContainSpace(context)) {
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_S);
				}
				if (nextTokenType != null) { // nextToken is retrieved
					if (spaceFollows && (context != CSS_COMMENT)) {
						// next is space -> append
//						text.append(yytext());
						length += yylength();
					} else {
						// next is NOT space -> push this for next time, return itself
						fBufferedContext = nextTokenType;
//						fBufferedText = new StringBuffer(yytext());
						fBufferedStart = yychar;
						fBufferedLength = yylength();
					}
				}
			}
		}

		if (context != null) {
			if (context == UNDEFINED) {
				context = CSS_UNKNOWN;
			}
			return fRegionFactory.createRegion(context, start, textLength, length);
		} else {
			return null;
		}
  	}

	/* user method */
	/* for standalone use */
  	public final List parseText() throws IOException {
  		List tokens = new ArrayList();

  		CSSTextToken token;
		for (String kind = primGetNextToken(); kind != null; kind = primGetNextToken()) {
			token = new CSSTextToken();
			token.kind = kind;  				
			token.start = yychar;
			token.length = yylength();
			token.image = yytext();
			tokens.add(token);
		}

  		return tokens;
  	}
  	
  	/* user method */
  	private boolean canContainSpace(String type) {
  		if (type == CSS_DELIMITER || type == CSS_RBRACE || type == CSS_DECLARATION_DELIMITER) {
  			return false;
  		} else {
  			return true;
  		}
  	}

	/* user method */
	public final int getOffset() {
		return yychar;
	}
	
	/* user method */
	public final boolean isEOF() {
		return zzAtEOF;
	}

	/* user method */
	public void reset(char[] charArray) {
		reset(new CharArrayReader(charArray), 0);
	}

	/* user method */
	public final void reset(java.io.Reader in, int newOffset) {
		/** the input device */
		zzReader = in;

		/** the current state of the DFA */
		zzState = 0;

		/** the current lexical state */
		zzLexicalState = fInitialState; //YYINITIAL;

		/** this buffer contains the current text to be matched and is
			the source of the yytext() string */
		if (zzBuffer.length != fInitialBufferSize) {
			zzBuffer = new char[fInitialBufferSize];
		}
		java.util.Arrays.fill(zzBuffer, (char)0);

		/** the textposition at the last accepting state */
		zzMarkedPos = 0;

		/** the textposition at the last state to be included in yytext */
//		yy_pushbackPos = 0;

		/** the current text position in the buffer */
		zzCurrentPos = 0;

		/** startRead marks the beginning of the yytext() string in the buffer */
		zzStartRead = 0;

		/** endRead marks the last character in the buffer, that has been read
			from input */
		zzEndRead = 0;

		/** number of newlines encountered up to the start of the matched text */
		yyline = 0;

		/** the number of characters up to the start of the matched text */
		yychar = 0;

		/**
		 * the number of characters from the last newline up to the start of the 
		 * matched text
		 */
//		yycolumn = 0; 

		/** 
		 * yy_atBOL == true <=> the scanner is currently at the beginning of a line
		 */
//		yy_atBOL = false;
		
		/** zzAtEOF == true <=> the scanner has returned a value for EOF */
		zzAtEOF = false;

		/* user variables */
		//		fUndefined.delete(0, fUndefined.length());
	}

	/* user method */
	public CSSTokenizer() {
		super();
	}

	/**
	 * Added to workaround stricter compilation options without creating
	 * an alternate skeleton file
	 */
	void _usePrivates() {
		System.out.print(yycolumn);
		System.out.print(yyline);
		System.out.print(Boolean.toString(zzAtBOL));
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSSTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSSTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 170) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 32: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_STRING;
          }
        case 52: break;
        case 34: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_DIMENSION;
          }
        case 53: break;
        case 39: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { return CSS_DECLARATION_VALUE_S;
          }
        case 54: break;
        case 36: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_FUNCTION;
          }
        case 55: break;
        case 19: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ATTRIBUTE_END;
          }
        case 56: break;
        case 1: 
          { return UNDEFINED;
          }
        case 57: break;
        case 9: 
          { yybegin(ST_IMPORT_DELIMITER); return CSS_MEDIUM;
          }
        case 58: break;
        case 37: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_STRING;
          }
        case 59: break;
        case 29: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_CLASS;
          }
        case 60: break;
        case 12: 
          { yybegin(YYINITIAL); return CSS_LBRACE;
          }
        case 61: break;
        case 4: 
          { yybegin(YYINITIAL); return CSS_RBRACE;
          }
        case 62: break;
        case 11: 
          { yybegin(ST_MEDIA_DELIMITER); return CSS_MEDIUM;
          }
        case 63: break;
        case 10: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 64: break;
        case 24: 
          { yybegin(ST_DECLARATION_PRE_VALUE); return CSS_DECLARATION_SEPARATOR;
          }
        case 65: break;
        case 50: 
          { yybegin(ST_FONT_FACE_DELIMITER); return CSS_FONT_FACE;
          }
        case 66: break;
        case 49: 
          { yybegin(ST_CHARSET_NAME); return CSS_CHARSET;
          }
        case 67: break;
        case 45: 
          { yybegin(ST_IMPORT_MEDIUM); return CSS_URI;
          }
        case 68: break;
        case 20: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_VALUE); return CSS_SELECTOR_ATTRIBUTE_OPERATOR;
          }
        case 69: break;
        case 40: 
          { return CSS_CDC;
          }
        case 70: break;
        case 15: 
          { yybegin(ST_DECLARATION); return CSS_LBRACE;
          }
        case 71: break;
        case 5: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_UNIVERSAL;
          }
        case 72: break;
        case 7: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_NAME); return CSS_SELECTOR_ATTRIBUTE_START;
          }
        case 73: break;
        case 42: 
          { return CSS_CDO;
          }
        case 74: break;
        case 8: 
          { yybegin(YYINITIAL); return CSS_DELIMITER;
          }
        case 75: break;
        case 18: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_OPERATOR); return CSS_SELECTOR_ATTRIBUTE_NAME;
          }
        case 76: break;
        case 38: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_HASH;
          }
        case 77: break;
        case 44: 
          { yybegin(ST_PAGE_PSEUDO_PAGE); return CSS_PAGE;
          }
        case 78: break;
        case 2: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ELEMENT_NAME;
          }
        case 79: break;
        case 31: 
          { yybegin(ST_CHARSET_DELIMITER); return CSS_STRING;
          }
        case 80: break;
        case 25: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_NUMBER;
          }
        case 81: break;
        case 16: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 82: break;
        case 33: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;
          }
        case 83: break;
        case 41: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_UNICODE_RANGE;
          }
        case 84: break;
        case 35: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PERCENTAGE;
          }
        case 85: break;
        case 13: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA_SEPARATOR;
          }
        case 86: break;
        case 26: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IDENT;
          }
        case 87: break;
        case 14: 
          { yybegin(ST_PAGE_DELIMITER); return CSS_PAGE_SELECTOR;
          }
        case 88: break;
        case 28: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_OPERATOR;
          }
        case 89: break;
        case 43: 
          { return CSS_COMMENT;
          }
        case 90: break;
        case 51: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IMPORTANT;
          }
        case 91: break;
        case 21: 
          { yybegin(ST_SELECTOR_ATTRIBUTE_END); return CSS_SELECTOR_ATTRIBUTE_VALUE;
          }
        case 92: break;
        case 17: 
          { yybegin(ST_SELECTOR); return CSS_SELECTOR_SEPARATOR;
          }
        case 93: break;
        case 3: 
          { return CSS_S;
          }
        case 94: break;
        case 30: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ID;
          }
        case 95: break;
        case 48: 
          { yybegin(ST_IMPORT_URI); return CSS_IMPORT;
          }
        case 96: break;
        case 27: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PARENTHESIS_CLOSE;
          }
        case 97: break;
        case 47: 
          { yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA;
          }
        case 98: break;
        case 23: 
          { yybegin(ST_DECLARATION); return CSS_DECLARATION_DELIMITER;
          }
        case 99: break;
        case 22: 
          { yybegin(ST_DECLARATION_SEPARATOR); return CSS_DECLARATION_PROPERTY;
          }
        case 100: break;
        case 6: 
          { yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO;
          }
        case 101: break;
        case 46: 
          { yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_URI;
          }
        case 102: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
