/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.ui.internal.navigator;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.ui.JptJaxbEclipseLinkUiImages;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.ELJaxbMappingImageHelper;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiImages;
import org.eclipse.jpt.jaxb.ui.internal.AbstractNavigatorItemLabelProviderFactory;

public class ELJaxbNavigatorItemLabelProviderFactory
extends AbstractNavigatorItemLabelProviderFactory {
    private static ItemExtendedLabelProvider.Factory INSTANCE = new ELJaxbNavigatorItemLabelProviderFactory();

    public static ItemExtendedLabelProvider.Factory instance() {
        return INSTANCE;
    }

    private ELJaxbNavigatorItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof OxmFile) {
            return this.buildOxmFileLabelProvider((OxmFile)item, manager);
        }
        if (item instanceof OxmXmlEnum) {
            return this.buildOxmXmlEnumLabelProvider((OxmXmlEnum)item, manager);
        }
        if (item instanceof OxmJavaType) {
            return this.buildOxmJavaTypeLabelProvider((OxmJavaType)item, manager);
        }
        if (item instanceof OxmJavaAttribute) {
            return this.buildOxmJavaAttributeLabelProvider((OxmJavaAttribute)item, manager);
        }
        return super.buildProvider(item, manager);
    }

    protected ImageDescriptor buildJavaPersistentAttributeImageDescriptor(String mappingKey) {
        return ELJaxbMappingImageHelper.imageDescriptorForAttributeMapping(mappingKey);
    }

    protected ItemExtendedLabelProvider buildOxmFileLabelProvider(OxmFile file, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(JptJaxbEclipseLinkUiImages.OXM_FILE, this.buildOxmFileText(file), this.buildOxmFileDescription(file), manager);
    }

    protected String buildOxmFileText(OxmFile file) {
        StringBuffer text = new StringBuffer();
        IPath path = file.getOxmResource().getFile().getRawLocation();
        text.append(path.lastSegment());
        text.append(" - ");
        text.append(path.removeLastSegments(1).toOSString());
        return text.toString();
    }

    protected String buildOxmFileDescription(OxmFile file) {
        return this.buildOxmFileText(file);
    }

    protected ItemExtendedLabelProvider buildOxmJavaTypeLabelProvider(OxmJavaType item, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)item, manager, this.buildOxmJavaTypeImageDescriptorModel(item), this.buildOxmJavaTypeTextModel(item), this.buildOxmJavaTypeDescriptionModel(item));
    }

    protected PropertyValueModel<ImageDescriptor> buildOxmJavaTypeImageDescriptorModel(OxmJavaType item) {
        return new StaticPropertyValueModel((Object)JptJaxbUiImages.JAXB_CLASS);
    }

    protected PropertyValueModel<String> buildOxmJavaTypeTextModel(OxmJavaType item) {
        return new PropertyAspectAdapter<OxmJavaType, String>("typeName", item){

            protected String buildValue_() {
                return ((OxmJavaType)this.subject).getTypeName().getTypeQualifiedName();
            }
        };
    }

    protected PropertyValueModel<String> buildOxmJavaTypeDescriptionModel(OxmJavaType item) {
        return new PropertyAspectAdapter<OxmJavaType, String>("typeName", item){

            protected String buildValue_() {
                return ((OxmJavaType)this.subject).getTypeName().getFullyQualifiedName();
            }
        };
    }

    protected ItemExtendedLabelProvider buildOxmXmlEnumLabelProvider(OxmXmlEnum item, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)item, manager, this.buildOxmXmlEnumImageDescriptorModel(item), this.buildOxmXmlEnumTextModel(item), this.buildOxmXmlEnumDescriptionModel(item));
    }

    protected PropertyValueModel<ImageDescriptor> buildOxmXmlEnumImageDescriptorModel(OxmXmlEnum item) {
        return new StaticPropertyValueModel((Object)JptJaxbUiImages.JAXB_ENUM);
    }

    protected PropertyValueModel<String> buildOxmXmlEnumTextModel(OxmXmlEnum item) {
        return new PropertyAspectAdapter<OxmXmlEnum, String>("typeName", item){

            protected String buildValue_() {
                return ((OxmXmlEnum)this.subject).getTypeName().getTypeQualifiedName();
            }
        };
    }

    protected PropertyValueModel<String> buildOxmXmlEnumDescriptionModel(OxmXmlEnum item) {
        return new PropertyAspectAdapter<OxmXmlEnum, String>("typeName", item){

            protected String buildValue_() {
                return ((OxmXmlEnum)this.subject).getTypeName().getFullyQualifiedName();
            }
        };
    }

    protected ItemExtendedLabelProvider buildOxmJavaAttributeLabelProvider(OxmJavaAttribute item, ItemExtendedLabelProvider.Manager manager) {
        return new ModelItemExtendedLabelProvider((Object)item, manager, this.buildOxmJavaAttributeImageDescriptorModel(item), this.buildOxmJavaAttributeTextModel(item), this.buildOxmJavaAttributeDescriptionModel(item));
    }

    protected PropertyValueModel<ImageDescriptor> buildOxmJavaAttributeImageDescriptorModel(OxmJavaAttribute item) {
        return new PropertyAspectAdapter<OxmJavaAttribute, ImageDescriptor>("mapping", item){

            protected ImageDescriptor buildValue_() {
                return ELJaxbNavigatorItemLabelProviderFactory.this.buildOxmJavaAttributeImageDescriptor(((OxmJavaAttribute)this.subject).getMappingKey());
            }
        };
    }

    protected ImageDescriptor buildOxmJavaAttributeImageDescriptor(String mappingKey) {
        return ELJaxbMappingImageHelper.imageDescriptorForAttributeMapping(mappingKey);
    }

    protected PropertyValueModel<String> buildOxmJavaAttributeTextModel(OxmJavaAttribute item) {
        return new PropertyAspectAdapter<OxmJavaAttribute, String>("javaAttributeName", item){

            protected String buildValue_() {
                return ((OxmJavaAttribute)this.subject).getJavaAttributeName();
            }
        };
    }

    protected PropertyValueModel<String> buildOxmJavaAttributeDescriptionModel(OxmJavaAttribute item) {
        return this.buildOxmJavaAttributeTextModel(item);
    }
}

