/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.tests.encoding.html;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.contenttype.HTMLResourceEncodingDetector;
import org.eclipse.wst.html.tests.encoding.HTMLEncodingTestsPlugin;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;

public class HTMLEncodingTests
extends TestCase {
    private boolean DEBUG = false;
    private final String fileDir = "html/";
    private final String fileHome = "testfiles/";
    private final String fileLocation = "testfiles/html/";
    private int READ_BUFFER_SIZE = 8000;

    private static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    public HTMLEncodingTests(String name) {
        super(name);
    }

    private void doTestFileStream(String filename, String expectedIANAEncoding, IResourceCharsetDetector detector) throws IOException {
        File file = HTMLEncodingTestsPlugin.getTestFile(filename);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.valueOf(filename) + " was not found");
        }
        FileInputStream inputStream = new FileInputStream(file);
        InputStream istream = HTMLEncodingTests.getMarkSupportedStream(inputStream);
        try {
            detector.set(istream);
            EncodingMemento encodingMemento = ((HTMLResourceEncodingDetector)detector).getEncodingMemento();
            String foundIANAEncoding = null;
            if (encodingMemento != null) {
                foundIANAEncoding = encodingMemento.getJavaCharsetName();
            }
            boolean expectedIANAResult = false;
            expectedIANAResult = expectedIANAEncoding == null ? expectedIANAEncoding == foundIANAEncoding : expectedIANAEncoding.equalsIgnoreCase(foundIANAEncoding);
            HTMLEncodingTests.assertTrue((String)("encoding test file " + filename + " expected: " + expectedIANAEncoding + " found: " + foundIANAEncoding), (boolean)expectedIANAResult);
            if (expectedIANAEncoding != null) {
                this.ensureCanRead(filename, foundIANAEncoding, istream);
            }
        }
        finally {
            if (istream != null) {
                istream.close();
            }
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    private void ensureCanRead(String filename, String encoding, InputStream inStream) throws IOException {
        Charset charset = Charset.forName(encoding);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader reader = new InputStreamReader(inStream, charsetDecoder);
        StringBuffer stringBuffer = this.readInputStream(reader);
        if (this.DEBUG) {
            System.out.println();
            System.out.println(filename);
            System.out.println(stringBuffer.toString());
        }
    }

    private StringBuffer readInputStream(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int numRead = 0;
        char[] tBuff = new char[this.READ_BUFFER_SIZE];
        while ((numRead = reader.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer;
    }

    public void testEmptyFile() throws IOException {
        String filename = "testfiles/html/EmptyFile.html";
        this.doTestFileStream(filename, System.getProperty("file.encoding"), (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testIllformedNormalNonDefault() throws IOException {
        String filename = "testfiles/html/IllformedNormalNonDefault.html";
        String ianaInFile = "UTF-8";
        this.doTestFileStream(filename, ianaInFile, (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testMultiNonDefault() throws IOException {
        String filename = "testfiles/html/MultiNonDefault.html";
        this.doTestFileStream(filename, "ISO-8859-6", (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testNoEncoding() throws IOException {
        String filename = "testfiles/html/NoEncoding.html";
        this.doTestFileStream(filename, System.getProperty("file.encoding"), (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testnoquotes() throws IOException {
        String filename = "testfiles/html/noquotes.html";
        this.doTestFileStream(filename, "UTF-8", (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testNormalNonDefault() throws IOException {
        String filename = "testfiles/html/NormalNonDefault.html";
        String ianaInFile = "UTF-8";
        this.doTestFileStream(filename, ianaInFile, (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testUTF16BE() throws IOException {
        String filename = "testfiles/html/utf16be.html";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testUTF16LE() throws IOException {
        String filename = "testfiles/html/utf16le.html";
        this.doTestFileStream(filename, "UTF-16LE", (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testUTF16LENoQuotes() throws IOException {
        String filename = "testfiles/html/noquotesUTF16le.html";
        this.doTestFileStream(filename, "UTF-16LE", (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }

    public void testUTF16BOM() throws IOException {
        String filename = String.valueOf("testfiles/html/") + "utf16BOM.html";
        this.doTestFileStream(filename, "UTF-16", (IResourceCharsetDetector)new HTMLResourceEncodingDetector());
    }
}

