/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ReplaceInvocationsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ReplaceInvocationsAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public ReplaceInvocationsAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ReplaceInvocationsAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.replace_invocations_action");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
            }
            catch (JavaScriptModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaScriptPlugin.log(e);
            }
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    @Override
    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue((boolean)(first instanceof IFunction));
            IFunction method = (IFunction)first;
            if (ActionUtil.isProcessable(this.getShell(), (IJavaScriptElement)method)) {
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(method, this.getShell());
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
    }

    private void handleException(CoreException e) {
        ExceptionHandler.handle(e, RefactoringMessages.ReplaceInvocationsAction_dialog_title, RefactoringMessages.ReplaceInvocationsAction_unavailable);
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IJavaScriptElement editorInput = SelectionConverter.getInput(this.fEditor);
            if (editorInput instanceof ITypeRoot && ActionUtil.isProcessable(this.getShell(), editorInput)) {
                ITypeRoot typeRoot = (ITypeRoot)editorInput;
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(typeRoot, selection.getOffset(), selection.getLength(), this.getShell());
            }
        }
        catch (JavaScriptModelException e) {
            this.handleException((CoreException)((Object)e));
        }
    }
}

