/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.util.Collection;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class BreakpointRequestTests
extends RequestTest {
    public void testInvalidBreakpoint() throws Exception {
        RhinoRequest request = new RhinoRequest("breakpoint");
        request.getArguments().put("breakpointId", Integer.valueOf("9999"));
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertFalse((boolean)response.isSuccess());
    }

    public void testBreakpointsWithNoBreakpoints() throws Exception {
        RhinoRequest request = new RhinoRequest("breakpoints");
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        Collection breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertTrue((boolean)breakpoints.isEmpty());
    }

    public void testClearInvalidBreakpoint() throws Exception {
        RhinoRequest request = new RhinoRequest("clearbreakpoint");
        request.getArguments().put("breakpointId", Integer.valueOf("9999"));
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertFalse((boolean)response.isSuccess());
    }

    public void testBreakpoints() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointsHandler(this));
        RhinoRequest request = new RhinoRequest("breakpoints");
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        Collection breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertTrue((boolean)breakpoints.isEmpty());
        String script = Util.getTestSource("scripts", "script1.js");
        BreakpointRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script, 1);
        request = new RhinoRequest("breakpoints");
        this.debugSession.send((Packet)request);
        response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertEquals((int)8, (int)breakpoints.size());
        for (Number breakpointId : breakpoints) {
            request = new RhinoRequest("breakpoint");
            request.getArguments().put("breakpointId", breakpointId);
            this.debugSession.send((Packet)request);
            response = this.debugSession.receiveResponse(request.getSequence(), 30000);
            BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
            Map breakpoint = (Map)response.getBody().get("breakpoint");
            BreakpointRequestTests.assertEquals((int)breakpointId.intValue(), (int)Util.numberAsInt(breakpoint.get("breakpointId")));
            BreakpointRequestTests.assertTrue((boolean)breakpoint.containsKey("scriptId"));
            this.deleteBreakpoint(this.debugSession, breakpointId);
        }
    }

    public void testGetSetClearBreakpoint() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointsHandler(this));
        this.eventHandler.addSubhandler(new RequestTest.ClearBreakpointsHandler(this));
        RhinoRequest request = new RhinoRequest("breakpoints");
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        Collection breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertTrue((boolean)breakpoints.isEmpty());
        String script = Util.getTestSource("scripts", "script1.js");
        BreakpointRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script, 7);
        request = new RhinoRequest("breakpoints");
        this.debugSession.send((Packet)request);
        response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertEquals((int)2, (int)breakpoints.size());
        for (Number breakpointId : breakpoints) {
            request = new RhinoRequest("breakpoint");
            request.getArguments().put("breakpointId", breakpointId);
            this.debugSession.send((Packet)request);
            response = this.debugSession.receiveResponse(request.getSequence(), 30000);
            BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
            Map breakpoint = (Map)response.getBody().get("breakpoint");
            BreakpointRequestTests.assertEquals((int)breakpointId.intValue(), (int)Util.numberAsInt(breakpoint.get("breakpointId")));
            BreakpointRequestTests.assertTrue((boolean)breakpoint.containsKey("scriptId"));
            this.deleteBreakpoint(this.debugSession, breakpointId);
        }
    }

    void deleteBreakpoint(DebugSession session, Number breakpointid) {
        RhinoRequest request = new RhinoRequest("clearbreakpoint");
        request.getArguments().put("breakpointId", breakpointid);
        try {
            this.debugSession.send((Packet)request);
            Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
            BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        }
        catch (DisconnectedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }
}

