/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class UnknownContentTypeDialog2
extends MessageDialog {
    private String fFileName;
    private IContentTypeSettings fContentTypeSettings;

    public UnknownContentTypeDialog2(Shell parent, IPreferenceStore store, String fileName, IContentTypeSettings contentTypeSettings) {
        super(parent, SSEUIMessages.UnknownContentTypeDialog_0, null, null, 6, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.fFileName = fileName;
        this.fContentTypeSettings = contentTypeSettings;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            try {
                this.fContentTypeSettings.addFileSpec(this.fFileName, 4);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    protected Control createMessageArea(Composite composite) {
        super.createMessageArea(composite);
        Link messageLink = new Link(composite, 64);
        messageLink.setText(NLS.bind((String)SSEUIMessages.UnknownContentTypeDialog_3, (Object)Platform.getContentTypeManager().getContentType(this.fContentTypeSettings.getId()).getName()));
        messageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnknownContentTypeDialog2.this.linkClicked();
            }
        });
        return composite;
    }

    private void linkClicked() {
        String pageId = "org.eclipse.ui.preferencePages.ContentTypes";
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{pageId}, null);
        dialog.open();
    }
}

