/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.internet.cache.internal.CacheMessages;
import org.eclipse.wst.internet.cache.internal.CachePlugin;

public class LicenseAcceptanceDialog
extends IconAndMessageDialog {
    private static Hashtable dialogsInUse = new Hashtable();
    private String url;
    private String licenseURL;
    private Button agreeButton = null;

    protected LicenseAcceptanceDialog(Shell parent, String url, String licenseURL) {
        super(parent);
        this.url = url;
        this.licenseURL = licenseURL;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CacheMessages._UI_CACHE_DIALOG_TITLE);
        shell.setImage(null);
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        buttonBar.setLayout((Layout)layout);
        GridData gd = new GridData(64);
        buttonBar.setLayoutData((Object)gd);
        this.agreeButton = this.createButton(buttonBar, 0, CacheMessages._UI_CACHE_DIALOG_AGREE_BUTTON, false);
        this.agreeButton.setEnabled(false);
        this.createButton(buttonBar, 1, CacheMessages._UI_CACHE_DIALOG_DISAGREE_BUTTON, false);
        return buttonBar;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4);
        gd.widthHint = 500;
        composite.setLayoutData((Object)gd);
        Label licenseText1 = new Label(composite, 0);
        licenseText1.setText(CacheMessages._UI_CACHE_DIALOG_LICENSE_STATEMENT1);
        Label urlText = new Label(composite, 64);
        gd = new GridData(4, 128, true, false, 1, 1);
        urlText.setLayoutData((Object)gd);
        urlText.setText(this.url);
        new Label(composite, 0);
        Label licenseText2 = new Label(composite, 64);
        gd = new GridData(4, 128, true, false, 1, 1);
        licenseText2.setLayoutData((Object)gd);
        try {
            Browser browser;
            ProgressMonitorPart monitor;
            StackLayout stackLayout;
            Composite licenseTextComposite;
            block14: {
                BufferedReader breader;
                InputStreamReader isreader;
                block13: {
                    licenseTextComposite = new Composite(composite, 0);
                    stackLayout = new StackLayout();
                    licenseTextComposite.setLayout((Layout)stackLayout);
                    gd = new GridData(4, 4, true, true);
                    gd.heightHint = 400;
                    licenseTextComposite.setLayoutData((Object)gd);
                    Composite monitorComposite = new Composite(licenseTextComposite, 0);
                    monitorComposite.setLayout((Layout)new GridLayout());
                    gd = new GridData(4, 4, true, true);
                    gd.heightHint = 400;
                    monitorComposite.setLayoutData((Object)gd);
                    monitor = new ProgressMonitorPart(monitorComposite, (Layout)new GridLayout());
                    gd = new GridData(4, 1024, true, true);
                    monitor.setLayoutData((Object)gd);
                    monitor.beginTask(CacheMessages._UI_LOADING_LICENSE, 100);
                    stackLayout.topControl = monitorComposite;
                    browser = new Browser(licenseTextComposite, 2048);
                    gd = new GridData(4, 4, true, true);
                    browser.setUrl(this.licenseURL);
                    if (!this.licenseURL.startsWith("jar:")) break block14;
                    InputStream licenseStream = null;
                    isreader = null;
                    breader = null;
                    try {
                        URL browserURL = new URL(this.licenseURL);
                        licenseStream = browserURL.openStream();
                        isreader = new InputStreamReader(licenseStream);
                        breader = new BufferedReader(isreader);
                        StringBuffer sb = new StringBuffer();
                        while (true) {
                            String str;
                            block15: {
                                if ((str = breader.readLine()) != null) break block15;
                                browser.setText(sb.toString());
                                break;
                            }
                            sb.append(str);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_20 = null;
                        if (licenseStream != null) {
                            licenseStream.close();
                        }
                        if (isreader != null) {
                            isreader.close();
                        }
                        if (breader != null) {
                            breader.close();
                        }
                        throw throwable;
                    }
                    {
                        Object var19_21 = null;
                        if (licenseStream == null) break block13;
                    }
                    licenseStream.close();
                }
                if (isreader != null) {
                    isreader.close();
                }
                if (breader != null) {
                    breader.close();
                }
            }
            browser.setLayoutData((Object)gd);
            browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total != 0) {
                        monitor.internalWorked((double)(event.current * 100 / event.total));
                    }
                }

                public void completed(ProgressEvent event) {
                    monitor.done();
                    stackLayout.topControl = browser;
                    LicenseAcceptanceDialog.this.agreeButton.setEnabled(true);
                    licenseTextComposite.layout();
                }
            });
            licenseText2.setText(CacheMessages._UI_CACHE_DIALOG_LICENSE_STATEMENT2);
        }
        catch (Exception exception) {
            try {
                CachePlugin.getDefault().getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(this.licenseURL));
                licenseText2.setText(CacheMessages._UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_INTERNAL);
            }
            catch (Exception exception2) {
                licenseText2.setText(MessageFormat.format(CacheMessages._UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_BROWSER, this.licenseURL));
            }
        }
        this.createButtonBar(composite);
        return composite;
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean promptForLicense(Shell parent, String url, String licenseURL) throws IOException {
        LicenseAcceptanceDialog dialog;
        boolean newDialog;
        boolean agreedToLicense;
        block9: {
            block10: {
                agreedToLicense = false;
                newDialog = true;
                dialog = null;
                if (!dialogsInUse.containsKey(licenseURL)) break block10;
                newDialog = false;
                dialog = (LicenseAcceptanceDialog)((Object)dialogsInUse.get(licenseURL));
                break block9;
            }
            InputStream is = null;
            try {
                try {
                    URL urlObj = new URL(licenseURL);
                    is = urlObj.openStream();
                    dialog = new LicenseAcceptanceDialog(parent, url, licenseURL);
                    dialogsInUse.put(licenseURL, dialog);
                    dialog.setBlockOnOpen(true);
                }
                catch (Exception exception) {
                    throw new IOException("The license cannot be opened.");
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (is == null) break block9;
            }
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        if (dialog == null) return agreedToLicense;
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            agreedToLicense = true;
        }
        if (!newDialog) return agreedToLicense;
        dialogsInUse.remove(licenseURL);
        return agreedToLicense;
    }

    public boolean close() {
        if (this.agreeButton != null) {
            this.agreeButton.dispose();
            this.agreeButton = null;
        }
        return super.close();
    }
}

